import json
import os
import copy

PostProcessors = {}
EquatorLength = 40075016.68557849

with open(os.path.join(os.path.dirname(__file__), "color_themes.json"), "r") as f:
  ColorThemes = json.load(f)

try:
  ColorThemes["Default"] = copy.deepcopy(ColorThemes["Weninger color scheme"])
except:
  ColorThemes["Default"] = {
    "theme_ref": "NULL theme",
    "range_map":{
      "ALL": {"lower": -999, "upper": 999, "color": [160, 186, 191]}
    }
  }

MeshUnit = {
  "1":          {"long": 1.0,          "lat": 40.0/60.0},
  "2":          {"long": 1.0/8.0,      "lat": 40.0/60.0/8.0},
  "3":          {"long": 1.0/80.0,     "lat": 40.0/60.0/80.0},
  "4":          {"long": 1.0/160.0,    "lat": 40.0/60.0/160.0},
  "5":          {"long": 1.0/320.0,    "lat": 40.0/60.0/320.0},
  "6":          {"long": 1.0/640.0,    "lat": 40.0/60.0/640.0},
  "_ex100m_12": {"long": 4.5/3600.0,   "lat": 3.0/3600.0},
  "_ex100m_13": {"long": 4.5/3600.0,   "lat": 3.0/3600.0},
  "_ex50m_13":  {"long": 2.25/3600.0,  "lat": 1.5/3600.0},
  "_ex50m_14":  {"long": 2.25/3600.0,  "lat": 1.5/3600.0},
  "_ex10m_14":  {"long": 0.45/3600.0,  "lat": 0.3/3600.0},
  "_ex1m_16":   {"long": 0.045/3600.0, "lat": 0.03/3600.0},
}
