[英語版 README はこちら](/README.md)

# H-RISK with NoiseModelling

[![DOI](https://joss.theoj.org/papers/10.21105/joss.06023/status.svg)](https://doi.org/10.21105/joss.06023)

## このソフトウェアについて

騒音予測・健康リスク推定のためのQGISプラグインです。
NoiseModellingによる騒音予測を実装しています。


![](readme/sample.png)

図: 札幌市における自動車騒音予測結果の例 (チュートリアル参照).

* この日本語版READMEは英語版READMEの翻訳であり，内容が一致しない部分があります。
英語版READMEの内容が正ですので，そちらも参照してください。

* 風車騒音に関する騒音予測については，[H-RISK for Wind turbine noise](https://gitlab.com/jtagusari/hrisk-wtn)を参照してください。

## 機能

- OpenStreetMap、Shuttle Radar Topography Mission、Vector Tiles（国土地理院提供）からジオメトリを取得する
- NoiseModellingを使用して騒音レベルを予測する。
- 予測された騒音レベルと、欧州地域における環境騒音ガイドライン（WHO欧州地域事務局）に示された暴露-反応関係に基づいて、健康リスクを推定する


- H-RISK v0.1.0以降，NoiseModelling v4.0.4の動作を確認しています。
- H-RISK v0.1.4以降，NoiseModelling v4.0.5の動作を確認しています。
- H-RISK v0.6.1以降，NoiseModelling v5.0.1の動作を確認しています。

## ライセンス等

GPL v3ライセンスに準拠（詳細は`LICENSE`参照）。

なお，外部プラグインのライセンスは下記の通り：

- NoiseModelling： GPL v3
- OpenJDK: GPL v2 (Classpath Exception)


『このサービスは、政府統計総合窓口(e-Stat)のAPI機能を使用していますが、サービスの内容は国によって保証されたものではありません。』

## インストール方法

このプラグインを利用するためには、以下のコンポーネントのインストールが必要です。

- QGIS (バージョン3.22以上)
- Quick OSMプラグイン（QGISからインストール可能）
- NoiseModelling
- Java

以下のセクションでは、このプラグインとこれらの要素のインストール方法について説明します。

### ステップ1：QGISのインストール

[QGIS website](https://qgis.org/)を参照し，QGISをインストールしてください。
なお、バージョンは3.22.0以上である必要があります。

### ステップ2：このプラグインのインストール

このプラグインをQGIS公式リポジトリからインストールします。

1. QGISを起動し，`プラグイン` -> `プラグインの管理とインストール` (下図参照)からプラグインマネージャを起動してください。<br />
  ![install H-RISK on QGIS 1](readme/install-hrisk-1.png)
1. プラグインマネージャのリストの中から，このプラグインを検索してください (下図参照)。このプラグインを選択し，`プラグインのインストール`をクリックしてください。<br />
  ![install H-RISK on QGIS 2](readme/install-hrisk-2.png)
1. `H-RISK`という項目が`プロセシングツールボックス` (下図参照)に表示されていることを確認してください。<br />
  ![install H-RISK on QGIS 3](readme/install-hrisk-3.png)
1. 同様に，`QuickOSM`プラグインをインストールしてください。


### ステップ3：NoiseModellingおよびJava環境のインストール

このプラグインの全機能を利用するには、NoiseModellingとJava環境のインストールが必要です。
これらのインストールは，このプラグインに実装されているアルゴリズムを使って簡単に行うことができます。

1. `H-RISK`の`設定`グループの`コンポーネントのインストール`アルゴリズムをダブルクリックで実行してください（下図参照）。<br />
  ![install H-RISK on QGIS 3](readme/install-hrisk-3.png)
1. ダイアログボックスが表示されます。必要に応じてインストール場所を変更し，実行してください（下図参照）。<br />
  ![install H-RISK on QGIS 4](readme/install-hrisk-4.png)
1. NoiseModellingおよびJavaがダウンロードされ，展開され，またそれぞれについて環境変数が設定されます。環境変数は`NOISEMODELLING_HOME`および`JAVA_FOR_NOISEMODELLING`という名称です。
1. 上記の設定を有効にするために，QGISを再起動してください。


#### NoiseModellingの手動インストール

上記の手順がうまく行かない場合には，次の手順にしたがってNoiseModellingを手動でインストールします。
まず，NoiseModelling (No-GUI version) (<https://github.com/Universite-Gustave-Eiffel/NoiseModelling/releases>) のアーカイブをダウンロードしてください。

##### Windowsの場合

1. 上記のアーカイブを適当な場所に展開してください。（例：`%APPDATA%\H-RISK\NoiseModelling\5.0.1`）
1. 環境変数`NOISEMODELLING_HOME`を上記のフォルダの`bin`がある場所に設定してください。
（例：`%APPDATA%\H-RISK\NoiseModelling\5.0.1\scriptrunner`）このとき，`%NOISEMODELLING_HOME%\bin\wps_scripts.bat`が存在することを確認してください。
1. QGISを再起動してください。


##### Mac/Linuxの場合

1. 上記のアーカイブを適当な場所に展開してください。（例：`~Applications/H-RISK/NoiseModelling/4.0.5`）
1. 上記のパスを，`~/.bash_profile`に`NOISEMODELLING_HOME`として追記してください。（例：`export NOISEMODELLING_HOME ~Applications/H-RISK/NoiseModelling/4.0.5/scriptrunner`）このとき，`bin/wps_scripts`が上記のパスに存在することを確認してください。
1. QGISを再起動してください。

#### Javaの手動インストール

NoiseModellingの指示 (<https://noisemodelling.readthedocs.io/en/latest/Requirements.html>) にしたがい，Javaをインストールしてください。ただし，環境変数の名称は`JAVA_FOR_NOISEMODELLING`としてください。（NoiseModellingの指示では`JAVA_HOME`となっています）

Javaのインストールが完了したら，QGISを再起動してください。

