# Contributing guide

Thank you for investing your time in contributing to the project! This guide will provide you with an overview of our contribution workflow.

Note that all contributions must be complied with the [CODE OF CONDUCT](CODE_OF_CONDUCT.md).

Please feel free to contact with the [maintainer of this project](<mailto:j.tagusari@eng.hokudai.ac.jp>) if you have any questions.

## Issues

If you spot a problem with the project, you can open a new issue using the relevant issue form. 
If you find an issue that interests you, you are welcome to open a merge request with a fix.

## Merge requests

Various kinds of merge requests are warmly welcomed, including:

- Merge requests that fix bugs
- Merge requests that solve issues

Here are some notes about merge requests:

- The license applied to this project (see [LICENSE](LICENSE)) will also apply to the contents of the merge request.
- If you have any ideas for new features for this project, please discuss them by opening a new issue.
- Merge requests that do not comply with the Code of Conduct (see [CODE OF CONDUCT](CODE_OF_CONDUCT.md)) will be declined.


### Contribution Process

1. **Fork the Project**: Start by forking the project to your own GitLab account. This allows you to make changes without affecting the original project.
2. **Clone the Project**: Next, clone the forked project to your local machine. This allows you to make changes to the code.
3. **Create a New Branch**: Before making changes, create a new branch in your local project. This helps isolate your changes and makes it easier to submit a merge request later. Use a descriptive name for your branch (e.g., `fix-bug-123` or `add-new-feature`).
4. **Make Your Changes**: Now you're ready to make your changes. Make sure to follow the project's coding standards and guidelines.
5. **Commit Your Changes**: After making your changes, commit them to your local project. Write a clear and concise commit message describing what you've done.
6. **Push Your Changes**: Push your changes and the new branch to your forked project on GitLab.
7. **Submit a Merge Request**: Finally, navigate to your forked project on GitLab and click on the "New Merge Request" button. Fill out the form and submit your merge request.

Remember to regularly pull from the original project to keep your local copy up to date. This helps avoid merge conflicts.

### Review Process

Once you've submitted a merge request, it goes through a review process. Here's what to expect:

1. **Automated Checks**: After submission, automated checks will run to ensure the project builds and all tests pass with your changes.
2. **Maintainer Review**: A project maintainer will review your merge request. They may provide feedback and request changes. Please respond to comments and make necessary changes.
3. **Revision**: If changes are requested, make the changes in your branch and commit them. GitLab will automatically update the merge request with your new commits.
4. **Approval**: Once the maintainer is satisfied with the changes, they will approve the merge request.
5. **Merge**: After approval, a maintainer will merge your changes into the main project. Your contribution is now part of the project!

Remember, the review process can take time. Please be patient and respectful of the maintainers' time.