from qgis.core import QgsProcessingProvider

from .algconfig.installcomponents import installcomponents
from .algconfig.testalgorithms import testalgorithms
from .algconfig.testcomponents import testcomponents

from .alginit.initroademissionfromtraffic import initroademissionfromtraffic
from .alginit.initroad import initroad
from .alginit.initsource import initsource
from .alginit.initemissiontable import initemissiontable
from .alginit.initdirtable import initdirtable
from .alginit.initatomtable import initatomtable
from .alginit.initbuilding import initbuilding
from .alginit.initgroundabsorption import initgroundabsorption
from .alginit.initelevationpoint import initelevationpoint
from .alginit.initreceiver import initreceiver
from .alginit.initroadtraffictable import initroadtraffictable

from .algmerge.mergebuilding import mergebuilding
from .algmerge.mergeroad import mergeroad
from .algmerge.mergeelevationpoint import mergeelevationpoint

from .algfetch.fetchroadosm import fetchroadosm
from .algfetch.fetchbuildingosm import fetchbuildingosm
from .algfetch.fetchdemrastersrtm import fetchdemrastersrtm
from .algfetch.fetchpopghs import fetchpopghs

from .algreceiver.receivercrosssection import receivercrosssection
from .algreceiver.receiverfacade import receiverfacade
from .algreceiver.receiverregulargrid import receiverregulargrid
from .algreceiver.receiverdelaunaygrid import receiverdelaunaygrid

from .algnoise.noisefromtraffic import noisefromtraffic
from .algnoise.noisefromemission import noisefromemission
from .algnoise.isosurface import isosurface
from .algnoise.drawnoisecolor import drawnoisecolor
from .algnoise.formatnmresults import formatnmresults

from .algrisk.estimatelevelofbuilding import estimatelevelofbuilding
from .algrisk.estimatepopulationofbuilding import estimatepopulationofbuilding
from .algrisk.estimatepopulationofbuildingplg import estimatepopulationofbuildingplg
from .algrisk.estimateriskofbuilding import estimateriskofbuilding
from .algrisk.summarizerisk import summarizerisk


class hrisk_provider(QgsProcessingProvider):

  def __init__(self):        
    QgsProcessingProvider.__init__(self)

  def unload(self):
    pass

  def loadAlgorithms(self):
    self.addAlgorithm(installcomponents())
    self.addAlgorithm(testalgorithms())
    self.addAlgorithm(testcomponents())
    self.addAlgorithm(fetchroadosm())
    self.addAlgorithm(fetchbuildingosm())
    self.addAlgorithm(fetchdemrastersrtm())
    self.addAlgorithm(fetchpopghs())
    self.addAlgorithm(noisefromtraffic())
    self.addAlgorithm(noisefromemission())
    self.addAlgorithm(formatnmresults())
    self.addAlgorithm(initroad())
    self.addAlgorithm(initsource())
    self.addAlgorithm(initemissiontable())
    self.addAlgorithm(initdirtable())
    self.addAlgorithm(initatomtable())
    self.addAlgorithm(initbuilding())
    self.addAlgorithm(initreceiver())
    self.addAlgorithm(initelevationpoint())
    self.addAlgorithm(initgroundabsorption())
    self.addAlgorithm(initroademissionfromtraffic())
    self.addAlgorithm(initroadtraffictable())
    self.addAlgorithm(mergebuilding())
    self.addAlgorithm(mergeroad())
    self.addAlgorithm(mergeelevationpoint())
    self.addAlgorithm(receiverfacade())
    self.addAlgorithm(receiverregulargrid())
    self.addAlgorithm(receiverdelaunaygrid())
    self.addAlgorithm(receivercrosssection())
    self.addAlgorithm(isosurface())
    self.addAlgorithm(estimatelevelofbuilding())
    self.addAlgorithm(estimatepopulationofbuilding())
    self.addAlgorithm(estimatepopulationofbuildingplg())
    self.addAlgorithm(estimateriskofbuilding())
    self.addAlgorithm(summarizerisk())
    self.addAlgorithm(drawnoisecolor())

  def id(self):
    return 'hrisk'

  def name(self):
    return self.tr('H-RISK')

  def icon(self):
    return QgsProcessingProvider.icon(self)

  def longName(self):
    return self.name()
