from qgis.PyQt.QtCore import (QT_TRANSLATE_NOOP, QCoreApplication)
from qgis.core import (
  QgsProcessingAlgorithm,
  QgsProcessingParameterEnum,
  QgsProcessingParameterFile,
  QgsProcessingParameterNumber,
  QgsProcessingParameterField,
  QgsProcessingParameterFeatureSource,
  QgsProject
  )

from ..algutil.hriskvar import ColorThemes
from ..algutil.hriskutil import HrUtil
from ..algutil.hrisknoisecolorrenderer import HrNoiseColorRenderer

class drawnoisecolor(QgsProcessingAlgorithm):
  
  # UIs
  PARAMETERS = {  
    "TARGET_LAYER": {
      "ui_func": QgsProcessingParameterFeatureSource,
      "ui_args":{
        "description": QT_TRANSLATE_NOOP("drawnoisecolor","Target layer")
      }
    },
    "TARGET_ATTRIBUTE": {
      "ui_func": QgsProcessingParameterField,
      "ui_args": {
        "description": QT_TRANSLATE_NOOP("drawnoisecolor","Target attribute"),
        "parentLayerParameterName": "TARGET_LAYER"
      }
    },
    "COLOR_THEME": {
      "ui_func": QgsProcessingParameterEnum,
      "ui_args": {
        "description": QT_TRANSLATE_NOOP("drawnoisecolor","Color theme"),
        "options": [],
        "defaultValue": 0
      }
    },    
    "OPACITY": {
      "ui_func": QgsProcessingParameterNumber,
      "ui_args":{
        "optional": True,
        "description": QT_TRANSLATE_NOOP("drawnoisecolor","Opacity of the fill (0: transparent - 1: opaque)"),
        "type": QgsProcessingParameterNumber.Double,
        "minValue": 0.0, "defaultValue": None, "maxValue": 1.0,
        "defaultValue": 1.0
      }
    },
    "COLOR_THEME_FILE": {
      "ui_func": QgsProcessingParameterFile,
      "ui_args": {
        "optional": True,
        "description": QT_TRANSLATE_NOOP("drawnoisecolor","Color theme (json file)"),
        "extension": "json"
      }
    },
  }  
  
  COLOR_THEMES = []
  
  def __init__(self) -> None:
    super().__init__()
    self.UTIL = HrUtil(self)
    self.NCR = HrNoiseColorRenderer()
  
  # initialization of the algorithm
  def initAlgorithm(self, config):
        
    self.COLOR_THEMES = ["Default"]
    for k, v in ColorThemes.items():
      if "range_map" in v.keys() and k not in self.COLOR_THEMES:
        self.COLOR_THEMES.append(k)
    self.COLOR_THEMES.append("External json")
    
    self.PARAMETERS["COLOR_THEME"]["ui_args"]["options"] = self.COLOR_THEMES
    self.UTIL.setDefaultValue("COLOR_THEME", self.COLOR_THEMES.index("Default"))
    
    self.UTIL.initParameters()
          
  # execution of the algorithm
  def processAlgorithm(self, parameters, context, feedback):  
    
    color_theme_name = self.COLOR_THEMES[self.parameterAsInt(parameters, "COLOR_THEME", context)]
    color_theme_file = self.parameterAsString(parameters, "COLOR_THEME_FILE", context)
    color_theme_file = None if len(color_theme_file) == 0 else color_theme_file
    attribute = self.parameterAsString(parameters, "TARGET_ATTRIBUTE", context)
    
    self.NCR.setColorArgs(
      theme = color_theme_name,
      coloring = "graduated_symbol",
      attribute = attribute,
      opacity = parameters.get("OPACITY"),
      theme_json_path = color_theme_file
    )
    
    
    target_layer_id = self.parameterAsString(parameters, "TARGET_LAYER", context)
    qgs_project = QgsProject.instance()
    layer = qgs_project.mapLayer(target_layer_id)
    self.NCR.applyRenderer(layer)
    
    return {}
  
  def name(self):
    return 'drawnoisecolor'

  def displayName(self):
    return self.tr("Draw noise color")
  
  def group(self):
    return self.tr('Predict sound level')

  def groupId(self):
    return 'soundlevel'

  def createInstance(self):
    return drawnoisecolor()
  
  # placing here is necessary, when employing pylupdate
  def tr(self, string):
    return QCoreApplication.translate(self.__class__.__name__, string)

      