from qgis.PyQt.QtCore import (QT_TRANSLATE_NOOP, QCoreApplication)

from qgis.core import (
  QgsProcessingAlgorithm,
  QgsProcessingParameterBoolean,
  )

import os
import platform
from ..algutil.hriskutil import HrUtil

class testcomponents(QgsProcessingAlgorithm):

  PARAMETERS = {                  
    "CHECK_NM": {
      "ui_func": QgsProcessingParameterBoolean,
      "ui_args": {
        "description": QT_TRANSLATE_NOOP("testcomponents","Check NoiseModelling" ),
        "defaultValue": True
      }
    },
    "CHECK_JAVA": {
      "ui_func": QgsProcessingParameterBoolean,
      "ui_args": {
        "description": QT_TRANSLATE_NOOP("testcomponents","Check Java environment required for NoiseModelling" ),
        "defaultValue": True
      }
    }
  }
  
  NM_TARGET = "wps_scripts"
  JAVA_TARGET = "java.exe" if platform.system() == 'Windows' else "java"
  
  def __init__(self):
    super().__init__()
    self.UTIL = HrUtil(self)
    
  def initAlgorithm(self, config):
    self.UTIL.initParameters()
  
    
  def processAlgorithm(self, parameters, context, feedback):
    self.UTIL.registerProcessingParameters(parameters, context, feedback)  
    err_flag = False
    
    if self.parameterAsBool(parameters, "CHECK_NM", context):
      feedback.pushInfo("Checking NoiseModelling")
      try:
        nm_path = os.environ["NOISEMODELLING_HOME"]
        feedback.pushInfo(f"NOISEMODELLING_HOME: {nm_path}")
      except KeyError:
        err_flag = True
        feedback.pushWarning("Environment variable of NOISEMODELLING_HOME is not set.")
      
      try:
        os.path.exists(os.path.join(nm_path, self.NM_TARGET))
        feedback.pushInfo("Existence of wps_scripts: OK")
      except:
        err_flag = True
        feedback.pushWarning("wps_scripts is not found.")
        
    if self.parameterAsBool(parameters, "CHECK_JAVA", context):
      feedback.pushInfo("Checking Java environment")
      try:
        java_path = os.environ["JAVA_FOR_NOISEMODELLING"]
        feedback.pushInfo(f"JAVA_FOR_NOISEMODELLING: {java_path}")
      except KeyError:
        err_flag = True
        feedback.pushWarning("Environment variable of JAVA_FOR_NOISEMODELLING is not set.")
      
      try:
        os.path.exists(os.path.join(nm_path, self.JAVA_TARGET))
        feedback.pushInfo("Existence of java.exe: OK")
      except:
        err_flag = True
        feedback.pushWarning("java.exe is not found.")
    
    if err_flag:
      raise Exception("Error(s) occurred in checking the environment.")
    
    return {"H-RISK":self.UTIL.getPluginVersion(), "NOISEMODELLING":self.UTIL.getNoiseModellingVersion()}


  def name(self):
    return self.__class__.__name__
  
  def displayName(self):
    return self.tr("Test components")

  def group(self):
    return self.tr("Configurations")

  def groupId(self):
    return "config"

  def createInstance(self):
    return testcomponents()


  # placing here is necessary, when employing pylupdate
  def tr(self, string):
    return QCoreApplication.translate(self.__class__.__name__, string)
