# ワークスペースの全てのpythonファイルについて，クラスのプロパティおよびメソッドの引数の型をチェックする．

import os
import ast
import dataclasses

@dataclasses.dataclass
class check_algorithms(object):
  WORKSPACE: str
  CLASSES: dict = {}
  
  def __init__(self):
    # このファイルの親ディレクトリをWORKSPACEに設定する
    self.WORKSPACE = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
  
  def check_parameters(self):
    for root, dirs, files in os.walk(self.WORKSPACE):
      for file in files:
        if file.endswith(".py"):
          classes = {}
          file_path = os.path.join(root, file)
          with open(file_path, "r") as f:
            content = f.read()
            tree = ast.parse(content)
            for node in ast.walk(tree):
              if isinstance(node, ast.ClassDef):
                classes[node.name] = self.check_class(node)
              # クラスのメソッドであるか
              elif isinstance(node, ast.FunctionDef):
                # メソッドの引数の型をチェックする
                self.check_function(node)

  def check_class(self, node) -> dict:
    member = {}

    for nd in node.body:
      if isinstance(nd, ast.FunctionDef):
        member[nd.name] = self.check_function(nd)

  def check_function(self, node) -> dict:
    for arg in node.args.args:
      if arg.annotation is None:
        print(f"Error: {arg.arg} in {node.name} has no type annotation.")