from qgis.core import QgsProcessingProvider

from .installcomponents import installcomponents
from .algnoise.noisefromtraffic import noisefromtraffic
from .algnoise.noisefromemission import noisefromemission
from .alginit.initroademissionfromtraffic import initroademissionfromtraffic
from .alginit.initroad import initroad
from .alginit.initbuilding import initbuilding
from .alginit.initgroundabsorption import initgroundabsorption
from .alginit.initelevationpoint import initelevationpoint
from .alginit.mergebuilding import mergebuilding
from .alginit.mergeroad import mergeroad
from .algfetch.fetchall import fetchall
from .algfetch.fetchallja import fetchallja
from .algfetch.fetchroadja import fetchroadja
from .algfetch.fetchroadosm import fetchroadosm
from .algfetch.fetchbuildingosm import fetchbuildingosm
from .algfetch.fetchbuildingja import fetchbuildingja
from .algfetch.fetchdemrastersrtm import fetchdemrastersrtm
from .algfetch.fetchdemvectorja import fetchdemvectorja
from .algfetch.fetchdemrasterja import fetchdemrasterja
from .algfetch.fetchpopja import fetchpopja
from .algreceiver.receiverfacade import receiverfacade
from .algreceiver.receiverregulargrid import receiverregulargrid
from .algreceiver.receiverdelaunaygrid import receiverdelaunaygrid
from .algnoise.isosurface import isosurface
from .algrisk.estimatelevelofbuilding import estimatelevelofbuilding
from .algrisk.estimatepopulationofbuilding import estimatepopulationofbuilding
from .algrisk.estimatepopulationofbuildingplg import estimatepopulationofbuildingplg
from .algrisk.estimateriskofbuilding import estimateriskofbuilding


class hrisk_provider(QgsProcessingProvider):

    def __init__(self):        
        QgsProcessingProvider.__init__(self)

    def unload(self):
        pass

    def loadAlgorithms(self):
        self.addAlgorithm(installcomponents())
        self.addAlgorithm(fetchall())
        self.addAlgorithm(fetchallja())
        self.addAlgorithm(fetchroadja())
        self.addAlgorithm(fetchbuildingja())
        self.addAlgorithm(fetchdemvectorja())
        self.addAlgorithm(fetchdemrasterja())
        self.addAlgorithm(fetchpopja())
        self.addAlgorithm(fetchroadosm())
        self.addAlgorithm(fetchbuildingosm())
        self.addAlgorithm(fetchdemrastersrtm())
        self.addAlgorithm(noisefromtraffic())
        self.addAlgorithm(noisefromemission())
        self.addAlgorithm(initroad())
        self.addAlgorithm(initbuilding())
        self.addAlgorithm(initelevationpoint())
        self.addAlgorithm(initgroundabsorption())
        self.addAlgorithm(initroademissionfromtraffic())
        self.addAlgorithm(mergebuilding())
        self.addAlgorithm(mergeroad())
        self.addAlgorithm(receiverfacade())
        self.addAlgorithm(receiverregulargrid())
        self.addAlgorithm(receiverdelaunaygrid())
        self.addAlgorithm(isosurface())
        self.addAlgorithm(estimatelevelofbuilding())
        self.addAlgorithm(estimatepopulationofbuilding())
        self.addAlgorithm(estimatepopulationofbuildingplg())
        self.addAlgorithm(estimateriskofbuilding())

    def id(self):
        return 'hrisk'

    def name(self):
        return self.tr('H-RISK')

    def icon(self):
        return QgsProcessingProvider.icon(self)

    def longName(self):
        return self.name()
