'''
/***************************************************************************
 HeritageInventoryMain
                                 A QGIS plugin
 Digitally register, manage, and visualise heritage resource data with this
 inventory worksheet plugin.

 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-02-27
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Anna Sanasaryan
        email                : ansa16a@upv.edu.es, annasanasaryan@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
'''

import os

from qgis.PyQt import uic
from qgis.gui import QgsMapToolEmitPoint
from qgis.core import (
    QgsEditorWidgetSetup, QgsSimpleFillSymbolLayer, QgsVectorLayer, QgsProject,
    QgsVectorLayerSimpleLabeling, QgsFillSymbol, QgsTextFormat, QgsWkbTypes,
    QgsPalLayerSettings, QgsField, QgsVectorFileWriter, QgsFields,
    QgsCoordinateTransformContext
)
from qgis.PyQt.QtGui import QPixmap, QRegularExpressionValidator, QFont, QColor
from qgis.PyQt import QtCore
from qgis.PyQt.QtCore import (
    QLocale, QFileInfo, QTranslator, QCoreApplication, QRegularExpression,
    QVariant, Qt
)
from qgis.utils import iface
from qgis.PyQt.QtWidgets import (
    QWidget, QMessageBox, QFileDialog, QMainWindow, QCheckBox, QFrame,
    QTreeWidgetItem
)
from .pyscripts.image_loader import Ui_Form, ImageLoader_1
from .pyscripts.get_started import (
    getStarted_step1, getStarted_step2, getStarted_step3,
    getStarted_step4, getStarted_step5, getStarted_step6)
from .pyscripts.shared import fieldTitles
from .pyscripts.register_attributes import register_tabs
from .pyscripts.point_and_polygons import (
    change_crs_to_EPSG_3857, add_to_the_point_cloud, register_point_on_map,
    remove_from_the_point_cloud, add_point_2_tableMA, add_point_2_tablePA,
    hide_numbering_from_map_MA, hide_numbering_from_map_PA,
    show_numbering_on_map_MA, show_numbering_on_map_PA,
    numbering_style_white_MA, numbering_style_white_PA,
    numbering_style_black_MA, numbering_style_black_PA,
    clear_all_rows_and_remove_MA, clear_all_rows_and_remove_PA,
    draw_area_on_map_MA, draw_area_on_map_PA, remove_selected_rows_MA,
    remove_selected_rows_PA, move_row_down_MA, move_row_down_PA,
    move_row_up_MA, move_row_up_PA, init_resize_tablewidgets_to_contents,
    export_tablewidgets_2_excel, numbering, distance_calc,
    input_polygon_coordsMA, input_polygon_coordsPA,
    remove_tw_cont_and_last_value, delete_polygon, clear_all_rows, area_calc,
    create_polygonMA, create_polygonPA,
    clear_point_of_reference_data_from_worksheet
)
from .pyscripts.add_point_poly import AddPointPoly
from .pyscripts.instructions_excel import InstructionsExcel
import shutil


# This loads the .ui file so that PyQt can populate the plugin with the
# elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'her_inv_main.ui')
    )
iface.actionPan().trigger()


class HeritageInventoryMain(QMainWindow, FORM_CLASS):
    """Main window class for the Heritage Inventory plugin."""

    def __init__(self, parent=None):
        """Constructor."""
        super(HeritageInventoryMain, self).__init__(parent)

        self.setupUi(self)
        self.selected_language = None
        self.iface = iface
        self.canvas = iface.mapCanvas()  # Store reference to the map canvas
        # Create the maps tool using the canvas reference
        self.maptool = QgsMapToolEmitPoint(self.canvas)
        # Connect signal that the canvas was clicked
        self.canvas.setMapTool(self.maptool)
        self.plugin_dir = os.path.dirname(__file__)
        self.frame_14.setEnabled(False)  # Set initial state to disabled
        self.frame_99.setEnabled(False)  # Set initial state to disabled
        self.frame_101.setEnabled(False)  # Set initial state to disabled
        self.frame_102.setEnabled(False)  # Set initial state to disabled
        self.frame_104.setEnabled(False)  # Set initial state to disabled
        self.image_loader = None  # Initialize ImageLoader instance
        self.initiated_from_new_worksheet = False

        """Connections"""
        self.init_action_connections()
        self.init_pushButton_connections()
        self.init_radioButton_connections()
        self.init_checkBox_connections()
        self.init_comboBox_connections()
        self.init_combobox_lists()
        self.init_lineEdit_validator()
        self.lineEdit_29.textChanged.connect(self.update_combo_box_X)
        self.init_dateEdit_setLocale()
        init_resize_tablewidgets_to_contents(self)

        self.treeWidget.itemDoubleClicked.connect(self.tree_widget_column_edit)
        clear_point_of_reference_data_from_worksheet(self)

        global fnameim_1, fnameim_2
        fnameim_1, fnameim_2 = '-', '-'

        self.layout_duplicated = False

    def init_action_connections(self):
        """ Connect Menu bar actions to methods"""

        self.actionOpen_project.triggered.connect(self.open_project)
        self.actionExport_as_xls.triggered.connect(self.export_as_xls)
        self.actionNew_Project.triggered.connect(self.create_new_project)
        self.actionNew_Worksheet.triggered.connect(self.new_worksheet)
        self.actionSave_project.triggered.connect(self.save_project_file)

        self.actionArmenian.triggered.connect(self.am)
        self.actionEnglish.triggered.connect(self.en)
        self.actionSpanish.triggered.connect(self.es)

        self.actionStep_1.triggered.connect(
            lambda: getStarted_step1(
                self.label, self.lineEdit_27, self.lineEdit_28))
        self.actionStep_2.triggered.connect(
            lambda: getStarted_step2(
                self.label, self.lineEdit_27, self.lineEdit_28))
        self.actionStep_3.triggered.connect(
            lambda: getStarted_step3(
                self.label, self.lineEdit_27, self.lineEdit_28))
        self.actionStep_4.triggered.connect(
            lambda: getStarted_step4(
                self.label, self.lineEdit_27, self.lineEdit_28))
        self.actionStep_5.triggered.connect(
            lambda: getStarted_step5(
                self.label, self.lineEdit_27, self.lineEdit_28))
        self.actionStep_6.triggered.connect(
            lambda: getStarted_step6(
                self.label, self.lineEdit_27, self.lineEdit_28))

    def init_pushButton_connections(self):
        """Connect pushButtons to methods when they are pressed."""

        self.pushButton.clicked.connect(self.browse_image_1)
        self.pushButton_2.clicked.connect(self.clear_image_1)
        self.pushButton_3.clicked.connect(self.browse_image_2)
        self.pushButton_4.clicked.connect(self.clear_image_2)
        self.pushButton_5.clicked.connect(
            lambda: change_crs_to_EPSG_3857(self))
        self.pushButton_6.clicked.connect(
            lambda: register_point_on_map(self))
        self.pushButton_7.clicked.connect(
            lambda: add_to_the_point_cloud(self))
        self.pushButton_8.clicked.connect(
            lambda: remove_from_the_point_cloud(self))
        self.pushButton_9.clicked.connect(self.show_AddPointPolyMA)
        self.pushButton_10.clicked.connect(
            lambda: draw_area_on_map_MA(self))
        self.pushButton_11.clicked.connect(
            lambda: remove_selected_rows_MA(self))
        self.pushButton_12.clicked.connect(
            lambda: move_row_up_MA(self))
        self.pushButton_13.clicked.connect(
            lambda: clear_all_rows_and_remove_MA(self))
        self.pushButton_14.clicked.connect(
            lambda: move_row_down_MA(self))
        self.pushButton_15.clicked.connect(self.open_instructions_excel_MA)
        self.pushButton_16.clicked.connect(self.show_AddPointPolyPA)
        self.pushButton_17.clicked.connect(
            lambda: draw_area_on_map_PA(self))
        self.pushButton_18.clicked.connect(
            lambda: remove_selected_rows_PA(self))
        self.pushButton_19.clicked.connect(
            lambda: move_row_up_PA(self))
        self.pushButton_20.clicked.connect(
            lambda: clear_all_rows_and_remove_PA(self))
        self.pushButton_21.clicked.connect(
            lambda: move_row_down_PA(self))
        self.pushButton_22.clicked.connect(self.open_instructions_excel_PA)
        self.pushButton_23.clicked.connect(
            lambda: export_tablewidgets_2_excel(self))
        self.pushButton_24.clicked.connect(self.add_document)
        self.pushButton_25.clicked.connect(self.remove_selected_documents)
        self.pushButton_26.clicked.connect(self.imageLoader_1)
        self.pushButton_27.clicked.connect(
            lambda: ImageLoader_1.remove_checked_layouts(
                self, self.label, self.verticalLayout_17))
        self.pushButton_28.clicked.connect(self.back_btn)
        self.pushButton_29.clicked.connect(self.next_btn)
        self.pushButton_30.clicked.connect(self.register_in_attribute_table)

    def init_radioButton_connections(self):
        """Connect radioButtons to methods when they are toggled."""

        self.radioButton_4.toggled.connect(self.radioButton_4_clicked)
        # Section 2. Heritage Certificate. Enables lineEdit if Other is pressed
        self.radioButton_5.toggled.connect(
            lambda enabled: self.lineEdit_8.setEnabled(enabled))
        # Section 6.1 Typology.
        # Enables lineEdits and label if Other category button is pressed
        self.radioButton_8.toggled.connect(
            lambda enabled: (
                self.lineEdit_52.setEnabled(enabled),
                self.comboBox_2.setCurrentIndex(14) if enabled else None,
                self.comboBox_3.setCurrentIndex(-1) if enabled else None,
                self.lineEdit_52.clear() if not enabled else None))
        # Section 6.2 Construction details. Storeys:
        # Enables the lineEdit if the more button is pressed
        self.radioButton_14.toggled.connect(
            lambda enabled: self.lineEdit_32.setEnabled(enabled))
        # Section 8.1 Integrity of the heritage resource. Current condition:
        # Enables the combobox if the Demolished rbutton is pressed
        self.radioButton_15.toggled.connect(
            lambda enabled: self.comboBox_4.setEnabled(enabled))
        # Enables the textEdit if the 'Moved to a new location' is pressed
        self.radioButton_21.toggled.connect(
            lambda enabled: self.textEdit_23.setEnabled(enabled))
        # Section 8.2 Interventions and restoration work undertaken.
        # Alterations: Enables the checkboxed if the Yes button is pressed
        self.radioButton_23.toggled.connect(
            lambda checked: self.frame_14.setEnabled(checked))
        # Section 8.2 Interventions and restoration work undertaken.
        # Restorer - position:
        # Enables checkboxes and linedits if 'Yes' is pressed
        self.radioButton_25.toggled.connect(
            lambda enabled: self.frame_101.setEnabled(enabled))
        self.radioButton_26.toggled.connect(
            lambda: show_numbering_on_map_MA(self))
        # hide numbering in the vertices MA
        self.radioButton_27.setChecked(True)
        self.radioButton_27.toggled.connect(
            lambda: hide_numbering_from_map_MA(self))
        # Section 10.2 Availability, Workdays. Enabels the checkBoxes if the
        # Known is pressed
        self.radioButton_29.toggled.connect(
            lambda enabled: self.frame_104.setEnabled(enabled))
        # Section 8.2 Conservation standards (specify existing documents).
        # Enabels the textBox if the Yes button is pressed
        self.radioButton_31.toggled.connect(
            lambda enabled: self.textEdit_13.setEnabled(enabled))
        # Section 9.3 Management. Enables the textedit if 'other' is pressed
        self.radioButton_42.toggled.connect(
            lambda enabled: self.textEdit_14.setEnabled(enabled))
        # Section 8.3 Risks and threats. Enables checkboxes if Yes is pressed
        self.radioButton_43.toggled.connect(
            lambda enabled: self.frame_102.setEnabled(enabled))
        # shows the numbering in the verteces and points
        self.radioButton_44.toggled.connect(
            lambda: show_numbering_on_map_PA(self))
        # Section 2. IDENTIFICATION INFORMATION. Disables Heritage Ceritificate
        # and Heritage Certificate ID info containters if pressed
        self.radioButton_47.toggled.connect(
            lambda enabled: (
                self.radioButton_4.setChecked(not enabled),
                self.frame.setEnabled(not enabled),
                self.radioButton_4_clicked(enabled)))
        # Section 8.2 Interventions and restoration work undertaken.
        # Enables the lineEdit if the radiobutton is pressed
        self.radioButton_53.toggled.connect(
            lambda enabled: self.lineEdit_65.setEnabled(enabled))
        # Section 8.2 Interventions and restoration work undertaken.
        # Enables the lineEdit if the radiobutton is pressed
        self.radioButton_56.toggled.connect(
            lambda enabled: self.lineEdit_66.setEnabled(enabled))
        self.radioButton_60.setChecked(True)
        # by default hides the numbering in the verteces and points
        self.radioButton_60.toggled.connect(
            lambda: hide_numbering_from_map_PA(self))
        self.radioButton_61.toggled.connect(
            lambda: numbering_style_white_MA(self))
        self.radioButton_62.toggled.connect(
            lambda: numbering_style_black_MA(self))
        self.radioButton_63.toggled.connect(
            lambda: numbering_style_white_PA(self))
        self.radioButton_64.toggled.connect(
            lambda: numbering_style_black_PA(self))
        self.radioButton_65.toggled.connect(
            lambda enabled: self.lineEdit_59.setEnabled(enabled))
        self.radioButton_66.toggled.connect(
            lambda enabled: self.lineEdit_60.setEnabled(enabled))
        # Section 6.2 Construction Details. Author-position: Enables frame that
        # contains lineEdits and labels if Other category button is pressed
        self.radioButton_68.toggled.connect(
            lambda enabled: self.frame_99.setEnabled(enabled))
        # Section 6.1 Typology.
        # Enables the lineEdit and a label if  Other element button is pressed
        self.radioButton_69.toggled.connect(
            lambda enabled: (
                self.lineEdit_50.setEnabled(enabled),
                self.lineEdit_50.clear() if not enabled else None,
                self.comboBox_3.setCurrentIndex(
                    self.comboBox_3.count() - 1) if enabled else None))
        self.radioButton_76.toggled.connect(self.not_open_for_use_clicked)
        # Section 10.2 Availability. Disables the textEdit if No is pressed
        self.radioButton_79.toggled.connect(
            lambda enabled: self.frame_103.setEnabled(enabled))
        # Section 10.1 More then 1 use. Enables the textEdit if Yes is pressed
        self.radioButton_80.toggled.connect(
            lambda enabled: self.textEdit_54.setEnabled(enabled))

    def init_checkBox_connections(self):
        """
        Connect checkBoxes to methods when they are checked.
        When a checkbox is toggled, trigger associated lineEdits or textEdits
        to be enabled or disabled, or radioButtons to be toggled.
        """

        # Section 7. Reason for its designation:
        # Enables the lineEdit_38 if Other button is pressed
        self.checkBox_26.toggled.connect(
            lambda enabled: self.lineEdit_38.setEnabled(enabled))
        # Section 10.2 Availability. Enables the textEdit if Other is pressed
        self.checkBox_31.toggled.connect(
            lambda enabled: self.textEdit_49.setEnabled(enabled))
        # Section 8.3, Risks and threats.
        # Enables the textBox if the Other button is pressed
        self.checkBox_82.toggled.connect(
            lambda enabled: self.textEdit_26.setEnabled(enabled))
        # Section 10.3 Local Accessibility.
        # Enables the textBox if the Other button is pressed
        self.checkBox_112.toggled.connect(
            lambda enabled: self.textEdit_46.setEnabled(enabled))
        # Section 10, 10.2. 'Types of visits'.
        # Automatically toggles the 'Open for public use' radioButton if one of
        # the checkBox options is selected
        self.checkBox_122.toggled.connect(self.open_for_use)
        self.checkBox_123.toggled.connect(self.open_for_use)
        self.checkBox_124.toggled.connect(self.open_for_use)
        self.checkBox_125.toggled.connect(self.open_for_use)
        # Section 10.1 Use. Enables the textBox if the Other button is pressed
        self.checkBox_130.toggled.connect(
            lambda enabled: self.textEdit_53.setEnabled(enabled))

    def init_comboBox_connections(self):
        """
        Initialise the connections for the comboBoxes. Set up the connections
        for comboBox_2 and comboBox_3 to ensure that when an item is selected
        from the main category (comboBox_2) or the main item (comboBox_3), the
        corresponding radio buttons are unchecked.
        """

        self.comboBox.currentTextChanged.connect(self.update_lineedit_3246)
        # Section 6.1 Typology. If chosen from main category uncheck the other
        self.comboBox_2.activated.connect(
            lambda: self.radioButton_8.setChecked(False))
        self.comboBox_2.activated.connect(
            lambda: self.radioButton_69.setChecked(True))

        # Section 6.1 Typology. If chosen from main element uncheck the other
        self.comboBox_3.activated.connect(
            lambda: self.radioButton_69.setChecked(False))
        self.comboBox_2.currentIndexChanged.connect(self.updateElementCombo)
        self.comboBox_6.currentIndexChanged.connect(self.world_map)


    def init_lineEdit_validator(self):
        """Allow the use of only certain characters in lineEdits."""

        self.lineEdit.setValidator(QRegularExpressionValidator(QRegularExpression(r"^[^\d]+$")))
        self.lineEdit_2.setValidator(QRegularExpressionValidator(QRegularExpression(r"^[^\d]+$")))
        self.lineEdit_4.setValidator(QRegularExpressionValidator(QRegularExpression(r"^[^\d]+$")))
        self.lineEdit_5.setValidator(QRegularExpressionValidator(QRegularExpression(r"^[^\d]+$")))
        self.lineEdit_7.setValidator(QRegularExpressionValidator(QRegularExpression('[0-9-]+')))
        self.lineEdit_12.setValidator(QRegularExpressionValidator(QRegularExpression('[0-9]+')))
        self.lineEdit_20.setValidator(QRegularExpressionValidator(QRegularExpression(r"^[^\d]+$")))
        self.lineEdit_19.setValidator(QRegularExpressionValidator(QRegularExpression('[0-9]+')))
        self.lineEdit_21.setValidator(QRegularExpressionValidator(QRegularExpression(r"^[^\d]+$")))
        self.lineEdit_22.setValidator(QRegularExpressionValidator(QRegularExpression(r"^[^\d]+$")))
        self.lineEdit_29.setValidator(QRegularExpressionValidator(
            QRegularExpression('([1-9]|[1-5][0-9]|60)')))
        self.lineEdit_30.setValidator(QRegularExpressionValidator(QRegularExpression('[0-9]+')))
        self.lineEdit_31.setValidator(QRegularExpressionValidator(QRegularExpression('[0-9]+')))
        self.lineEdit_34.setValidator(
            QRegularExpressionValidator(QRegularExpression('[0-9]+\\.?[0-9]*')))
        self.lineEdit_35.setValidator(
            QRegularExpressionValidator(QRegularExpression('[0-9]+\\.?[0-9]*')))

    def init_dateEdit_setLocale(self):
        """
        Tab '1-3'. Section 1.
        Set the dateEdit to the current date and translate the content
        according to the language.
        """

        self.dateEdit.setDateTime(QtCore.QDateTime.currentDateTime())
        if self.label.text().startswith('Ամսաթիվ'):
            self.dateEdit.setLocale(QLocale(QLocale.Armenian, QLocale.Armenia))
        if self.label.text() == 'Date:':
            self.dateEdit.setLocale(
                QLocale(QLocale.English, QLocale.UnitedKingdom))
        if self.label.text() == 'Fecha:':
            self.dateEdit.setLocale(QLocale(QLocale.Spanish, QLocale.Spain))

    def init_combobox_lists(self):
        """Dictionary of languages and element types."""

        # Lists for comboBox_3 based on language
        self.lists_by_lang = {
            'Date:': [
                ['academy', 'school', 'university', 'other'],
                ['cinema', 'concert hall', 'house of culture', 'library',
                 'museum', 'opera', 'theatre', 'other'],
                ['bank', 'complex', 'department store', 'market', 'shop',
                 'shopping centre', 'other'],
                ['clinic', 'elderly care homes', 'health centre', 'hospital',
                 'other'],
                ['capitol', 'city hall', 'court', 'embassy',
                 'parliament building', 'house of representatives',
                 'ministry building', 'post office',
                 "prime minister's office/government house", 'town hall',
                 'other'],
                ['campground', 'hostel', 'hotel', 'house', 'rural house',
                 'other'],
                ['observatory', 'tecnological centre', 'transformer station',
                 'other'],
                ['barracks', 'fortress/fortification', 'military post',
                 'shelter', 'tower', 'other'],
                ['cathedral', 'chapel', 'church', 'gurdwara', 'monastery',
                 'mosque', 'pagoda', 'sanctuary', 'synagogue', 'temple', 'other'],
                ['bust', 'cemetery', 'cross-stone (khachkar)', 'grave',
                 'mausoleum', 'memorial fountain', 'pantheon', 'sculpture',
                 'statue', 'tomb', 'other'],
                ['cave', 'mosaic', 'petroglyph', 'remains', 'other'],
                ['aqueduct', 'bridge', 'drinking fountain', 'fountain',
                 'green area', 'historic garden', 'social meeting point',
                 'street', 'square', 'water area', 'other'],
                ['barn', 'canal', 'cellar', 'cultivation fields', 'farmland',
                 'stable', 'tool shed', 'winery', 'other'],
                ['graffiti', 'mural', 'ornamental object', 'painting',
                 'pottery and ceramics', 'stained glass', 'other'],
                ['']
            ],
            'Ամսաթիվ՝': [
                ['ակադեմիա', 'դպրոց', 'համալսարան', 'այլ'],
                ['գրադարան', 'թանգարան', 'թատրոն', 'կինոթատրոն', 'համերգասրահ',
                 'մշակույթի տուն', 'օպերա', 'այլ'],
                ['առևտրային կենտրոն/մոլ', 'բանկ', 'խանութ', 'համալիր',
                 'հանրախանութ', 'շուկա', 'այլ'],
                ['առողջարան', 'կլինիկա', 'հիվանդանոց', 'տարեցների խնամքի տներ',
                 'այլ'],
                ['դեսպանատուն', 'թաղապետարան', 'խորհրդարանի շենք',
                 'նախարարության շենք', 'դատարան', 'վարչապետական շենք',
                 'փոստի բաժանմունք', 'քաղաքապետարան', 'այլ'],
                ['ամառանոց', 'հանրակացարան', 'հյուրանոց', 'տուն', 'այլ'],
                ['աստղադիտարան', 'տեխնոլոգիական կենտրոն',
                 'տրանսֆորմատորային կայան', 'այլ'],
                ['աշտարակ', 'բերդ/ամրոց', 'դարպաս', 'դիրքեր', 'զորանոց',
                 'մարտադաշտ', 'այլ'],
                ['եկեղեցի', 'մատուռ', 'մզկիթ', 'սինագոգ', 'սրբավայր', 'վանք',
                 'տաճար', 'այլ'],
                ['արձան', 'գերեզման', 'գերեզմանատուն', 'դամբարան',
                 'դիմաքանդակ', 'խաչքար', 'կիսանդրի', 'հուշաղբյուր',
                 'հուշատախտակ', 'պանթեոն', 'վիշապաքար', 'տապանաքար', 'քանդակ',
                 'այլ'],
                ['ժայռապատկեր', 'խճանկար', 'հնագիտական մնացորդներ', 'քարանձավ',
                 'այլ'],
                ['այգի', 'կամուրջ', 'կանաչ տարածք', 'հրապարակ', 'շատրվան',
                 'ջրային տարածք', 'ջրատար', 'ջրմուղ', 'ցայտաղբյուր', 'փողոց',
                 'այլ'],
                ['գինու գործարան', 'գյուղատնտեսական տարածք', 'մառան',
                 'մշակման արտեր/դաշտեր', 'ջրանցք', 'այլ'],
                ['ապակենկար (վիտրաժ)', 'գեղանկարչություն', 'գրաֆիտի',
                 'զարդաքանդակ', 'խեցեղեն և կերամիկա', 'խճանկար', 'որմնանկար',
                 'պաննո', 'այլ'],
                ['']
            ],
            'Fecha:': [
                ['academia', 'escuela', 'universidad', 'otro'],
                ['biblioteca', 'casa de cultura', 'cine', 'museo', 'ópera',
                 'sala de conciertos', 'teatro', 'otro'],
                ['banco', 'centro comercial', 'grandes almacenes', 'mercado',
                 'tienda', 'otro'],
                ['centro de salud', 'clínica', 'hospital',
                 'residencias para mayores', 'otro'],
                ['ayuntamiento', 'edificio de parlamento',
                 'edificio del ministerio',
                 'embajada', 'oficina de correos', 'palacio de justicia',
                 'palacio de la moncloa/casa de gobierno',
                 'palacio de las cortes',
                 'palacio del congreso de los diputados', 'otro'],
                ['albergue', 'camping', 'casa', 'casa rural', 'hotel', 'otro'],
                ['centro tecnológico', 'estación transformadora',
                 'observatorio', 'otro'],
                ['cuartel', 'fortaleza/fortificación', 'puestos militares',
                 'refugio', 'torre', 'otro'],
                ['capilla', 'catedral', 'gurdwara', 'iglesia', 'mezquita',
                 'monasterio', 'pagoda', 'santuario', 'sinagoga', 'templo',
                 'otro'],
                ['busto', 'cementerio', 'escultura', 'estatua',
                 'fuente conmemorativa', 'mausoleo', 'panteón',
                 'placa conmemorativa', 'sepulcro', 'tumba', 'otro'],
                ['cueva', 'mosaico', 'petroglifo', 'restos', 'otro'],
                ['acueducto', 'bebedero', 'calle', 'canal', 'fuente',
                 'jardín histórico', 'planta', 'plaza', 'puente',
                 'punto de encuentro social', 'zona de agua', 'zona verde',
                 'otro'],
                ['bodega', 'campos de cultivo', 'casa de aperos', 'establo',
                 'granero', 'otro'],
                ['alfarería y cerámica', 'cuadro', 'grafiti', 'mural',
                 'objeto ornamental', 'vidrieras', 'otro'],
                ['']
            ]
        }

    def update_combo_box_X(self):
        """
        Disables 'X' option in Latitude band (comboBox) if the text in UTM Zone
        (lineEdit_29) is 32, 34 or 36.
        """

        if self.lineEdit_29.text() in {"32", "34", "36"}:
            self.comboBox.model().item(20).setEnabled(False)
        else:
            self.comboBox.model().item(20).setEnabled(True)

    def update_lineedit_3246(self):
        """
        Update the input validation for UTM Zone (lineEdit_29) based on the
        current selection of the Latitude band (comboBox). If the current text
        of comboBox is 'X', the input for lineEdit_29 is restricted to prevent
        the values 32, 34, and 36.
        """

        current_text = self.comboBox.currentText()
        if current_text == "X":
            # Prevent lineEdit_29 from accepting values 32, 34, 36
            regex = QRegularExpression("(?!32|34|36).*")  # Restrict input except for 32, 34, and 36
            validator = QRegularExpressionValidator(regex)
            self.lineEdit_29.setValidator(validator)
        else:
            # Allow lineEdit_29 to accept values 32, 34, 36
            self.lineEdit_29.setValidator(None)

    def translate(self, context, text):
        """Translate the given text in the given context."""

        return QCoreApplication.translate(context, text)

    def pantool(self):
        """Set the mouse as a pantool."""

        iface.actionPan().trigger()

    def new_worksheet(self):
        """Open a new worksheet."""

        msg_box = QMessageBox()
        msg_box.setIcon(QMessageBox.Information)
        if self.label.text().startswith('Ամսաթիվ'):
            window_title = 'Նոր աշխատաթերթը բացման ընթացքում է'
            quit_msg = ('Դուք պատրաստվում եք բացել նոր աշխատանքային թերթ: '
                        'Խնդրում ենք նկատի ունենալ, որ բոլոր տվյալները '
                        'կջնջվեն ընթացիկ աշխատաթերթից: Համոզվեք, որ պահպանել '
                        'եք նախագիծը նախքան նորը բացելը:\n\nԿցանկանա՞ք բացել '
                        'նոր աշխատաթերթ:')
            yes_text = 'Այո'
            cancel_text = 'Ոչ'
        elif self.label.text() == 'Date:':
            window_title = 'Opening new Worksheet'
            quit_msg = ('You are about to open a new Worksheet. Please note, '
                        'that all data will be erased from the current '
                        'Worksheet. Make sure to save the project before '
                        'opening the new one.\n\nWould you still like to open '
                        'a new Worksheet?')
            yes_text = 'Yes'
            cancel_text = 'No'
        elif self.label.text() == 'Fecha:':
            window_title = 'Abriendo nueva ficha'
            quit_msg = ('Está a punto de abrir una nueva ficha. Tenga en '
                        'cuenta que se borrarán todos los datos de la ficha '
                        'actual. Asegúrese de guardar el proyecto antes de '
                        'abrir uno nuevo\n\n¿Desea abrir una nueva ficha?')
            yes_text = 'Sí'
            cancel_text = 'No'
        msg_box.setWindowTitle(window_title)
        msg_box.setText(quit_msg)
        yes_button = msg_box.addButton(yes_text, QMessageBox.YesRole)
        msg_box.addButton(cancel_text, QMessageBox.RejectRole)
        msg_box.exec_()
        reply = msg_box.clickedButton()
        if reply == yes_button:
            if self.confirm_close():
                self.initiated_from_new_worksheet = True
                self.close()
                self.mw = HeritageInventoryMain()
                self.mw.show()

    def create_new_project(self):
        """Menu bar. File > New Project. Create a new project"""

        msg_box = QMessageBox()
        if self.label.text().startswith('Ամսաթիվ'):
            window_title = ''
            quit_msg = ('Խնդրում ենք ընտրել այն թղթապանակը, որտեղ կպահվի '
                        'ամբողջ նախագիծը:')
            button_Yes = msg_box.addButton(
                        'Ընտրել թղթապանակը', QMessageBox.YesRole)
            _ = msg_box.addButton('Չեղարկել', QMessageBox.NoRole)
        if self.label.text() == 'Date:':
            window_title = ''
            quit_msg = ('Please, select the folder where all the project will '
                        'be saved.')
            button_Yes = msg_box.addButton('Select folder', QMessageBox.YesRole)
            _ = msg_box.addButton('Cancel', QMessageBox.NoRole)
        if self.label.text() == 'Fecha:':
            window_title = ''
            quit_msg = ('Por favor, seleccione la carpeta donde se guardará '
                        'todo el proyecto.')
            button_Yes = msg_box.addButton(
                        'Seleccionar carpeta', QMessageBox.YesRole)
            _ = msg_box.addButton('Cancelar', QMessageBox.NoRole)
        msg_box.setWindowTitle(window_title)
        msg_box.setText(quit_msg)
        msg_box.exec_()
        reply = msg_box.clickedButton()
        if reply == button_Yes:
            self.direct_img()
            self.create_polygon_layer_PA()
            self.create_polygon_layer_MA()
            self.create_point_layer()
            self.change_display_name()

    def create_polygon_layer_PA(self):
        """
        Create a polygon layer for Protected Area and add it to the project.
        """

        if directory:
            Fields = QgsFields()
            Fields.append(QgsField('ID', QVariant.String))

            for fTitle in fieldTitles:
                Fields.append(QgsField(fTitle, QVariant.String))
            crs = QgsProject.instance().crs()
            newpath = directory.replace(os.sep, '/')
            fName = '{}\Protected_Area.gpkg'.format(newpath)
            crs = QgsProject.instance().crs()

            save_options = QgsVectorFileWriter.SaveVectorOptions()
            save_options.driverName = 'GPKG'
            save_options.fileEncoding = 'utf-8'

            writer = QgsVectorFileWriter.create(
                fileName=fName,  # file name to write to
                fields=Fields,  # fields to write
                # geometry type of output file
                geometryType=QgsWkbTypes.Polygon,
                srs=crs,  # spatial reference system of output file
                # coordinate transform context
                transformContext=QgsCoordinateTransformContext(),
                options=save_options)  # save options
            del writer  # delete the writer to flush features to disk

            layer = QgsVectorLayer(
                r'{}'.format(fName), 'Protected_Area', 'ogr')  # layer details

            editor_widget_setup = QgsEditorWidgetSetup(
                'ExternalResource', {
                    'FileWidget': True, 'DocumentViewer': 1,
                    'RelativeStorage': 0, 'StorageMode': 0,
                    'DocumentViewerHeight': 0, 'FileWidgetButton': True,
                    'DocumentViewerWidth': 800})

            index1 = layer.fields().indexFromName('3.vipr_im_1')
            index2 = layer.fields().indexFromName('3.vipr_im_2')

            layer.setEditorWidgetSetup(index1, editor_widget_setup)
            layer.setEditorWidgetSetup(index2, editor_widget_setup)

            # polygin sybology
            myRenderer = layer.renderer()
            mySymbol1 = QgsFillSymbol.createSimple({
                'color': '218,218,218,89', 'color_border': '#000000',
                'width_border': '0.5', 'outline_style': 'dot'})
            myRenderer.setSymbol(mySymbol1)

            # polygon label
            layer_settings = QgsPalLayerSettings()
            text_format = QgsTextFormat()
            text_format.setFont(QFont('Arial'))
            text_format.setSize(9)
            layer_settings.setFormat(text_format)
            layer_settings.fieldName = '2.idin_name'
            layer_settings.Placement = 7
            layer_settings.placementFlags = (
                QgsPalLayerSettings.AboveLine | QgsPalLayerSettings.BelowLine)
            layer_settings.dist = 2
            layer_settings.enabled = True
            layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)
            layer.setLabelsEnabled(True)
            layer.setLabeling(layer_settings)

            QgsProject.instance().addMapLayer(layer)
            # iface.showAttributeTable(layer)

    def create_polygon_layer_MA(self):
        """
        Create a polygon layer for Monument Area and add it to the project.
        """

        if directory:
            Fields = QgsFields()
            Fields.append(QgsField('ID', QVariant.String))

            for fTitle in fieldTitles:
                Fields.append(QgsField(fTitle, QVariant.String))
            crs = QgsProject.instance().crs()
            newpath = directory.replace(os.sep, '/')
            fName = '{}\Monument_Area.gpkg'.format(newpath)
            crs = QgsProject.instance().crs()

            save_options = QgsVectorFileWriter.SaveVectorOptions()
            save_options.driverName = 'GPKG'
            save_options.fileEncoding = 'utf-8'

            writer = QgsVectorFileWriter.create(
                fileName=fName,  # file name to write to
                fields=Fields,  # fields to write
                # geometry type of output file
                geometryType=QgsWkbTypes.Polygon,
                srs=crs,  # spatial reference system of output file
                # coordinate transform context
                transformContext=QgsCoordinateTransformContext(),
                options=save_options)  # save options
            del writer  # delete the writer to flush features to disk

            layer = QgsVectorLayer(r'{}'.format(fName), 'Monument_Area', 'ogr')

            editor_widget_setup = QgsEditorWidgetSetup(
                'ExternalResource', {
                    'FileWidget': True, 'DocumentViewer': 1,
                    'RelativeStorage': 0, 'StorageMode': 0,
                    'DocumentViewerHeight': 0, 'FileWidgetButton': True,
                    'DocumentViewerWidth': 800})

            index1 = layer.fields().indexFromName('3.vipr_im_1')
            index2 = layer.fields().indexFromName('3.vipr_im_2')

            layer.setEditorWidgetSetup(index1, editor_widget_setup)
            layer.setEditorWidgetSetup(index2, editor_widget_setup)

            # polygin sybology
            color_base = QColor(218, 218, 218, 89)
            black = QColor(0, 0, 0, 255)

            # base symbol
            base_symbol = QgsSimpleFillSymbolLayer(
                color=color_base,
                strokeColor=black,
                strokeWidth=0.5)
            layer.renderer().symbol().changeSymbolLayer(0, base_symbol)
            layer.triggerRepaint()

            # polygon label
            layer_settings = QgsPalLayerSettings()
            text_format = QgsTextFormat()
            text_format.setFont(QFont('Arial', 10))
            layer_settings.setFormat(text_format)
            layer_settings.fieldName = 'ID'
            layer_settings.enabled = True
            layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)
            layer.setLabelsEnabled(True)
            layer.setLabeling(layer_settings)

            layer.triggerRepaint()

            QgsProject.instance().addMapLayer(layer)
            # iface.showAttributeTable(layer)

    def create_point_layer(self):
        """Create a point layer and add it to the project."""

        if directory:
            Fields = QgsFields()
            Fields.append(QgsField('ID', QVariant.String))

            for fTitle in fieldTitles:
                Fields.append(QgsField(fTitle, QVariant.String))

            crs = QgsProject.instance().crs()
            newpath = directory.replace(os.sep, '/')
            fName = '{}\Representative_Point.gpkg'.format(newpath)
            crs = QgsProject.instance().crs()
            save_options = QgsVectorFileWriter.SaveVectorOptions()
            save_options.driverName = 'GPKG'
            save_options.fileEncoding = 'utf-8'
            writer = QgsVectorFileWriter.create(
                fileName=fName,  # file name to write to
                fields=Fields,  # fields to write
                geometryType=QgsWkbTypes.Point,  # geometry type of output file
                srs=crs,  # spatial reference system of output file
                # coordinate transform context
                transformContext=QgsCoordinateTransformContext(),
                options=save_options)  # save options
            del writer  # delete the writer to flush features to disk
            layer = QgsVectorLayer(
                r'{}'.format(fName), 'Representative_Point', 'ogr')

            editor_widget_setup = QgsEditorWidgetSetup(
                'ExternalResource', {
                    'FileWidget': True, 'DocumentViewer': 1,
                    'RelativeStorage': 0, 'StorageMode': 0,
                    'DocumentViewerHeight': 0, 'FileWidgetButton': True,
                    'DocumentViewerWidth': 800})

            index1 = layer.fields().indexFromName('3.vipr_im_1')
            index2 = layer.fields().indexFromName('3.vipr_im_2')

            layer.setEditorWidgetSetup(index1, editor_widget_setup)
            layer.setEditorWidgetSetup(index2, editor_widget_setup)

            QgsProject.instance().addMapLayer(layer)  # add layer to the map
            # iface.showAttributeTable(layer)  # open the Attribute Table

    def change_display_name(self):
        """Update display names for all layers to use the field '2.idin_name'."""

        layers = ['Representative_Point', 'Monument_Area', 'Protected_Area']
        for layer in layers:
            lay = QgsProject.instance().mapLayersByName(layer)[0]
            lay.setDisplayExpression(' \"2.idin_name\" ')

    def direct_img(self):
        """Create folders and store the directory of images and documents."""

        global directory
        directory = QFileDialog().getExistingDirectory()
        if (not directory or
            len(directory) == 0 or
                not os.path.exists(directory)):
            return

        folder_images = 'Heritage_Images'
        folder_docs = 'Heritage_Docs'

        global dir_doc, dir_img
        dir_doc = directory+'/'+folder_docs
        dir_img = directory+'/'+folder_images

        try:
            os.makedirs(dir_img)
            os.makedirs(dir_doc)
        except OSError:
            if not os.path.isdir(dir_img):
                raise
            if not os.path.isdir(dir_doc):
                raise

    def save_project_file(self):
        """
        Menu bar. File > Save project.
        Save project as *.qgs or *.qgz file.
        """

        if self.label.text().startswith('Ամսաթիվ'):
            title = 'Պահպանել Ֆայլը'
        elif self.label.text() == 'Date:':
            title = 'Save File'
        elif self.label.text() == 'Fecha:':
            title = 'Guardar archivo'
        path, _ = QFileDialog.getSaveFileName(
            None, title, '', 'QGIS (*.qgs);; QGZ (*qgz)')
        if path:
            if os.path.isfile(path):
                os.remove(path)
            QgsProject.instance().setFileName(path)
            QgsProject.instance().write()

    def export_as_xls(self):
        """
        Menu bar. File > Export to Excel.
        Export atribute table as an Excel file (xlsx).
        """

        layers = QgsProject.instance().mapLayers().values()
        name = []
        for layer in layers:
            name.append(layer.name())
        if any(x == 'Representative_Point' for x in name):
            if self.label.text().startswith('Ամսաթիվ'):
                title = 'Պահպանել Excel տարբերակով'
            elif self.label.text() == 'Date:':
                title = 'Export layers as Excel'
            elif self.label.text() == 'Fecha:':
                title = 'Exportar capas a Excel'
            path, _ = QFileDialog.getSaveFileName(
                self, title, '', 'Excel (*.xlsx)')
            if path != '':
                layer0 = QgsProject.instance().mapLayersByName(
                    'Protected_Area')[0]
                layer1 = QgsProject.instance().mapLayersByName(
                    'Monument_Area')[0]
                layer2 = QgsProject.instance().mapLayersByName(
                    'Representative_Point')[0]
                crs = QgsProject.instance().transformContext()
                options = QgsVectorFileWriter.SaveVectorOptions()
                options.driverName = 'XLSX'
                options.fileEncoding = 'UTF-8'
                options.layerOptions = ['GEOMETRY=AS_XYZ']
                options.layerName = 'Protected_Area'
                # polygon layers
                QgsVectorFileWriter.writeAsVectorFormatV3(
                    layer0, path, crs, options)

                options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteLayer
                options.layerName = 'Monument_Area'
                QgsVectorFileWriter.writeAsVectorFormatV3(
                    layer1, path, crs, options)
                # point layer
                options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteLayer
                options.layerName = 'Representative_Point'
                QgsVectorFileWriter.writeAsVectorFormatV3(
                    layer2, path, crs, options)
        else:
            msg_box = QMessageBox()
            if self.label.text().startswith('Ամսաթիվ'):
                msg_box.information(
                    self, 'Նախագիծը բացակայում է',
                    'Նախագծում բացակայում են կանխադրված շերտերը։\n\nԽնդրում '
                    'ենք ստեղծել մի նոր նախագիծ կամ բացել արդեն գույություն '
                    'ունեցողը և նորից փորձել:')
            elif self.label.text() == 'Date:':
                msg_box.information(
                    self, 'The project is not loaded', 'The default layers '
                    'are missing from the project.\n\nPlease create or open a '
                    'project and try again.')
            elif self.label.text() == 'Fecha:':
                msg_box.information(
                    self, 'El proyecto no está cargado', 'Faltan las capas '
                    'por defecto del proyecto.\n\nPor favor, cree o abre un '
                    'proyecto e inténtelo de nuevo.')

    def open_project(self):
        """
        Menu bar. File > Open project.
        Open an existing *.qgs or *.qgz project file.
        """

        if self.label.text().startswith('Ամսաթիվ'):
            title = 'Ընտրել գոյություն ունեցող նախագիծ'
        elif self.label.text() == 'Date:':
            title = 'Select an existing project'
        elif self.label.text() == 'Fecha:':
            title = 'Seleccionar un proyecto existente'
        path, _ = QFileDialog.getOpenFileName(
            self, title, '', 'QGIS, QGZ (*.qgs *qgz)')
        if path:
            project = QgsProject.instance()
            project.read(path)

    def am(self):
        """Change the interface to Armenian."""

        msg_box = QMessageBox()
        if self.label.text().startswith('Ամսաթիվ'):
            window_title = 'Անցնել հայերենի'
            quit_msg = ('Աշխատանքային թերթի բոլոր մուտքագրված տվյալները '
                        'հնարավոր է որ ջնջվեն:\n\nՑանկանու՞մ եք շարունակել '
                        'փոխել լեզուն:')
            button_Yes = msg_box.addButton('Այո', QMessageBox.YesRole)
            _ = msg_box.addButton('Ոչ', QMessageBox.NoRole)
        if self.label.text() == 'Date:':
            window_title = 'Switch to Armenian'
            quit_msg = ('You are about to switch to Armenian.\nAll the data '
                        'input in the Worksheet may be deleted.\n\nWould you '
                        'like to proceed with changing the language?')
            button_Yes = msg_box.addButton('Yes', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        if self.label.text() == 'Fecha:':
            window_title = 'Cambiar al Armenio'
            quit_msg = ('Está a punto de cambiar al Armenio.\nPuede ser que '
                        'se borren todos los datos introducidos en la ficha.'
                        '\n\n¿Desea continuar con el cambio de idioma?')
            button_Yes = msg_box.addButton('Sí', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        msg_box.setWindowTitle(window_title)
        msg_box.setText(quit_msg)
        msg_box.exec_()
        reply = msg_box.clickedButton()
        if reply == button_Yes:
            self.selected_language = 'Հայերեն'
            self.close()
            self.translator = QTranslator()
            self.translator.load(
                f'{self.plugin_dir}/i18n/HeritageInventory_hye_AM.qm')
            QCoreApplication.installTranslator(self.translator)
            self.mw = HeritageInventoryMain()
            self.mw.show()

    def en(self):
        """Change the interface to English."""

        msg_box = QMessageBox()
        if self.label.text().startswith('Ամսաթիվ'):
            window_title = 'Անցնել անգլերենի'
            quit_msg = ('Աշխատանքային թերթի բոլոր մուտքագրված տվյալները '
                        'հնարավոր է որ ջնջվեն:\n\nՑանկանու՞մ եք շարունակել '
                        'փոխել լեզուն:')
            button_Yes = msg_box.addButton('Այո', QMessageBox.YesRole)
            _ = msg_box.addButton('Ոչ', QMessageBox.NoRole)
        if self.label.text() == 'Date:':
            window_title = 'Switch to English'
            quit_msg = ('You are about to switch to English.\nAll the data '
                        'input in the Worksheet may be deleted.\n\nWould you '
                        'like to proceed with changing the language?')
            button_Yes = msg_box.addButton('Yes', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        if self.label.text() == 'Fecha:':
            window_title = 'Cambiar al Inglés'
            quit_msg = ('Está a punto de cambiar al Inglés.\nPuede ser que se '
                        'borren todos los datos introducidos en la ficha.\n\n'
                        '¿Desea continuar con el cambio de idioma?')
            button_Yes = msg_box.addButton('Sí', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        msg_box.setWindowTitle(window_title)
        msg_box.setText(quit_msg)
        msg_box.exec_()
        reply = msg_box.clickedButton()
        if reply == button_Yes:
            self.selected_language = 'English'
            self.close()
            self.translator = QTranslator()
            self.translator.load(
                f'{self.plugin_dir}/i18n/HeritageInventory_eng_GB.qm')
            QCoreApplication.installTranslator(self.translator)
            self.mw = HeritageInventoryMain()
            self.mw.show()

    def es(self):
        """Change the interface to Spanish."""

        msg_box = QMessageBox()
        if self.label.text().startswith('Ամսաթիվ'):
            window_title = 'Անցնել իսպաներենի'
            quit_msg = ('Աշխատանքային թերթի բոլոր մուտքագրված տվյալները '
                        'հնարավոր է որ ջնջվեն:\n\nՑանկանու՞մ եք շարունակել '
                        'փոխել լեզուն:')
            button_Yes = msg_box.addButton('Այո', QMessageBox.YesRole)
            _ = msg_box.addButton('Ոչ', QMessageBox.NoRole)
        if self.label.text() == 'Date:':
            window_title = 'Switch to Spanish'
            quit_msg = ('You are about to switch to Spanish.\nAll the data '
                        'input in the Worksheet may be deleted.\n\nWould you '
                        'like to proceed with changing the language?')
            button_Yes = msg_box.addButton('Yes', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        if self.label.text() == 'Fecha:':
            window_title = 'Cambiar al Castellano'
            quit_msg = ('Está a punto de cambiar al Castellano.\nPuede ser '
                        'que se borren todos los datos introducidos en la '
                        'ficha.\n\n¿Desea continuar con el cambio de idioma?')
            button_Yes = msg_box.addButton('Sí', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        msg_box.setWindowTitle(window_title)
        msg_box.setText(quit_msg)
        msg_box.exec_()
        reply = msg_box.clickedButton()
        if reply == button_Yes:
            self.selected_language = 'Español'
            self.close()
            self.translator = QTranslator()
            self.translator.load(
                f'{self.plugin_dir}/i18n/HeritageInventory_spa_ES.qm')
            QCoreApplication.installTranslator(self.translator)
            self.dateEdit.setLocale(QLocale(QLocale.Spanish, QLocale.Spain))
            self.mw = HeritageInventoryMain()
            self.mw.show()


    def confirm_close(self):
        """Handle the close confirmation."""

        msg_box = QMessageBox()
        if self.label.text().startswith('Ամսաթիվ'):
            window_title = 'Վստա՞հ եք, որ ուզում եք դուրս գալ:'
            quit_msg = ('Աշխատանքային թերթի բոլոր մուտքագրված տվյալները '
                        'հնարավոր է որ ջնջվեն:')
            button_Yes = msg_box.addButton('Այո', QMessageBox.YesRole)
            _ = msg_box.addButton('Ոչ', QMessageBox.NoRole)
        if self.label.text() == 'Date:':
            window_title = 'Are you sure you want to exit?'
            quit_msg = 'All the data input in the Worksheet may be deleted.'
            button_Yes = msg_box.addButton('Yes', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        if self.label.text() == 'Fecha:':
            window_title = '¿Está seguro de que desea salir?'
            quit_msg = ('Puede ser que se borren todos los datos '
                        'introducidos en la ficha.')
            button_Yes = msg_box.addButton('Sí', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        msg_box.setWindowTitle(window_title)
        msg_box.setText(quit_msg)
        msg_box.exec_()
        reply = msg_box.clickedButton()
        if reply == button_Yes:
            return True
        return False

    def closeEvent(self, event):
        """Handle the close event."""
        if not self.initiated_from_new_worksheet:
            if self.selected_language is None:
                if self.confirm_close():
                    event.accept()
                else:
                    event.ignore()
            else:
                event.accept()
        else:
            event.accept()
            # Reset the flag to False for the next session
            self.initiated_from_new_worksheet = False

    def back_btn(self):
        """Return to the previous tab."""

        i = self.tabWidget.currentIndex()
        if -1 < i < 11:
            i -= 1
            self.tabWidget.setCurrentIndex(i)

    def next_btn(self):
        """Go to the next tab."""

        i = self.tabWidget.currentIndex()
        if -1 < i < 11:
            i += 1
            self.tabWidget.setCurrentIndex(i)

    def browse_image_1(self):
        """
        Tab '1-3'. Section 3. Browse button, current state.
        Browse an image for the current state of the heritage.
        """

        # Open a file dialog to browse for an image file
        self.label_130.setEnabled(True)
        global fnameim_1
        if self.label.text().startswith('Ամսաթիվ'):
            caption = 'Ընտրել պատկերը '
            ext = ('Պատկերային ֆայլեր '
                   '(*.jpg *.jpeg *.png *.jfif *.tiff *.raw *.bmp)')
        elif self.label.text() == 'Date:':
            caption = 'Select an image'
            ext = ('Image Files '
                   '(*.jpg *.jpeg *.png *.jfif *.tiff *.raw *.bmp)')
        elif self.label.text() == 'Fecha:':
            caption = 'Seleccione una imagen'
            ext = ('Archivos de imagen '
                   '(*.jpg *.jpeg *.png *.jfif *.tiff *.raw *.bmp)')
        fnameim_1, _ = QFileDialog.getOpenFileName(self, caption, '', ext)
        # Load the selected image and display it in the QLabel
        if fnameim_1:
            pixmapim_1 = QPixmap(fnameim_1)
            pixmapim_1 = pixmapim_1.scaled(
                                           384, pixmapim_1.height(),
                                           QtCore.Qt.KeepAspectRatio,
                                           QtCore.Qt.SmoothTransformation)
            self.label_130.setPixmap(pixmapim_1)
        else:
            self.label_130.setEnabled(False)

    def browse_image_2(self):
        """
        Tab '1-3'. Section 3. Browse button, initial state.
        Browse an image for the initial state of the heritage.
        """

        # Open a file dialog to browse for an image file
        self.label_131.setEnabled(True)
        global fnameim_2
        if self.label.text().startswith('Ամսաթիվ'):
            caption = 'Ընտրել պատկերը'
            ext = ('Պատկերային ֆայլեր '
                   '(*.jpg *.jpeg *.png *.jfif *.tiff *.raw *.bmp)')
        elif self.label.text() == 'Date:':
            caption = 'Select an image'
            ext = ('Image Files '
                   '(*.jpg *.jpeg *.png *.jfif *.tiff *.raw *.bmp)')
        elif self.label.text() == 'Fecha:':
            caption = 'Seleccione una imagen'
            ext = ('Archivos de imagen '
                   '(*.jpg *.jpeg *.png *.jfif *.tiff *.raw *.bmp)')
        fnameim_2, _ = QFileDialog.getOpenFileName(self, caption, '', ext)
        # Load the selected image and display it in the QLabel
        if fnameim_2:
            pixmapim_2 = QPixmap(fnameim_2)
            pixmapim_2 = pixmapim_2.scaled(
                                           384, pixmapim_2.height(),
                                           QtCore.Qt.KeepAspectRatio,
                                           QtCore.Qt.SmoothTransformation)
            self.label_131.setPixmap(pixmapim_2)
        else:
            self.label_131.setEnabled(False)

    def clear_image_1(self):
        """
        Tab '1-3'. Section 3. Clear button, current state.
        Clear selected image for the current state of the heritage.
        """

        self.label_130.clear()
        # self.resize(self.label_130.width(), self.label_130.height())
        self.label_130.setEnabled(False)

    def clear_image_2(self):
        """
        Tab '1-3'. Section 3. Clear button, initial state.
        Clear selected image for the initial state of the heritage.
        """

        self.label_131.clear()
        # self.resize(self.label_131.width(), self.label_131.height())
        self.label_131.setEnabled(False)

    def radioButton_4_clicked(self, enabled):
        """
        Tab '1-3'. Section 2. 'Heritage Certificate'.
        Disable the Heritage Certificate ID lineEdit if 'Does not have a
        certificate' button is pressed.
        """

        if enabled:
            self.lineEdit_9.clear()
            self.lineEdit_9.setEnabled(False)
            if self.label.text().startswith('Ամսաթիվ'):
                self.lineEdit_9.setText('Բացակայում է')
            elif self.label.text() == 'Date:':
                self.lineEdit_9.setText('None')
            elif self.label.text() == 'Fecha:':
                self.lineEdit_9.setText('Ninguno')
        else:
            self.lineEdit_9.clear()
            self.lineEdit_9.setEnabled(True)


    def updateElementCombo(self, index):
        """
        Tab '6'. Section 6.1.
        Update the list of items in the item's combo box depending on the
        language and the item selected from the category list.
        """

        self.comboBox_3.clear()
        language = self.label.text()
        if language in self.lists_by_lang:
            self.comboBox_3.addItems(self.lists_by_lang[language][index])

    def open_for_use(self):
        """
        Tab '10'. Section 10.2 Types of visits.
        Toggle the 'Open for public use' radioButton if one of the checkBox
        options is selected.
        """

        self.radioButton_79.setChecked(True)

    def not_open_for_use_clicked(self, disabled):
        """
        Tab '10'. Section 10.2. 'Types of visits'.
        Uncheck all options for types of visits.
        """

        if disabled:
            self.checkBox_122.setChecked(False)
            self.checkBox_123.setChecked(False)
            self.checkBox_124.setChecked(False)
            self.checkBox_125.setChecked(False)
            self.frame_19.setEnabled(False)
        else:
            self.frame_19.setEnabled(True)

    def register_in_attribute_table(self):
        """
        Confirm the folder where the files should be saved.
        """

        msg_box = QMessageBox()
        if self.label.text().startswith('Ամսաթիվ'):
            quit_msg = ('Խնդրում ենք հաստատել այն թղթապանակը, որտեղ կպահվի '
                        'ամբողջ նախագիծը:')
            button_Yes = msg_box.addButton('Այո', QMessageBox.YesRole)
            _ = msg_box.addButton('Ոչ', QMessageBox.NoRole)
        if self.label.text() == 'Date:':
            quit_msg = ('Please, confirm the folder where all the project '
                        'will be saved.')
            button_Yes = msg_box.addButton('Yes', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        if self.label.text() == 'Fecha:':
            quit_msg = ('Por favor, confirme la carpeta donde se guardará '
                        'todo el proyecto.')
            button_Yes = msg_box.addButton('Sí', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        msg_box.setWindowTitle('')
        msg_box.setText(quit_msg)
        msg_box.exec_()
        reply = msg_box.clickedButton()
        if reply == button_Yes:
            self.direct_img()
            register_tabs(self, dir_doc, dir_img, fnameim_1, fnameim_2)
            self.save_project_to_folder()
            self.save_excel_to_folder()

    def save_project_to_folder(self):
        """Save the project file to the folder."""

        msg_box = QMessageBox()
        if self.label.text().startswith('Ամսաթիվ'):
            window_title = 'Պահպանել նախագիծը'
            quit_msg = 'Ցանկանու՞մ եք պահպանել նախագիծը:'
            button_Yes = msg_box.addButton('Այո', QMessageBox.YesRole)
            _ = msg_box.addButton('Ոչ', QMessageBox.NoRole)
        if self.label.text() == 'Date:':
            window_title = 'Save the project'
            quit_msg = 'Would you like to save the project?'
            button_Yes = msg_box.addButton('Yes', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        if self.label.text() == 'Fecha:':
            window_title = 'Guardar el proyecto'
            quit_msg = '¿Desea guardar el proyecto?'
            button_Yes = msg_box.addButton('Sí', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        msg_box.setWindowTitle(window_title)
        msg_box.setText(quit_msg)
        msg_box.exec_()
        reply = msg_box.clickedButton()
        if reply == button_Yes:
            self.save_project_file()

    def save_excel_to_folder(self):
        """
        Prepare an Excel file containing the registered coordinates of the
        Monument and Protected area.
        """

        msg_box = QMessageBox()
        if self.label.text().startswith('Ամսաթիվ'):
            window_title = 'Excel ֆայլ'
            quit_msg = ('Մուտքագրեք Excel ֆայլի անունը, որը պարունակում է '
                        'հուշարձանի և պահպանական գոտու տարածքների '
                        'կոորդինատները:')
            button_Yes = msg_box.addButton('Այո', QMessageBox.YesRole)
            _ = msg_box.addButton('Ոչ', QMessageBox.NoRole)
        if self.label.text() == 'Date:':
            window_title = 'Excel file'
            quit_msg = ('Please provide a name for an Excel file that contains'
                        ' the registered coordinates of the monument and '
                        'protected area.')
            button_Yes = msg_box.addButton('Yes', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        if self.label.text() == 'Fecha:':
            window_title = 'Archivo Excel'
            quit_msg = ('Indique un nombre para un archivo Excel que contiene '
                        'las coordenadas registradas del monumento y la zona '
                        'protegida.')
            button_Yes = msg_box.addButton('Sí', QMessageBox.YesRole)
            _ = msg_box.addButton('No', QMessageBox.NoRole)
        msg_box.setWindowTitle(window_title)
        msg_box.setText(quit_msg)
        msg_box.exec_()
        reply = msg_box.clickedButton()
        if reply == button_Yes:
            export_tablewidgets_2_excel(self)

    def add_row(self, table_widget, input_polygon_coords_func):
        """Add a row to the tableWidget and prompt for coordinate input."""

        if (self.AddPointPoly.lineEdit.text() and
            self.AddPointPoly.comboBox.currentIndex() != 0 and
            self.AddPointPoly.lineEdit_2.text() and
            self.AddPointPoly.lineEdit_3.text() and
            (self.AddPointPoly.radioButton.isChecked() or
                self.AddPointPoly.radioButton_2.isChecked())):
            num_rows = table_widget.rowCount()
            table_widget.insertRow(num_rows)
            numbering(self, table_widget)
            if input_polygon_coords_func is not None:
                input_polygon_coords_func()
            distance_calc(self, table_widget)
        else:
            self.AddPointPoly.notext()
            return False

    def addrowMA(self):
        """Add a row to the Monument Area table."""

        self.add_row(self.tableWidget, lambda: input_polygon_coordsMA(self))

    def addrowPA(self):
        """Add a row to the Protected Area table."""

        self.add_row(self.tableWidget_1, lambda: input_polygon_coordsPA(self))

    def check_attribute_equality(self, layer_name):
        """
        Check if the last item of the layers have the same attribute
        information.
        """

        point_layer = QgsProject.instance().mapLayersByName(
            'Representative_Point')[0]
        polygon_layer = QgsProject.instance().mapLayersByName(layer_name)[0]

        # Get all features in the point layer
        point_features = [f for f in point_layer.getFeatures()]
        # Check if there are features in the point layer
        if not point_features:
            return None, None, None, point_layer, polygon_layer

        # Get the last feature added to the point layer
        last_point_feature = point_features[-1]

        # Get all features in the polygon layer
        polygon_features = [f for f in polygon_layer.getFeatures()]
        # Check if there are features in the polygon layer
        if not polygon_features:
            return (last_point_feature['4.2.loin_coorpore_full_utm'],
                    None, None, point_layer, polygon_layer)

        # Get the last feature added to the polygon layer
        last_polygon_feature = polygon_features[-1]

        # Get the attribute values for the field '4.2.loin_coorpore_full_utm'
        point_value = last_point_feature['4.2.loin_coorpore_full_utm']
        polygon_value = last_polygon_feature['4.2.loin_coorpore_full_utm']

        return (point_value, polygon_value, last_point_feature,
                point_layer, polygon_layer)

    def tree_widget_column_edit(self, item, column):
        """
        Tab '14'. Section 14.1.
        Only let 'Notes' column be editable.
        """

        flags = item.flags()
        if column == 3:
            item.setFlags(flags | QtCore.Qt.ItemIsEditable)
        elif flags & QtCore.Qt.ItemIsEditable:
            item.setFlags(flags ^ QtCore.Qt.ItemIsEditable)

    def add_document(self):
        """
        Tab '14'. Section 14.1.
        Add a document to the treeWidget list.
        Specify the name, type, original path and size of the document.
        """

        options = QFileDialog.Options()
        # options |= QFileDialog.DontUseNativeDialog
        files, _ = QFileDialog.getOpenFileNames(
            self,
            'Select Documents',
            '',
            'All Files (*);;Text Files (*.txt);;PDF Files (*.pdf);;'
            'Word Files (*.docx);;Excel Files (*.xlsx);;'
            'PowerPoint Files (*.pptx)',
            options=options)
        if files:
            for file in files:
                file_info = QFileInfo(file)
                file_name = file_info.fileName()
                file_type = os.path.splitext(file_name)[1]
                file_path = str(file)
                item = QTreeWidgetItem([
                    file_name, file_type, (str(
                        round(
                            file_info.size() / (1024 * 1024), 2)) + ' MB'
                        ),
                    '', file_path])
                item.setFlags(item.flags() | Qt.ItemIsUserCheckable)
                item.setCheckState(0, Qt.Checked)
                self.treeWidget.addTopLevelItem(item)

    def remove_selected_documents(self):
        """
        Tab '14'. Section 14.1.
        Remove the selected documents from the treeWidget list.
        """

        top_level_items = self.treeWidget.findItems('', Qt.MatchContains, 0)
        for item in top_level_items:
            if item.checkState(0) == Qt.Checked:
                index = self.treeWidget.indexOfTopLevelItem(item)
                self.treeWidget.takeTopLevelItem(index)

    def imageLoader_1(self):
        """
        Tab '14'. Section 14.2.
        Add the UI from the image_loader.py file.
        """

        # Always create a new instance of ImageLoader_1
        self.image_loader = ImageLoader_1()

        # Find all child widgets of verticalLayout_17 recursively
        all_widgets = self.findChildren(QWidget)
        frames = [
            widget for widget in all_widgets if isinstance(widget, QFrame)]

        # Check if checkboxes are already present in the layout
        checkboxes_found = any(
            isinstance(child, QCheckBox) and (
                child.text() == 'Image_1' or
                child.text() == 'Պատկեր_1' or
                child.text() == 'Imagen_1'
            )
            for frame in frames
            for child in frame.findChildren(QCheckBox)
        )
        if checkboxes_found:
            # Check if layout is not duplicated yet
            if not self.layout_duplicated:
                # Call a function from ImageLoader_1 to duplicate the layout
                new_widget = self.image_loader.duplicate_layout(
                    self.gridLayout_40, self.verticalLayout_17, self.label)
                if new_widget is not None:  # Check if new_widget is not None
                    # Set the flag to True after duplicating
                    self.layout_duplicated = True
            else:
                frame_4 = Ui_Form.create_vl_17(self)
                self.verticalLayout_17.addWidget(frame_4)
                Ui_Form.image_count = 1

                # Add the image_loader widget under the previous one
                row_count = self.gridLayout_40.rowCount()
                self.gridLayout_40.addWidget(
                    self.image_loader, row_count, 0, 1, 1)
                checkbox_widgets = ImageLoader_1.get_checkbox_widget_list(
                    self.verticalLayout_17)
                ImageLoader_1.update_checkbox_labels(
                    self.label, self.verticalLayout_17, checkbox_widgets, 1)
        else:
            # Create widget only if checkboxes are not present
            if hasattr(self, 'gridLayout_40'):
                frame_4 = Ui_Form.create_vl_17(self)
                self.verticalLayout_17.insertWidget(0, frame_4)
            else:
                frame_4 = Ui_Form.create_vl_17(self)
                self.verticalLayout_17.insertWidget(0, frame_4)

            Ui_Form.image_count = 1
            # Add the image_loader widget under the previous one
            row_count = self.gridLayout_40.rowCount()
            self.gridLayout_40.addWidget(self.image_loader, row_count, 0, 1, 1)

    def show_AddPointPolyMA(self):
        """
        Tab '5'. Section 5.1. Add a row.
        Initialise the pop-up window.
        """

        self.AddPointPoly = AddPointPoly(
            self.tableWidget, 'Monument_Area', self)
        numbering(self, self.tableWidget)
        self.AddPointPoly.clearAndFocus()
        self.AddPointPoly.show()

    def show_AddPointPolyPA(self):
        """
        Tab '5'. Section 5.2. Add a row.
        Initialise the pop-up window.
        """

        self.AddPointPoly = AddPointPoly(
            self.tableWidget_1, 'Protected_Area', self)
        numbering(self, self.tableWidget_1)
        self.AddPointPoly.clearAndFocus()
        self.AddPointPoly.show()

    def finish_adding_points(
                self, table_widget, lineEdit1, lineEdit2, lineEdit_ha_2,
                pushButton1, pushButton2, pushButton3, pushButton4,):
        """Finish adding points and perform necessary actions."""

        self.AddPointPoly.close()
        numRows = table_widget.rowCount()
        if numRows > 2:
            pushButton3.setEnabled(True)
            pushButton2.setEnabled(True)
        else:
            pushButton3.setDisabled(True)
            pushButton2.setDisabled(True)
        if numRows < 4:
            msg_box = QMessageBox()
            if self.label.text().startswith('Ամսաթիվ'):
                title = 'Ուշադրություն'
                text = ('Գրանցման համար անհրաժեշտ է առնվազն 3 կետ։'
                        '\n\nԿցանկանայի՞ք ավելացնել ևս մեկ կետ:')
            elif self.label.text() == 'Date:':
                title = 'Warning'
                text = ('A minimum of 3 points is required to be registered.'
                        '\n\nWould you like to add another point?')
            elif self.label.text() == 'Fecha:':
                title = 'Atención'
                text = ('Se requiere un mínimo de 3 puntos para ser '
                        'registrado.\n\n¿Desea añadir algún otro punto?')
            buttonReply = msg_box.question(self, title, text)
            if buttonReply == QMessageBox.Yes:
                if table_widget == self.tableWidget:
                    self.addrowMA()
                else:
                    self.addrowPA()
            else:
                clear_all_rows(
                    self, table_widget, lineEdit1, lineEdit2, lineEdit_ha_2,
                    pushButton1, pushButton2, pushButton3, pushButton4)
        else:
            if table_widget == self.tableWidget:
                remove_tw_cont_and_last_value(self, 'Monument_Area')
                create_polygonMA(self)
            else:
                remove_tw_cont_and_last_value(self, 'Protected_Area')
                create_polygonPA(self)
            pushButton1.setEnabled(True)
            pushButton2.setEnabled(True)
            pushButton3.setEnabled(True)
            pushButton4.setEnabled(True)
            self.pantool()

    def finish_adding_pointsMA(self):
        """Finish adding points for the Monument Area table."""

        self.finish_adding_points(
            self.tableWidget, self.lineEdit_45, self.lineEdit_83,
            self.lineEdit_131, self.pushButton_11, self.pushButton_12,
            self.pushButton_14, self.pushButton_13)

    def finish_adding_pointsPA(self):
        """Finish adding points for the Protected Area table."""

        self.finish_adding_points(
            self.tableWidget_1, self.lineEdit_131, self.lineEdit_132,
            self.lineEdit_45, self.pushButton_18, self.pushButton_19,
            self.pushButton_21, self.pushButton_20)

    def open_instructions_excel_MA(self):
        """Open the InstructionsExcel dialog for Monument Area."""

        self.instructions_dialog = InstructionsExcel(
            self.tableWidget, 'Monument_Area', self.lineEdit_45,
            self.lineEdit_83, self.lineEdit_131, self.lineEdit_132,
            self.pushButton_12, self.pushButton_14, self.pushButton_11,
            self.pushButton_13, self, delete_polygon, clear_all_rows,
            numbering, distance_calc, area_calc, create_polygonMA,
            create_polygonPA)
        self.instructions_dialog.show()

    def open_instructions_excel_PA(self):
        """Open the InstructionsExcel dialog for Protected Area."""

        self.instructions_dialog = InstructionsExcel(
            self.tableWidget_1, 'Protected_Area', self.lineEdit_131,
            self.lineEdit_132, self.lineEdit_45, self.lineEdit_83,
            self.pushButton_19, self.pushButton_21, self.pushButton_18,
            self.pushButton_20, self, delete_polygon, clear_all_rows,
            numbering, distance_calc, area_calc, create_polygonMA,
            create_polygonPA)
        self.instructions_dialog.show()

    def world_map(self, index):
        """
        Downloads images of the World Map from the plugin directory into
        specified folder.
        """

        if index == 0:
            destin_dir = QFileDialog().getExistingDirectory()
            if (not destin_dir or
                    len(destin_dir) == 0 or
                    not os.path.exists(destin_dir)):
                return
            else:
                source_image_path = f'{self.plugin_dir}/logos/Figures_1.jpg'
                destin_file_path = os.path.join(destin_dir, 'Figures_1.jpg')
                shutil.copy(source_image_path, destin_file_path)
                os.startfile(destin_file_path)
        elif index == 1:
            destin_dir = QFileDialog().getExistingDirectory()
            if (not destin_dir or
                    len(destin_dir) == 0 or
                    not os.path.exists(destin_dir)):
                return
            else:
                source_image_path = f'{self.plugin_dir}/logos/Figures_2.jpg'
                destin_file_path = os.path.join(destin_dir, 'Figures_2.jpg')
                shutil.copy(source_image_path, destin_file_path)
                os.startfile(destin_file_path)
