# -*- coding: latin1 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
import os, math, time

class InverseDistanceInterpolation(QObject):    

    def __init__(self, controlpoints, weightingPower, searchRadius, maxPoints, minPoints, transformed):
        QObject.__init__(self)
        
        self.controlpoints = controlpoints
        
        self.weightingPower = weightingPower
        self.searchRadius = searchRadius
        self.maxPoints = maxPoints
        self.minPoints = minPoints
        
        self.transformed = transformed
        
        
    def run(self, point):
        
        print "vorher: " + str(point.toString(3))
        
        sumInvertedPoweredDistance = 0
        sumDistanceWeightedResidualX = 0
        sumDistanceWeightedResidualY = 0
        
        for controlpoint in self.controlpoints:
            pt = QgsPoint()
            resX = 0
            resY = 0
            
            if self.transformed == True:
                pt = QgsPoint(float(controlpoint.getXtrans()), float(controlpoint.getYtrans()))
                resX = float(controlpoint.getXtrans()) - float(controlpoint.getXglobal())
                resY = float(controlpoint.getYtrans()) - float(controlpoint.getYglobal())
            else:
                pt = QgsPoint(float(controlpoint.getXglobal()), float(controlpoint.getYglobal()))
                plocal = QgsPoint(float(controlpoint.getXlocal()), float(controlpoint.getYlocal()))                
                resX = float(controlpoint.getXglobal()) - float(controlpoint.getXlocal())
                resY = float(controlpoint.getYglobal()) - float(controlpoint.getYlocal())
                
                if point == plocal:
                    print "nachher 0: " + str(QgsPoint(float(controlpoint.getXglobal()), float(controlpoint.getYglobal())).toString(3))
                    return QgsPoint(float(controlpoint.getXglobal()), float(controlpoint.getYglobal()))

            try:
                sumDistanceWeightedResidualX += resX / ((point.sqrDist(pt))**0.5)*self.weightingPower
                sumDistanceWeightedResidualY += resY / ((point.sqrDist(pt))**0.5)*self.weightingPower
            except ZeroDivisionError:
                print "nachher1: " + str(QgsPoint(float(controlpoint.getXglobal()), float(controlpoint.getYglobal())).toString(3))
                return QgsPoint(float(controlpoint.getXglobal()), float(controlpoint.getYglobal()))

            try:
                sumInvertedPoweredDistance += 1/((point.sqrDist(pt))**0.5)*self.weightingPower
            except ZeroDivisionError:
                print "Helmert2d: ZeroDivisionError (inversedistanceinterpolation.py)" 
            
        dx = sumDistanceWeightedResidualX / sumInvertedPoweredDistance
        dy = sumDistanceWeightedResidualY / sumInvertedPoweredDistance
            
        print "nachher2: " + str(QgsPoint(point.x() - dx, point.y() - dy).toString(3))
            
        return QgsPoint(point.x() - dx, point.y() - dy)
            
        

