from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *

import sys, os, time
import resources

from tools.helmert2ddialog import Helmert2dDialog
from tools.doCompareCoordsByIdDialog import CompareCoordsByIdDialog
from tools.doCompareCoordsById import CompareCoordsById 
from tools.doCompareCoordsByLocationDialog import CompareCoordsByLocationDialog
from tools.doCompareCoordsByLocation import CompareCoordsByLocation


class Helmert2dPlugin:

    def __init__(self, iface, version):
        self.iface = iface
        self.canvas = self.iface.mapCanvas()
        self.version = version
        
        
    def initGui(self):
        self.action_helmert2d = QAction(QIcon(":/plugins/helmert2d/icons/helmert2d.png"), "Show Helmert2d window", self.iface.mainWindow())
        self.action_helmert2d.setCheckable(False)      
        
        self.action_diffbyident = QAction(QIcon(":/plugins/helmert2d/icons/diffbyident.png"), "Coordinate difference by identifier", self.iface.mainWindow())
        self.action_diffbyident.setCheckable(False)          
    
        self.action_diffbylocation = QAction(QIcon(":/plugins/helmert2d/icons/diffbylocation.png"), "Coordinate difference by location", self.iface.mainWindow())
        self.action_diffbylocation.setCheckable(False)             
        
        QObject.connect(self.action_helmert2d, SIGNAL("triggered()"), self.doShowDockWindow)
        QObject.connect(self.action_diffbyident, SIGNAL("triggered()"), self.doCompareCoordsByIdDialog)
        QObject.connect(self.action_diffbylocation, SIGNAL("triggered()"), self.doCompareCoordsByLocationDialog)
 
        self.iface.addPluginToMenu(self.action_helmert2d.tr("Helmert2d"), self.action_helmert2d)
#        self.iface.addPluginToMenu(self.action_diffbyident.tr("Diff by identifier"), self.action_diffbyident)
#        self.iface.addPluginToMenu(self.action_diffbyident.tr("Diff by location"), self.action_diffbylocation)

        self.toolBar = self.iface.addToolBar("Helmert2d")
        self.toolBar.setObjectName("Helmert2d")
        self.toolBar.addAction(self.action_helmert2d)       
        self.toolBar.addAction(self.action_diffbyident)
        self.toolBar.addAction(self.action_diffbylocation)       
        

    def doShowDockWindow(self):
        self.dlg = Helmert2dDialog(self.iface.mainWindow(), self.iface, self.version)
        self.dlg.initGui()
#        self.dlg.test1()
        self.dlg.show()


    def doCompareCoordsByIdDialog(self):
        print "diff by ident"
        d = CompareCoordsByIdDialog(self.iface.mainWindow())
        d.initGui()
        d.show()
        QObject.connect( d, SIGNAL( "okClickedCopyCoordsById(QString, QString, QString, QString, bool)" ), self.doCompareCoordsById )


    def doCompareCoordsById(self, layerNameA, layerNameB, idA, idB, addLayerToMap):
        d = CompareCoordsById()
        d.run(self.iface, layerNameA, layerNameB, idA, idB, addLayerToMap)


    def doCompareCoordsByLocationDialog(self):
        print "diff by location"
        d = CompareCoordsByLocationDialog(self.iface.mainWindow())
        d.initGui()
        d.show()
        QObject.connect( d, SIGNAL( "okClickedCopyCoordsByLocation(QString, QString, QString, QString, double, bool)" ), self.doCompareCoordsByLocation )


    def doCompareCoordsByLocation(self, layerNameA, layerNameB, idA, idB, searchRadius, addLayerToMap):
        d = CompareCoordsByLocation()
        d.run(self.iface, layerNameA, layerNameB, idA, idB, searchRadius, addLayerToMap)

        
    def unsetTool(self):    
        pass
        
        
    def deactivate(self):
        pass
#        self.action_select3vertex.setChecked(False)      
#       
#        self.p1 = None
#        self.p2 = None       


    def unload(self):
        print "Helmert2d: unload plugin."
        self.iface.removePluginMenu(self.action_helmert2d.tr("Helmert2d"), self.action_helmert2d)
        self.iface.removeToolBarIcon(self.action_helmert2d)
        
