# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import QtXml
from qgis.core import *
from qgis.gui import *
import os, time


class TransformationStatistics( QObject ):
    
    def __init__(self, transformedSimplePoints, transformationType, estimateScale, estimateRotation):
        
            self.u = None
            self.numGcp = 0
            sum_vx = 0
            sum_vy = 0
            
            self.m0 = None
            self.mpkt = None

            for point in transformedSimplePoints:
                
                if point.isChecked() == False:
                    continue
                
                self.numGcp += 1
                
                vx = (float(point.getXtrans()) - float(point.getXglobal())) * 1000
                vy = (float(point.getYtrans()) - float(point.getYglobal())) * 1000

                sum_vx = sum_vx + vx*vx
                sum_vy = sum_vy + vy*vy
            
            if transformationType == 1:
                self.u = 2
                if estimateScale == True:
                   self.u += 1
                if estimateRotation == True:
                   self.u += 1
            elif transformationType == 2:
                self.u = 6
                   
#            print "sum_vx: " + str(sum_vx)
#            print "sum_vy: " + str(sum_vy)
#            print "numGcp: " + str(self.numGcp)
#            print "u: " + str(self.u)

            self.m0 = ( (sum_vx + sum_vy) / (2*self.numGcp - self.u) )**0.5
            self.mpkt = 2**0.5 * self.m0


    def getNumberOfGcp(self):
        return self.numGcp
        
        
    def getNumberOfParameters(self):
        return self.u
        
        
    def getDeviationOfResidual(self):
        return self.m0
        
        
    def getDeviationOfPoint(self):
        return self.mpkt
    
    

        
