# -*- coding: latin1 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *


class Helmert2dTransformation(QObject):    
    def __init__(self, parameters):
        QObject.__init__(self)
 
        self.a = parameters[0]
        self.b = parameters[1]
        self.c = parameters[2]
        self.d = parameters[3]
        
    
    def transformSimplePoints(self, points):
        transformedPoints = []
        for point in points:
            x, y = self.transformSimplePoint(point)
            point.setXtrans(x)
            point.setYtrans(y)
            transformedPoints.append(point)
            
        return transformedPoints
            

    def transformSimplePoint(self, point):
            x = self.a + self.c*float(point.getXlocal()) - self.d*float(point.getYlocal())
            y = self.b + self.d*float(point.getXlocal()) + self.c*float(point.getYlocal())

            return x, y
        

