# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Heliware
                                 A QGIS plugin
 Heliware Plugin
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-10-09
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Heliware
        email                : mukulsharma.ajm1997@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication,Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QDialogButtonBox, QDialog, QCheckBox, QListWidget, QListWidgetItem
from qgis.PyQt import QtWidgets

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Heliware_plugin_dialog import HeliwareDialog
import os.path
from qgis.core import QgsProject, QgsApplication, QgsVectorLayer, QgsVectorFileWriter, QgsJsonUtils
#from qgis.gui import QgsFileWidget
import json
import os
from shapely.geometry import Polygon,LineString
from shapely.ops import split
from shapely.ops import cascaded_union, unary_union, polygonize
from itertools import combinations
import webbrowser
import pathlib
import sys


class Heliware:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Heliware_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Heliware')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Heliware', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        #icon_path = ':/plugins/Heliware_plugin/heli_icon.png'
        path = os.path.dirname(__file__)
        icon_path=path+"/heli_icon.png"
        self.add_action(
            icon_path,
            text=self.tr(u'Heliware Plugin'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&Heliware'),
                action)
            self.iface.removeToolBarIcon(action)

    def pre_import_data(self,select_layers):
        coordinates_list=[]
        for lay in select_layers:
            layer = lay.layer()
            feature={}
            selected_fid = []
            for layerdata in layer.getFeatures():
                layer_geo = layerdata.geometry()
                layer_geo=layer_geo.asJson()
                lay_geojson = json.loads(layer_geo)
                if lay_geojson['type']=='LineString':
                    newdata = { "type": "Feature",
                        "geometry": {
                        "type": "LineString",
                        "coordinates": lay_geojson['coordinates']
                        },
                        "properties": {
                        "prop0": "value0",
                        "prop1": {"this": "that"}
                        }
                        }
                    coordinates_list.append(newdata)
                elif lay_geojson['type']=='Polygon':
                    newdata = { "type": "Feature",
                        "geometry": {
                        "type": "Polygon",
                        "coordinates": lay_geojson['coordinates']
                        },
                        "properties": {
                        "prop0": "value0",
                        "prop1": {"this": "that"}
                        }
                        }
                    coordinates_list.append(newdata)

                elif lay_geojson['type']=='MultiPolygon':
                    for poly in lay_geojson['coordinates']:
                        newdata = { "type": "Feature",
                            "geometry": {
                            "type": "Polygon",
                            "coordinates": poly
                            },
                            "properties": {
                            "prop0": "value0",
                            "prop1": {"this": "that"}
                            }
                            }
                        coordinates_list.append(newdata)

                elif lay_geojson['type']=='MultiLineString':
                    for mline in lay_geojson['coordinates']:
                        newdata = { "type": "Feature",
                            "geometry": {
                            "type": "LineString",
                            "coordinates": mline
                            },
                            "properties": {
                            "prop0": "value0",
                            "prop1": {"this": "that"}
                            }
                            }
                        coordinates_list.append(newdata)

        ls =  [{ "type": "FeatureCollection","features":coordinates_list}]
        return ls

    def scutning_layer(self,ls):
        dir_path = os.path.dirname(__file__)
        if not os.path.exists(dir_path+'/output/scutning'):
            os.makedirs(dir_path+'/output/scutning')
        else:
            fpath = dir_path+'/output/scutning'
            for ofs in os.listdir(fpath):
                os.remove(os.path.join(fpath,ofs))
        polygonlist,fl,pl,ll= [],[],[],[]
        n,p,l=[],[],[]
        for i in ls:
            for j in i['features']:
                if j['geometry']['type']=='Polygon':
                    pl.append(Polygon(j['geometry']['coordinates'][0]))
                if j['geometry']['type']=='LineString':
                    ll.append(LineString(j['geometry']['coordinates']))

        if len(ll) > 0:
            for poly in pl:
                for sl in ll:
                    try:
                        res = poly.intersection(sl)
                        if res.is_empty == False:
                            for pnt in res.coords:
                                polygonlist.append([pnt[0],pnt[1]])
                            c = polygonlist.copy()
                            polygonlist.clear()
                            data = { "type": "Feature",
                                "geometry": {
                                "type": "LineString",
                                "coordinates": c
                                },
                                "properties": {
                                    "letter": "G",
                                    "color": "blue",
                                    "rank": "7",
                                    "ascii": "71",
                                    "SD_NAME": "Gee"
                                            
                                }
                                }
                            l.append(data)
                    except Exception as e:
                        pass
        listpoly = []
        for a, b in combinations(pl, 2):
            try:
                res = a.intersection(b) 
                listpoly.append(res)
            except Exception as e:
                pass

        for res in listpoly:
            if type(res) == Polygon:
                for ply in res.exterior.coords:
                    polygonlist.append([ply[0],ply[1]])
                c = polygonlist.copy()
                polygonlist.clear()
                data = { "type": "Feature",
                    "geometry": {
                    "type": "Polygon",
                    "coordinates": [c]
                    },
                    "properties": {
                    "letter": "G",
                    "color": "blue",
                    "rank": "7",
                    "ascii": "71",
                    "SD_NAME": "Gee"
                    }
                    }
                p.append(data)

        for a in ll:
            for b in  ll:
                res = a.intersection(b)
                if type(res) == 'Point':
                    if type(res) == Point:
                        data = { "type": "Feature",
                        
                        "geometry": {
                        "type": "Point",
                        "coordinates": [res.x,res.y]
                        },
                        "properties": {
                        "letter": "G",
                        "color": "red",
                        "rank": "7",
                        "ascii": "71",
                        "SD_NAME": "Gee"
                        }
                        }
                        n.append(data)

                
        final_obj1 =  { "type": "FeatureCollection","features":p}
        final_obj2 =  { "type": "FeatureCollection","features":n}
        final_obj3 =  { "type": "FeatureCollection","features":l}
        with open(dir_path+'/output/scutning/scutning_output_polygon.geojson','w') as outfile1:
            json.dump(final_obj1,outfile1)
            outfile1.close()
        with open(dir_path+'/output/scutning/scutning_output_point.geojson','w') as outfile2:
            json.dump(final_obj2,outfile2)
            outfile2.close()
        with open(dir_path+'/output/scutning/scutning_output_line.geojson','w') as outfile3:
            json.dump(final_obj3,outfile3)
            outfile3.close()

        if os.path.exists(dir_path+'/output/scutning/scutning_output_polygon.geojson'):
            vlayer1 = QgsVectorLayer(dir_path+"/output/scutning/scutning_output_polygon.geojson","scutning_polygon_layer","ogr")
            QgsProject.instance().addMapLayer(vlayer1)
        if os.path.exists(dir_path+'/output/scutning/scutning_output_point.geojson'):
            vlayer2 = QgsVectorLayer(dir_path+"/output/scutning/scutning_output_point.geojson","scutning_point_layer","ogr")
            QgsProject.instance().addMapLayer(vlayer2)
        if os.path.exists(dir_path+'/output/scutning/scutning_output_line.geojson'):
            vlayer3 = QgsVectorLayer(dir_path+"/output/scutning/scutning_output_line.geojson","scutning_linestring_layer","ogr")
            QgsProject.instance().addMapLayer(vlayer3)

    def snipping_layer(self,ls):
        dir_path = os.path.dirname(__file__)
        if not os.path.exists(dir_path+'/output/snipping'):
            os.makedirs(dir_path+'/output/snipping')
        polygonlist,fs,sl = [],[],[]
        if len(ls) == 1:
            for i in ls:
                for j in i['features']:
                    if j['geometry']['type']=='Polygon':
                        for index,cord in enumerate(j['geometry']['coordinates'][0]):
                            if index == 0:
                                sl.append(cord)
                                polygonlist.append(cord)
                            else:
                                polygonlist.append(cord)
                        polygonlist.pop()
                        #polygonlist.append(sl[0])
                        polygonlist[-1]=sl[0]
                        data0 = { "type": "Feature",
                        "geometry": {
                        "type": "Polygon",
                        "coordinates": [polygonlist]
                        },
                        "properties": {
                        }
                        }
                        fs.append(data0)
                    if j['geometry']['type']=='LineString':
                        for index,cord in enumerate(j['geometry']['coordinates']):

                            if index == 0:
                                sl.append(cord)
                                polygonlist.append(cord)
                            else:
                                polygonlist.append(cord)
                        polygonlist.pop()
                        polygonlist.append(sl[0])
                        data0 = { "type": "Feature",
                        "geometry": {
                        "type": "LineString",
                        "coordinates": polygonlist
                        },
                        "properties": {
                        }
                        }
                        fs.append(data0)

        final_obj =  { "type": "FeatureCollection","features":fs}
        with open(dir_path+'/output/snipping/snipping_output.geojson','w') as outfile:
            json.dump(final_obj,outfile)
            outfile.close()

        vlayer = QgsVectorLayer(dir_path+"/output/snipping/snipping_output.geojson","snipping_layer","ogr")
        QgsProject.instance().addMapLayer(vlayer)

    def installer_func(self):
        plugin_dir = os.path.dirname(os.path.realpath(__file__))

        try:
            import pip
        except ImportError:
            exec(
                open(str(pathlib.Path(plugin_dir, 'scripts', 'get_pip.py'))).read()
            )
            import pip
            # just in case the included version is old
            pip.main(['install', '--upgrade', 'pip'])

        sys.path.append(plugin_dir)

        with open(os.path.join(plugin_dir,'requirements.txt'), "r") as requirements:
            for dep in requirements.readlines():
                dep = dep.strip().split("==")[0]
                try:
                    __import__(dep)
                except ImportError as e:
                    print("{} not available, installing".format(dep))
                    pip.main(['install', dep])

    def ReverseDigitization_layer(self,ls):
        self.installer_func()
        from haversine import haversine

        dir_path = os.path.dirname(__file__)
        if not os.path.exists(dir_path+'/output/ReverseDigitization'):
            os.makedirs(dir_path+'/output/ReverseDigitization')
        
        list1,list2,list_to_store_distance = [],[],[]

        for i in ls:
            for idex,pts in enumerate(range(len(i['features']))):
                if idex == 0:
                    if i['features'][pts]['geometry']['type'] == 'Polygon':
                        for new_pts in i['features'][pts]['geometry']['coordinates'][0]:
                            list1.append(new_pts)
                    if i['features'][pts]['geometry']['type'] == 'LineString':
                        for new_pts in i['features'][pts]['geometry']['coordinates']:
                            list1.append(new_pts)
                if idex == 1:
                    if i['features'][pts]['geometry']['type'] == 'Polygon':
                        for new_pts in i['features'][pts]['geometry']['coordinates'][0]:
                            list2.append(new_pts)
                            res = haversine(new_pts,list1[-1])
                            list_to_store_distance.append(res)
                    if i['features'][pts]['geometry']['type'] == 'LineString':
                        for new_pts in i['features'][pts]['geometry']['coordinates']:
                            list2.append(new_pts)
                            res = haversine(new_pts,list1[-1])
                            list_to_store_distance.append(res)
        idx = list_to_store_distance.index(min(list_to_store_distance))
        reserve_data = list2[idx]
        list1.append(reserve_data)
        for index,i in enumerate(range(len(list2))):
            if index > idx:
                list1.append(list2[i])
        for index,i in enumerate(range(len(list2))):
            if index <idx:
                list1.append(list2[i])
        list1.append(reserve_data)
        nfl = []
        data = { "type": "Feature",
                                "geometry": {
                                "type": "Polygon",
                                "coordinates": [list1]
                                },
                                "properties": {
                                    "letter": "G",
                                    "color": "blue",
                                    "rank": "7",
                                    "ascii": "71",
                                    "SD_NAME": "Gee"
                                            
                                }
                                }
        nfl.append(data)
        # return Response({"m":"done"})
        final_obj =  { "type": "FeatureCollection","features":nfl}

        with open(dir_path+'/output/ReverseDigitization/ReverseDigitization_output.geojson','w') as outfile:
            json.dump(final_obj,outfile)
            outfile.close()

        vlayer = QgsVectorLayer(dir_path+"/output/ReverseDigitization/ReverseDigitization_output.geojson","ReverseDigitization_layer","ogr")
        QgsProject.instance().addMapLayer(vlayer)

    def export_to_map(self):
        # some code for your algorithm while press "export to Map" button
        dir_path = os.path.dirname(__file__)
        if not os.path.exists(dir_path+'/output'):
            os.makedirs(dir_path+'/output')
        filter_layers = ["Scutning","Snipping","ReverseDigitization"]
        
        select_layers = self.selected_layer()
        selectedLayerIndex = self.dlg.comboBox.currentIndex()
        if filter_layers[selectedLayerIndex]=="Scutning":
            ls = self.pre_import_data(select_layers)
            self.scutning_layer(ls)
        elif filter_layers[selectedLayerIndex]=="Snipping":
            ls = self.pre_import_data(select_layers)
            self.snipping_layer(ls)

        elif filter_layers[selectedLayerIndex]=="ReverseDigitization":
            ls = self.pre_import_data(select_layers)
            self.ReverseDigitization_layer(ls)
            
        self.dlg.close()

    def export_to_heliware(self):
        return webbrowser.open('https://heliware.co.in/app/')

    def selected_layer(self):
        layers = QgsProject.instance().layerTreeRoot().children()
        select_layers=[]
        for row in range(0,len(layers)):
            if self.dlg.qtable.item(row,1).checkState()==Qt.CheckState.Checked:
                select_layers.append(layers[row])
                layers[row].setItemVisibilityChecked(True)
            else:
                layers[row].setItemVisibilityChecked(False)
        return select_layers

    def stacked_window(self):
        current_stacked = self.dlg.menu_widget.currentRow()
        if current_stacked == 0:
            self.dlg.stacked_widget.setCurrentWidget(self.dlg.exporter)
        elif current_stacked == 1:
            self.dlg.stacked_widget.setCurrentWidget(self.dlg.about)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        filter_layers = ["Scutning","Snipping","ReverseDigitization"]
        if self.first_start == True:
            self.first_start = False
            self.dlg = HeliwareDialog()

            self.dlg.menu_widget.itemClicked.connect(self.stacked_window)

            self.dlg.pushButton_1.clicked.connect(self.export_to_map)
            self.dlg.pushButton_2.clicked.connect(self.export_to_heliware)

        # Fetch the currently loaded layers
        layers = QgsProject.instance().layerTreeRoot().children()

        row=0
        self.dlg.qtable.setRowCount(len(layers))
        for layer_name in layers:
            self.dlg.qtable.setItem(row, 0, QtWidgets.QTableWidgetItem(layer_name.name()))
            item = QtWidgets.QTableWidgetItem("")
            item.setFlags(Qt.ItemFlag.ItemIsUserCheckable | Qt.ItemFlag.ItemIsEnabled)
            item.setCheckState(Qt.CheckState.Unchecked)
            self.dlg.qtable.setItem(row, 1, item)
            row+=1

        # Clear the contents of the comboBox from previous runs
        self.dlg.comboBox.clear()
        # Populate the comboBox with names of all the loaded layers
        self.dlg.comboBox.addItems([layer for layer in filter_layers])
        
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
