# -*- coding: utf-8 -*-

"""
/***************************************************************************
 HedgeTools
                                 A QGIS plugin
 Hedge caracterisation from polygon layer.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-01-24
        copyright            : (C) 2022 by Gabriel Marquès / Dynafor
        email                : gabriel.marques@toulouse-inp.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Gabriel Marquès / Dynafor'
__date__ = '2022-01-24'
__copyright__ = '(C) 2022 by Gabriel Marquès / Dynafor'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
from . import resources # Only need in hedge_tools.py normaly but just to keep track of import 
from .algorithm.extraction.manage_tiles import ManageRasterTilesProcessingAlgorithm
from .algorithm.extraction.generate_dhm import GenerateDHMProcessingAlgorithm
from .algorithm.extraction.generate_ndvi import GenerateNDVIProcessingAlgorithm
from .algorithm.extraction.generate_tree_cover import GenerateTreeCoverProcessingAlgorithm
from .algorithm.extraction.preprocess_diff_wooded_area import PreProcessDiffForestHedgeAlgorithm
from .algorithm.extraction.diff_wooded_area import DiffForestHedgeAlgorithm
from .algorithm.extraction.split_by_network import SplitByNetworkAlgorithm
from .algorithm.extraction.aggregation import AggregationAlgorithm
from .algorithm.data_preparation.topological_arc import TopologicalArcAlgorithm
from .algorithm.data_preparation.topological_nodes import TopologicalNodesAlgorithm
from .algorithm.data_preparation.create_polygons_from_ma import CreatePolygonsAlgorithm
from .algorithm.data_preparation.median_axis_simplification import MedianAxisSimplificationAlgorithm
from .algorithm.data_transformation.split_by_orientation import SplitByOrientationAlgorithm
from .algorithm.data_transformation.split_by_distance import SplitByDistanceAlgorithm
from .algorithm.data_transformation.split_by_interface import SplitByInterfaceAlgorithm
from .algorithm.hedges_caracterisation.morphology.length import LengthAlgorithm
from .algorithm.hedges_caracterisation.morphology.width import WidthAlgorithm
from .algorithm.hedges_caracterisation.morphology.orientation import OrientationAlgorithm
from .algorithm.hedges_caracterisation.morphology.shape_metrics import ShapeMetricsAlgorithm
from .algorithm.hedges_caracterisation.physiognomy.height_metrics_from_DHM import HeightMetricsFromDHMAlgorithm
from .algorithm.hedges_caracterisation.physiognomy.strata_proportion_from_DHM import StrataProportionFromDHMAlgorithm
from .algorithm.hedges_context.geographic.topographic_position import TopoPositionAlgorithm
from .algorithm.hedges_context.geographic.relative_orientation import RelativeOrientationAlgorithm
from .algorithm.hedges_context.geographic.shortest_dist_to_forest import DistanceToForestAlgorithm
from .algorithm.hedges_network.forest_connection import ForestConnectionAlgorithm
from .algorithm.hedges_network.create_subgraph import SubgraphCreationAlgorithm
from .algorithm.hedges_network.connectivity_metrics import ConnectivityMetricsAlgorithm
from .algorithm.hedge_grid.landscape_metrics import LandscapeMetricsAlgorithm

class HedgeToolsProvider(QgsProcessingProvider):

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        QgsProcessingProvider.unload(self)
        # pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """

        self.addAlgorithm(ManageRasterTilesProcessingAlgorithm())
        self.addAlgorithm(GenerateDHMProcessingAlgorithm())
        self.addAlgorithm(GenerateNDVIProcessingAlgorithm())
        self.addAlgorithm(GenerateTreeCoverProcessingAlgorithm())
        self.addAlgorithm(PreProcessDiffForestHedgeAlgorithm())
        self.addAlgorithm(DiffForestHedgeAlgorithm())
        self.addAlgorithm(SplitByNetworkAlgorithm())
        self.addAlgorithm(AggregationAlgorithm())
        self.addAlgorithm(TopologicalArcAlgorithm())
        self.addAlgorithm(TopologicalNodesAlgorithm())
        self.addAlgorithm(CreatePolygonsAlgorithm())
        self.addAlgorithm(MedianAxisSimplificationAlgorithm())
        self.addAlgorithm(LengthAlgorithm())
        self.addAlgorithm(WidthAlgorithm())
        self.addAlgorithm(OrientationAlgorithm())
        self.addAlgorithm(ShapeMetricsAlgorithm())
        self.addAlgorithm(SplitByOrientationAlgorithm())
        self.addAlgorithm(SplitByDistanceAlgorithm())
        self.addAlgorithm(SplitByInterfaceAlgorithm())
        self.addAlgorithm(HeightMetricsFromDHMAlgorithm())
        self.addAlgorithm(TopoPositionAlgorithm())
        self.addAlgorithm(StrataProportionFromDHMAlgorithm())
        self.addAlgorithm(RelativeOrientationAlgorithm())
        self.addAlgorithm(DistanceToForestAlgorithm())
        self.addAlgorithm(ForestConnectionAlgorithm())
        self.addAlgorithm(SubgraphCreationAlgorithm())
        self.addAlgorithm(ConnectivityMetricsAlgorithm())
        self.addAlgorithm(LandscapeMetricsAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return "hedgetools"

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr("Hedge tools")

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QIcon(":/plugins/hedge_tools/images/hedge_tools.png")

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
