# -*- coding: utf-8 -*-
"""
/***************************************************************************
 HankakuConverter
                                 A QGIS plugin
 This plug-in converts string attribute values to full-width (Zenkaku) and half-width (Hankaku) characters to each other.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-02-07
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Sanda Takeru
        email                : takeru_sanda999@maff.go.jp
 ***************************************************************************/

 /***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .hankaku_converter_dialog import HankakuConverterDialog
import os.path

class HankakuConverter:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')
        if locale is not None:
            locale = locale[0:2]
        else:
            locale = 'en' 
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'HankakuConverter_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Hankaku Converter')
        self.toolbar = self.iface.addToolBar(u'HankakuConverter')
        self.toolbar.setObjectName(u'HankakuConverter')


        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('HankakuConverter', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        current_directory = os.path.dirname(os.path.abspath(__file__))
        
        icon_path = os.path.join(current_directory, "icon.png")
        self.add_action(
            icon_path,
            text=self.tr(u'Hankaku Converter'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

        self.dlg = HankakuConverterDialog()

    def unload(self):
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Hankaku Converter'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        # アクティブレイヤをデフォルト設置
        self.dlg.mMapLayerComboBox.setLayer(self.iface.activeLayer())
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:

            def convert_characters(layer, convert_to_half):
                try:
                    if convert_to_half:
                        translation_table = str.maketrans({chr(0xFF01 + i): chr(0x21 + i) for i in range(94)})
                    else:
                        translation_table = str.maketrans({chr(0x0021 + i): chr(0xFF01 + i) for i in range(94)})

                    layer.startEditing()  # Start the editing session.
                    for field in layer.fields():
                        if field.typeName() == 'String':
                            for feature in layer.getFeatures():                           
                                value = feature[field.name()]
                                if value:
                                    feature[field.name()] = value.translate(translation_table)
                                    layer.updateFeature(feature)
                                    
                except Exception as e:
                    print(f"An error occurred: {e}")
                finally:
                    layer.commitChanges()  # Commit the changes.

            def main():
                """Main function."""
                layer = self.dlg.mMapLayerComboBox.currentLayer()
                convert_to_half = self.dlg.radioButton_ZtoH.isChecked()
                convert_characters(layer, convert_to_half)

            main()

            pass