from qgis.PyQt.QtCore import QUrl
from qgis.PyQt.QtGui import QDesktopServices
from qgis.PyQt.QtWidgets import QAction

from qgis.gui import QgsMapToolEmitPoint
from qgis.core import (
    QgsCoordinateTransform,
    QgsCoordinateReferenceSystem,
    QgsProject
)


class StreetLens:

    def __init__(self, iface):
        self.iface = iface
        self.canvas = iface.mapCanvas()
        self.action = None
        self.tool = None

    def initGui(self):
        self.action = QAction(
            "Street View",
            self.iface.mainWindow()
        )
        self.action.triggered.connect(self.ativar_ferramenta)
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("StreetLens", self.action)

    def unload(self):
        self.iface.removeToolBarIcon(self.action)
        self.iface.removePluginMenu("StreetLens", self.action)

    def ativar_ferramenta(self):
        self.tool = ClickTool(self.canvas)
        self.canvas.setMapTool(self.tool)


class ClickTool(QgsMapToolEmitPoint):

    def __init__(self, canvas):
        super().__init__(canvas)
        self.canvas = canvas

    def canvasReleaseEvent(self, event):
        ponto = self.toMapCoordinates(event.pos())

        origem = self.canvas.mapSettings().destinationCrs()
        destino = QgsCoordinateReferenceSystem("EPSG:4326")

        transform = QgsCoordinateTransform(
            origem,
            destino,
            QgsProject.instance()
        )

        ponto_wgs84 = transform.transform(ponto)

        lat = ponto_wgs84.y()
        lon = ponto_wgs84.x()

        url = (
            "https://www.google.com/maps/@?api=1"
            f"&map_action=pano&viewpoint={lat},{lon}"
        )

        QDesktopServices.openUrl(QUrl(url))
