# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GuidedOfflineEditingPluginDialog
                                 A QGIS plugin
 Extend the built-in Offline Editing Plugin providing automated processes
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-06-08
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Yann Voté
        email                : ygversil@lilo.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import uic
from PyQt5 import QtWidgets

# This loads your .ui file so that PyQt can populate your plugin with the
# elements from Qt Designer
UI_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'guided_offline_editing_progress_dialog_base.ui'
), resource_suffix='')


class GuidedOfflineEditingPluginProgressDialog(QtWidgets.QDialog, UI_CLASS):
    """Progress dialog showing current progress when offline layers are
    being synchronized back online."""

    def __init__(self, parent=None):
        super().__init__(parent)
        self.setupUi(self)

    def setup_progress_bar(self, format_, layer_count):
        """Initialize progress bar."""
        self.progress_bar.setFormat(format_)
        self.progress_bar.setRange(0, layer_count)
        self.progress_bar.reset()

    def set_progress_bar(self, value):
        """Update progress bar."""
        self.progress_bar.setValue(value)

    def set_progress_label(self, current_layer_idx, layer_count):
        """Update text label."""
        self.progress_label.setText(
            self.tr('Layer {} of {}').format(current_layer_idx, layer_count)
        )
        self.progress_bar.reset()

    def set_title(self, title):
        """Update the dialog title."""
        self.setWindowTitle(title)
