# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GtfsShapesCreatorDockWidget
                                 A QGIS plugin
 Generates GTFS shapes.txt files by routing transit lines on OpenStreetMap road and rail networks, with current support for opentransportdata.swiss
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-11-15
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Luigi Dal Bosco
        email                : luigi.dalbosco@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis import processing
from qgis.PyQt import QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal
from qgis.core import (
    QgsCoordinateReferenceSystem,
    QgsVectorLayer,
    QgsProject,
    QgsFields,
    QgsField,
    QgsPointXY,
    Qgis,
)

from .agency_selection import (
    update_agences,
    check_gtfs_folder,
    get_agecy_s_routes,
    generate_agencies_gtfs,
)

from .osmimport_routes_ptstops import (
    downloading_ways,
    downloading_railway,
    downloading_ferryroutes,
    busroutes,
    full_city_roads,
    Selected_Ttbls,
    preapare_GTFSstops_by_transport,
    time_tables_perTransport,
    angles_tram,
    angles_buses,
    rectangles_sidewalk,
    rectangles_OSMonROADline,
    OSMintersecGTFS,
    OSM_PTstps_dwnld,
    stp_posGTFSnm_rect,
    joinNEWandValidOSM,
    highway_average_speed,
    transcript_main_files,
    Ttbls_plus,
    angle_onRD_sidewalk,
    shape_assignement,
    if_not_make,
    if_csv_exist_else_df_empty,
    if_display_r_layer,
    load_files_to_del,
    if_remove,
    add_filepath_to_lines_csv,
    find,
    display_OSM_and_SWISSTOPO_IMAGE_maps,
    display_all_OSM4routing_trips_stops,
)

from .OSM_PT_routing import (
    if_remove_single_file,
    check_the_off_road_pt_stops,
    move_OSMstops_on_the_road,
    mini_routing,
    defining_minitrips,
    trips,
    vector_layer_to_csv,
    recalulate_lon_lat_from_editing,
    vector_layer_to_gpkg,
    save_and_stop_editing_layers,
)

from .GTFS_shapes_Tracer import (
    update_trips_list,
    shp_dst_trvl,
    shape_txt,
    stop_times_update,
)

from qgis.PyQt.QtWidgets import QListWidgetItem, QApplication, QProgressBar
import pandas as pd
import json
import datetime
import getpass

from .resources import *

import webbrowser
from qgis.PyQt.QtCore import QVariant
from PyQt5.QtCore import Qt
from qgis.PyQt.QtWidgets import QListWidgetItem

FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "gtfs_shapes_creator_dockwidget_base.ui")
)


class GtfsShapesCreatorDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, iface, parent=None):
        """Constructor."""
        super().__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect

        self.iface = iface

        self.setupUi(self)

        self.openTheLinkButton.clicked.connect(self.__goToSwissLink)

        self.updateAgenciesButton.clicked.connect(self.__updateAgencies)

        self.searchButton.clicked.connect(self.___searchItem)

        self.updateBusButton.clicked.connect(self.__updateBuses)

        self.uploadOSMButton.clicked.connect(self.__uploadOSM)

        self.zoomStopButton.clicked.connect(self.__ZoomStop)

        self.RmvBusesButton.clicked.connect(self.__removeBuses)

        self.createTripsButton.clicked.connect(self.__OSM_PT_routing)

        self.DiplayTripsButton.clicked.connect(self.__displayTrips)

        self.createShapesButton.clicked.connect(self.__shapesCreator)

    #    !!! ---- agency_seleciton functions ---- !!!

    def __goToSwissLink(self):
        webbrowser.open(
            "https://data.opentransportdata.swiss/en/dataset/?q=GTFS&groups=timetables&sort=metadata_modified+desc"
        )

    def __updateAgencies(self):

        self.listAgenciesWidget.clear()  # Clear existing items
        gtfs_folder_path = self.mGtfsFolderWidget.filePath()
        check_gtfs_folder(gtfs_folder_path)
        ls_agencies = update_agences(gtfs_folder_path)
        for agen in ls_agencies:
            self.listAgenciesWidget.addItem(QListWidgetItem(str(agen)))

    def ___searchItem(self):
        search_string = self.searchLineEdit.text()
        match_items = self.listAgenciesWidget.findItems(search_string, Qt.MatchContains)
        for idx in range(self.listAgenciesWidget.count()):
            it = self.listAgenciesWidget.item(idx)
            it.setHidden(it not in match_items)

    def __updateBuses(self):
        bar_for_messages = self.iface.messageBar()
        bar_for_messages.setMinimumHeight(150)
        selected_items = self.listAgenciesWidget.selectedItems()

        gtfs_folder_path = self.mGtfsFolderWidget.filePath()

        ls_agencies_selected = [item.text() for item in selected_items]
        routes, agency_name_fold = get_agecy_s_routes(
            ls_agencies_selected, gtfs_folder_path
        )

        self.listBusWidget.clear()  # Clear existing items
        trnsprt_correspondant = {
            "T": "Tram",
            "B": "Bus",
            "R": "RegRailServ",
            "FUN": "Funicular",
            "BAT": "Ferry",
        }
        routes["trnsprt"] = (
            routes["route_desc"].map(trnsprt_correspondant).fillna("trnsprt")
        )
        routes["trnsp_shrt_name"] = (
            routes["trnsprt"].astype(str) + "_" + routes["route_short_name"].astype(str)
        )
        ls_transport = routes.trnsp_shrt_name.unique()

        files_to_del = load_files_to_del(gtfs_folder_path)
        if files_to_del["path"]:
            bar_for_messages.pushMessage(
                "Info",
                self.tr(
                    f"The temporary files will be deleted only restarting QGIS, their paths are saved on files_to_delete.json"
                ),
                level=Qgis.Info,
                duration=7,
            )

        self.toolBox.setCurrentIndex(1)
        for trnsprt in ls_transport:
            self.listBusWidget.addItem(QListWidgetItem(str(trnsprt)))

        return routes, agency_name_fold

    def __uploadOSM(self):
        bar_for_messages = self.iface.messageBar()
        bar_for_messages.setMinimumHeight(150)
        progressMessageBar = bar_for_messages.createMessage(
            self.tr(
                f"Starting at {datetime.datetime.now().time().replace(microsecond=0)} the real job (..be patient, please)"
            )
        )
        progress = QProgressBar()
        progress.setMaximum(10)
        progress.setAlignment(Qt.AlignLeft | Qt.AlignVCenter)
        progressMessageBar.layout().addWidget(progress)
        bar_for_messages.pushWidget(progressMessageBar, Qgis.Info)
        QApplication.processEvents()

        progress.setValue(1)
        QApplication.processEvents()

        selected_items = self.listBusWidget.selectedItems()

        # load the folders

        gtfs_folder_path = self.mGtfsFolderWidget.filePath()

        selected_agencies = self.listAgenciesWidget.selectedItems()

        count_all_agencies = self.listAgenciesWidget.count()
        agencies_folder, outputspath = generate_agencies_gtfs(
            gtfs_folder_path,
            selected_agencies,
            count_all_agencies,
        )
        progress.setValue(2)
        QApplication.processEvents()
        #    !!! ---- OSMimport_road_PTstops functions ---- !!!

        temp_folder = "OSM_data"
        road_temp_folder = os.path.join(agencies_folder, temp_folder)

        trips_txt = os.path.join(agencies_folder, "trips.txt")

        stops_txt = os.path.join(agencies_folder, "stops.txt")
        stops = pd.read_csv(stops_txt)

        agency_txt = os.path.join(agencies_folder, "agency.txt")
        agency = pd.read_csv(agency_txt)
        ls_agency = agency.agency_id.unique()

        lines_df_csv = os.path.join(agencies_folder, "lines_files_list.csv")

        south = round(float(stops.stop_lat.min()) - 0.05, 6)
        west = round(float(stops.stop_lon.min()) - 0.05, 6)
        north = round(float(stops.stop_lat.max()) + 0.05, 6)
        east = round(float(stops.stop_lon.max()) + 0.05, 6)

        OSM_ways_name = "OSM_ways"
        OSM_ways_gpkg = os.path.join(road_temp_folder, OSM_ways_name + ".gpkg")

        extent = str(south) + "," + str(west) + "," + str(north) + "," + str(east)
        extent_quickosm = (
            str(south)
            + ","
            + str(west)
            + ","
            + str(north)
            + ","
            + str(east)
            + " [EPSG:4326]"
        )

        # naming files and paths

        OSM_roads_name = "OSM_roads"
        OSM_roads_gpkg = os.path.join(road_temp_folder, OSM_roads_name + ".gpkg")

        OSM_roads_with_ms_ow_fr_name = "OSM_roads_plus"
        OSM_roads_with_ms_ow_fr_gpkg = os.path.join(
            road_temp_folder, OSM_roads_with_ms_ow_fr_name + ".gpkg"
        )

        OSM_tram_name = "OSM_tram"
        OSM_rails_gpkg = os.path.join(road_temp_folder, OSM_tram_name + ".gpkg")

        OSM_Regtrain_name = "OSM_Regtrain"
        OSM_Regtrain_gpkg = os.path.join(road_temp_folder, OSM_Regtrain_name + ".gpkg")

        OSM_funicular_name = "OSM_funicular"
        OSM_funicular_gpkg = os.path.join(
            road_temp_folder, OSM_funicular_name + ".gpkg"
        )

        OSM_ferry_name = "OSM_ferry"
        OSM_ferry_gpkg = os.path.join(road_temp_folder, OSM_ferry_name + ".gpkg")

        OSM_roads_nameCSV = "OSM_roads_CSV"
        OSM_roads_csv = os.path.join(road_temp_folder, OSM_roads_name + ".csv")

        highway_speed_name = "highway_average_speed"
        highway_speed_csv = os.path.join(road_temp_folder, highway_speed_name + ".csv")

        bus_lanes_name = "OSM_bus_lanes"
        OSM_bus_lanes_gpkg = os.path.join(road_temp_folder, bus_lanes_name + ".gpkg")
        OSM_bus_lanes_csv = os.path.join(road_temp_folder, bus_lanes_name + ".csv")

        OSM_bus_lanes_with_ms_ow_fr_name = "OSM_bus_lanes_plus"
        OSM_bus_lanes_with_ms_ow_fr_gpkg = os.path.join(
            road_temp_folder, OSM_bus_lanes_with_ms_ow_fr_name + ".gpkg"
        )

        full_roads_name = "full_city_roads"
        full_roads_gpgk = os.path.join(road_temp_folder, full_roads_name + ".gpkg")

        city_roads_name = "city roads"

        city_rails_name = "city rails"

        city_Regtrain_name = "city Regtrain"

        city_funicular_name = "city funicular"

        city_ferry_name = "city ferry"

        Ttlbs_txt = os.path.join(agencies_folder, "stop_times.txt")

        Ttbls_plus_name = "stop_times_plus"
        Ttbls_plus_csv = os.path.join(agencies_folder, Ttbls_plus_name + ".csv")

        Ttbls_selected_name = "stop_times_selected_lines"
        Ttbls_selected_txt = os.path.join(agencies_folder, Ttbls_selected_name + ".txt")

        files_to_delete_next_bus_loading_name = "files_to_delete_next_bus_loading"
        files_to_delete_next_bus_loading_json = os.path.join(
            agencies_folder, "temp", files_to_delete_next_bus_loading_name + ".json"
        )
        files_to_del = load_files_to_del(agencies_folder)

        user_name = getpass.getuser() or "user"
        temp_folder = f"{user_name}_main_files"
        main_files_fld = os.path.join(agencies_folder, temp_folder)
        main_files_csv = os.path.join(agencies_folder, temp_folder, "main_files.csv")

        temp_folder = "temp/trip_id_assignement"
        folder_trip_id_assign = os.path.join(agencies_folder, temp_folder)

        ls_buses_done_name = "buses"
        ls_buses_done_csv = os.path.join(main_files_fld, ls_buses_done_name + ".csv")

        tempfolder = "temp/stop_times_perroute"
        temp_folder_Ttbls = os.path.join(agencies_folder, tempfolder)

        tempfolder = "temp/GTFSstops&segments_perroute"
        temp_folder_GTFSstops = os.path.join(agencies_folder, tempfolder)

        tempfolder = "temp/temp_roads_angls"
        temproadfldr = os.path.join(agencies_folder, tempfolder)

        tempfolderGTFSnm = "temp/temp_GTFSnomatch"
        temp_GTFSnm_folder = os.path.join(agencies_folder, tempfolderGTFSnm)

        tempfolder = "temp/temp_rect"
        temp_rect_folder = os.path.join(agencies_folder, tempfolder)

        tempfolder = "perdinst"
        perdist = os.path.join(temp_rect_folder, tempfolder)

        temp_folder = "temp/OSM_PTstops"
        OSMstops_temp_folder = os.path.join(agencies_folder, temp_folder)

        tempfolder = "temp/temp_OSM"
        temp_OSM_folder = os.path.join(agencies_folder, tempfolder)

        tempfolder = "temp/temp_GTFSpos"
        temp_GTFSpos_folder = os.path.join(agencies_folder, tempfolder)

        tempfolder = "temp/temp_OSM_forrouting"
        temp_OSM_for_routing = os.path.join(agencies_folder, tempfolder)

        GTFSnm_angledf_csv = os.path.join(outputspath, "GTFSnm_angl.csv")
        OSMwithGTFS_csv = os.path.join(outputspath, "OSMintersecGTFS.csv")
        dfnomatch_csv = os.path.join(outputspath, "OSMnomatch.csv")
        GTFSnm_rect_csv = os.path.join(outputspath, "GTFSnm_rect.csv")
        GTFSnmRCT_posdf_csv = os.path.join(outputspath, "GTFSnmRCT_NEWpos.csv")

        GTFSnm_angledf = pd.DataFrame()
        OSMwithGTFS = pd.DataFrame()
        dfnomatch = pd.DataFrame()
        GTFSnm_rect = pd.DataFrame()
        GTFSnmRCT_posdf = pd.DataFrame()

        # condition if the plugin have aleady run at list ones
        if not os.path.exists(main_files_csv):
            transcript_main_files(
                main_files_fld,
                main_files_csv,
                OSM_ways_name,
                OSM_ways_gpkg,
                OSM_roads_name,
                OSM_roads_gpkg,
                OSM_roads_nameCSV,
                OSM_roads_csv,
                highway_speed_name,
                highway_speed_csv,
                bus_lanes_name,
                OSM_bus_lanes_gpkg,
                OSM_bus_lanes_csv,
                full_roads_name,
                full_roads_gpgk,
                Ttbls_selected_name,
                Ttbls_selected_txt,
                files_to_delete_next_bus_loading_name,
                files_to_delete_next_bus_loading_json,
            )

            os.makedirs(road_temp_folder, exist_ok=True)

            Roads_layer = downloading_ways(extent, extent_quickosm)
            vector_layer_to_gpkg(Roads_layer, OSM_roads_name, OSM_roads_gpkg)

            vector_layer_to_csv(Roads_layer, OSM_roads_csv)

            Rials_layer = downloading_railway(extent, extent_quickosm, "tram")
            vector_layer_to_gpkg(Rials_layer, OSM_tram_name, OSM_rails_gpkg)

            progress.setValue(3)
            QApplication.processEvents()

            Regtrain_layer = downloading_railway(
                extent, extent_quickosm, "narrow_gauge"
            )
            vector_layer_to_gpkg(Regtrain_layer, OSM_Regtrain_name, OSM_Regtrain_gpkg)

            funicular_layer = downloading_railway(extent, extent_quickosm, "funicular")
            vector_layer_to_gpkg(
                funicular_layer, OSM_funicular_name, OSM_funicular_gpkg
            )

            ferry_layer = downloading_ferryroutes(extent, extent_quickosm, "ferry")
            vector_layer_to_gpkg(ferry_layer, OSM_ferry_name, OSM_ferry_gpkg)

            progress.setValue(4)
            QApplication.processEvents()

            highway_average_speed(OSM_roads_csv, highway_speed_csv)

            busroutes(
                bus_lanes_name,
                OSM_bus_lanes_gpkg,
                OSM_bus_lanes_csv,
                OSM_roads_gpkg,
                highway_speed_csv,
                OSM_bus_lanes_with_ms_ow_fr_gpkg,
                OSM_bus_lanes_with_ms_ow_fr_name,
            )

            full_city_roads(
                OSM_roads_gpkg,
                OSM_roads_csv,
                full_roads_gpgk,
                highway_speed_csv,
                OSM_roads_with_ms_ow_fr_name,
                OSM_roads_with_ms_ow_fr_gpkg,
                OSM_bus_lanes_with_ms_ow_fr_gpkg,
            )

        if_not_make(
            [
                temp_folder_Ttbls,
                temp_folder_GTFSstops,
                temproadfldr,
                temp_GTFSnm_folder,
                temp_rect_folder,
                perdist,
                OSMstops_temp_folder,
                temp_OSM_folder,
                temp_GTFSpos_folder,
                temp_OSM_for_routing,
                folder_trip_id_assign,
            ]
        )

        if os.path.exists(GTFSnm_angledf_csv):
            GTFSnm_angledf = pd.read_csv(GTFSnm_angledf_csv)
        if os.path.exists(OSMwithGTFS_csv):
            OSMwithGTFS = pd.read_csv(OSMwithGTFS_csv)
        if os.path.exists(dfnomatch_csv):
            dfnomatch = pd.read_csv(dfnomatch_csv)
        if os.path.exists(GTFSnm_rect_csv):
            GTFSnm_rect = pd.read_csv(GTFSnm_rect_csv)
        GTFSnmRCT_posdf = if_csv_exist_else_df_empty(GTFSnmRCT_posdf_csv)

        if os.path.exists(ls_buses_done_csv):
            ls_buses_df = pd.read_csv(ls_buses_done_csv)
            prev_ls_buses = [str(bus) for bus in list(ls_buses_df.trnsp_shrt_name)]
            del ls_buses_df

        try:
            prev_ls_buses
        except NameError:
            prev_ls_buses = []

        ls_buses_selected = [item.text() for item in selected_items]

        ls_buses = [bus for bus in ls_buses_selected if bus not in prev_ls_buses]

        prev_ls_buses = prev_ls_buses + ls_buses
        ls_buses_df = pd.DataFrame(prev_ls_buses).rename(columns={0: "trnsp_shrt_name"})
        if os.path.exists(ls_buses_done_csv):
            os.remove(ls_buses_done_csv)
        ls_buses_df.to_csv(ls_buses_done_csv, index=False)
        progress.setValue(5)
        QApplication.processEvents()

        if not os.path.exists(Ttbls_plus_csv):
            Ttbls_plus(Ttlbs_txt, Ttbls_plus_csv, agencies_folder, trips_txt)

        files_to_del = Selected_Ttbls(
            ls_buses, Ttbls_selected_txt, Ttbls_plus_csv, files_to_del
        )

        stops_times_plus = pd.read_csv(Ttbls_selected_txt)

        # create transport Times tables for each transport

        lsrts = stops_times_plus.route_id.unique()

        lslines = []

        if os.path.exists(lines_df_csv):
            lines_df = pd.read_csv(lines_df_csv, dtype={"route_short_name": str})
        else:
            lines_df = pd.DataFrame()

        lines_df_row_init = len(lines_df)

        sumTtbls = 0
        i_row = lines_df_row_init
        for rt in lsrts:
            line, nameline, Ttbl_file, rt_srt_nm, trnsprt_type, trnsp_shrt_name = (
                time_tables_perTransport(
                    rt, stops_times_plus, temp_folder_Ttbls, lslines
                )
            )
            sumTtbls = sumTtbls + len(line)

            lines_df = add_filepath_to_lines_csv(
                lines_df,
                lines_df_csv,
                i_row,
                files_to_save={
                    "line_name": nameline,
                    "route_short_name": rt_srt_nm,
                    "GTFSstop_times": Ttbl_file,
                    "trnsprt_type": trnsprt_type,
                    "trnsp_shrt_name": trnsp_shrt_name,
                },
            )
            lslines.append(nameline)
            i_row += 1

        # creating the a df for listing the files paths

        i_row = lines_df_row_init
        while i_row < len(lines_df):
            Ttbl_file = lines_df.loc[i_row, "GTFSstop_times"]
            line = lines_df.loc[i_row, "line_name"]
            shrt_name = lines_df.loc[i_row, "route_short_name"]
            GTFSstops, Ttbl_with_sequences_csv, files_to_del = (
                preapare_GTFSstops_by_transport(
                    stops_txt,
                    Ttbl_file,
                    line,
                    temp_folder_GTFSstops,
                    shrt_name,
                    temp_folder_Ttbls,
                    files_to_del,
                )
            )

            lines_df = add_filepath_to_lines_csv(
                lines_df,
                lines_df_csv,
                i_row,
                files_to_save={
                    "GTFSstop_times_with_seq": Ttbl_with_sequences_csv,
                    "GTFSstops&segments": GTFSstops,
                },
            )
            i_row = i_row + 1
        del i_row

        i_row = lines_df_row_init
        while i_row < len(lines_df):
            line = lines_df.loc[i_row, "line_name"]
            Ttbl_file = lines_df.loc[i_row, "GTFSstop_times"]
            GTFSstops_csv = lines_df.loc[i_row, "GTFSstops&segments"]
            line_trip_csv = os.path.join(
                folder_trip_id_assign, str(line) + "_trip_assignement.csv"
            )
            shape_assignement(GTFSstops_csv, Ttbl_file, line_trip_csv, trips_txt)
            lines_df = add_filepath_to_lines_csv(
                lines_df, lines_df_csv, i_row, {"trip_assignement": line_trip_csv}
            )

            i_row += 1
        progress.setValue(6)
        QApplication.processEvents()

        city_roads_layer = QgsVectorLayer(OSM_roads_gpkg, city_roads_name, "ogr")

        city_rails_layer = QgsVectorLayer(OSM_rails_gpkg, city_rails_name, "ogr")

        city_regtrain_layer = QgsVectorLayer(
            OSM_Regtrain_gpkg, city_Regtrain_name, "ogr"
        )

        city_funicular_layer = QgsVectorLayer(
            OSM_funicular_gpkg, city_funicular_name, "ogr"
        )

        city_ferry_layer = QgsVectorLayer(OSM_ferry_gpkg, city_ferry_name, "ogr")

        # create GTFSstops gpkg with angle of the nearest road

        i_row = lines_df_row_init
        while i_row < len(lines_df):

            line = lines_df.loc[i_row, "line_name"]
            GTFSstops_path = lines_df.loc[i_row, "GTFSstops&segments"]
            if lines_df.loc[i_row, "trnsprt_type"] == "Tram":
                GTFSstops_angle, GTFSnm_RD, GTFSnm_angCSV, spl_file = angles_tram(
                    city_rails_layer,
                    line,
                    GTFSstops_path,
                    temproadfldr,
                    temp_GTFSnm_folder,
                )
            elif lines_df.loc[i_row, "trnsprt_type"] == "RegRailServ":
                GTFSstops_angle, GTFSnm_RD, GTFSnm_angCSV, spl_file = angles_tram(
                    city_regtrain_layer,
                    line,
                    GTFSstops_path,
                    temproadfldr,
                    temp_GTFSnm_folder,
                )
            elif lines_df.loc[i_row, "trnsprt_type"] == "Funicular":
                GTFSstops_angle, GTFSnm_RD, GTFSnm_angCSV, spl_file = angles_tram(
                    city_funicular_layer,
                    line,
                    GTFSstops_path,
                    temproadfldr,
                    temp_GTFSnm_folder,
                )
            elif lines_df.loc[i_row, "trnsprt_type"] == "Ferry":
                GTFSstops_angle, GTFSnm_RD, GTFSnm_angCSV, spl_file = angles_tram(
                    city_ferry_layer,
                    line,
                    GTFSstops_path,
                    temproadfldr,
                    temp_GTFSnm_folder,
                )
            else:
                GTFSstops_angle, GTFSnm_RD, GTFSnm_angCSV, spl_file = angles_buses(
                    city_roads_layer,
                    line,
                    GTFSstops_path,
                    temproadfldr,
                    temp_GTFSnm_folder,
                )

            lines_df = add_filepath_to_lines_csv(
                lines_df,
                lines_df_csv,
                i_row,
                files_to_save={
                    "GTFSnm_RD": GTFSnm_RD,
                    "GTFSstps_angle": GTFSstops_angle,
                    "GTFSnm_angCSV": GTFSnm_angCSV,
                    "Spl_roads": spl_file,
                },
            )

            GTFSnm_angl_toconcat = pd.read_csv(GTFSnm_angCSV)
            GTFSnm_angledf = pd.concat(
                [GTFSnm_angledf, GTFSnm_angl_toconcat], ignore_index=True
            )
            i_row = i_row + 1

        files_to_del = if_remove(GTFSnm_angledf_csv, files_to_del)
        GTFSnm_angledf.to_csv(GTFSnm_angledf_csv, index=False)

        i_row = lines_df_row_init
        while i_row < len(lines_df):
            line = lines_df.loc[i_row, "line_name"]
            GTFSstops_angle = lines_df.loc[i_row, "GTFSstps_angle"]
            GTFSstops_angle_sidewalk_gpkg = os.path.join(
                temproadfldr, "GTFS" + str(line) + "_anlge_sidewalk.gpkg"
            )

            GTFSstops_angle_OSMonROADline_gpkg = os.path.join(
                temproadfldr, "GTFS" + str(line) + "_OSMonROADline.gpkg"
            )

            lines_df = add_filepath_to_lines_csv(
                lines_df,
                lines_df_csv,
                i_row,
                files_to_save={
                    "GTFSstps_angle_sidewalk": GTFSstops_angle_sidewalk_gpkg,
                    "GTFSstps_angle_OSMonROADline": GTFSstops_angle_OSMonROADline_gpkg,
                },
            )
            angle_onRD_sidewalk(
                GTFSstops_angle,
                GTFSstops_angle_sidewalk_gpkg,
                GTFSstops_angle_OSMonROADline_gpkg,
                agency_txt,
            )
            i_row = i_row + 1

        buses_long = 0.00020
        tram_long = 0.00080
        road_average_width = 0.00008

        i_row = lines_df_row_init
        while i_row < len(lines_df):

            GTFSstops_angle_sidewalk_gpkg = lines_df.loc[
                i_row, "GTFSstps_angle_sidewalk"
            ]
            line = lines_df.loc[i_row, "line_name"]
            trnsprt_type = lines_df.loc[i_row, "trnsprt_type"]
            GTFSstps_rect_sidewalk_csv = os.path.join(
                temp_rect_folder, "GTFSangl_sidewalk_" + str(line) + ".csv"
            )

            GTFSstps_rect_sidewalk_gpkg = os.path.join(
                temp_rect_folder, "rects_sidewalk_" + str(line) + ".gpkg"
            )

            GTFSstops_angle_sidewalk_layer = QgsVectorLayer(
                GTFSstops_angle_sidewalk_gpkg,
                "GTFS" + str(line) + "_anlge_sidewalk",
                "ogr",
            )
            ls_GTFSstps_rect = []
            if not GTFSstops_angle_sidewalk_layer.featureCount() == 0:
                files_to_del = rectangles_sidewalk(
                    GTFSstops_angle_sidewalk_gpkg,
                    buses_long,
                    tram_long,
                    line,
                    GTFSstps_rect_sidewalk_gpkg,
                    GTFSstps_rect_sidewalk_csv,
                    trnsprt_type,
                    files_to_del,
                )

                lines_df = add_filepath_to_lines_csv(
                    lines_df,
                    lines_df_csv,
                    i_row,
                    files_to_save={
                        "GTFSstps_rect_sidewalk_gpkg": GTFSstps_rect_sidewalk_gpkg,
                        "GTFSstps_rect_sidewalk_csv": GTFSstps_rect_sidewalk_csv,
                    },
                )
                ls_GTFSstps_rect.append(GTFSstps_rect_sidewalk_gpkg)

            GTFSstops_path_OSMonROADline = lines_df.loc[
                i_row, "GTFSstps_angle_OSMonROADline"
            ]
            GTFSstps_rect_OSMonROADline_gpkg = os.path.join(
                temp_rect_folder, "rects_OSMonROADline_" + str(line) + ".gpkg"
            )
            GTFSstops_angle_OSMonROADline_layer = QgsVectorLayer(
                GTFSstops_path_OSMonROADline,
                "GTFS" + str(line) + "_OSMonROADline",
                "ogr",
            )
            if not GTFSstops_angle_OSMonROADline_layer.featureCount() == 0:
                rectangles_OSMonROADline(
                    GTFSstops_path_OSMonROADline,
                    buses_long,
                    tram_long,
                    road_average_width,
                    line,
                    GTFSstps_rect_OSMonROADline_gpkg,
                    trnsprt_type,
                )
                ls_GTFSstps_rect.append(GTFSstps_rect_OSMonROADline_gpkg)

            GTFSstps_rect_gpkg = os.path.join(
                temp_rect_folder, "rects_" + str(line) + ".gpkg"
            )
            lines_df = add_filepath_to_lines_csv(
                lines_df, lines_df_csv, i_row, {"GTFSstps_rect": GTFSstps_rect_gpkg}
            )
            if ls_GTFSstps_rect and (
                not 29 in ls_agency or not 344 in ls_agency or not 764 in ls_agency
            ):
                params = {
                    "LAYERS": ls_GTFSstps_rect,
                    "CRS": QgsCoordinateReferenceSystem("EPSG:4326"),
                    "OUTPUT": GTFSstps_rect_gpkg,
                }
                processing.run("native:mergevectorlayers", params)
            else:
                layerType = "Polygon"
                crs = "EPSG:4326"
                emptyLayer = QgsVectorLayer(
                    f"{layerType}?crs={crs}", "New Empty Layer", "memory"
                )
                fields = QgsFields()
                fields.append(QgsField("fid", QVariant.Int))
                fields.append(QgsField("line_name", QVariant.String))
                emptyLayer.startEditing()
                emptyLayer.dataProvider().addAttributes(fields.toList())
                emptyLayer.updateFields()
                emptyLayer.commitChanges()
                vector_layer_to_gpkg(emptyLayer, "New Empty Layer", GTFSstps_rect_gpkg)

            i_row = i_row + 1

        i_row = lines_df_row_init

        while i_row < len(lines_df):
            line = lines_df.loc[i_row, "line_name"]
            shrt_name = lines_df.loc[i_row, "route_short_name"]
            trnsprt_type = lines_df.loc[i_row, "trnsprt_type"]

            OSM_PTstp_rel_name = "PT_stops_rel_" + str(line)
            OSM_PTstp_rel_gpkg = os.path.join(
                OSMstops_temp_folder, OSM_PTstp_rel_name + ".gpkg"
            )

            OSM_PTstp_name = "PT_stop_position_" + str(line)
            OSM_PTstp_gpkg = os.path.join(
                OSMstops_temp_folder, OSM_PTstp_name + ".gpkg"
            )

            lines_df = add_filepath_to_lines_csv(
                lines_df, lines_df_csv, i_row, {"OSM_PTstp": OSM_PTstp_gpkg}
            )

            progress.setValue(7)
            QApplication.processEvents()

            OSM_PTstps_dwnld(
                extent,
                extent_quickosm,
                OSM_PTstp_rel_gpkg,
                OSM_PTstp_gpkg,
                shrt_name,
                OSM_PTstp_rel_name,
                OSM_PTstp_name,
                trnsprt_type,
            )

            i_row += 1

        i_row = lines_df_row_init
        while i_row < len(lines_df):
            line = lines_df.loc[i_row, "line_name"]
            rect = lines_df.loc[i_row, "GTFSstps_rect"]
            OSM_PTstp_gpkg = lines_df.loc[i_row, "OSM_PTstp"]
            intersect, match, OSMjnGTFS, OSMnomatch = OSMintersecGTFS(
                rect, OSM_PTstp_gpkg, temp_OSM_folder, line
            )
            lines_df = add_filepath_to_lines_csv(
                lines_df,
                lines_df_csv,
                i_row,
                files_to_save={"OSMintersecGTFS": OSMjnGTFS, "OSMnomatch": OSMnomatch},
            )

            OSMwithGTFS = pd.concat([OSMwithGTFS, intersect], ignore_index=True)
            dfnomatch = pd.concat([dfnomatch, match], ignore_index=True)

            i_row = i_row + 1

        files_to_del = if_remove(OSMwithGTFS_csv, files_to_del)
        OSMwithGTFS.to_csv(OSMwithGTFS_csv, index=False)
        files_to_del = if_remove(dfnomatch_csv, files_to_del)
        dfnomatch.to_csv(dfnomatch_csv, index=False)

        # create list of GTFS rectangls that don't match with any OSM
        i_row = lines_df_row_init
        while i_row < len(lines_df):
            OSMjnGTFS = pd.read_csv(lines_df.loc[i_row, "OSMintersecGTFS"])
            GTFSstops = pd.read_csv(lines_df.loc[i_row, "GTFSstops&segments"])
            GTFSnm_RD = pd.read_csv(lines_df.loc[i_row, "GTFSnm_angCSV"])
            GTFSnmRCT_csv = os.path.join(
                temp_GTFSnm_folder,
                "GTFSnmRCT_" + str(lines_df.loc[i_row, "line_name"]) + ".csv",
            )
            if not OSMjnGTFS.empty:
                lsGTFSjoined = OSMjnGTFS.GTFS_stop_id.unique()
                GTFSstops = GTFSstops[~GTFSstops.stop_id.isin(lsGTFSjoined)]

            if not GTFSnm_RD.empty:
                lsGTFSnmRD = GTFSnm_RD.stop_id.unique()
                GTFSstops = GTFSstops[~GTFSstops.stop_id.isin(lsGTFSnmRD)]

            GTFSnmRCT = GTFSstops
            GTFSnmRCT.to_csv(GTFSnmRCT_csv, index=False)
            lines_df.loc[i_row, "GTFSnmRCT"] = GTFSnmRCT_csv
            GTFSnm_rect = pd.concat([GTFSnm_rect, GTFSnmRCT], ignore_index=True)

            i_row += 1

        if os.path.exists(GTFSnm_rect_csv):
            os.remove(GTFSnm_rect_csv)
        GTFSnm_rect.to_csv(GTFSnm_rect_csv, index=False)

        i_row = lines_df_row_init
        while i_row < len(lines_df):
            trnsprt_type = lines_df.loc[i_row, "trnsprt_type"]
            line_name = lines_df.loc[i_row, "line_name"]
            GTFSnmRCT_csv = lines_df.loc[i_row, "GTFSnmRCT"]
            splt_roads = lines_df.loc[i_row, "Spl_roads"]
            test = pd.read_csv(GTFSnmRCT_csv)
            if not test.empty:
                NEWpos_file_nmRCT, files_to_del = stp_posGTFSnm_rect(
                    GTFSnmRCT_csv,
                    line_name,
                    splt_roads,
                    temp_GTFSpos_folder,
                    buses_long,
                    tram_long,
                    trnsprt_type,
                    agency_txt,
                    files_to_del,
                )
            else:
                NEWpos_file_nmRCT = os.path.join(
                    temp_GTFSpos_folder, "GTFSnmRCT_pos_" + str(line_name) + ".csv"
                )

            lines_df = add_filepath_to_lines_csv(
                lines_df,
                lines_df_csv,
                i_row,
                {"GTFSnmRCT_newOSMpos": NEWpos_file_nmRCT},
            )
            if os.path.exists(NEWpos_file_nmRCT):
                posdf = pd.read_csv(NEWpos_file_nmRCT)
                GTFSnmRCT_posdf = pd.concat([GTFSnmRCT_posdf, posdf], ignore_index=True)
            i_row += 1

        files_to_del = if_remove(GTFSnmRCT_posdf_csv, files_to_del)
        GTFSnmRCT_posdf.to_csv(GTFSnmRCT_posdf_csv, index=False)

        files_to_del_str = json.dumps(files_to_del, indent=2)
        with open(files_to_delete_next_bus_loading_json, "w") as f:
            f.write(files_to_del_str)
        if files_to_del["path"]:
            bar_for_messages.pushMessage(
                "Info",
                self.tr(
                    f"The temporary files will be deleted only restarting QGIS, their paths are saved on {files_to_delete_next_bus_loading_json}"
                ),
                level=Qgis.Info,
                duration=7,
            )

        i_row = lines_df_row_init
        while i_row < len(lines_df):
            newOSMpos = lines_df.loc[i_row, "GTFSnmRCT_newOSMpos"]
            GTFSnomatch_RD = lines_df.loc[i_row, "GTFSnm_angCSV"]
            OSMintersectGTFS = lines_df.loc[i_row, "OSMintersecGTFS"]
            GTFSstps_seg = lines_df.loc[i_row, "GTFSstops&segments"]
            line = lines_df.loc[i_row, "line_name"]
            files_to_del = joinNEWandValidOSM(
                newOSMpos,
                GTFSnomatch_RD,
                OSMintersectGTFS,
                GTFSstps_seg,
                temp_OSM_for_routing,
                line,
                stops_txt,
                files_to_del,
            )

            i_row += 1

        #  >>>>>>>>>>>>     XXXXXXXXXXXXXXXXXXXX     <<<<<<<<<<<
        #  >>>  !!! ---- OSM_PT_rounting functions ---- !!! <<<<
        #  >>>>>>>>>>>>     XXXXXXXXXXXXXXXXXXXX     <<<<<<<<<<<

        self.stopsnmRDlistWidget.clear()  # Clear existing items

        temp_folder = "zoom_nmRD"
        nmRD_temp_folder = os.path.join(agencies_folder, temp_folder)

        OSMallroad_name = "OSMallroad"
        OSMallroad_gpkg = os.path.join(nmRD_temp_folder, OSMallroad_name + ".gpkg")

        tram_rails_name = "OSM_tram"
        tram_rails_gpgk = os.path.join(road_temp_folder, tram_rails_name + ".gpkg")

        if not os.path.exists(nmRD_temp_folder):
            os.mkdir(nmRD_temp_folder)

        if not os.path.exists(OSMallroad_gpkg):
            ls_roads = []
            if os.path.exists(full_roads_gpgk):
                ls_roads.append(full_roads_gpgk)
            if os.path.exists(tram_rails_gpgk):
                ls_roads.append(tram_rails_gpgk)
            if os.path.exists(OSM_Regtrain_gpkg):
                ls_roads.append(OSM_Regtrain_gpkg)
            if os.path.exists(OSM_funicular_gpkg):
                ls_roads.append(OSM_funicular_gpkg)
            if os.path.exists(OSM_ferry_gpkg):
                ls_roads.append(OSM_ferry_gpkg)
            params = {
                "LAYERS": ls_roads,
                "CRS": QgsCoordinateReferenceSystem("EPSG:4326"),
                "OUTPUT": OSMallroad_gpkg,
            }
            processing.run("native:mergevectorlayers", params)

        tempfolder = "temp/temp_OSM_forrouting"
        temp_OSM_for_routing = os.path.join(agencies_folder, tempfolder)

        allstops_name = "ALLstops"
        allstops_gpkg = os.path.join(nmRD_temp_folder, str(allstops_name) + ".gpkg")
        allstops_csv = os.path.join(nmRD_temp_folder, str(allstops_name) + ".csv")

        nmRD_stops_name = "nmRD_stops"
        nmRD_stops_csv = os.path.join(nmRD_temp_folder, str(nmRD_stops_name) + ".csv")

        ls_files = os.listdir(temp_OSM_for_routing)
        ls_with_gpkg = [file for file in ls_files if ".gpkg" in file]
        ls_to_check = [
            file for file in ls_with_gpkg if "shm" not in file and "wal" not in file
        ]

        progress.setValue(8)
        QApplication.processEvents()

        move_OSMstops_on_the_road(
            temp_OSM_for_routing,
            nmRD_temp_folder,
            OSMallroad_gpkg,
            ls_to_check,
            lines_df,
            files_to_del,
        )

        to_check = check_the_off_road_pt_stops(
            nmRD_temp_folder,
            OSMallroad_gpkg,
            allstops_name,
            allstops_csv,
            nmRD_stops_csv,
            ls_to_check,
        )

        progress.setValue(9)
        QApplication.processEvents()

        if not to_check.empty:
            i_row = 0
            while i_row < len(to_check):
                to_check.loc[i_row, "seq_stpID"] = (
                    str(to_check.loc[i_row, "line_name"])
                    + "_trip"
                    + str(to_check.loc[i_row, "trip"])
                    + "_pos"
                    + str(to_check.loc[i_row, "pos"])
                )
                i_row += 1

            ls_stop_to_display = to_check.seq_stpID.unique()

            for stop_to_disp in ls_stop_to_display:
                self.stopsnmRDlistWidget.addItem(QListWidgetItem(str(stop_to_disp)))
            if_remove_single_file(nmRD_stops_csv)
            to_check.to_csv(nmRD_stops_csv)

            display_OSM_and_SWISSTOPO_IMAGE_maps()

            if_display_r_layer(full_roads_gpgk, full_roads_name)
            if_display_r_layer(tram_rails_gpgk, tram_rails_name)
            if_display_r_layer(OSM_Regtrain_gpkg, OSM_Regtrain_name)
            if_display_r_layer(OSM_funicular_gpkg, OSM_funicular_name)
            if_display_r_layer(OSM_ferry_gpkg, OSM_ferry_name)

            display_all_OSM4routing_trips_stops(
                temp_OSM_for_routing, ls_buses_selected, lines_df
            )

            self.toolBox.setCurrentIndex(2)
        else:
            self.stopsnmRDlistWidget.addItem(
                QListWidgetItem(
                    str(
                        "All the stops are on one of the networks (roads'one or rails'one)"
                    )
                )
            )

            self.__OSM_PT_routing()

            self.toolBox.setCurrentIndex(3)

        # saving the lines df
        if os.path.exists(lines_df_csv):
            os.remove(lines_df_csv)
        lines_df.to_csv(lines_df_csv, index=False)

        progress.setValue(10)
        bar_for_messages.clearWidgets()

    def __OSM_PT_routing(self):
        bar_for_messages = self.iface.messageBar()
        bar_for_messages.setMinimumHeight(150)
        progressMessageBar = bar_for_messages.createMessage(
            self.tr(
                f"at {datetime.datetime.now().time().replace(microsecond=0)} : GTFS Shapes Creator has started routing.."
            )
        )
        progress = QProgressBar()
        progress.setMaximum(5)
        progress.setAlignment(Qt.AlignLeft | Qt.AlignVCenter)
        progressMessageBar.layout().addWidget(progress)
        bar_for_messages.pushWidget(progressMessageBar, Qgis.Info)
        QApplication.processEvents()

        progress.setValue(1)
        QApplication.processEvents()

        all_layers = QgsProject.instance().mapLayers().values()
        save_and_stop_editing_layers(all_layers)
        for layer in all_layers:
            if "OSM4routing_" in layer.name():
                QgsProject.instance().removeMapLayer(layer)
        # load the folders

        selected_items = self.listBusWidget.selectedItems()
        ls_buses_selected = [item.text() for item in selected_items]

        gtfs_folder_path = self.mGtfsFolderWidget.filePath()

        selected_agencies = self.listAgenciesWidget.selectedItems()

        count_all_agencies = self.listAgenciesWidget.count()
        agencies_folder, outputspath = generate_agencies_gtfs(
            gtfs_folder_path,
            selected_agencies,
            count_all_agencies,
        )

        files_to_del = load_files_to_del(agencies_folder)
        if files_to_del["path"]:
            bar_for_messages.pushMessage(
                "Info",
                self.tr(
                    f"The temporary files will be deleted only restarting QGIS, their paths are saved on the files_to_delete.json"
                ),
                level=Qgis.Info,
                duration=7,
            )

        temp_folder = "OSM_data"
        road_temp_folder = os.path.join(agencies_folder, temp_folder)

        full_roads_name = "full_city_roads"
        full_roads_gpgk = os.path.join(road_temp_folder, full_roads_name + ".gpkg")

        tram_rails_name = "OSM_tram"
        tram_rails_gpgk = os.path.join(road_temp_folder, tram_rails_name + ".gpkg")

        OSM_Regtrain_name = "OSM_Regtrain"
        OSM_Regtrain_gpkg = os.path.join(road_temp_folder, OSM_Regtrain_name + ".gpkg")

        OSM_funicular_name = "OSM_funicular"
        OSM_funicular_gpkg = os.path.join(
            road_temp_folder, OSM_funicular_name + ".gpkg"
        )

        OSM_ferry_name = "OSM_ferry"
        OSM_ferry_gpkg = os.path.join(road_temp_folder, OSM_ferry_name + ".gpkg")

        tempfolder = "temp/temp_OSM_forrouting"
        temp_OSM_for_routing = os.path.join(agencies_folder, tempfolder)

        OSM4rout_name = "OSM4routing"
        OSM4rout_gpkg = os.path.join(outputspath, OSM4rout_name + ".gpkg")
        OSM4rout_csv = os.path.join(outputspath, OSM4rout_name + ".csv")

        OSM4routing_name = "OSM4routing_XYminiTrips"
        OSM4routing_csv = os.path.join(outputspath, OSM4routing_name + ".csv")

        lines_trips_csv = os.path.join(agencies_folder, "lines_trips.csv")

        tempfolder = "temp/mini-trips"
        temp_folder_minitrip = os.path.join(agencies_folder, tempfolder)

        tempfolder = "temp/lines_trips"
        temp_folder_linestrip = os.path.join(agencies_folder, tempfolder)

        name_folder = "shapes"
        shape_folder = os.path.join(outputspath, name_folder)

        trips_done_name = "trips_done"
        trips_done_csv = os.path.join(temp_folder_linestrip, trips_done_name + ".csv")

        os.makedirs(shape_folder, exist_ok=True)
        os.makedirs(temp_folder_minitrip, exist_ok=True)
        os.makedirs(temp_folder_linestrip, exist_ok=True)

        # loading the temporary tables and outpust of OSMtocheck Plugin

        ls_files = os.listdir(temp_OSM_for_routing)
        ls_with_gpkg = [file for file in ls_files if ".gpkg" in file]
        ls_to_do = [
            file for file in ls_with_gpkg if "shm" not in file and "wal" not in file
        ]

        ls_gpkg_df = pd.DataFrame(ls_to_do).rename(columns={0: "lines_draw_gpkg"})

        layers_to_route = []
        for to_do in ls_to_do:
            layers_to_route.append(
                os.path.join(
                    temp_OSM_for_routing, str(to_do) + "|layername=" + str(to_do[:-5])
                )
            )

        if_remove(OSM4rout_gpkg, files_to_del)
        params = {
            "LAYERS": layers_to_route,
            "CRS": QgsCoordinateReferenceSystem("EPSG:4326"),
            "OUTPUT": OSM4rout_gpkg,
        }
        processing.run("native:mergevectorlayers", params)

        # recalculate the coordinates of the stop position changed
        OSM4rout_layer = QgsVectorLayer(OSM4rout_gpkg, OSM4rout_name, "ogr")

        OSM4rout_layer = recalulate_lon_lat_from_editing(OSM4rout_layer)

        if_remove(OSM4rout_csv, files_to_del)
        vector_layer_to_csv(OSM4rout_layer, OSM4rout_csv)

        progress.setValue(2)
        QApplication.processEvents()

        # create mini trips
        defining_minitrips(OSM4rout_csv, OSM4routing_csv, lines_trips_csv)
        # routing
        try:
            mini_routing(
                OSM4routing_csv,
                full_roads_gpgk,
                tram_rails_gpgk,
                OSM_Regtrain_gpkg,
                OSM_funicular_gpkg,
                OSM_ferry_gpkg,
                temp_folder_minitrip,
            )
        except Exception:
            bar_for_messages.pushMessage(
                "Warning",
                self.tr(
                    "Something wrong while creating the trips, GO BACK to step 1, remove the buses concerned and try again"
                ),
                level=Qgis.Warning,
            )

        lines_trips = pd.read_csv(lines_trips_csv)

        progress.setValue(3)
        QApplication.processEvents()

        display_OSM_and_SWISSTOPO_IMAGE_maps()
        if_display_r_layer(full_roads_gpgk, full_roads_name)

        if_display_r_layer(tram_rails_gpgk, tram_rails_name)

        if_display_r_layer(OSM_Regtrain_gpkg, OSM_Regtrain_name)

        if_display_r_layer(OSM_funicular_gpkg, OSM_funicular_name)
        if_display_r_layer(OSM_ferry_gpkg, OSM_ferry_name)

        takeoff_ = lambda a: "".join([x for x in list(a) if x != "_"])
        ls_selected_line_names = [takeoff_(x) for x in ls_buses_selected]
        idx = 0
        while idx < len(lines_trips):
            trip = str(lines_trips.loc[idx, "line_trip"])

            trip_gpkg = os.path.join(outputspath, str(trip) + ".gpkg")
            trip_csv = os.path.join(outputspath, str(trip) + ".csv")
            lines_trips.loc[idx, "gpkg"] = trip_gpkg
            lines_trips.loc[idx, "csv"] = trip_csv
            if not os.path.exists(trip_gpkg):
                trips(trip, trip_gpkg, trip_csv, temp_folder_minitrip)

            if [x for x in ls_selected_line_names if x in trip]:
                if not QgsProject.instance().mapLayersByName(str(trip)):
                    trip_layer = QgsVectorLayer(trip_gpkg, trip, "ogr")
                    symbol = trip_layer.renderer().symbol()
                    symbol.setWidth(0.9)
                    QgsProject.instance().addMapLayer(trip_layer)
            idx += 1

        if_remove_single_file(trips_done_csv)
        ls_gpkg_df.to_csv(trips_done_csv, index=False)
        os.remove(lines_trips_csv)
        lines_trips.to_csv(lines_trips_csv, index=False)

        ls_files_output = os.listdir(outputspath)

        trip_done = [file for file in ls_files_output if ".gpkg" in file]
        ls_trips = [file[:-5] for file in trip_done]

        missing = lines_trips[~lines_trips.line_trip.isin(ls_trips)]

        if not missing.empty:
            i_row = 0
            while i_row < len(missing):
                trip = missing.loc[i_row, "line_trip"]
                i_row += 1
                bar_for_messages.pushMessage(
                    "Warning", self.tr(f"{trip} is missing"), level=Qgis.Warning
                )

        self.tripsListWidget.clear()  # Clear existing items

        progress.setValue(4)
        QApplication.processEvents()

        ls_trips_to_display = update_trips_list(outputspath)

        for trip_to_disp in ls_trips_to_display:
            self.tripsListWidget.addItem(QListWidgetItem(str(trip_to_disp)))

        self.toolBox.setCurrentIndex(3)

        progress.setValue(5)
        QApplication.processEvents()
        bar_for_messages.clearWidgets()

    def __shapesCreator(self):
        bar_for_messages = self.iface.messageBar()
        bar_for_messages.setMinimumHeight(150)
        progressMessageBar = bar_for_messages.createMessage(
            self.tr(
                f"at {datetime.datetime.now().time().replace(microsecond=0)} : Integrating the shapes to the GTFS file take much less time"
            )
        )
        progress = QProgressBar()
        progress.setMaximum(3)
        progress.setAlignment(Qt.AlignLeft | Qt.AlignVCenter)
        progressMessageBar.layout().addWidget(progress)
        bar_for_messages.pushWidget(progressMessageBar, Qgis.Info)
        QApplication.processEvents()

        progress.setValue(1)
        QApplication.processEvents()
        # load the folders
        gtfs_folder_path = self.mGtfsFolderWidget.filePath()
        selected_agencies = self.listAgenciesWidget.selectedItems()
        count_all_agencies = self.listAgenciesWidget.count()
        agencies_folder, outputspath = generate_agencies_gtfs(
            gtfs_folder_path,
            selected_agencies,
            count_all_agencies,
        )

        all_layers = (
            QgsProject.instance().mapLayers().values()
        )  # Get all layers in the project
        save_and_stop_editing_layers(all_layers)

        name_folder = "shapes"
        shape_folder = os.path.join(outputspath, name_folder)

        tempfolder = "temp/lines_trips"
        temp_folder_linestrip = os.path.join(agencies_folder, tempfolder)

        tempfolder = "temp/stop_times_perroute"
        temp_folder_Ttbls_per_route = os.path.join(agencies_folder, tempfolder)

        shapes_txt = os.path.join(agencies_folder, "shapes.txt")

        Ttlbs_txt = os.path.join(agencies_folder, "stop_times.txt")

        temp_folder = "OSM_data"
        road_temp_folder = os.path.join(agencies_folder, temp_folder)
        OSM_roads_name = "OSM_roads"
        OSM_roads_gpkg = os.path.join(road_temp_folder, OSM_roads_name + ".gpkg")

        lines_df_csv = os.path.join(agencies_folder, "lines_files_list.csv")

        lines_trips_csv = os.path.join(agencies_folder, "lines_trips.csv")

        # loading the trips in gpkg
        ls_files = os.listdir(outputspath)
        ls_trip_all = [file for file in ls_files if str(file[-5:]) == ".gpkg"]
        ls_with_gpkg = [
            file
            for file in ls_trip_all
            if file not in ["OSM4routing.gpkg", "mini_shapes.gpkg"]
        ]
        ls_trip_to_shape = [
            file for file in ls_with_gpkg if "shm" not in file and "wal" not in file
        ]
        progress.setValue(2)
        QApplication.processEvents()

        for trip_to_shape in ls_trip_to_shape:
            trip_gpkg = os.path.join(outputspath, trip_to_shape)
            trip_name = str(trip_to_shape[:-5])
            shp_dst_trvl(lines_trips_csv, trip_gpkg, trip_name)

        Ttbls = pd.read_csv(Ttlbs_txt, dtype="str")

        if "shape_dist_traveled" in Ttbls.columns:
            Ttbls = Ttbls.drop(["shape_dist_traveled"], axis=1)
            os.remove(Ttlbs_txt)
            Ttbls.to_csv(Ttlbs_txt, index=False)

        Ttbls_with_seq = pd.DataFrame()

        shapes = pd.DataFrame()

        for trip_to_shape in ls_trip_to_shape:
            trip_gpkg = os.path.join(outputspath, trip_to_shape)
            trip_name = str(trip_to_shape[:-5])
            trip_vertex_gpkg = os.path.join(
                temp_folder_linestrip, trip_name + "_vertex.gpkg"
            )
            shape_csv = os.path.join(shape_folder, str(trip_name) + ".csv")
            trip = shape_txt(trip_gpkg, trip_name, shape_csv, trip_vertex_gpkg)
            Ttbl_with_seq = stop_times_update(
                trip_name,
                lines_df_csv,
                lines_trips_csv,
                OSM_roads_gpkg,
                temp_folder_linestrip,
                trip_gpkg,
            )
            Ttbls_with_seq = pd.concat([Ttbls_with_seq, Ttbl_with_seq])
            shapes = pd.concat([shapes, trip], ignore_index=True)

        progress.setValue(2)
        QApplication.processEvents()

        shapes = shapes.rename(
            columns={
                "fid": "shape_pt_sequence",
                "line_trip": "shape_id",
                "lon": "shape_pt_lon",
                "lat": "shape_pt_lat",
            }
        )

        if_remove_single_file(shapes_txt)
        shapes.to_csv(shapes_txt, index=False)

        Ttbls = pd.read_csv(Ttlbs_txt)
        Ttbls_to_merge = Ttbls_with_seq[["orig_id", "shape_dist_traveled"]]
        Ttbls = Ttbls.merge(Ttbls_to_merge, how="left", on="orig_id")

        os.remove(Ttlbs_txt)
        Ttbls.to_csv(Ttlbs_txt, index=False)

        import zipfile

        trips_txt = os.path.join(agencies_folder, "trips.txt")
        routes_txt = os.path.join(agencies_folder, "routes.txt")
        agency_txt = os.path.join(agencies_folder, "agency.txt")
        stops_txt = os.path.join(agencies_folder, "stops.txt")
        calendar_txt = os.path.join(agencies_folder, "calendar.txt")
        calendar_dates_txt = os.path.join(agencies_folder, "calendar_dates.txt")
        zip_file = os.path.join(
            agencies_folder,
            os.path.splitext(os.path.basename(agencies_folder))[0] + ".zip",
        )
        lista_files = [
            Ttlbs_txt,
            shapes_txt,
            trips_txt,
            routes_txt,
            agency_txt,
            stops_txt,
            calendar_txt,
            calendar_dates_txt,
        ]

        progress.setValue(3)
        QApplication.processEvents()

        with zipfile.ZipFile(zip_file, "w") as zipMe:
            for file in lista_files:
                zipMe.write(
                    file,
                    arcname=os.path.basename(file),
                    compress_type=zipfile.ZIP_DEFLATED,
                )

        bar_for_messages.pushMessage(
            "Info",
            self.tr(f"It's DONE! Find your file in {zip_file}, CONGRATULATION!"),
            level=Qgis.Info,
            duration=120,
        )

    def __ZoomStop(self):

        # load the folders

        gtfs_folder_path = self.mGtfsFolderWidget.filePath()

        selected_agencies = self.listAgenciesWidget.selectedItems()

        count_all_agencies = self.listAgenciesWidget.count()
        agencies_folder, outputspath = generate_agencies_gtfs(
            gtfs_folder_path,
            selected_agencies,
            count_all_agencies,
        )

        temp_folder = "zoom_nmRD"
        nmRD_temp_folder = os.path.join(agencies_folder, temp_folder)
        nmRD_stops_name = "nmRD_stops"

        nmRD_stops_csv = os.path.join(nmRD_temp_folder, str(nmRD_stops_name) + ".csv")

        to_check = pd.read_csv(nmRD_stops_csv, index_col="seq_stpID")
        selected_item = self.stopsnmRDlistWidget.currentItem().text()

        latitude = float(to_check.at[selected_item, "lat"])
        longitude = float(to_check.at[selected_item, "lon"])
        target_point = QgsPointXY(longitude, latitude)

        canvas = self.iface.mapCanvas()

        canvas.setCenter(target_point)

        canvas.zoomScale(50)

        canvas.refresh()

    def __removeBuses(self):
        bar_for_messages = self.iface.messageBar()
        bar_for_messages.setMinimumHeight(150)

        gtfs_folder_path = self.mGtfsFolderWidget.filePath()

        selected_agencies = self.listAgenciesWidget.selectedItems()

        count_all_agencies = self.listAgenciesWidget.count()

        agencies_folder, outputspath = generate_agencies_gtfs(
            gtfs_folder_path, selected_agencies, count_all_agencies
        )

        temp_folder_main = str(os.getenv("USERNAME")) + "_main_files"
        main_files_fld = os.path.join(agencies_folder, temp_folder_main)
        buses_done_csv = os.path.join(main_files_fld, "buses.csv")
        lines_df_csv = os.path.join(agencies_folder, "lines_files_list.csv")
        uq_mn_trips_csv = os.path.join(
            agencies_folder, "temp/mini-trips/uq_mini_trips.csv"
        )
        files_to_delete_next_bus_loading_json = os.path.join(
            agencies_folder, "temp/files_to_delete_next_bus_loading.json"
        )

        files_to_del = load_files_to_del(agencies_folder)
        if files_to_del["path"]:
            bar_for_messages.pushMessage(
                "Info",
                self.tr(
                    f"The temporary files will be deleted only restarting QGIS, their paths are saved on {files_to_delete_next_bus_loading_json}"
                ),
                level=Qgis.Info,
                duration=7,
            )

        lines_df_csv = os.path.join(str(agencies_folder), "lines_files_list.csv")

        buses_done = pd.read_csv(buses_done_csv, index_col="trnsp_shrt_name")

        selected_items = self.listBusWidget.selectedItems()
        ls_lines = [item.text() for item in selected_items]

        ls_lines_names = []
        for line in ls_lines:
            if "Funicular" in line:
                trnsp = "Funicular"
                shrt_name = line[10:]
                line_name = trnsp + shrt_name
            elif "Ferry" in line:
                trnsp = "Ferry"
                shrt_name = line[6:]
                line_name = trnsp + shrt_name
            elif "RegRailServ" in line:
                trnsp = "RegRailServ"
                shrt_name = line[12:]
                line_name = trnsp + shrt_name
            elif "Tram" in line:
                trnsp = "Tram"
                shrt_name = line[5:]
                line_name = trnsp + shrt_name
            else:
                trnsp = "Bus"
                shrt_name = line[4:]
                line_name = trnsp + shrt_name
            ls_lines_names.append(line_name)
            try:
                buses_done = buses_done.drop(line)
            except Exception:
                self.iframe.messageBar().pushMessage(
                    "Info",
                    self.tr("you have never run the plugins with the " + str(line)),
                    level=Qgis.Info,
                    duration=7,
                )

        lines_df = pd.read_csv(lines_df_csv, dtype="str", index_col="line_name")

        if os.path.exists(uq_mn_trips_csv):
            uq_mn_trips = pd.read_csv(uq_mn_trips_csv)

        ls_files = lines_df.columns

        for line_name in ls_lines_names:
            if os.path.exists(uq_mn_trips_csv):
                i_row = 0
                ls_row_to_drop = []
                while i_row < len(uq_mn_trips):
                    if line_name in str(uq_mn_trips.loc[i_row, "mini_tr_path"]):
                        ls_row_to_drop.append(i_row)
                    i_row += 1
                uq_mn_trips = uq_mn_trips.drop(ls_row_to_drop)
                uq_mn_trips = uq_mn_trips.reset_index(drop=True)
            for file in ls_files:
                try:
                    path_to_del = lines_df.loc[line_name, file]
                    files_to_del = if_remove(path_to_del, files_to_del)
                except Exception:
                    bar_for_messages.pushMessage(
                        "Info",
                        self.tr(
                            "the "
                            + str(line_name)
                            + "'s \""
                            + str(file)
                            + "\" hasn't produced yet"
                        ),
                        level=Qgis.Info,
                        duration=7,
                    )
            try:
                lines_df = lines_df.drop(line_name)
            except Exception:
                bar_for_messages.pushMessage(
                    "Info",
                    self.tr(
                        "you have never run the plugins with the " + str(line_name)
                    ),
                    level=Qgis.Info,
                    duration=7,
                )

        files_to_del = if_remove(lines_df_csv, files_to_del)
        lines_df.to_csv(lines_df_csv)

        files_to_del = if_remove(buses_done_csv, files_to_del)
        buses_done.to_csv(buses_done_csv)

        if os.path.exists(uq_mn_trips_csv):
            if_remove(uq_mn_trips_csv, files_to_del)
            uq_mn_trips.to_csv(uq_mn_trips_csv, index=False)

        for line_name in ls_lines_names:
            for found in find("*" + str(line_name) + "*", agencies_folder):
                files_to_del = if_remove(found, files_to_del)
            bar_for_messages.pushMessage(
                "Info",
                self.tr("the " + str(line_name) + " has been removed sucessfully"),
                level=Qgis.Info,
                duration=30,
            )

        files_to_del_str = json.dumps(files_to_del, indent=2)
        with open(files_to_delete_next_bus_loading_json, "w") as f:
            f.write(files_to_del_str)
        if files_to_del["path"]:
            bar_for_messages.pushMessage(
                "Info",
                self.tr(
                    f"The temporary files will be deleted only restarting QGIS, their paths are saved on {files_to_delete_next_bus_loading_json}"
                ),
                level=Qgis.Info,
                duration=7,
            )

    def __displayTrips(self):
        gtfs_folder_path = self.mGtfsFolderWidget.filePath()

        selected_agencies = self.listAgenciesWidget.selectedItems()

        count_all_agencies = self.listAgenciesWidget.count()

        agencies_folder, outputspath = generate_agencies_gtfs(
            gtfs_folder_path, selected_agencies, count_all_agencies
        )
        temp_folder = "OSM_data"
        road_temp_folder = os.path.join(agencies_folder, temp_folder)

        full_roads_name = "full_city_roads"
        full_roads_gpgk = os.path.join(road_temp_folder, full_roads_name + ".gpkg")

        tram_rails_name = "OSM_tram"
        tram_rails_gpgk = os.path.join(road_temp_folder, tram_rails_name + ".gpkg")

        OSM_Regtrain_name = "OSM_Regtrain"
        OSM_Regtrain_gpkg = os.path.join(road_temp_folder, OSM_Regtrain_name + ".gpkg")

        OSM_funicular_name = "OSM_funicular"
        OSM_funicular_gpkg = os.path.join(
            road_temp_folder, OSM_funicular_name + ".gpkg"
        )
        OSM_ferry_name = "OSM_ferry"
        OSM_ferry_gpkg = os.path.join(road_temp_folder, OSM_ferry_name + ".gpkg")

        selected_items = self.tripsListWidget.selectedItems()
        ls_to_disp = [item.text() for item in selected_items]

        display_OSM_and_SWISSTOPO_IMAGE_maps()

        if_display_r_layer(full_roads_gpgk, full_roads_name)
        if_display_r_layer(full_roads_gpgk, full_roads_name)
        if_display_r_layer(tram_rails_gpgk, tram_rails_name)
        if_display_r_layer(OSM_Regtrain_gpkg, OSM_Regtrain_name)
        if_display_r_layer(OSM_funicular_gpkg, OSM_funicular_name)
        if_display_r_layer(OSM_ferry_gpkg, OSM_ferry_name)

        for trip in ls_to_disp:
            if not QgsProject.instance().mapLayersByName(str(trip[:-5])):
                trip_gpkg = os.path.join(outputspath, trip)
                tirp_layer = QgsVectorLayer(trip_gpkg, str(trip[:-5]), "ogr")
                symbol = tirp_layer.renderer().symbol()
                symbol.setWidth(0.9)
                QgsProject.instance().addMapLayer(tirp_layer)

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()
