# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GSMCoverBuilderDialog
                                 A QGIS plugin
 GSM Cover Builder allows you to quickly generate coverage plans based on localities and a defined coverage radius
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-02-11
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Fadil Kristof GNANKAMBARY
        email                : krisfadil@live.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import QDialog, QFormLayout
from qgis.gui import QgsFieldComboBox, QgsMapLayerComboBox
from qgis.core import QgsMapLayerProxyModel

# Charger le fichier .ui pour générer l'interface utilisateur
FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), 'GSM_Cover_Builder_dialog_base.ui'))

class GSMCoverBuilderDialog(QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(GSMCoverBuilderDialog, self).__init__(parent)
        self.setupUi(self)

        # Initialiser les éléments QgsMapLayerComboBox et QgsFieldComboBox
        self.mMapLayerComboBox.setFilters(QgsMapLayerProxyModel.VectorLayer)
        self.mMapLayerComboBox.setCurrentIndex(-1)  # Aucun élément sélectionné au début

        # Connecter le signal layerChanged pour mettre à jour les champs dans mFieldComboBox
        self.mMapLayerComboBox.layerChanged.connect(self.update_fields)

        # Connecter le signal de changement de champ
        self.mFieldComboBox.fieldChanged.connect(self.on_field_changed)

    def update_fields(self):
        """Mettre à jour la liste des champs de la couche sélectionnée dans mFieldComboBox."""
        layer = self.mMapLayerComboBox.currentLayer()
        if layer:
            self.mFieldComboBox.setLayer(layer)  # Met à jour les champs de la couche sélectionnée
            self.mFieldComboBox.setCurrentIndex(-1)  # Réinitialise la sélection du champ

    def on_field_changed(self, fieldName):
        """Réagir au changement de champ dans mFieldComboBox."""
        print(f"Champ sélectionné : {fieldName}")
        # Je peux ici alimenter une variable ou un paramètre du script avec fieldName
