# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeoscienceSectionVerticalExaggeration
                                 A QGIS plugin
 This plugin creates a vertically exaggerated section of your already created geoscience section.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from .tasks import task1_create_scale  # Import your Task1 module here
from .tasks import task2_exaggerate
from .tasks import task3_make_permanent
from .tasks import task4_delete_temp

import os.path


class GeoscienceSectionVerticalExaggeration:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)

        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'GeoscienceSectionVerticalExaggeration_{}.qm'.format(locale)
        )

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr(u'&Geoscience Section Vertical Exaggeration')
        self.first_start = True

    def tr(self, message):
        return QCoreApplication.translate('GeoscienceSectionVerticalExaggeration', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):

        icon = QIcon(icon_path) if icon_path else QIcon()
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip:
            action.setStatusTip(status_tip)

        if whats_this:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        """Create menu entries and toolbar icons inside QGIS GUI."""

        icon_path = os.path.join(self.plugin_dir, "icons", "icon1.png")
        self.action_task1_create_scale = self.add_action(
            icon_path,
            "Generate vertical section scale (at 1:1)",
            self.run_task1_create_scale
        )

        icon_path = os.path.join(self.plugin_dir, "icons", "icon2.png")
        self.action_task2_exaggerate = self.add_action(
            icon_path,
            "Apply vertical exaggeration (to section group)",
            self.run_task2_exaggerate
        )

        icon_path = os.path.join(self.plugin_dir, "icons", "icon3.png")
        self.action_task3_make_permanent = self.add_action(
            icon_path,
            "Make selected group permanent",
            self.run_task3_make_permanent
        )

        icon_path = os.path.join(self.plugin_dir, "icons", "icon4.png")
        self.action_task4_delete_temp = self.add_action(
            icon_path,
            "Remove and delete temporary features in selected group",
            self.run_task4_delete_temp
        )

    def unload(self):
        """Remove plugin menu items and icons from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(self.menu, action)
            self.iface.removeToolBarIcon(action)

    def run_task1_create_scale(self):
        task1_create_scale.run(self.iface)

    def run_task2_exaggerate(self):
        task2_exaggerate.run(self.iface)

    def run_task3_make_permanent(self):
        task3_make_permanent.run(self.iface)

    def run_task4_delete_temp(self):
        task4_delete_temp.run(self.iface)

