# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Growth region - MapTool

                             -------------------
        begin                : 2025-09-02
        copyright            : (C) 2025 by Luiz Motta
        email                : motta.luiz@gmail.com

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from typing import Tuple

from qgis.PyQt.QtCore import pyqtSlot

from qgis.core import QgsApplication
from qgis.gui import (
    QgsMapCanvas,
    QgsMapTool,
    QgsMapMouseEvent
)

from .gr_raster_layer import GrowthRegionRasterLayer, getCanvasRGB


class GrowthRegionMapTool(QgsMapTool):
    def __init__(self, map_canvas:QgsMapCanvas):
        super().__init__( map_canvas )
        
        self._cursor = QgsApplication.getThemeCursor( QgsApplication.CapturePoint )
        self._gr_raster = GrowthRegionRasterLayer( map_canvas)
        self._seed_pixel_point_xy = None
        self.canvas = map_canvas


    def __del__(self)->None:
        self.cleanup()

    @pyqtSlot()
    def activate(self)->None:
        super().activate()
        self.canvas.setCursor( self._cursor )

    @pyqtSlot(QgsMapMouseEvent)
    def canvasPressEvent(self, e:QgsMapMouseEvent)->None:
        self._gr_raster._seed_img_point = e.originalPixelPoint()
        self._gr_raster._seed_map_point = e.originalMapPoint()
        self._gr_raster.seed_rgb = getCanvasRGB( self.canvas, self._gr_raster._seed_img_point )

        self._gr_raster.updateLayer()

    @pyqtSlot(QgsMapMouseEvent)
    def canvasMoveEvent(self, e:QgsMapMouseEvent)->None:
        pixel_point = e.originalPixelPoint()
        self._gr_raster.showRGB.emit( getCanvasRGB( self.canvas, pixel_point ) )

    def cleanup(self)->None:
        self._gr_raster.freeLayer()
