# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Growth region
                                 A QGIS plugin

                             -------------------
        begin                : 2025-09-02
        copyright            : (C) 2025 by Luiz Motta
        email                : motta.luiz@gmail.com

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

__author__ = "Luiz Motta"
__date__ = "2025-09-02"
__copyright__ = "(C) 2025, Luiz Motta"
__revision__ = "$Format:%H$"


import os

from qgis.PyQt.QtCore import (
    QObject,
    QDir,
    pyqtSlot
)
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import  QAction

from qgis.gui import QgisInterface, QgsMapTool


from .gr.gr_maptool import GrowthRegionMapTool
from .gr.translate import setTranslation

def classFactory(iface:QgisInterface):
    return GrowthRegionPlugin(iface)


class GrowthRegionPlugin(QObject):
    def __init__(self, iface:QgisInterface):
        super().__init__()
        self.iface = iface
        self.canvas = iface.mapCanvas()

        setTranslation( type(self).__name__, os.path.dirname(__file__) )

        self.plugin_name = 'GrowthRegion'
        self.action_name = 'Growth Region'
        self.gr_action = None
        self.gr_maptool = None
        self.previus_maptool = None

    def initGui(self)->None:
        path = QDir( os.path.dirname(__file__) )
        icon = QIcon( path.filePath('resources/growth_region.svg'))
        self.gr_action = QAction( icon, self.action_name, self.iface.mainWindow() )
        self.gr_action.setToolTip( self.action_name )
        self.gr_action.setCheckable(True)
        self.gr_action.triggered.connect(self.on_RgClicked)

        self.canvas.mapToolSet.connect( self.on_MapToolSet )

        self.gr_maptool = GrowthRegionMapTool( self.canvas )
        self.previus_maptool = self.canvas.mapTool()

        self.menu_name = f"&{self.action_name}"
        self.iface.addPluginToVectorMenu( self.menu_name, self.gr_action )
        self.iface.vectorToolBar().addAction(self.gr_action)

    def unload(self)->None:
        self.iface.removePluginMenu( self.menu_name, self.gr_action )
        self.iface.vectorToolBar().removeAction( self.gr_action )
        
        if self.gr_maptool:
            self.canvas.unsetMapTool( self.gr_maptool )
        
        # Disconnect
        try:
            self.gr_action.triggered.disconnect( self.on_RgClicked )
        except Exception:
            pass
        self.gr_action.deleteLater()

        del self.gr_maptool

    @pyqtSlot(bool)
    def on_RgClicked(self, enabled:bool)->None:
        if enabled:
            self.previus_maptool = self.canvas.mapTool()
            self.canvas.setMapTool( self.gr_maptool )
            return
        self.canvas.setMapTool( self.previus_maptool )

    @pyqtSlot(QgsMapTool, QgsMapTool)
    def on_MapToolSet(self, newTool:QgsMapTool, oldTool:QgsMapTool)->None:
        if oldTool == self.gr_maptool:
            self.gr_action.setChecked(False)
