# -*- coding: utf-8 -*-

"""
/***************************************************************************
 gridindex
                                 A QGIS plugin
 This plugin generates a grid of rectangular polygons for map book page indexing.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-06-07
        copyright            : (C) 2025 by Kapildev Adhikari
        email                : kapildevadk@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Kapildev Adhikari'
__date__ = '2025-06-07'
__copyright__ = '(C) 2025 by Kapildev Adhikari'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
import os
from .gridindex_algorithm import gridindexAlgorithm


class gridindexProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self, *args, **kwargs):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(gridindexAlgorithm())
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self, *args, **kwargs):
        """The ID of your plugin, used for identifying the provider.
        
        This string should be unique and must not be changed within a plugin
        once released.
        """
        return 'grid_index'

    def name(self, *args, **kwargs):
        return self.tr('Grid Index')

    def longName(self, *args, **kwargs):
        return self.tr('Grid Index')
    
    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        # Construct the full path to the icon file
        icon_path = os.path.join(os.path.dirname(__file__), 'icon.png')
        return QIcon(icon_path)
