# Grid Coordinate Generator / Générateur de Grille de Coordonnées

[English](#english) | [Français](#français)

---

<a name="english"></a>
## 🌍 English

### Description

**Grid Coordinate Generator** is a QGIS plugin that automatically calculates optimal grid intervals for coordinate grids in map layouts. It eliminates the frustration of trial-and-error when setting up coordinate grids by using the "nice numbers" method to propose clean, readable intervals.

### ✨ Key Features

- 🎯 **Automatic Interval Calculation**: Uses the "nice numbers" algorithm (1, 2, 5 × 10ⁿ) to generate clean intervals
- 🌐 **Multi-CRS Support**: Works seamlessly with both geographic (WGS84, latitude/longitude) and projected (UTM, etc.) coordinate systems
- 📐 **Multi-Unit Support**: Display in meters, kilometers, decimal degrees, or DMS (Degrees Minutes Seconds)
- 📊 **Two Layout Modes**:
  - **General Mode**: All features from selected layers displayed together
  - **Atlas Mode**: Group features by identifier field for batch processing
- 🎨 **Real-time Preview**: Grid displayed instantly on the QGIS canvas
- 🗺️ **Multi-Geometry Support**: Works with polygons, lines, and points
- 🔄 **Multi-Layer Support**: Select and process multiple layers simultaneously
- 🌍 **Internationalization**: Available in French, English, Spanish, and Arabic (easily extensible)

### 📥 Installation

#### Method 1: From QGIS Plugin Repository (Recommended)

1. Open QGIS
2. Go to **Plugins** → **Manage and Install Plugins**
3. Search for "Grid Coordinate Generator"
4. Click **Install Plugin**

#### Method 2: Manual Installation

1. Download the latest release from [GitHub Releases](https://github.com/AzizT-dev/grid-coordinate-generator/releases)
2. Extract the ZIP file
3. Copy the `grid_coordinate_generator` folder to your QGIS plugins directory:
   - **Windows**: `C:\Users\YourName\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins\`
   - **macOS**: `~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins/`
   - **Linux**: `~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/`
4. Restart QGIS
5. Enable the plugin in **Plugins** → **Manage and Install Plugins**

### 🚀 Quick Start

1. **Open the plugin**: Click the Grid Generator icon in the toolbar or go to **Plugins** → **KAT Tools** → **Grid Coordinate Generator**
2. **Select layers**: Choose one or more vector layers from the list
3. **Choose mode**:
   - **General**: Process all features together
   - **Atlas**: Group by identifier field
4. **Select units**: Choose display units (meters, km, decimal degrees, or DMS)
5. **Click Execute**: The grid appears on your canvas with calculated intervals displayed in the log

### 🔧 Advanced Configuration

#### Understanding the Calculation

The plugin uses the **"nice numbers"** algorithm:

1. Calculates the extent (width × height) of your features
2. Divides by target number of divisions (default: 10)
3. Rounds to the nearest "nice number": 1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, etc.

**Example**:
- Extent: 325m × 480m
- Raw interval: 48m (480/10)
- Nice interval: **50m** ✓

#### CRS-Unit Matrix

| Data CRS | Selected Unit | Result |
|----------|---------------|--------|
| UTM (meters) | meters | Direct calculation |
| UTM (meters) | km | Converted to km |
| UTM (meters) | decimal degrees | Converted to degrees (latitude-dependent) |
| UTM (meters) | DMS | Converted to DMS |
| WGS84 (degrees) | meters | Converted to meters (~111 km/degree) |
| WGS84 (degrees) | km | Converted to km |
| WGS84 (degrees) | decimal degrees | Direct calculation |
| WGS84 (degrees) | DMS | Direct calculation |

### 🐛 Troubleshooting

**Problem**: "No valid geometry found"  
- **Solution**: Check that your layer contains valid geometries. Use **Vector** → **Geometry Tools** → **Check Validity** in QGIS.

**Problem**: Grid intervals are too large/small  
- **Cause**: Expected behavior - the plugin optimizes for readability (10 divisions)  
- **Workaround**: Use the calculated interval as a starting point and adjust manually

**Problem**: "Interval calculated: 0.000 km"  
- **Cause**: Your features are very small relative to the unit chosen  
- **Solution**: Choose a smaller unit (e.g., meters instead of km)

**Problem**: Different intervals in General vs Atlas mode  
- **Explanation**: Normal - General mode calculates based on global extent, Atlas mode on individual feature extent


### 📄 License

This plugin is licensed under the GNU General Public License v2.0. See [LICENSE](LICENSE) for details.

### 👤 Author

**Aziz TRAORE**  
- Email: aziz.explorer@gmail.com  
- GitHub: [AzizT-dev](https://github.com/AzizT-dev)  
- LinkedIn: [Koroman Aziz Traoré](https://linkedin.com/in/koroman-aziz-traore)

### 🙏 Acknowledgments

- Inspired by challenges faced by cartographers when setting up coordinate grids
- Built with the excellent QGIS Python API
- "Nice numbers" algorithm based on [Matplotlib's implementation](https://github.com/matplotlib/matplotlib)

### 📊 Statistics

![GitHub stars](https://img.shields.io/github/stars/AzizT-dev/grid-coordinate-generator?style=social)  
![GitHub forks](https://img.shields.io/github/forks/AzizT-dev/grid-coordinate-generator?style=social)  
![GitHub downloads](https://img.shields.io/github/downloads/AzizT-dev/grid-coordinate-generator/total)  
![License](https://img.shields.io/github/license/AzizT-dev/grid-coordinate-generator)

---

## 📞 Support

- **Issues**: [GitHub Issues](https://github.com/AzizT-dev/grid-coordinate-generator/issues)  
- **Discussions**: [GitHub Discussions](https://github.com/AzizT-dev/grid-coordinate-generator/discussions)  
- **Email**: aziz.explorer@gmail.com

---

<a name="français"></a>
## 🇫🇷 Français

### Description

**Générateur de Grille de Coordonnées** est une extension QGIS qui calcule automatiquement les intervalles optimaux pour les grilles de coordonnées dans les mises en page cartographiques. Elle élimine la frustration du tâtonnement lors de la configuration des grilles en utilisant la méthode des "nombres propres" pour proposer des intervalles nets et lisibles.

### ✨ Fonctionnalités principales

- 🎯 **Calcul automatique d'intervalle** : Utilise l'algorithme des "nice numbers" (1, 2, 5 × 10ⁿ) pour générer des intervalles propres
- 🌐 **Support multi-CRS** : Fonctionne avec les systèmes de coordonnées géographiques (WGS84) et projetés (UTM, etc.)
- 📐 **Support multi-unités** : Affichage en mètres, kilomètres, degrés décimaux ou DMS (Degrés Minutes Secondes)
- 📊 **Deux modes de mise en page** :
  - **Mode Général** : Toutes les entités des couches sélectionnées affichées ensemble
  - **Mode Atlas** : Regrouper les entités par champ identifiant pour traitement par lots
- 🎨 **Aperçu en temps réel** : Grille affichée instantanément sur le canevas QGIS
- 🗺️ **Support multi-géométries** : Fonctionne avec polygones, lignes et points
- 🔄 **Support multi-couches** : Sélectionner et traiter plusieurs couches simultanément
- 🌍 **Internationalisation** : Disponible en français, anglais, espagnol et en arabe (facilement extensible)


### 📥 Installation

#### Méthode 1 : Depuis le dépôt d'extensions QGIS (Recommandé)

1. Ouvrir QGIS
2. Aller dans **Extensions** → **Installer/Gérer les extensions**
3. Rechercher "Grid Coordinate Generator"
4. Cliquer sur **Installer l'extension**

#### Méthode 2 : Installation manuelle

1. Télécharger la dernière version depuis [GitHub Releases](https://github.com/AzizT-dev/grid-coordinate-generator/releases)
2. Extraire le fichier ZIP
3. Copier le dossier `grid_coordinate_generator` dans votre répertoire d'extensions QGIS :
   - **Windows** : `C:\Users\VotreNom\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins\`
   - **macOS** : `~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins/`
   - **Linux** : `~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/`
4. Redémarrer QGIS
5. Activer l'extension dans **Extensions** → **Installer/Gérer les extensions**

### 🚀 Démarrage rapide

1. **Ouvrir l'extension** : Cliquer sur l'icône Grid Generator dans la barre d'outils ou aller dans **Extensions** → **KAT Tools** → **Générateur de Grille de Coordonnées**
2. **Sélectionner les couches** : Choisir une ou plusieurs couches vectorielles dans la liste
3. **Choisir le mode** :
   - **Général** : Traiter toutes les entités ensemble
   - **Atlas** : Regrouper par champ identifiant
4. **Sélectionner les unités** : Choisir les unités d'affichage (mètres, km, degrés décimaux ou DMS)
5. **Cliquer sur Exécuter** : La grille apparaît sur votre canevas avec les intervalles calculés affichés dans le journal

### 📖 Exemples d'utilisation

#### Exemple 1 : Grille de prospection minière (UTM)

**Scénario** : Créer une grille 100m × 100m pour une zone de prospection minière

1. Charger votre polygone de zone d'étude (EPSG:32630 - WGS 84 / UTM zone 30N)
2. Ouvrir le Générateur de Grille de Coordonnées
3. Sélectionner votre couche polygone
4. Choisir le **Mode Général**
5. Sélectionner **mètres** comme unité
6. Cliquer sur **Exécuter**
7. L'extension calcule : Intervalle X = 100,0 m, Intervalle Y = 100,0 m

#### Exemple 2 : Atlas de régions administratives (WGS84)

**Scénario** : Créer des grilles individuelles pour chaque région d'un pays

1. Charger votre couche de régions (EPSG:4326 - WGS 84)
2. Ouvrir le Générateur de Grille de Coordonnées
3. Sélectionner votre couche de régions
4. Choisir le **Mode Atlas**
5. Sélectionner le champ identifiant : "nom_region"
6. Sélectionner **degrés décimaux** comme unité
7. Cliquer sur **Exécuter**
8. Naviguer entre les régions avec les boutons Précédent/Suivant
9. Chaque région affiche sa grille optimisée

#### Exemple 3 : Conversion multi-CRS

**Scénario** : Vos données sont en UTM mais vous avez besoin d'intervalles en degrés

1. Charger votre couche UTM (EPSG:32630)
2. Ouvrir le Générateur de Grille de Coordonnées
3. Sélectionner **degrés décimaux** ou **DMS** comme unité
4. L'extension convertit automatiquement et affiche : "0,05° (≈ 5,55 km à cette latitude)"

### 🔧 Configuration avancée

#### Comprendre le calcul

L'extension utilise l'algorithme des **"nice numbers"** :

1. Calcule l'emprise (largeur × hauteur) de vos entités
2. Divise par le nombre de divisions cibles (par défaut : 10)
3. Arrondit au "nombre propre" le plus proche : 1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, etc.

**Exemple** :
- Emprise : 325m × 480m
- Intervalle brut : 48m (480/10)
- Intervalle propre : **50m** ✓

#### Matrice CRS-Unité

| CRS des données | Unité sélectionnée | Résultat |
|-----------------|-------------------|----------|
| UTM (mètres) | mètres | Calcul direct |
| UTM (mètres) | km | Converti en km |
| UTM (mètres) | degrés décimaux | Converti en degrés (dépend de la latitude) |
| UTM (mètres) | DMS | Converti en DMS |
| WGS84 (degrés) | mètres | Converti en mètres (~111 km/degré) |
| WGS84 (degrés) | km | Converti en km |
| WGS84 (degrés) | degrés décimaux | Calcul direct |
| WGS84 (degrés) | DMS | Calcul direct |

### 🐛 Dépannage

**Problème** : "Aucune géométrie valide trouvée"
- **Solution** : Vérifier que votre couche contient des géométries valides. Utiliser **Vecteur** → **Outils de géométrie** → **Vérifier la validité** dans QGIS.

**Problème** : Les intervalles de grille sont trop grands/petits
- **Cause** : C'est le comportement attendu - l'extension optimise pour la lisibilité (10 divisions)
- **Solution de contournement** : Utiliser l'intervalle calculé comme point de départ et ajuster manuellement dans votre mise en page

**Problème** : "Intervalle calculé : 0,000 km"
- **Cause** : Vos entités sont très petites par rapport à l'unité choisie
- **Solution** : Choisir une unité plus petite (par ex. mètres au lieu de km)

**Problème** : Intervalles différents en mode Général vs Atlas
- **Explication** : Normal - le mode Général calcule basé sur l'emprise globale, le mode Atlas sur l'emprise de chaque entité


### 📄 Licence

Cette extension est sous licence GNU General Public License v2.0. Voir [LICENSE](LICENSE) pour les détails.

### 👤 Auteur

**Aziz TRAORE**
- Email : aziz.explorer@gmail.com
- GitHub : [AzizT-dev](https://github.com/AzizT-dev)
- LinkedIn : [Koroman Aziz Traoré](https://linkedin.com/in/koroman-aziz-traore)

### 🙏 Remerciements

- Inspiré par les défis rencontrés par les cartographes lors de la configuration des grilles de coordonnées
- Construit avec l'excellente API Python QGIS
- Algorithme des "nice numbers" basé sur [l'implémentation de Matplotlib](https://github.com/matplotlib/matplotlib)

### 📊 Statistiques

![GitHub stars](https://img.shields.io/github/stars/AzizT-dev/grid-coordinate-generator?style=social)
![GitHub forks](https://img.shields.io/github/forks/AzizT-dev/grid-coordinate-generator?style=social)
![GitHub downloads](https://img.shields.io/github/downloads/AzizT-dev/grid-coordinate-generator/total)
![License](https://img.shields.io/github/license/AzizT-dev/grid-coordinate-generator)


---

## 📞 Support

- **Issues**: [GitHub Issues](https://github.com/your-username/grid-coordinate-generator/issues)
- **Discussions**: [GitHub Discussions](https://github.com/your-username/grid-coordinate-generator/discussions)
- **Email**: aziz.explorer@gmail.com

---

**Made with ❤️ for the QGIS community**

**Fait avec ❤️ pour la communauté QGIS**
