# -*- coding: utf-8 -*-

"""

utils.py

This file contains every helper functions.

"""


__author__ = 'gaspard.quentin1905@gmail.com'
__date__ = '2024-02-11'
__copyright__ = 'Copyright 2024, Laboratoire ThéMA'

"""
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.core import QgsVectorLayer

def getLayerMinMaxValue(layers: list[QgsVectorLayer], fieldname: str) -> tuple[int, int]:
    """ 
        Helper function that returns the couple min max value found in the layer with the field name given.
    """
    min = -1
    max = -1
    for layer in layers:
        idx = layer.fields().indexFromName(fieldname)
        if idx == -1:
            raise Exception(f"field {fieldname} not found in the layer of fields : \n {[field.name() for field in layer.fields()]}")
        tmp_min = layer.minimumValue(idx)
        tmp_max = layer.maximumValue(idx)
        if min == -1 or tmp_min < min:
            min = tmp_min
        if max == -1 or tmp_max > max:
            max = tmp_max
    return (min, max)

def updateDictAppend_(dict1: dict, dict2: dict):
    """ 
        Helper function that merges dict2 into dict1 like the .update() builtin method
        but, when a key k is common, creates a list such as dict1[k] <- [dict1[k], dict2[k]]
        instead of overriding dict1[k] by dict2[k]
    """
    result = dict1.copy()

    for key, value in dict2.items():
        if key in result:
            if isinstance(result[key], list):
                if isinstance(value, list):
                    for e in value:
                        result[key].append(e)
                else:
                    result[key].append(value)
            else:
                result[key] = [result[key], value]
        else:
            result[key] = value

    return result

