# About Graphab 3 for QGIS

The *Graphab for QGIS* plugin is a tool that allow you to use the [*Graphab*](https://thema.univ-fcomte.fr/productions/software/graphab/fr/home.html) software on QGIS. This plugin integrates the basic functionalities of Graphab :

 - Graphab projects visualization
 - Graphs creation from a landscape map with an identification of habitat patches and links (Euclidean distance or least cost path)
 - Metrics of usual connectivity calculation

But it also adds :

 - Landscape map creation from rasters and vectors

# Authors

The *Graphab for QGIS* plugin has been developed by Gaspard Quentin, Robin Marlin-Lefebvre and Gilles Vuidel in the ThéMA laboratory (University of Franche-Comté - [CNRS](https://www.cnrs.fr/)).

# Terms of use

The *Graphab for QGIS* plugin is available freely under GPL license. *Graphab for QGIS* users are invited to quote this [reference](https://doi.org/10.1016/j.simpa.2021.100065) below in their works :

> Foltête, J.-C., Vuidel, G., Savary, P., Clauzel, C., Sahraoui, Y., Girardet, X., & Bourgeois, M. (2021). Graphab : An application for modeling and managing ecological habitat networks. *Software Impacts, 8*, 100065.

# Required configuration

*Graphab for QGIS* works on all computers that support Java 11 or more (PC under Linux, Windows, Mac…). Some functions can work without the need of Java.

# Documentation

Documentation are available below :

 - [User guide (en)](https://thema.univ-fcomte.fr/productions/software/graphab/download/graphab34qgis_manual-3.0-en.pdf)
 - [Graphab guide](https://thema.univ-fcomte.fr/productions/software/graphab/download/manual-3.0-en.pdf)

---

# A propos de Graphab 3 for QGIS

Le plugin *Graphab for QGIS* est un outil permettant d'utiliser le programme [*Graphab*](https://sourcesup.renater.fr/www/graphab/) sur l'outil QGIS. Ce plugin intègre les fonctionnalités de base de Graphab :

 - Visualisation de projets Graphab
 - Création de graphes à partir d'une carte de paysage avec identification des taches d'habitat et des liens (distance euclidienne ou chemin de moindre coût)
 - Calcul des métriques de connectivité usuelles

Mais aussi ajoute :

 - Création de la carte d'occupation du sol à partir de données rasters et vecteurs

# Auteurs

Le plugin *Graphab for QGIS* a été développé par Gaspard Quentin, Robin Marlin-Lefebvre et Gilles Vuidel au laboratoire ThéMA (Université de Franche-Comté - [CNRS](https://www.cnrs.fr/)).

# Conditions d'utilisation

Le plugin *Graphab for QGIS* est disponible librement sous license GPL. Les utilisateurs de *Graphab for QGIS* sont invités à citer la [référence](https://doi.org/10.1016/j.simpa.2021.100065) ci-dessous dans leurs travaux :

> Foltête, J.-C., Vuidel, G., Savary, P., Clauzel, C., Sahraoui, Y., Girardet, X., & Bourgeois, M. (2021). Graphab : An application for modeling and managing ecological habitat networks. *Software Impacts, 8*, 100065.

# Configuration requise

*Graphab for QGIS* fonctionne sur tout ordinateur supportant Java 11 ou supérieur (PC sous Linux, Windows, Mac…). Certaines fonctions peuvent fonctionner sans la nécessité d’avoir Java.

# Documentation

Une documentation est disponible ci-dessous :

 - [Manuel utilisateur (fr)](https://thema.univ-fcomte.fr/productions/software/graphab/download/graphab34qgis_manuel-3.0-fr.pdf)
 - [Manuel Graphab](https://thema.univ-fcomte.fr/productions/software/graphab/download/manual-3.0-fr.pdf)
