# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CorridorDialog
                                 A QGIS plugin
 This plugin allows you to convert easly a Graphab project
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-04-20
        git sha              : $Format:%H$
        copyright            : (C) 2020 by ThéMA
        email                : robin.marlinl@gmail.com
        author               : Robin Marlin-Lefebvre
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5.QtCore import QCoreApplication
import processing

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from PyQt5.QtWidgets import QMessageBox

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'ui_files', 'corridor_dialog.ui'))


class CorridorDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, plugin):
        """Constructor."""
        super(CorridorDialog, self).__init__(None)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.projectComboBox.currentIndexChanged.connect(self.select_project)
        self.graphComboBox.currentIndexChanged.connect(lambda: self.populateMetricCB(self.graphComboBox.currentText()))
        self.vectorRadio.clicked.connect(self.toggleRasterParameters)
        self.rasterRadio.clicked.connect(self.toggleRasterParameters)
        self.unitComboBox.addItems(plugin.UNITS)
        self.distanceCB.addItems(plugin.UNITS)
        self.probaCB.addItems(plugin.PROBA_DIST)

        self.plugin = plugin
        # EXTREMELY IMPORTANT VARIABLE IF windowProcess NOT STOCK HE CAN'T USE POSTPROCESSALGORITHM()
        self.windowProcess = None
        
    #--------------------------------------------------------------------------
    def toggleRasterParameters(self):
        to_toggle = [self.label_4,
                     self.label_5,
                     self.label_6,
                     self.metricCB,
                     self.distanceSB,
                     self.distanceCB,
                     self.probaCB]
        for widget in to_toggle:
            widget.setEnabled(not self.vectorRadio.isChecked())
        self.maxDistSB.setEnabled(self.vectorRadio.isChecked())
        self.unitComboBox.setEnabled(self.vectorRadio.isChecked())
        self.label_2.setEnabled(self.vectorRadio.isChecked())
        
    #--------------------------------------------------------------------------
    def showDialog(self):
        """Initialize basic window and waiting for any action of the user"""
        if not self.plugin.java:
            self.plugin.showJavaNotFound()
            return

        # upgrade the list of loaded project
        self.projects = self.plugin.getProjects()
        if len(self.projects) == 0:
            QMessageBox.information( 
                None,
                self.translate('no_project', 'ERROR: no project opened'),
                self.translate('no_project', 'please open or create a project')
            )
            return

        self.maxDistSB.setEnabled(False)
        self.unitComboBox.setEnabled(False)
        self.label_2.setEnabled(False)
        self.rasterRadio.setChecked(True)
        self.projectComboBox.clear()
        self.projectComboBox.addItems([prj.project.name for prj in self.projects])
        if self.graphComboBox.count() > 0:
            self.populateMetricCB(self.graphComboBox.currentText())
        else:
            self.populateMetricCB()
        self.adjustSize()
        self.show()

        result = self.exec_()
        # See if OK was pressed
        if result:
            # get all parameters set
            self.calcCorridor()
    
    #--------------------------------------------------------------------------
    
    def select_project(self, index):
        """Open a window to select a project if there is no project selected yet and 
        initialize some items with project values"""
        project = self.projects[index]
        
        # populate the combo box with all available graphs
        self.graphComboBox.clear()
        self.graphComboBox.addItems([graph.name for graph in project.project.graphs])

    #--------------------------------------------------------------------------
    def translate(self, context, string):
        return QCoreApplication.translate(context, string)


    #--------------------------------------------------------------------------
    def populateMetricCB(self, graphName: str = ''):
        """Populates the metric combobox. (Removes all previous entries)

        :param graphName: the graph that we need to check for metrics
        :type graphName: str
        """
        self.metricCB.clear()

        if graphName == '':
            return

        project = self.projects[self.projectComboBox.currentIndex()].project
        for graph in project.graphs:
            if graph.name != graphName:
                continue
            for metric in graph.metrics:
                if 'bc' in metric.name or 'fc' in metric.name:
                    self.metricCB.addItem(metric.name)

    #--------------------------------------------------------------------------
    def calcCorridor(self):
        """Get all parameters set by the user and send them to the processing to calculate corridors"""
        # get the name of the graph selected
        indProject = self.projectComboBox.currentIndex()
        pathProject = self.projects[indProject].projectFile
        graphName = self.graphComboBox.currentText()
        format = 0 if self.rasterRadio.isChecked() else 1

        # create readable parameters for processing
        params = {
            'INPUT' : pathProject,
            'NAMEGRAPH': graphName,
            'FORMAT': format
        }

        if self.rasterRadio.isChecked():
            # raster parameters
            if self.metricCB.count() > 0:
                params['METRIC'] = self.metricCB.currentText()
            params['DIST'] = self.distanceSB.value()
            params['DISTUNIT'] = self.distanceCB.currentIndex()
            params['PROBA'] = self.probaCB.currentIndex()
        else:
            # vector parameters
            params['MAXDIST'] = self.maxDistSB.value()
            params['MAXDISTUNIT'] = self.unitComboBox.currentIndex()

        # call the process to create a graph with all the parameters
        self.windowProcess = processing.createAlgorithmDialog("graphab3:calc_corridor", params)
        self.windowProcess.show()
        self.windowProcess.runAlgorithm()
