# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GraphSymbology / GraphSymbologyDialog
                                 A QGIS plugin
 This plugin allows you to convert easly a Graphab project
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-04-20
        git sha              : $Format:%H$
        copyright            : (C) 2020 by ThéMA
        email                : robin.marlinl@gmail.com
        author               : Robin Marlin-Lefebvre
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import typing

from ..utils import getLayerMinMaxValue

from ..GraphabProject import GraphabProject

from PyQt5.QtWidgets import QMessageBox
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import QgsProject, QgsLayerTreeGroup

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'ui_files', 'graph_symbology_dialog.ui'))

class GraphSymbologyDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, plugin):
        """Constructor."""
        super(GraphSymbologyDialog, self).__init__(None)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # Link the window to the main object (Graphab) for shared variables
        self.plugin = plugin
        # populate the combobox with existing style files names
        self.colorComboBox.addItems(self.plugin.stylesTabUnabled)

        self.graphComboBox.currentIndexChanged.connect(self.populateMetricComboBox)
        self.project: GraphabProject|None = None
        
    #--------------------------------------------------------------------------
    
    def showDialog(self):
        """Open a dialog window to choose a Graph (if it is not done yet) of a specific Project and 
        paramters like the color ramp of circles, the scale size, the field what color depends and if 
        the size depends of  the Capacity of circles or not."""

        # Verif if a Project has been deleted
        projects: list[GraphabProject] = self.plugin.getProjects()

        # Get the current selected layer if it exist
        nodeSelected = self.plugin.iface.layerTreeView().currentNode()
        graphGroup = None
        for project in projects:
            for graph in project.project.graphs:
                if nodeSelected and nodeSelected.name() == graph.name:
                    graphGroup = nodeSelected
                    self.project = project

        if self.project is None:
            if len(projects) == 1:
                self.project = projects[0]
            elif nodeSelected and "GraphabProject" in nodeSelected.customProperties():
                self.project = self.plugin.getProjectFromPath(nodeSelected.customProperty("GraphabProject"))
            else:
                QMessageBox.information(self.plugin.iface.mainWindow(), "Graphab", "Select a graph or a project before.")
                return

        #populate the combobox with existing groups names
        # Verif if there is Graph availables and stop the function if not
        self.project = typing.cast(GraphabProject, self.project)
        graphsName = [groupGraphLoop.name() for groupGraphLoop in self.project.getGraphsGroup().children()]
        if len(graphsName) == 0:
            QMessageBox.information(self.plugin.iface.mainWindow(), "Graphab",
                                    "There is no graph in selected project")
            return
        self.graphComboBox.clear()
        self.graphComboBox.addItems(graphsName)
        if graphGroup != None:
            try:
                self.graphComboBox.setCurrentIndex(self.project.getGraphsGroup().children().index(graphGroup))
            except:
                print("Wrong selected Graph group")

        #writing default value for min and max scale
        self.lineEdit.setText("1")
        self.lineEdit_2.setText("15")

        # show the dialog
        self.show()

        # Run the dialog event loop
        result = self.exec_()
        # See if OK was pressed
        if result:
            # change symbology of graph selected
            self.getInfoGraph()

    # --------------------------------------------------------------------------
    def populateMetricComboBox(self):
        """populates the combobox with existing fieldnames"""
        if self.project is None:
            return
        graphName = self.graphComboBox.currentText()
        self.metricComboBox.clear()
        graphGroup = self.project.getGraphsGroup().findGroup(graphName)
        if graphGroup is None:
            return
        for layer in graphGroup.findLayers():
            for field in layer.layer().fields():
                if (name := field.name()).endswith('_'+graphName) or name == 'capacity':
                    if self.metricComboBox.findText(name) == -1:
                        self.metricComboBox.addItem(name)
    #--------------------------------------------------------------------------
    def getInfoGraph(self):
        """Get parameters entered by the user in the Symbology window and use them to change the symbology
        of the Graph selected."""
        if self.project is None:
            return

        # get fieldname choosen
        fieldname = self.metricComboBox.currentText()
        # get stylename choosen
        styleName = self.colorComboBox.currentText()
        minScale = None
        maxScale = None

        #get graphGroup choosen
        selectedgraphGroupIndex = self.graphComboBox.currentIndex()
        graphGroup = self.project.getGraphsGroup().children()[selectedgraphGroupIndex]

        layerGraph = graphGroup.children()[0]

        #get min and max scale
        minScaleTampon = self.lineEdit.text()
        if minScaleTampon.isnumeric():
            minScale = minScaleTampon

        maxScaleTampon = self.lineEdit_2.text()
        if maxScaleTampon.isnumeric():
            maxScale = maxScaleTampon

        #get a boolean if the checkbox is checked
        defaultSize = self.checkBox.isChecked()

        #TODO: do the handling for multihabitat or interhabitat
        # get nodes layer of the specific graphGroup
        nodes = [lt.layer() for lt in graphGroup.children() if lt.layer().name() == 'Nodes']
        min, max = getLayerMinMaxValue(nodes, fieldname)
        if min == -1 and max == -1:
            min, max = None, None
        for layer in nodes:
            if self.project is None or fieldname != 'capacity':
                self.plugin.GraphabStyle.prepareStyle(fieldname, layer, styleName, minScale, maxScale, defaultSize, min, max)
                continue
            habitatID = self.project.getHabitatIDOfLayer(layer)
            self.plugin.GraphabStyle.prepareStyle(fieldname, layer, styleName, minScale, maxScale, defaultSize, min, max, habitatID=habitatID)


        # Set visible on the QGIS layer window the edited Graph
        layerGraph.setItemVisibilityChecked(True)
        graphGroup.setItemVisibilityChecked(True)

        # Expand the layer group
        graphGroup.setExpanded(True)
