# -*- coding: utf-8 -*-

"""
/***************************************************************************
 GpxMaker
                                 A QGIS plugin
 This plugin export GPX files for GARMIN® devices.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-05-31
        copyright            : (C) 2024 by Sanda Takeru
        email                : takeru_sanda999@maff.go.jp
 ***************************************************************************/

"""

__author__ = 'Sanda Takeru'
__date__ = '2024-05-31'
__copyright__ = '(C) 2024 by Sanda Takeru'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .gpx_maker_provider import GpxMakerProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class GpxMakerPlugin(object):

    def __init__(self):
        self.provider = None

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = GpxMakerProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
