# -*- coding: utf-8 -*-

"""
/***************************************************************************
 GpxMaker
                                 A QGIS plugin
 This plugin export GPX files for GARMIN® devices.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-05-31
        copyright            : (C) 2024 by Sanda Takeru
        email                : takeru_sanda999@maff.go.jp
 ***************************************************************************/

"""

__author__ = 'Sanda Takeru'
__date__ = '2024-05-31'
__copyright__ = '(C) 2024 by Sanda Takeru'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from pathlib import Path
from PyQt5.QtGui import QIcon

from qgis.core import QgsProcessingProvider
from .gpx_maker_algorithm import GpxMakerAlgorithm


class GpxMakerProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(GpxMakerAlgorithm())
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'GPX Maker for GARMIN® devices'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('GPX Maker for GARMIN® devices')

    def icon(self):
        path = (Path(__file__).parent / "icon.svg").resolve()
        return QIcon(str(path))

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
