# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GpkgCreator
                                 A QGIS plugin
 Creates geopackages that match the requirements for the EMI project
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-08
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Edouard Brülhart
        email                : edouard.bruelhart@unifr.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import QComboBox, QDialog, QAction, QMessageBox, QInputDialog, QVBoxLayout, QLabel, QPushButton
from qgis.core import QgsVectorLayer, QgsProject, QgsRelation, QgsEditorWidgetSetup, QgsFieldConstraints, QgsDefaultValue, QgsPalLayerSettings, QgsVectorLayerSimpleLabeling, QgsAttributeEditorContainer, QgsAttributeEditorField, QgsOptionalExpression, QgsExpression, QgsField, QgsEditFormConfig
from qgis.PyQt.QtCore import QVariant
from qgis.gui import QgsMapLayerComboBox
from osgeo import ogr
import os
import json
import requests

def classFactory(iface):
    return GpkgCreator(iface)

#Creates an EMI layer
class LayerSelectionDialog_create(QDialog):
    def __init__(self, project_name, gpkg_name, parent=None):
        super(LayerSelectionDialog_create, self).__init__(parent)
        self.setWindowTitle("Select the prompted layers")
        self.layout = QVBoxLayout()

        # Ask the project name
        self.project_label = QLabel(f"Project name: {project_name}")
        self.layout.addWidget(self.project_label)

        # Create a label for GPKG name
        self.gpkg_label = QLabel(f"GPKG name: {gpkg_name}")
        self.layout.addWidget(self.gpkg_label)

        # Create a label for layer selection
        self.label = QLabel("Select identification's layer:")
        self.layout.addWidget(self.label)

        # Create a layer combobox
        self.layer_combobox = QgsMapLayerComboBox()
        self.layout.addWidget(self.layer_combobox)

        # Create a label for field selection
        self.field_label = QLabel("Select identification's name column in the identification's layer:")
        self.layout.addWidget(self.field_label)

        # Create a field combobox
        self.field_combobox = QComboBox()
        self.layout.addWidget(self.field_combobox)

        # Connect the signal to update field combobox when layer selection changes
        self.layer_combobox.currentIndexChanged.connect(self.updateFieldComboBox)

        # Create a label for collector selection
        self.label_col = QLabel("Select collectors layer:")
        self.layout.addWidget(self.label_col)

        # Create a layer combobox
        self.layer_combobox_col = QgsMapLayerComboBox()
        self.layout.addWidget(self.layer_combobox_col)

        # Create a label for field selection
        self.field_label_col = QLabel("Select fullname column in the collectors layer:")
        self.layout.addWidget(self.field_label_col)

        # Create a field combobox
        self.field_combobox_col = QComboBox()
        self.layout.addWidget(self.field_combobox_col)

        self.setLayout(self.layout)

        # Connect the signal to update field combobox when layer selection changes
        self.layer_combobox_col.currentIndexChanged.connect(self.updateFieldComboBox_col)

        # Create a label for collector selection
        self.label_sub = QLabel("Select observation_subject layer:")
        self.layout.addWidget(self.label_sub)

        # Create a layer combobox
        self.layer_combobox_sub = QgsMapLayerComboBox()
        self.layout.addWidget(self.layer_combobox_sub)

        # Create a label for field selection
        self.field_label_sub = QLabel("Select name column in the observation_subject layer:")
        self.layout.addWidget(self.field_label_sub)

        # Create a field combobox
        self.field_combobox_sub = QComboBox()
        self.layout.addWidget(self.field_combobox_sub)

        # Create a button to confirm the selection
        self.button_ok = QPushButton("OK")
        self.button_ok.clicked.connect(self.accept)
        self.layout.addWidget(self.button_ok)

        self.setLayout(self.layout)

        # Connect the signal to update field combobox when layer selection changes
        self.layer_combobox_sub.currentIndexChanged.connect(self.updateFieldComboBox_sub)

    #Gives the selected binomial nomenclature item
    def selectedLayer(self):
        return self.layer_combobox.currentLayer()
    
    #Gives the selected binomial nomenclature item's field
    def selectedField(self):
        return self.field_combobox.currentText()
    
    def updateFieldComboBox(self):
        # Clear the field combobox
        self.field_combobox.clear()

        # Get the selected layer
        selected_layer = self.selectedLayer()
        if not selected_layer:
            return
        
        # Get the field names from the selected layer
        field_names = [field.name() for field in selected_layer.fields()]
        self.field_combobox.addItems(field_names)

    #Gives the selected binomial nomenclature item
    def selectedLayer_col(self):
        return self.layer_combobox_col.currentLayer()
    
    #Gives the selected binomial nomenclature item's field
    def selectedField_col(self):
        return self.field_combobox_col.currentText()
    
    def updateFieldComboBox_col(self):
        # Clear the field combobox
        self.field_combobox_col.clear()

        # Get the selected layer
        selected_layer_col = self.selectedLayer_col()
        if not selected_layer_col:
            return
        
        # Get the field names from the selected layer
        field_names_col = [field.name() for field in selected_layer_col.fields()]
        self.field_combobox_col.addItems(field_names_col)

    #Gives the selected binomial nomenclature item
    def selectedLayer_sub(self):
        return self.layer_combobox_sub.currentLayer()
    
    #Gives the selected binomial nomenclature item's field
    def selectedField_sub(self):
        return self.field_combobox_sub.currentText()
    
    def updateFieldComboBox_sub(self):
        # Clear the field combobox
        self.field_combobox_sub.clear()

        # Get the selected layer
        selected_layer_sub = self.selectedLayer_sub()
        if not selected_layer_sub:
            return
        
        # Get the field names from the selected layer
        field_names_sub= [field.name() for field in selected_layer_sub.fields()]
        self.field_combobox_sub.addItems(field_names_sub)

#Modify an already existing layer
class LayerSelectionDialog_modify(QDialog):
    def __init__(self, parent=None):
        super(LayerSelectionDialog_modify, self).__init__(parent)
        self.setWindowTitle("Select the prompted geopackages:")
        self.layout = QVBoxLayout()

        # Create a label for layer selection
        self.label_mod = QLabel("Select the geopackage to modify:")
        self.layout.addWidget(self.label_mod)

        # Create a layer combobox
        self.layer_combobox_mod = QgsMapLayerComboBox()
        self.layout.addWidget(self.layer_combobox_mod)

        # Connect the signal to update field combobox when layer selection changes
        self.layer_combobox_mod.currentIndexChanged.connect(self.updateLayerComboBox)

        # Create a label for layer selection
        self.label = QLabel("Select identification's layer:")
        self.layout.addWidget(self.label)

        # Create a layer combobox
        self.layer_combobox = QgsMapLayerComboBox()
        self.layout.addWidget(self.layer_combobox)

        # Create a label for field selection
        self.field_label = QLabel("Select identification's name column in the identification's layer:")
        self.layout.addWidget(self.field_label)

        # Create a field combobox
        self.field_combobox = QComboBox()
        self.layout.addWidget(self.field_combobox)

        # Connect the signal to update field combobox when layer selection changes
        self.layer_combobox.currentIndexChanged.connect(self.updateFieldComboBox)

        # Create a label for collector selection
        self.label_col = QLabel("Select collectors layer:")
        self.layout.addWidget(self.label_col)

        # Create a layer combobox
        self.layer_combobox_col = QgsMapLayerComboBox()
        self.layout.addWidget(self.layer_combobox_col)

        # Create a label for field selection
        self.field_label_col = QLabel("Select fullname column in the collectors layer:")
        self.layout.addWidget(self.field_label_col)

        # Create a field combobox
        self.field_combobox_col = QComboBox()
        self.layout.addWidget(self.field_combobox_col)

        self.setLayout(self.layout)

        # Connect the signal to update field combobox when layer selection changes
        self.layer_combobox_col.currentIndexChanged.connect(self.updateFieldComboBox_col)

        # Create a label for collector selection
        self.label_sub = QLabel("Select observation_subject layer:")
        self.layout.addWidget(self.label_sub)

        # Create a layer combobox
        self.layer_combobox_sub = QgsMapLayerComboBox()
        self.layout.addWidget(self.layer_combobox_sub)

        # Create a label for field selection
        self.field_label_sub = QLabel("Select name column in the observation_subject layer:")
        self.layout.addWidget(self.field_label_sub)

        # Create a field combobox
        self.field_combobox_sub = QComboBox()
        self.layout.addWidget(self.field_combobox_sub)

        # Create a button to confirm the selection
        self.button_ok = QPushButton("OK")
        self.button_ok.clicked.connect(self.accept)
        self.layout.addWidget(self.button_ok)

        self.setLayout(self.layout)

        # Connect the signal to update field combobox when layer selection changes
        self.layer_combobox_sub.currentIndexChanged.connect(self.updateFieldComboBox_sub)

        

    #Gives the selected binomial nomenclature item
    def selectedLayer_mod(self):
        return self.layer_combobox_mod.currentLayer()
    
    def updateLayerComboBox(self):
        # Get the selected layer
        selected_layer = self.selectedLayer_mod()
        if not selected_layer:
            return
        
    #Gives the selected binomial nomenclature item
    def selectedLayer(self):
        return self.layer_combobox.currentLayer()
    
    #Gives the selected binomial nomenclature item's field
    def selectedField(self):
        return self.field_combobox.currentText()
    
    def updateFieldComboBox(self):
        # Clear the field combobox
        self.field_combobox.clear()

        # Get the selected layer
        selected_layer = self.selectedLayer()
        if not selected_layer:
            return
        
        # Get the field names from the selected layer
        field_names = [field.name() for field in selected_layer.fields()]
        self.field_combobox.addItems(field_names)
        
    #Gives the selected binomial nomenclature item
    def selectedLayer_col(self):
        return self.layer_combobox_col.currentLayer()
    
    #Gives the selected binomial nomenclature item's field
    def selectedField_col(self):
        return self.field_combobox_col.currentText()
    
    def updateFieldComboBox_col(self):
        # Clear the field combobox
        self.field_combobox_col.clear()

        # Get the selected layer
        selected_layer_col = self.selectedLayer_col()
        if not selected_layer_col:
            return
        
        # Get the field names from the selected layer
        field_names_col = [field.name() for field in selected_layer_col.fields()]
        self.field_combobox_col.addItems(field_names_col)

    #Gives the selected binomial nomenclature item
    def selectedLayer_sub(self):
        return self.layer_combobox_sub.currentLayer()
    
    #Gives the selected binomial nomenclature item's field
    def selectedField_sub(self):
        return self.field_combobox_sub.currentText()
    
    def updateFieldComboBox_sub(self):
        # Clear the field combobox
        self.field_combobox_sub.clear()

        # Get the selected layer
        selected_layer_sub = self.selectedLayer_sub()
        if not selected_layer_sub:
            return
        
        # Get the field names from the selected layer
        field_names_sub= [field.name() for field in selected_layer_sub.fields()]
        self.field_combobox_sub.addItems(field_names_sub)

        
#Creates the selection dialog for observation only field
class LayerSelectionDialog_create_obs(QDialog):
    def __init__(self, gpkg_name, parent=None):
        super(LayerSelectionDialog_create_obs, self).__init__(parent)
        self.setWindowTitle("Select identification's layer")
        self.layout = QVBoxLayout()

        # Ask the project name
        # self.project_label = QLabel(f"Project name: {project_name}")
        # self.layout.addWidget(self.project_label)

        # Create a label for GPKG name
        self.gpkg_label = QLabel(f"GPKG name: {gpkg_name}")
        self.layout.addWidget(self.gpkg_label)

        # Create a label for layer selection
        self.label = QLabel("Select identification's layer:")
        self.layout.addWidget(self.label)

        # Create a layer combobox
        self.layer_combobox = QgsMapLayerComboBox()
        self.layout.addWidget(self.layer_combobox)

        # Create a label for field selection
        self.field_label = QLabel("Select identification's name column in the identification's layer:")
        self.layout.addWidget(self.field_label)

        # Create a field combobox
        self.field_combobox = QComboBox()
        self.layout.addWidget(self.field_combobox)

        # Connect the signal to update field combobox when layer selection changes
        self.layer_combobox.currentIndexChanged.connect(self.updateFieldComboBox)

        # Create a label for collector selection
        self.label_col = QLabel("Select collectors layer:")
        self.layout.addWidget(self.label_col)

        # Create a layer combobox
        self.layer_combobox_col = QgsMapLayerComboBox()
        self.layout.addWidget(self.layer_combobox_col)

        # Create a label for field selection
        self.field_label_col = QLabel("Select fullname column in the collectors layer:")
        self.layout.addWidget(self.field_label_col)

        # Create a field combobox
        self.field_combobox_col = QComboBox()
        self.layout.addWidget(self.field_combobox_col)

        # Create a button to confirm the selection
        self.button_ok = QPushButton("OK")
        self.button_ok.clicked.connect(self.accept)
        self.layout.addWidget(self.button_ok)

        self.setLayout(self.layout)

        # Connect the signal to update field combobox when layer selection changes
        self.layer_combobox_col.currentIndexChanged.connect(self.updateFieldComboBox_col)

    #Gives the selected binomial nomenclature item
    def selectedLayer(self):
        return self.layer_combobox.currentLayer()
    
    #Gives the selected binomial nomenclature item's field
    def selectedField(self):
        return self.field_combobox.currentText()
    
    def updateFieldComboBox(self):
        # Clear the field combobox
        self.field_combobox.clear()

        # Get the selected layer
        selected_layer = self.selectedLayer()
        if not selected_layer:
            return
        
        # Get the field names from the selected layer
        field_names = [field.name() for field in selected_layer.fields()]
        self.field_combobox.addItems(field_names)

    #Gives the selected binomial nomenclature item
    def selectedLayer_col(self):
        return self.layer_combobox_col.currentLayer()
    
    #Gives the selected binomial nomenclature item's field
    def selectedField_col(self):
        return self.field_combobox_col.currentText()
    
    def updateFieldComboBox_col(self):
        # Clear the field combobox
        self.field_combobox_col.clear()

        # Get the selected layer
        selected_layer_col = self.selectedLayer_col()
        if not selected_layer_col:
            return
        
        # Get the field names from the selected layer
        field_names_col = [field_col.name() for field_col in selected_layer_col.fields()]
        self.field_combobox_col.addItems(field_names_col)

class GpkgCreator:
    def __init__(self, iface):
        self.iface = iface

    def initGui(self):
        # create action that will start plugin configuration
        self.create_action = QAction(
                          "Create an EMI geopackage",
                          self.iface.mainWindow())
        self.create_action.triggered.connect(self.run_create)

        self.modify_action = QAction(
                            "Modify an existing EMI geopackage",
                            self.iface.mainWindow())
        self.modify_action.triggered.connect(self.run_modify)

        self.create_obs_action = QAction(
                            "Create an observation EMI geopackage",
                            self.iface.mainWindow())
        self.create_obs_action.triggered.connect(self.run_create_obs)

        # add toolbar button
        self.iface.addPluginToVectorMenu("&EMI", self.create_action)
        self.iface.addPluginToVectorMenu("&EMI", self.modify_action)
        self.iface.addPluginToVectorMenu("&EMI", self.create_obs_action)

    def unload(self):
        # remove the toolbar button
        self.iface.removePluginVectorMenu("&EMI", self.create_action)
        self.iface.removePluginVectorMenu("&EMI", self.modify_action)
        self.iface.removePluginVectorMenu("&EMI", self.create_obs_action)

    def run_create(self):
        #Extract the project names from directus
        collection_url = "https://emi-collection.unifr.ch/directus/items/Projects"
        column = 'project_id'
        params = {'sort[]': f'{column}'}
        session = requests.Session()
        response = session.get(collection_url, params=params)
        data = response.json()['data']
        project_names = [item[column] for item in data]
        combo_box = QComboBox()
        combo_box.addItems(project_names)
        # Ask user to select a project name from the combo box
        combo_box_prompt = QMessageBox()
        combo_box_prompt.setWindowTitle("Select Project")
        combo_box_prompt.setText("Please select a project:")
        combo_box_prompt.addButton(QMessageBox.Ok)
        combo_box_prompt.layout().addWidget(combo_box)
        combo_box_prompt.exec_()
        # Get the selected project name
        if combo_box_prompt.clickedButton():
            project_name = combo_box.currentText()

        # Ask user to enter the name of the GPKG
        gpkg_name, ok = QInputDialog.getText(self.iface.mainWindow(), "GPKG name", "Enter the name of the GPKG:")
        if not ok or gpkg_name == "":
            return

        # Create the dialog to select a layer
        dialog = LayerSelectionDialog_create(project_name, gpkg_name)
        if dialog.exec_() != QDialog.Accepted:
            return

        # Get the selected layer from the dialog
        selected_layer = dialog.selectedLayer()
        selected_field = dialog.selectedField()
        selected_layer_col = dialog.selectedLayer_col()
        selected_field_col = dialog.selectedField_col()
        selected_layer_sub = dialog.selectedLayer_sub()
        selected_field_sub = dialog.selectedField_sub()
        if not selected_layer or not selected_field or not selected_layer_col or not selected_field_col or not selected_layer_sub or not selected_field_sub:
            return

        # Retrieve layer information
        plant_layer_id = selected_layer.id()
        collector_layer_id = selected_layer_col.id()
        subject_layer_id = selected_layer_sub.id()
        
        # Stores the project's folder
        project_folder = QgsProject.instance().readPath("./")
        # Creates the gpkg's path
        gpkg_file = os.path.join(project_folder, gpkg_name + '.gpkg')
        gpkg_file = gpkg_file.replace("\\", "/")
        # Define the type gpkg for the layer
        driver = ogr.GetDriverByName('GPKG')
        # Creates the gpkg
        ds = driver.CreateDataSource(gpkg_file)
        # Sets the layer name (same as gpkg's name)
        layer_name = gpkg_name
        #sets the layer's srs
        project_crs = QgsProject.instance().crs()
        crs_wkt = project_crs.toWkt()
        srs = ogr.osr.SpatialReference()
        srs.ImportFromWkt(crs_wkt)
        #Sets the layer geometry type (here point)
        geom_type = ogr.wkbPoint
        #Creates the layer
        layer = ds.CreateLayer(layer_name, srs, geom_type)

        #Creation of the sample metadata fields
        field_def1 = ogr.FieldDefn("collector_fullname", ogr.OFTString)
        field_def1.SetWidth(200)
        layer.CreateField(field_def1)

        field_def2 = ogr.FieldDefn("observation_subject", ogr.OFTString)
        field_def2.SetWidth(200)
        layer.CreateField(field_def2)

        field_def3 = ogr.FieldDefn("inat_upload", ogr.OFTString)
        field_def3.SetWidth(200)
        layer.CreateField(field_def3)

        field_def4 = ogr.FieldDefn("is_wild", ogr.OFTString)
        field_def4.SetWidth(200)
        layer.CreateField(field_def4)

        field_def5 = ogr.FieldDefn("taxon_name", ogr.OFTString)
        field_def5.SetWidth(200)
        layer.CreateField(field_def5)

        field_def6 = ogr.FieldDefn("no_name_on_list", ogr.OFTString)
        field_def6.SetWidth(200)
        layer.CreateField(field_def6)

        field_def7 = ogr.FieldDefn("name_proposition", ogr.OFTString)
        field_def7.SetWidth(200)
        layer.CreateField(field_def7)

        field_def8 = ogr.FieldDefn("sample_id", ogr.OFTString)
        field_def8.SetWidth(15)
        layer.CreateField(field_def8)

        field_def9 = ogr.FieldDefn("picture_panel", ogr.OFTString)
        field_def9.SetWidth(200)
        layer.CreateField(field_def9)

        field_def10 = ogr.FieldDefn("picture_general", ogr.OFTString)
        field_def10.SetWidth(200)
        layer.CreateField(field_def10)

        field_def11 = ogr.FieldDefn("picture_detail", ogr.OFTString)
        field_def11.SetWidth(200)
        layer.CreateField(field_def11)

        field_def12 = ogr.FieldDefn("picture_cut", ogr.OFTString)
        field_def12.SetWidth(200)
        layer.CreateField(field_def12)

        field_def13 = ogr.FieldDefn("picture_panel_label", ogr.OFTString)
        field_def13.SetWidth(200)
        layer.CreateField(field_def13)
        
        field_def14 = ogr.FieldDefn("picture_free", ogr.OFTString)
        field_def14.SetWidth(200)
        layer.CreateField(field_def14)

        field_def15 = ogr.FieldDefn("x_coord", ogr.OFTReal)
        field_def15.SetPrecision(0)
        layer.CreateField(field_def15)

        field_def16 = ogr.FieldDefn("y_coord", ogr.OFTReal)
        field_def16.SetPrecision(0)
        layer.CreateField(field_def16)

        #Creation of the individual metadata fields
        field_def17 = ogr.FieldDefn("ipen", ogr.OFTString)
        field_def17.SetWidth(200)
        layer.CreateField(field_def17)

        field_def18 = ogr.FieldDefn("herbivory_(percent)", ogr.OFTInteger)
        layer.CreateField(field_def18)

        field_def19 = ogr.FieldDefn("comment_eco", ogr.OFTString)
        field_def19.SetWidth(1000)
        layer.CreateField(field_def19)

        #Creation of the environmental metadata fields
        field_def20 = ogr.FieldDefn("soil_type", ogr.OFTString)
        field_def20.SetWidth(200)
        layer.CreateField(field_def20)

        field_def21 = ogr.FieldDefn("weather", ogr.OFTString)
        field_def21.SetWidth(200)
        layer.CreateField(field_def21)

        field_def22 = ogr.FieldDefn("temperature_(°C)", ogr.OFTReal)
        field_def22.SetPrecision(0)
        layer.CreateField(field_def22)

        field_def23 = ogr.FieldDefn("comment_env", ogr.OFTString)
        field_def23.SetWidth(1000)
        layer.CreateField(field_def23)

        field_def24 = ogr.FieldDefn("date", ogr.OFTString)
        field_def24.SetWidth(200)
        layer.CreateField(field_def24)

        field_def25 = ogr.FieldDefn("collector_orcid", ogr.OFTString)
        field_def25.SetWidth(1000)
        layer.CreateField(field_def25)

        field_def26 = ogr.FieldDefn("collector_inat", ogr.OFTString)
        field_def26.SetWidth(1000)
        layer.CreateField(field_def26)

        #Close the GeoPackage file
        ds = None

        # Load the GeoPackage file as a vector layer in QGIS
        imp_layer = QgsVectorLayer(gpkg_file + "|layername=" + layer_name, layer_name, "ogr")
        QgsProject.instance().addMapLayer(imp_layer)
       
        #Create association relation between binomial nomenclature layer and taxon_name field
        imp_layer_id = imp_layer.id()
        imp_layer_field = "taxon_name"
        relation = QgsRelation()
        relation.setReferencingLayer(imp_layer_id)
        relation.setReferencedLayer(plant_layer_id)
        relation.addFieldPair(imp_layer_field, selected_field)
        relation.setId(layer_name + "_taxon")
        relation.setName(layer_name + "_taxon")
        QgsProject.instance().relationManager().addRelation(relation)

        #Create association relation between collector list and colector_orcid field
        imp_layer_field_col = "collector_fullname"
        relation2 = QgsRelation()
        relation2.setReferencingLayer(imp_layer_id)
        relation2.setReferencedLayer(collector_layer_id)
        relation2.addFieldPair(imp_layer_field_col, selected_field_col)
        relation2.setId(layer_name + "_collector")
        relation2.setName(layer_name + "_collector")
        QgsProject.instance().relationManager().addRelation(relation2)

        #Create association relation between observation subject list and observation_subject field
        imp_layer_field_sub = "observation_subject"
        relation3 = QgsRelation()
        relation3.setReferencingLayer(imp_layer_id)
        relation3.setReferencedLayer(subject_layer_id)
        relation3.addFieldPair(imp_layer_field_sub, selected_field_sub)
        relation3.setId(layer_name + "_subject")
        relation3.setName(layer_name + "_subject")
        QgsProject.instance().relationManager().addRelation(relation3)

        #Define the layer to change field properties
        layer = QgsProject.instance().mapLayer(imp_layer_id)
        
        # Define taxon list layer display expression
        layer_taxon = QgsProject.instance().mapLayer(plant_layer_id)
        layer_taxon.setDisplayExpression(selected_field)

        # Define collector list layer display expression
        layer_col = QgsProject.instance().mapLayer(collector_layer_id)
        layer_col.setDisplayExpression(selected_field_col)

        # Define observation subject list layer display expression
        layer_subject = QgsProject.instance().mapLayer(subject_layer_id)
        layer_subject.setDisplayExpression(selected_field_sub)

        #Define different widget types
        attach = QgsEditorWidgetSetup('ExternalResource', {}) #Defines attachment widget type
        checkbox = QgsEditorWidgetSetup('CheckBox', {'CheckedState': "1", 'UncheckedState': "0"})
        range = QgsEditorWidgetSetup('Range', {
            'AllowNull': True,
            'Max': 100,
            'Min': 0,
            'Step': 1,
            'Style': 'Slider'
        }
        )
        form_soil = QgsEditorWidgetSetup('ValueMap', 
                                         {'map': {
                                             "sandy soil": "sandy soil",
                                             "loamy soil": "loamy soil",
                                             "clay soil": "clay soil",
                                             "humus soil": "humus soil"
                                             }
                                             }
                                             )
        
        form_weather = QgsEditorWidgetSetup('ValueMap',
                                         {'map': {
                                             "sunny": "sunny",
                                             "cloudy": "cloudy",
                                             "rainy": "rainy",
                                             "snowy": "snowy",
                                             "foggy": "foggy"
                                             }
                                             }
                                             )

        #collector_fullname field properties
        layer.setFieldConstraint(1, QgsFieldConstraints.ConstraintNotNull)
        

        #observation_subject field properties
        layer.setFieldConstraint(2, QgsFieldConstraints.ConstraintNotNull)
        layer.setDisplayExpression(selected_field_sub)

        #inat_upload field properties
        layer.setEditorWidgetSetup(3, checkbox)
        layer.setDefaultValueDefinition(3, QgsDefaultValue('1'))

        #is_wild field properties
        layer.setEditorWidgetSetup(4, checkbox)
        layer.setDefaultValueDefinition(4, QgsDefaultValue('0'))

        #taxon_name field properties
        expr_constr_taxon = 'CASE WHEN "no_name_on_list" = 1 THEN "taxon_name" IS NULL ELSE "taxon_name" IS NOT NULL END'
        layer.setConstraintExpression(5, expr_constr_taxon)
        layer.setDisplayExpression(selected_field)

        #no_name_on_list field properties
        layer.setEditorWidgetSetup(6, checkbox)
        layer.setDefaultValueDefinition(6, QgsDefaultValue('0'))

        #name_proposition field properties
        expr_constr_name = 'CASE WHEN "no_name_on_list" = 0 THEN "name_proposition" IS NULL ELSE "name_proposition" IS NOT NULL END'
        layer.setConstraintExpression(7, expr_constr_name)

        #sample_id field properties
        expr_constr = f'regexp_match(to_string("sample_id"), \'{project_name}_[0-9]{{6}}\')'
        layer.setFieldConstraint(8, QgsFieldConstraints.ConstraintNotNull)
        layer.setFieldConstraint(8, QgsFieldConstraints.ConstraintUnique)
        layer.setConstraintExpression(8, expr_constr)

        #picture_panel field properties
        layer.setFieldConstraint(9, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(9, attach)

        #picture_general field properties
        layer.setFieldConstraint(10, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(10, attach)

        #picture_detail field properties
        layer.setFieldConstraint(11, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(11, attach)

        #picture_cut field properties
        layer.setFieldConstraint(12, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(12, attach)

        #picture_panel_label field properties
        layer.setFieldConstraint(13, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(13, attach)

        #picture_free field properties
        layer.setEditorWidgetSetup(14, attach)

        #x_coord field properties
        coord_x = QgsDefaultValue("$x")
        layer.setDefaultValueDefinition(15, coord_x)

        #y_coord field properties
        coord_y = QgsDefaultValue("$y")
        layer.setDefaultValueDefinition(16, coord_y)

        #ipen field properties
        
        #herbivory_(percent) field properties
        layer.setEditorWidgetSetup(18, range)

        #comment_eco field properties

        #soil_type field properties
        layer.setEditorWidgetSetup(20, form_soil)

        #weather field properties
        layer.setEditorWidgetSetup(21, form_weather)

        #temperature_(°C) field properties

        #comment_env field properties

        # date field properties
        date = QgsDefaultValue("format_date(now(), 'yyyyMMddHHmmss')")
        layer.setDefaultValueDefinition(24, date)

        # collector_orcid field properties
        layer.setDefaultValueDefinition(25, QgsDefaultValue('attribute(get_feature(\'collector_list\', \'fullname\', "collector_fullname"), \'ORCID\')', True))
        layer.setFieldConstraint(25, QgsFieldConstraints.ConstraintNotNull)

        # collector_inat field properties
        layer.setDefaultValueDefinition(26, QgsDefaultValue('attribute(get_feature(\'collector_list\', \'fullname\', "collector_fullname"), \'iNat_username\')', True))
        layer.setFieldConstraint(26, QgsFieldConstraints.ConstraintNotNull)


        #Change picture naming for the five concerned fields for QField
        custom_attachment = "QFieldSync/attachment_naming"
        rename_1 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_01.jpg'"
        rename_2 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_02.jpg'"
        rename_3 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_03.jpg'"
        rename_4 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_04.jpg'"
        rename_5 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_05.jpg'"
        rename_6 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_06.jpg'"
        custom_attachment_values = {
            "picture_panel": rename_1,
            "picture_general": rename_2,
            "picture_detail": rename_3,
            "picture_cut": rename_4,
            "picture_panel_label": rename_5,
            "picture_free": rename_6
        }
        custom_attachment_json = json.dumps(custom_attachment_values)
        layer.setCustomProperty(custom_attachment, custom_attachment_json)

        # Setup QFieldCloud layer action
        custom_layer_action = "QFieldSync/cloud_action"
        param = "offline"
        layer.setCustomProperty(custom_layer_action, param)

        # Change layout to drag and drop
        config = layer.editFormConfig()
        config.setLayout(QgsEditFormConfig.TabLayout)
        layer.setEditFormConfig(config)
        root = config.invisibleRootContainer()
        root.clear()

        # Create sample metadata tab
        sample_metadata = QgsAttributeEditorContainer("sample metadata", root)

        # Define the fields
        collector_fullname = QgsAttributeEditorField("collector_fullname", 1, sample_metadata)
        observation_subject = QgsAttributeEditorField("observation_subject", 2, sample_metadata)
        inat_upload = QgsAttributeEditorField("inat_upload", 3, sample_metadata)
        is_wild = QgsAttributeEditorField("is_wild", 4, sample_metadata)
        taxon_name = QgsAttributeEditorField("taxon_name", 5, sample_metadata)
        no_name_on_list = QgsAttributeEditorField("no_name_on_list", 6, sample_metadata)
        if_no_name_list = QgsAttributeEditorContainer("if_no_name_list", sample_metadata) #create the if_no_name_list tab
        if_no_expression = QgsOptionalExpression(QgsExpression("no_name_on_list = 1")) #add the visibility expression
        if_no_name_list.setVisibilityExpression(if_no_expression)
        name_proposition = QgsAttributeEditorField("name_proposition", 7, if_no_name_list)
        sample_id = QgsAttributeEditorField("sample_id", 8, sample_metadata)
        pictures = QgsAttributeEditorContainer("pictures", sample_metadata)
        pictures_expression = QgsOptionalExpression(QgsExpression('regexp_match(to_string("sample_id"),' + f"'{project_name}_[0-9]{{6}}') AND " + '(if("no_name_on_list" = 0, "taxon_name" IS NOT NULL, TRUE)) AND (if("no_name_on_list" = 1, "name_proposition" IS NOT NULL, TRUE))'))
        pictures.setVisibilityExpression(pictures_expression)
        picture_general = QgsAttributeEditorField("picture_general", 9, sample_metadata)
        picture_panel = QgsAttributeEditorField("picture_panel", 10, sample_metadata)
        picture_panel_label = QgsAttributeEditorField("picture_panel_label", 11, sample_metadata)
        picture_detail = QgsAttributeEditorField("picture_detail", 12, sample_metadata)
        picture_cut = QgsAttributeEditorField("picture_cut", 13, sample_metadata)
        picture_free = QgsAttributeEditorField("picture_free", 14, sample_metadata)
        
        #Construct the sample metadata tab structure
        sample_metadata.addChildElement(collector_fullname)
        sample_metadata.addChildElement(observation_subject)
        sample_metadata.addChildElement(inat_upload)
        sample_metadata.addChildElement(is_wild)
        sample_metadata.addChildElement(taxon_name)
        sample_metadata.addChildElement(no_name_on_list)
        if_no_name_list.addChildElement(name_proposition)
        sample_metadata.addChildElement(if_no_name_list)
        sample_metadata.addChildElement(sample_id)
        pictures.addChildElement(picture_general)
        pictures.addChildElement(picture_panel)
        pictures.addChildElement(picture_panel_label)
        pictures.addChildElement(picture_detail)
        pictures.addChildElement(picture_cut)
        pictures.addChildElement(picture_free)
        sample_metadata.addChildElement(pictures)
        root.addChildElement(sample_metadata)

        #Create individual metadata tab
        individual_metadata = QgsAttributeEditorContainer("individual_metadata", root)
        ipen = QgsAttributeEditorField("ipen", 1, individual_metadata)
        herbivory = QgsAttributeEditorField("herbivory_(percent)", 2, individual_metadata)
        comment_eco = QgsAttributeEditorField("comment_eco", 3, individual_metadata)
        individual_metadata.addChildElement(ipen)
        individual_metadata.addChildElement(herbivory)
        individual_metadata.addChildElement(comment_eco)
        root.addChildElement(individual_metadata)

        #Create environmental metadata tab
        environmental_metadata = QgsAttributeEditorContainer("environmental metadata", root)
        soil = QgsAttributeEditorField("soil_type", 1, environmental_metadata)
        weather = QgsAttributeEditorField("weather", 2, environmental_metadata)
        temperature = QgsAttributeEditorField("temperature_(°C)", 3, environmental_metadata)
        comment_env = QgsAttributeEditorField("comment_env", 4, environmental_metadata)
        environmental_metadata.addChildElement(soil)
        environmental_metadata.addChildElement(weather)
        environmental_metadata.addChildElement(temperature)
        environmental_metadata.addChildElement(comment_env)
        root.addChildElement(environmental_metadata)
        layer.setEditFormConfig(config)

        #Display label for the points
        label = QgsPalLayerSettings()
        label.fieldName = "sample_id"
        label.textcolor = QColor(0, 0, 0)
        label.placement = QgsPalLayerSettings.OverPoint
        layer.setLabelsEnabled(True)
        layer.setLabeling(QgsVectorLayerSimpleLabeling(label))

        #Show feature count
        root = QgsProject.instance().layerTreeRoot()
        layer_node = root.findLayer(imp_layer.id())
        layer_node.setCustomProperty("showFeatureCount", 1)

    def run_modify(self):
        #Extract the project names from directus
        collection_url = "https://emi-collection.unifr.ch/directus/items/Projects"
        column = 'project_id'
        params = {'sort[]': f'{column}'}
        session = requests.Session()
        response = session.get(collection_url, params=params)
        data = response.json()['data']
        project_names = [item[column] for item in data]
        combo_box = QComboBox()
        combo_box.addItems(project_names)
        # Ask user to select a project name from the combo box
        combo_box_prompt = QMessageBox()
        combo_box_prompt.setWindowTitle("Select Project")
        combo_box_prompt.setText("Please select a project (advised to choose the same as the one used to create the layer):")
        combo_box_prompt.addButton(QMessageBox.Ok)
        combo_box_prompt.layout().addWidget(combo_box)
        combo_box_prompt.exec_()
        # Get the selected project name
        if combo_box_prompt.clickedButton():
            project_name = combo_box.currentText()

        # Create the dialog to select a layer
        dialog = LayerSelectionDialog_modify()
        if dialog.exec_() != QDialog.Accepted:
            return

        # Get the selected layer from the dialog
        selected_layer_mod = dialog.selectedLayer_mod()
        if not selected_layer_mod:
            return
        
        # Get the selected layer from the dialog
        selected_layer = dialog.selectedLayer()
        selected_field = dialog.selectedField()
        selected_layer_col = dialog.selectedLayer_col()
        selected_field_col = dialog.selectedField_col()
        selected_layer_sub = dialog.selectedLayer_sub()
        selected_field_sub = dialog.selectedField_sub()
        if not selected_layer or not selected_field or not selected_layer_col or not selected_field_col or not selected_layer_sub or not selected_field_sub:
            return
        
        # Retrieve layers information
        plant_layer_id = selected_layer.id()
        collector_layer_id = selected_layer_col.id()
        subject_layer_id = selected_layer_sub.id()
        
        # Load the layer to modify
        layer = selected_layer_mod
        layer_name = selected_layer_mod.name()
        fields = layer.fields()

        #Retrieve project informations
        project_folder = QgsProject.instance().readPath("./")
        # Creates the gpkg's path
        gpkg_file = os.path.join(project_folder, layer_name + '.gpkg')
        gpkg_file = gpkg_file.replace("\\", "/")

        #Creation of the sample metadata fields
        if fields.indexOf("collector_fullname") == -1:
            field_def1 = QgsField("collector_fullname", QVariant.String)
            layer.dataProvider().addAttributes([field_def1])

        if fields.indexOf("observation_subject") == -1:
            field_def2 = QgsField("observation_subject", QVariant.String)
            layer.dataProvider().addAttributes([field_def2])

        if fields.indexOf("inat_upload") == -1:
            field_def3 = QgsField("inat_upload", QVariant.String)
            layer.dataProvider().addAttributes([field_def3])

        if fields.indexOf("is_wild") == -1:
            field_def4 = QgsField("is_wild", QVariant.String)
            layer.dataProvider().addAttributes([field_def4])
        
        if fields.indexOf("taxon_name") == -1:
            field_def5 = QgsField("taxon_name", QVariant.String)
            layer.dataProvider().addAttributes([field_def5])

        if fields.indexOf("no_name_on_list") == -1:
            field_def6 = QgsField("no_name_on_list", QVariant.String)
            layer.dataProvider().addAttributes([field_def6])

        if fields.indexOf("name_proposition") == -1:
            field_def7 = QgsField("name_proposition", QVariant.String)
            layer.dataProvider().addAttributes([field_def7])

        if fields.indexOf("sample_id") == -1:
            field_def8 = QgsField("sample_id", QVariant.String)
            layer.dataProvider().addAttributes([field_def8])

        if fields.indexOf("picture_panel") == -1:
            field_def9 = QgsField("picture_panel", QVariant.String)
            layer.dataProvider().addAttributes([field_def9])
            
        if fields.indexOf("picture_general") == -1:
            field_def10 = QgsField("picture_general", QVariant.String)
            layer.dataProvider().addAttributes([field_def10])

        if fields.indexOf("picture_detail") == -1:
            field_def11 = QgsField("picture_detail", QVariant.String)
            layer.dataProvider().addAttributes([field_def11])

        if fields.indexOf("picture_cut") == -1:
            field_def12 = QgsField("picture_cut", QVariant.String)
            layer.dataProvider().addAttributes([field_def12])

        if fields.indexOf("picture_panel_label") == -1:
            field_def13 = QgsField("picture_panel_label", QVariant.String)
            layer.dataProvider().addAttributes([field_def13])

        if fields.indexOf("picture_free") == -1:
            field_def14 = QgsField("picture_free", QVariant.String)
            layer.dataProvider().addAttributes([field_def14])
        
        if fields.indexOf("x_coord") == -1:
            field_def15 = QgsField("x_coord", QVariant.Double)
            layer.dataProvider().addAttributes([field_def15])

        if fields.indexOf("y_coord") == -1:
            field_def16 = QgsField("y_coord", QVariant.Double)
            layer.dataProvider().addAttributes([field_def16])

        #Creation of the individual metadata fields
        if fields.indexOf("ipen") == -1:
            field_def17 = QgsField("ipen", QVariant.String)
            layer.dataProvider().addAttributes([field_def17])

        if fields.indexOf("herbivory_(percent)") == -1:
            field_def18 = QgsField("herbivory_(percent)", QVariant.Int)
            layer.dataProvider().addAttributes([field_def18])

        if fields.indexOf("comment_eco") == -1:
            field_def19 = QgsField("comment_eco", QVariant.String)
            layer.dataProvider().addAttributes([field_def19])

        #Creation of the environmental metadata fields
        if fields.indexOf("soil_type") == -1:
            field_def20 = QgsField("soil_type", QVariant.String)
            layer.dataProvider().addAttributes([field_def20])

        if fields.indexOf("weather") == -1:
            field_def21 = QgsField("weather", QVariant.String)
            layer.dataProvider().addAttributes([field_def21])

        if fields.indexOf("temperature_(°C)") == -1:
            field_def22 = QgsField("temperature_(°C)", QVariant.Double)
            layer.dataProvider().addAttributes([field_def22])

        if fields.indexOf("comment_env") == -1:
            field_def23 = QgsField("comment_env", QVariant.String)
            layer.dataProvider().addAttributes([field_def23])

        if fields.indexOf("date") == -1:
            field_def24 = QgsField("date", QVariant.String)
            layer.dataProvider().addAttributes([field_def24])

        if fields.indexOf("collector_orcid") == -1:
            field_def25 = QgsField("collector_orcid", QVariant.String)
            layer.dataProvider().addAttributes([field_def25])

        if fields.indexOf("collector_inat") == -1:
            field_def26 = QgsField("collector_inat", QVariant.String)
            layer.dataProvider().addAttributes([field_def26])

        layer.updateFields()
       
        #Create association relation between binomial nomenclature layer and taxon_name field
        imp_layer_id = layer.id()
        imp_layer_field = "taxon_name"
        relation = QgsRelation()
        relation.setReferencingLayer(imp_layer_id)
        relation.setReferencedLayer(plant_layer_id)
        relation.addFieldPair(imp_layer_field, selected_field)
        relation.setId(layer_name + "_taxon")
        relation.setName(layer_name + "_taxon")
        QgsProject.instance().relationManager().addRelation(relation)

        #Create association relation between collector list and colector_orcid field
        imp_layer_field_col = "collector_fullname"
        relation2 = QgsRelation()
        relation2.setReferencingLayer(imp_layer_id)
        relation2.setReferencedLayer(collector_layer_id)
        relation2.addFieldPair(imp_layer_field_col, selected_field_col)
        relation2.setId(layer_name + "_collector")
        relation2.setName(layer_name + "_collector")
        QgsProject.instance().relationManager().addRelation(relation2)

        #Create association relation between observation subject list and observation_subject field
        imp_layer_field_sub = "observation_subject"
        relation3 = QgsRelation()
        relation3.setReferencingLayer(imp_layer_id)
        relation3.setReferencedLayer(subject_layer_id)
        relation3.addFieldPair(imp_layer_field_sub, selected_field_sub)
        relation3.setId(layer_name + "_subject")
        relation3.setName(layer_name + "_subject")
        QgsProject.instance().relationManager().addRelation(relation3)

        #Define the layer to change field properties
        layer = QgsProject.instance().mapLayer(imp_layer_id)
        
        # Define taxon list layer display expression
        layer_taxon = QgsProject.instance().mapLayer(plant_layer_id)
        layer_taxon.setDisplayExpression(selected_field)

        # Define collector list layer display expression
        layer_col = QgsProject.instance().mapLayer(collector_layer_id)
        layer_col.setDisplayExpression(selected_field_col)

        # Define observation subject list layer display expression
        layer_subject = QgsProject.instance().mapLayer(subject_layer_id)
        layer_subject.setDisplayExpression(selected_field_sub)

        #Define different widget types
        attach = QgsEditorWidgetSetup('ExternalResource', {}) #Defines attachment widget type
        checkbox = QgsEditorWidgetSetup('CheckBox', {'CheckedState': "1", 'UncheckedState': "0"})
        range = QgsEditorWidgetSetup('Range', {
            'AllowNull': True,
            'Max': 100,
            'Min': 0,
            'Step': 1,
            'Style': 'Slider'
        }
        )
        form_soil = QgsEditorWidgetSetup('ValueMap', 
                                         {'map': {
                                             "sandy soil": "sandy soil",
                                             "loamy soil": "loamy soil",
                                             "clay soil": "clay soil",
                                             "humus soil": "humus soil"
                                             }
                                             }
                                             )
        
        form_weather = QgsEditorWidgetSetup('ValueMap',
                                         {'map': {
                                             "sunny": "sunny",
                                             "cloudy": "cloudy",
                                             "rainy": "rainy",
                                             "snowy": "snowy",
                                             "foggy": "foggy"
                                             }
                                             }
                                             )


        
        #collector_fullname field properties
        collector_fullname_index = fields.indexOf("collector_fullname")
        layer.setFieldConstraint(collector_fullname_index, QgsFieldConstraints.ConstraintNotNull)
        

        #observation_subject field properties
        observation_subject_index = fields.indexOf("observation_subject")
        layer.setFieldConstraint(observation_subject_index, QgsFieldConstraints.ConstraintNotNull)
        layer.setDisplayExpression(selected_field_sub)

        #inat_upload field properties
        inat_upload_index = fields.indexOf("inat_upload")
        layer.setEditorWidgetSetup(inat_upload_index, checkbox)
        layer.setDefaultValueDefinition(inat_upload_index, QgsDefaultValue('1'))

        #is_wild field properties
        is_wild_index = fields.indexOf("is_wild")
        layer.setEditorWidgetSetup(is_wild_index, checkbox)
        layer.setDefaultValueDefinition(is_wild_index, QgsDefaultValue('0'))

        #taxon_name field properties
        taxon_name_index = fields.indexOf("taxon_name")
        expr_constr_taxon = 'CASE WHEN "no_name_on_list" = 1 THEN "taxon_name" IS NULL ELSE "taxon_name" IS NOT NULL END'
        layer.setConstraintExpression(taxon_name_index, expr_constr_taxon)
        layer.setDisplayExpression(selected_field)

        #no_name_on_list field properties
        no_name_on_list_index = fields.indexOf("no_name_on_list")
        layer.setEditorWidgetSetup(no_name_on_list_index, checkbox)
        layer.setDefaultValueDefinition(no_name_on_list_index, QgsDefaultValue('0'))

        #name_proposition field properties
        name_proposition_index = fields.indexOf("name_proposition")
        expr_constr_name = 'CASE WHEN "no_name_on_list" = 0 THEN "name_proposition" IS NULL ELSE "name_proposition" IS NOT NULL END'
        layer.setConstraintExpression(name_proposition_index, expr_constr_name)

        #picture_panel field properties
        picture_panel_index = fields.indexOf("picture_panel")
        layer.setFieldConstraint(picture_panel_index, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(picture_panel_index, attach)

        #picture_general field properties
        picture_general_index = fields.indexOf("picture_general")
        layer.setFieldConstraint(picture_general_index, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(picture_general_index, attach)

        #picture_detail field properties
        picture_detail_index = fields.indexOf("picture_detail")
        layer.setFieldConstraint(picture_detail_index, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(picture_detail_index, attach)

        #picture_cut field properties
        picture_cut_index = fields.indexOf("picture_cut")
        layer.setFieldConstraint(picture_cut_index, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(picture_cut_index, attach)

        #picture_panel_label field properties
        picture_panel_label_index = fields.indexOf("picture_panel_label")
        layer.setFieldConstraint(picture_panel_label_index, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(picture_panel_label_index, attach)

        #picture_free field properties
        picture_free_index = fields.indexOf("picture_free")
        layer.setEditorWidgetSetup(picture_free_index, attach)

        #x_coord field properties
        x_coord_index = fields.indexOf("x_coord")
        coord_x = QgsDefaultValue("$x")
        layer.setDefaultValueDefinition(x_coord_index, coord_x)

        #y_coord field properties
        y_coord_index = fields.indexOf("y_coord")
        coord_y = QgsDefaultValue("$y")
        layer.setDefaultValueDefinition(y_coord_index, coord_y)

        #ipen field properties
        
        #herbivory_(percent) field properties
        herbivory_index = fields.indexOf("herbivory_(percent)")
        layer.setEditorWidgetSetup(herbivory_index, range)

        #comment_eco field properties

        #soil_type field properties
        soil_type_index = fields.indexOf("soil_type")
        layer.setEditorWidgetSetup(soil_type_index, form_soil)

        #weather field properties
        weather_index = fields.indexOf("weather")
        layer.setEditorWidgetSetup(weather_index, form_weather)

        #temperature_(°C) field properties

        #comment_env field properties

        # date field properties
        date_index = fields.indexOf("date")
        date = QgsDefaultValue("format_date(now(), 'yyyyMMddHHmmss')")
        layer.setDefaultValueDefinition(date_index, date)

        # collector_orcid field properties
        collector_orcid_index = fields.indexOf("collector_orcid")
        layer.setDefaultValueDefinition(collector_orcid_index, QgsDefaultValue('attribute(get_feature(\'collector_list\', \'fullname\', "collector_fullname"), \'ORCID\')', True))
        layer.setFieldConstraint(collector_orcid_index, QgsFieldConstraints.ConstraintNotNull)

        # collector_inat field properties
        collector_inat_index = fields.indexOf("collector_inat")
        layer.setDefaultValueDefinition(collector_inat_index, QgsDefaultValue('attribute(get_feature(\'collector_list\', \'fullname\', "collector_fullname"), \'iNat_username\')', True))
        layer.setFieldConstraint(collector_inat_index, QgsFieldConstraints.ConstraintNotNull)


        #Change picture naming for the five concerned fields for QField
        custom_attachment = "QFieldSync/attachment_naming"
        rename_1 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_01.jpg'"
        rename_2 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_02.jpg'"
        rename_3 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_03.jpg'"
        rename_4 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_04.jpg'"
        rename_5 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_05.jpg'"
        rename_6 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_06.jpg'"
        custom_attachment_values = {
            "picture_panel": rename_1,
            "picture_general": rename_2,
            "picture_detail": rename_3,
            "picture_cut": rename_4,
            "picture_panel_label": rename_5,
            "picture_free": rename_6
        }
        custom_attachment_json = json.dumps(custom_attachment_values)
        layer.setCustomProperty(custom_attachment, custom_attachment_json)

        # Setup QFieldCloud layer action
        custom_layer_action = "QFieldSync/cloud_action"
        param = "offline"
        layer.setCustomProperty(custom_layer_action, param)

        # Change layout to drag and drop
        config = layer.editFormConfig()
        config.setLayout(QgsEditFormConfig.TabLayout)
        layer.setEditFormConfig(config)
        root = config.invisibleRootContainer()
        root.clear()

        # Create sample metadata tab
        sample_metadata = QgsAttributeEditorContainer("sample metadata", root)

        # Define the fields
        collector_fullname = QgsAttributeEditorField("collector_fullname", collector_fullname_index, sample_metadata)
        observation_subject = QgsAttributeEditorField("observation_subject", observation_subject_index, sample_metadata)
        inat_upload = QgsAttributeEditorField("inat_upload", inat_upload_index, sample_metadata)
        is_wild = QgsAttributeEditorField("is_wild", is_wild_index, sample_metadata)
        taxon_name = QgsAttributeEditorField("taxon_name", taxon_name_index, sample_metadata)
        no_name_on_list = QgsAttributeEditorField("no_name_on_list", no_name_on_list_index, sample_metadata)
        if_no_name_list = QgsAttributeEditorContainer("if_no_name_list", sample_metadata) #create the if_no_name_list tab
        if_no_expression = QgsOptionalExpression(QgsExpression("no_name_on_list = 1")) #add the visibility expression
        if_no_name_list.setVisibilityExpression(if_no_expression)
        name_proposition = QgsAttributeEditorField("name_proposition", name_proposition_index, if_no_name_list)
        sample_id_index = fields.indexOf("sample_id")
        sample_id = QgsAttributeEditorField("sample_id", sample_id_index, sample_metadata)
        pictures = QgsAttributeEditorContainer("pictures", sample_metadata)
        pictures_expression = QgsOptionalExpression(QgsExpression('regexp_match(to_string("sample_id"),' + f"'{project_name}_[0-9]{{6}}') AND " + '(if("no_name_on_list" = 0, "taxon_name" IS NOT NULL, TRUE)) AND (if("no_name_on_list" = 1, "name_proposition" IS NOT NULL, TRUE))'))
        pictures.setVisibilityExpression(pictures_expression)
        picture_general = QgsAttributeEditorField("picture_general", picture_general_index, sample_metadata)
        picture_panel = QgsAttributeEditorField("picture_panel", picture_panel_index, sample_metadata)
        picture_panel_label = QgsAttributeEditorField("picture_panel_label", picture_panel_label_index, sample_metadata)
        picture_detail = QgsAttributeEditorField("picture_detail", picture_detail_index, sample_metadata)
        picture_cut = QgsAttributeEditorField("picture_cut", picture_cut_index, sample_metadata)
        picture_free = QgsAttributeEditorField("picture_free", picture_free_index, sample_metadata)
        
        #Construct the sample metadata tab structure
        sample_metadata.addChildElement(collector_fullname)
        sample_metadata.addChildElement(observation_subject)
        sample_metadata.addChildElement(inat_upload)
        sample_metadata.addChildElement(is_wild)
        sample_metadata.addChildElement(taxon_name)
        sample_metadata.addChildElement(no_name_on_list)
        if_no_name_list.addChildElement(name_proposition)
        sample_metadata.addChildElement(if_no_name_list)
        sample_metadata.addChildElement(sample_id)
        pictures.addChildElement(picture_general)
        pictures.addChildElement(picture_panel)
        pictures.addChildElement(picture_panel_label)
        pictures.addChildElement(picture_detail)
        pictures.addChildElement(picture_cut)
        pictures.addChildElement(picture_free)
        sample_metadata.addChildElement(pictures)
        root.addChildElement(sample_metadata)

        #Create individual metadata tab
        individual_metadata = QgsAttributeEditorContainer("individual_metadata", root)
        ipen_index = fields.indexOf("ipen")
        ipen = QgsAttributeEditorField("ipen", ipen_index, individual_metadata)
        herbivory = QgsAttributeEditorField("herbivory_(percent)", herbivory_index, individual_metadata)
        comment_eco_index = fields.indexOf("comment_eco")
        comment_eco = QgsAttributeEditorField("comment_eco", comment_eco_index, individual_metadata)
        individual_metadata.addChildElement(ipen)
        individual_metadata.addChildElement(herbivory)
        individual_metadata.addChildElement(comment_eco)
        root.addChildElement(individual_metadata)

        #Create environmental metadata tab
        environmental_metadata = QgsAttributeEditorContainer("environmental metadata", root)
        soil = QgsAttributeEditorField("soil_type", soil_type_index, environmental_metadata)
        weather = QgsAttributeEditorField("weather", weather_index, environmental_metadata)
        temperature_index = fields.indexOf("temperature_(°C)")
        temperature = QgsAttributeEditorField("temperature_(°C)", temperature_index, environmental_metadata)
        comment_env_index = fields.indexOf("comment_env")
        comment_env = QgsAttributeEditorField("comment_env", comment_env_index, environmental_metadata)
        environmental_metadata.addChildElement(soil)
        environmental_metadata.addChildElement(weather)
        environmental_metadata.addChildElement(temperature)
        environmental_metadata.addChildElement(comment_env)
        root.addChildElement(environmental_metadata)
        layer.setEditFormConfig(config)

        #Display label for the points
        label = QgsPalLayerSettings()
        label.fieldName = "sample_id"
        label.textcolor = QColor(0, 0, 0)
        label.placement = QgsPalLayerSettings.OverPoint
        layer.setLabelsEnabled(True)
        layer.setLabeling(QgsVectorLayerSimpleLabeling(label))

        #Show feature count
        root = QgsProject.instance().layerTreeRoot()
        layer_node = root.findLayer(layer.id())
        layer_node.setCustomProperty("showFeatureCount", 1)

    def run_create_obs(self):
        gpkg_name, ok = QInputDialog.getText(self.iface.mainWindow(), "GPKG name", "Enter the name of the GPKG:")
        if not ok or gpkg_name == "":
            return

        # Create the dialog to select a layer
        dialog = LayerSelectionDialog_create_obs(gpkg_name)
        if dialog.exec_() != QDialog.Accepted:
            return

        # Get the selected layer from the dialog
        selected_layer = dialog.selectedLayer()
        selected_field = dialog.selectedField()
        selected_layer_col = dialog.selectedLayer_col()
        selected_field_col = dialog.selectedField_col()
        if not selected_layer or not selected_field or not selected_layer_col or not selected_field_col:
            return

        # Retrieve layer information
        plant_layer_id = selected_layer.id()
        collector_layer_id = selected_layer_col.id()
        
        # Stores the project's folder
        project_folder = QgsProject.instance().readPath("./")
        # Creates the gpkg's path
        gpkg_file = os.path.join(project_folder, gpkg_name + '_obs' '.gpkg')
        gpkg_file = gpkg_file.replace("\\", "/")
        # Define the type gpkg for the layer
        driver = ogr.GetDriverByName('GPKG')
        # Creates the gpkg
        ds = driver.CreateDataSource(gpkg_file)
        # Sets the layer name (same as gpkg's name)
        layer_name = gpkg_name + '_obs'
        #sets the layer's srs
        project_crs = QgsProject.instance().crs()
        crs_wkt = project_crs.toWkt()
        srs = ogr.osr.SpatialReference()
        srs.ImportFromWkt(crs_wkt)
        #Sets the layer geometry type (here point)
        geom_type = ogr.wkbPoint
        #Creates the layer
        layer = ds.CreateLayer(layer_name, srs, geom_type)

        #Creation of the sample metadata fields
        field_def1 = ogr.FieldDefn("collector_fullname", ogr.OFTString)
        field_def1.SetWidth(200)
        layer.CreateField(field_def1)

        field_def3 = ogr.FieldDefn("inat_upload", ogr.OFTString)
        field_def3.SetWidth(200)
        layer.CreateField(field_def3)
        
        field_def4 = ogr.FieldDefn("is_wild", ogr.OFTString)
        field_def4.SetWidth(200)
        layer.CreateField(field_def4)

        field_def5 = ogr.FieldDefn("taxon_name", ogr.OFTString)
        field_def5.SetWidth(200)
        layer.CreateField(field_def5)

        field_def6 = ogr.FieldDefn("no_name_on_list", ogr.OFTString)
        field_def6.SetWidth(200)
        layer.CreateField(field_def6)

        field_def7 = ogr.FieldDefn("name_proposition", ogr.OFTString)
        field_def7.SetWidth(200)
        layer.CreateField(field_def7)

        field_def8 = ogr.FieldDefn("picture_panel", ogr.OFTString)
        field_def8.SetWidth(200)
        layer.CreateField(field_def8)

        field_def9 = ogr.FieldDefn("picture_general", ogr.OFTString)
        field_def9.SetWidth(200)
        layer.CreateField(field_def9)

        field_def10 = ogr.FieldDefn("picture_detail", ogr.OFTString)
        field_def10.SetWidth(200)
        layer.CreateField(field_def10)
        
        field_def11 = ogr.FieldDefn("picture_free", ogr.OFTString)
        field_def11.SetWidth(200)
        layer.CreateField(field_def11)

        field_def12 = ogr.FieldDefn("x_coord", ogr.OFTReal)
        field_def12.SetPrecision(0)
        layer.CreateField(field_def12)

        field_def13 = ogr.FieldDefn("y_coord", ogr.OFTReal)
        field_def13.SetPrecision(0)
        layer.CreateField(field_def13)

        #Creation of the individual metadata fields
        field_def14 = ogr.FieldDefn("ipen", ogr.OFTString)
        field_def14.SetWidth(200)
        layer.CreateField(field_def14)

        field_def15 = ogr.FieldDefn("herbivory_(percent)", ogr.OFTInteger)
        layer.CreateField(field_def15)

        field_def16 = ogr.FieldDefn("comment_eco", ogr.OFTString)
        field_def16.SetWidth(1000)
        layer.CreateField(field_def16)

        #Creation of the environmental metadata fields
        field_def17 = ogr.FieldDefn("soil_type", ogr.OFTString)
        field_def17.SetWidth(200)
        layer.CreateField(field_def17)

        field_def18 = ogr.FieldDefn("weather", ogr.OFTString)
        field_def18.SetWidth(200)
        layer.CreateField(field_def18)

        field_def19 = ogr.FieldDefn("temperature_(°C)", ogr.OFTReal)
        field_def19.SetPrecision(0)
        layer.CreateField(field_def19)

        field_def20 = ogr.FieldDefn("comment_env", ogr.OFTString)
        field_def20.SetWidth(1000)
        layer.CreateField(field_def20)

        field_def21 = ogr.FieldDefn("date", ogr.OFTString)
        field_def21.SetWidth(200)
        layer.CreateField(field_def21)

        field_def22 = ogr.FieldDefn("collector_orcid", ogr.OFTString)
        field_def22.SetWidth(1000)
        layer.CreateField(field_def22)

        field_def23 = ogr.FieldDefn("collector_inat", ogr.OFTString)
        field_def23.SetWidth(1000)
        layer.CreateField(field_def23)

        #Close the GeoPackage file
        ds = None

        # Load the GeoPackage file as a vector layer in QGIS
        imp_layer = QgsVectorLayer(gpkg_file + "|layername=" + layer_name, layer_name, "ogr")
        QgsProject.instance().addMapLayer(imp_layer)
       
        #Create association relation between binomial nomenclature layer and taxon_name field
        imp_layer_id = imp_layer.id()
        imp_layer_field = "taxon_name"
        relation = QgsRelation()
        relation.setReferencingLayer(imp_layer_id)
        relation.setReferencedLayer(plant_layer_id)
        relation.addFieldPair(imp_layer_field, selected_field)
        relation.setId(layer_name + "_taxon")
        relation.setName(layer_name + "_taxon")
        QgsProject.instance().relationManager().addRelation(relation)

        #Create association relation between collector list and colector_orcid field
        imp_layer_field_col = "collector_fullname"
        relation2 = QgsRelation()
        relation2.setReferencingLayer(imp_layer_id)
        relation2.setReferencedLayer(collector_layer_id)
        relation2.addFieldPair(imp_layer_field_col, selected_field_col)
        relation2.setId(layer_name + "_collector")
        relation2.setName(layer_name + "_collector")
        QgsProject.instance().relationManager().addRelation(relation2)

        #Define the layer to change field properties
        layer = QgsProject.instance().mapLayer(imp_layer_id)
        
        # Define taxon list layer display expression
        layer_taxon = QgsProject.instance().mapLayer(plant_layer_id)
        layer_taxon.setDisplayExpression(selected_field)

        # Define collector list layer display expression
        layer_col = QgsProject.instance().mapLayer(collector_layer_id)
        layer_col.setDisplayExpression(selected_field_col)

        #Define different widget types
        attach = QgsEditorWidgetSetup('ExternalResource', {}) #Defines attachment widget type
        checkbox = QgsEditorWidgetSetup('CheckBox', {'CheckedState': "1", 'UncheckedState': "0"})
        range = QgsEditorWidgetSetup('Range', {
            'AllowNull': True,
            'Max': 100,
            'Min': 0,
            'Step': 1,
            'Style': 'Slider'
        }
        )
        form_soil = QgsEditorWidgetSetup('ValueMap', 
                                         {'map': {
                                             "sandy soil": "sandy soil",
                                             "loamy soil": "loamy soil",
                                             "clay soil": "clay soil",
                                             "humus soil": "humus soil"
                                             }
                                             }
                                             )
        
        form_weather = QgsEditorWidgetSetup('ValueMap',
                                         {'map': {
                                             "sunny": "sunny",
                                             "cloudy": "cloudy",
                                             "rainy": "rainy",
                                             "snowy": "snowy",
                                             "foggy": "foggy"
                                             }
                                             }
                                             )

        #collector_fullname field properties
        layer.setFieldConstraint(1, QgsFieldConstraints.ConstraintNotNull)

        #inat_upload field properties
        layer.setEditorWidgetSetup(2, checkbox)
        layer.setDefaultValueDefinition(2, QgsDefaultValue('1'))

        #is_wild field properties
        layer.setEditorWidgetSetup(3, checkbox)
        layer.setDefaultValueDefinition(3, QgsDefaultValue('0'))

        #taxon_name field properties
        expr_constr_taxon = 'CASE WHEN "no_name_on_list" = 1 THEN "taxon_name" IS NULL ELSE "taxon_name" IS NOT NULL END'
        layer.setConstraintExpression(4, expr_constr_taxon)
        layer.setDisplayExpression(selected_field)

        #no_name_on_list field properties
        layer.setEditorWidgetSetup(5, checkbox)
        layer.setDefaultValueDefinition(5, QgsDefaultValue('0'))

        #name_proposition field properties
        expr_constr_name = 'CASE WHEN "no_name_on_list" = 0 THEN "name_proposition" IS NULL ELSE "name_proposition" IS NOT NULL END'
        layer.setConstraintExpression(6, expr_constr_name)

        #picture_panel field properties
        layer.setFieldConstraint(7, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(7, attach)

        #picture_general field properties
        layer.setFieldConstraint(8, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(8, attach)

        #picture_detail field properties
        layer.setFieldConstraint(9, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(9, attach)

        #picture_free field properties
        layer.setEditorWidgetSetup(10, attach)

        #x_coord field properties
        coord_x = QgsDefaultValue("$x")
        layer.setDefaultValueDefinition(11, coord_x)

        #y_coord field properties
        coord_y = QgsDefaultValue("$y")
        layer.setDefaultValueDefinition(12, coord_y)

        #ipen field properties
        
        #herbivory_(percent) field properties
        layer.setEditorWidgetSetup(14, range)

        #comment_eco field properties

        #soil_type field properties
        layer.setEditorWidgetSetup(16, form_soil)

        #weather field properties
        layer.setEditorWidgetSetup(17, form_weather)

        #temperature_(°C) field properties

        #comment_env field properties

        # date field properties
        date = QgsDefaultValue("format_date(now(), 'yyyyMMddHHmmss')")
        layer.setDefaultValueDefinition(20, date)

        # collector_orcid field properties
        layer.setDefaultValueDefinition(21, QgsDefaultValue('attribute(get_feature(\'collector_list\', \'fullname\', "collector_fullname"), \'ORCID\')', True))
        layer.setFieldConstraint(21, QgsFieldConstraints.ConstraintNotNull)

        # collector_inat field properties
        layer.setDefaultValueDefinition(22, QgsDefaultValue('attribute(get_feature(\'collector_list\', \'fullname\', "collector_fullname"), \'iNat_username\')', True))
        layer.setFieldConstraint(22, QgsFieldConstraints.ConstraintNotNull)


        #Change picture naming for the five concerned fields for QField
        custom_attachment = "QFieldSync/attachment_naming"
        rename_1 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "date" ||' + "'_01.jpg'"
        rename_2 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "date" ||' + "'_02.jpg'"
        rename_3 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "date" ||' + "'_03.jpg'"
        rename_6 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "taxon_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "date" ||' + "'_04.jpg'"
        custom_attachment_values = {
            "picture_panel": rename_1,
            "picture_general": rename_2,
            "picture_detail": rename_3,
            "picture_free": rename_6
        }
        custom_attachment_json = json.dumps(custom_attachment_values)
        layer.setCustomProperty(custom_attachment, custom_attachment_json)

        # Setup QFieldCloud layer action
        custom_layer_action = "QFieldSync/cloud_action"
        param = "offline"
        layer.setCustomProperty(custom_layer_action, param)

        # Change layout to drag and drop
        config = layer.editFormConfig()
        config.setLayout(QgsEditFormConfig.TabLayout)
        layer.setEditFormConfig(config)
        root = config.invisibleRootContainer()
        root.clear()

        # Create sample metadata tab
        sample_metadata = QgsAttributeEditorContainer("sample metadata", root)

        # Define the fields
        collector_fullname = QgsAttributeEditorField("collector_fullname", 1, sample_metadata)
        inat_upload = QgsAttributeEditorField("inat_upload", 2, sample_metadata)
        is_wild = QgsAttributeEditorField("is_wild", 3, sample_metadata)
        taxon_name = QgsAttributeEditorField("taxon_name", 4, sample_metadata)
        no_name_on_list = QgsAttributeEditorField("no_name_on_list", 5, sample_metadata)
        if_no_name_list = QgsAttributeEditorContainer("if_no_name_list", sample_metadata) #create the if_no_name_list tab
        if_no_expression = QgsOptionalExpression(QgsExpression("no_name_on_list = 1")) #add the visibility expression
        if_no_name_list.setVisibilityExpression(if_no_expression)
        name_proposition = QgsAttributeEditorField("name_proposition", 6, if_no_name_list)
        pictures = QgsAttributeEditorContainer("pictures", sample_metadata)
        pictures_expression = QgsOptionalExpression(QgsExpression('(if("no_name_on_list" = 0, "taxon_name" IS NOT NULL, TRUE)) AND (if("no_name_on_list" = 1, "name_proposition" IS NOT NULL, TRUE))'))
        pictures.setVisibilityExpression(pictures_expression)
        picture_general = QgsAttributeEditorField("picture_general", 7, sample_metadata)
        picture_panel = QgsAttributeEditorField("picture_panel", 8, sample_metadata)
        picture_detail = QgsAttributeEditorField("picture_detail", 9, sample_metadata)
        picture_free = QgsAttributeEditorField("picture_free", 10, sample_metadata)
        
        #Construct the sample metadata tab structure
        sample_metadata.addChildElement(collector_fullname)
        sample_metadata.addChildElement(inat_upload)
        sample_metadata.addChildElement(is_wild)
        sample_metadata.addChildElement(taxon_name)
        sample_metadata.addChildElement(no_name_on_list)
        if_no_name_list.addChildElement(name_proposition)
        sample_metadata.addChildElement(if_no_name_list)
        pictures.addChildElement(picture_general)
        pictures.addChildElement(picture_panel)
        pictures.addChildElement(picture_detail)
        pictures.addChildElement(picture_free)
        sample_metadata.addChildElement(pictures)
        root.addChildElement(sample_metadata)

        #Create individual metadata tab
        individual_metadata = QgsAttributeEditorContainer("individual_metadata", root)
        ipen = QgsAttributeEditorField("ipen", 1, individual_metadata)
        herbivory = QgsAttributeEditorField("herbivory_(percent)", 2, individual_metadata)
        comment_eco = QgsAttributeEditorField("comment_eco", 3, individual_metadata)
        individual_metadata.addChildElement(ipen)
        individual_metadata.addChildElement(herbivory)
        individual_metadata.addChildElement(comment_eco)
        root.addChildElement(individual_metadata)

        #Create environmental metadata tab
        environmental_metadata = QgsAttributeEditorContainer("environmental metadata", root)
        soil = QgsAttributeEditorField("soil_type", 1, environmental_metadata)
        weather = QgsAttributeEditorField("weather", 2, environmental_metadata)
        temperature = QgsAttributeEditorField("temperature_(°C)", 3, environmental_metadata)
        comment_env = QgsAttributeEditorField("comment_env", 4, environmental_metadata)
        environmental_metadata.addChildElement(soil)
        environmental_metadata.addChildElement(weather)
        environmental_metadata.addChildElement(temperature)
        environmental_metadata.addChildElement(comment_env)
        root.addChildElement(environmental_metadata)
        layer.setEditFormConfig(config)

        #Show feature count
        root = QgsProject.instance().layerTreeRoot()
        layer_node = root.findLayer(imp_layer.id())
        layer_node.setCustomProperty("showFeatureCount", 1)