# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GpkgCreator
                                 A QGIS plugin
 Creates geopackages that match the requirements for the DBGI project
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-08
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Edouard Brülhart
        email                : edouard.bruelhart@unifr.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import *
from qgis.core import QgsVectorLayer, QgsProject, QgsRelation, QgsEditorWidgetSetup, QgsFieldConstraints, QgsDefaultValue, QgsPalLayerSettings, QgsVectorLayerSimpleLabeling, QgsAttributeEditorContainer, QgsAttributeEditorField, QgsOptionalExpression, QgsExpression, QgsField
from qgis.PyQt.QtCore import QVariant
from qgis.gui import QgsMapLayerComboBox
from osgeo import ogr
import os
import json

def classFactory(iface):
    return GpkgCreator(iface)

#Creates the selection dialog for binomial nomenclature item
class LayerSelectionDialog(QDialog):
    def __init__(self, gpkg_name, parent=None):
        super(LayerSelectionDialog, self).__init__(parent)
        self.setWindowTitle("Select identification's layer")
        self.layout = QVBoxLayout()

        # Create a label for GPKG name
        self.gpkg_label = QLabel(f"GPKG name: {gpkg_name}")
        self.layout.addWidget(self.gpkg_label)

        # Create a label for layer selection
        self.label = QLabel("Select identification's layer:")
        self.layout.addWidget(self.label)

        # Create a layer combobox
        self.layer_combobox = QgsMapLayerComboBox()
        self.layout.addWidget(self.layer_combobox)

        # Create a label for field selection
        self.field_label = QLabel("Select identification's name column in the identification's layer:")
        self.layout.addWidget(self.field_label)

        # Create a field combobox
        self.field_combobox = QComboBox()
        self.layout.addWidget(self.field_combobox)

        # Create a button to confirm the selection
        self.button_ok = QPushButton("OK")
        self.button_ok.clicked.connect(self.accept)
        self.layout.addWidget(self.button_ok)

        self.setLayout(self.layout)

        # Connect the signal to update field combobox when layer selection changes
        self.layer_combobox.currentIndexChanged.connect(self.updateFieldComboBox)

    #Gives the selected binomial nomenclature item
    def selectedLayer(self):
        return self.layer_combobox.currentLayer()
    
    #Gives the selected binomial nomenclature item's field
    def selectedField(self):
        return self.field_combobox.currentText()
    
    def updateFieldComboBox(self):
        # Clear the field combobox
        self.field_combobox.clear()

        # Get the selected layer
        selected_layer = self.selectedLayer()
        if not selected_layer:
            return
        
        # Get the field names from the selected layer
        field_names = [field.name() for field in selected_layer.fields()]
        self.field_combobox.addItems(field_names)

#Creates the selection dialog for binomial nomenclature item
class LayerSelectionDialog_second(QDialog):
    def __init__(self, parent=None):
        super(LayerSelectionDialog_second, self).__init__(parent)
        self.setWindowTitle("Select the geopackage to modify")
        self.layout = QVBoxLayout()

        # Create a label for layer selection
        self.label = QLabel("Select the name of the geopackage:")
        self.layout.addWidget(self.label)

        # Create a layer combobox
        self.layer_combobox = QgsMapLayerComboBox()
        self.layout.addWidget(self.layer_combobox)

        # Create a button to confirm the selection
        self.button_ok = QPushButton("OK")
        self.button_ok.clicked.connect(self.accept)
        self.layout.addWidget(self.button_ok)

        self.setLayout(self.layout)

        # Connect the signal to update field combobox when layer selection changes
        self.layer_combobox.currentIndexChanged.connect(self.updateLayerComboBox)

    #Gives the selected binomial nomenclature item
    def selectedLayer(self):
        return self.layer_combobox.currentLayer()
    
    def updateLayerComboBox(self):
        # Get the selected layer
        selected_layer = self.selectedLayer()
        if not selected_layer:
            return

class GpkgCreator:
    def __init__(self, iface):
        self.iface = iface

    def initGui(self):
        # create action that will start plugin configuration
        self.action = QAction(
                          "Create a DBGI geopackage",
                          self.iface.mainWindow())
        self.action.triggered.connect(self.run)

        self.second_action = QAction(
                            "Modify an existing DBGI geopackage",
                            self.iface.mainWindow())
        self.second_action.triggered.connect(self.run_second)

        # add toolbar button
        self.iface.addPluginToVectorMenu("&DBGI", self.action)
        self.iface.addPluginToVectorMenu("&DBGI", self.second_action)

    def unload(self):
        # remove the toolbar button
        self.iface.removePluginVectorMenu("&DBGI", self.action)
        self.iface.removePluginVectorMenu("&DBGI", self.second_action)

    def run(self):
        # Ask user to enter the name of the GPKG and name of the plant list
        gpkg_name, ok = QInputDialog.getText(self.iface.mainWindow(), "GPKG name", "Enter the name of the GPKG:")
        if not ok or gpkg_name == "":
            return

        # Create the dialog to select a layer
        dialog = LayerSelectionDialog(gpkg_name)
        if dialog.exec_() != QDialog.Accepted:
            return

        # Get the selected layer from the dialog
        selected_layer = dialog.selectedLayer()
        selected_field = dialog.selectedField()
        if not selected_layer or not selected_field:
            return

        # Retrieve layer information
        plant_layer_id = selected_layer.id()
        
        # Stores the project's folder
        project_folder = QgsProject.instance().readPath("./")
        # Creates the gpkg's path
        gpkg_file = os.path.join(project_folder, gpkg_name + '.gpkg')
        gpkg_file = gpkg_file.replace("\\", "/")
        # Define the type gpkg for the layer
        driver = ogr.GetDriverByName('GPKG')
        # Creates the gpkg
        ds = driver.CreateDataSource(gpkg_file)
        # Sets the layer name (same as gpkg's name)
        layer_name = gpkg_name
        #sets the layer's srs
        project_crs = QgsProject.instance().crs()
        crs_wkt = project_crs.toWkt()
        srs = ogr.osr.SpatialReference()
        srs.ImportFromWkt(crs_wkt)
        #Sets the layer geometry type (here point)
        geom_type = ogr.wkbPoint
        #Creates the layer
        layer = ds.CreateLayer(layer_name, srs, geom_type)

        #Creation of the sample metadata fields
        field_def1 = ogr.FieldDefn("sample_name", ogr.OFTString)
        field_def1.SetWidth(200)
        layer.CreateField(field_def1)

        field_def2 = ogr.FieldDefn("no_name_on_list", ogr.OFTInteger)
        #field_def2.SetWidth(200)
        layer.CreateField(field_def2)

        field_def3 = ogr.FieldDefn("name_proposition", ogr.OFTString)
        field_def3.SetWidth(200)
        layer.CreateField(field_def3)

        field_def4 = ogr.FieldDefn("sample_id", ogr.OFTString)
        field_def4.SetWidth(15)
        layer.CreateField(field_def4)

        field_def5 = ogr.FieldDefn("picture_panel", ogr.OFTString)
        field_def5.SetWidth(200)
        layer.CreateField(field_def5)

        field_def6 = ogr.FieldDefn("picture_general", ogr.OFTString)
        field_def6.SetWidth(200)
        layer.CreateField(field_def6)

        field_def7 = ogr.FieldDefn("picture_detail", ogr.OFTString)
        field_def7.SetWidth(200)
        layer.CreateField(field_def7)

        field_def8 = ogr.FieldDefn("picture_cut", ogr.OFTString)
        field_def8.SetWidth(200)
        layer.CreateField(field_def8)

        field_def9 = ogr.FieldDefn("picture_panel_label", ogr.OFTString)
        field_def9.SetWidth(200)
        layer.CreateField(field_def9)
        
        field_def10 = ogr.FieldDefn("picture_free", ogr.OFTString)
        field_def10.SetWidth(200)
        layer.CreateField(field_def10)

        field_def11 = ogr.FieldDefn("x_coord", ogr.OFTReal)
        field_def11.SetPrecision(0)
        layer.CreateField(field_def11)

        field_def12 = ogr.FieldDefn("y_coord", ogr.OFTReal)
        field_def12.SetPrecision(0)
        layer.CreateField(field_def12)

        #Creation of the individual metadata fields
        field_def13 = ogr.FieldDefn("ipen", ogr.OFTString)
        field_def13.SetWidth(200)
        layer.CreateField(field_def13)

        field_def14 = ogr.FieldDefn("herbivory_(percent)", ogr.OFTInteger)
        #field_def14.SetWidth(200)
        layer.CreateField(field_def14)

        field_def15 = ogr.FieldDefn("comment_eco", ogr.OFTString)
        field_def15.SetWidth(1000)
        layer.CreateField(field_def15)

        #Creation of the environmental metadata fields
        field_def16 = ogr.FieldDefn("soil_type", ogr.OFTString)
        field_def16.SetWidth(200)
        layer.CreateField(field_def16)

        field_def17 = ogr.FieldDefn("weather", ogr.OFTString)
        field_def17.SetWidth(200)
        layer.CreateField(field_def17)

        field_def18 = ogr.FieldDefn("temperature_(°C)", ogr.OFTReal)
        field_def18.SetPrecision(0)
        layer.CreateField(field_def18)

        field_def19 = ogr.FieldDefn("comment_env", ogr.OFTString)
        field_def19.SetWidth(1000)
        layer.CreateField(field_def19)

        #Close the GeoPackage file
        ds = None

        # Load the GeoPackage file as a vector layer in QGIS
        imp_layer = QgsVectorLayer(gpkg_file + "|layername=" + layer_name, layer_name, "ogr")
        QgsProject.instance().addMapLayer(imp_layer)
       
        #Create association relation between binomial nomenclature layer and sample_name field
        imp_layer_id = imp_layer.id()
        imp_layer_field = "sample_name"
        relation = QgsRelation()
        relation.setReferencingLayer(imp_layer_id)
        relation.setReferencedLayer(plant_layer_id)
        relation.addFieldPair(imp_layer_field, selected_field)
        relation.setId(layer_name)
        relation.setName(layer_name)
        QgsProject.instance().relationManager().addRelation(relation)

        #Define the layer to change field properties
        layer = QgsProject.instance().mapLayer(imp_layer_id)

        #Define different widget types
        attach = QgsEditorWidgetSetup('ExternalResource', {}) #Defines attachment widget type
        checkbox = QgsEditorWidgetSetup('CheckBox', {'CheckedState': 1, 'UncheckedState': 0})
        range = QgsEditorWidgetSetup('Range', {
            'AllowNull': True,
            'Max': 100,
            'Min': 0,
            'Step': 1,
            'Style': 'Slider'
        }
        )
        form_soil = QgsEditorWidgetSetup('ValueMap', 
                                         {'map': {
                                             "sandy soil": "sandy soil",
                                             "loamy soil": "loamy soil",
                                             "clay soil": "clay soil",
                                             "humus soil": "humus soil"
                                             }
                                             }
                                             )
        
        form_weather = QgsEditorWidgetSetup('ValueMap',
                                         {'map': {
                                             "sunny": "sunny",
                                             "cloudy": "cloudy",
                                             "rainy": "rainy",
                                             "snowy": "snowy",
                                             "foggy": "foggy"
                                             }
                                             }
                                             )

        #sample_name field properties
        layer.setFieldConstraint(1, QgsFieldConstraints.ConstraintNotNull)

        #no_name_on_list field properties
        layer.setEditorWidgetSetup(2, checkbox)
        layer.setDefaultValueDefinition(2, QgsDefaultValue('0'))

        #name_proposition field properties
        expr_constr_name = 'CASE WHEN "no_name_on_list" = 0 THEN "name_proposition" IS NULL ELSE "name_proposition" IS NOT NULL END'
        layer.setConstraintExpression(3, expr_constr_name)

        #sample_id field properties
        expr_constr = 'regexp_match(to_string("sample_id"), \'dbgi_[0-9]{6}\')'
        layer.setFieldConstraint(4, QgsFieldConstraints.ConstraintNotNull)
        layer.setFieldConstraint(4, QgsFieldConstraints.ConstraintUnique)
        layer.setConstraintExpression(4, expr_constr)

        #picture_panel field properties
        layer.setFieldConstraint(5, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(5, attach)

        #picture_general field properties
        layer.setFieldConstraint(6, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(6, attach)

        #picture_detail field properties
        layer.setFieldConstraint(7, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(7, attach)

        #picture_cut field properties
        layer.setFieldConstraint(8, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(8, attach)

        #picture_panel_label field properties
        layer.setFieldConstraint(9, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(9, attach)

        #picture_free field properties
        layer.setEditorWidgetSetup(10, attach)

        #x_coord field properties
        coord_x = QgsDefaultValue("$x")
        layer.setDefaultValueDefinition(11, coord_x)

        #y_coord field properties
        coord_y = QgsDefaultValue("$y")
        layer.setDefaultValueDefinition(12, coord_y)

        #ipen field properties
        
        #herbivory_(percent) field properties
        layer.setEditorWidgetSetup(14, range)

        #comment_eco field properties

        #soil_type field properties
        layer.setEditorWidgetSetup(16, form_soil)

        #weather field properties
        layer.setEditorWidgetSetup(17, form_weather)

        #temperature_(°C) field properties

        #comment_env field properties

        #Change picture naming for the five concerned fields for QField
        custom_property_key = "QFieldSync/attachment_naming"
        rename_1 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "sample_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_01.jpg'"
        rename_2 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "sample_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_02.jpg'"
        rename_3 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "sample_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_03.jpg'"
        rename_4 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "sample_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_04.jpg'"
        rename_5 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "sample_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_05.jpg'"
        rename_6 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "sample_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_06.jpg'"
        custom_property_values = {
            "picture_panel": rename_1,
            "picture_general": rename_2,
            "picture_detail": rename_3,
            "picture_cut": rename_4,
            "picture_panel_label": rename_5,
            "picture_free": rename_6
        }
        custom_property_json = json.dumps(custom_property_values)
        layer.setCustomProperty(custom_property_key, custom_property_json)

        #Clean the form layout tab
        config = layer.editFormConfig()
        config.setLayout(1)
        layer.setEditFormConfig(config)
        root = config.invisibleRootContainer()
        root.clear()

        #Create sample metadata tab
        sample_metadata = QgsAttributeEditorContainer("sample metadata", root)

        #Define the fields
        sample_name = QgsAttributeEditorField("sample_name", 1, sample_metadata)
        no_name_on_list = QgsAttributeEditorField("no_name_on_list", 2, sample_metadata)
        if_no_name_list = QgsAttributeEditorContainer("if_no_name_list", sample_metadata) #create the if_no_name_list tab
        if_no_expression = QgsOptionalExpression(QgsExpression("no_name_on_list = 1")) #add the visibility expression
        if_no_name_list.setVisibilityExpression(if_no_expression)
        name_proposition = QgsAttributeEditorField("name_proposition", 3, if_no_name_list)
        sample_id = QgsAttributeEditorField("sample_id", 4, sample_metadata)
        pictures = QgsAttributeEditorContainer("pictures", sample_metadata)
        pictures_expression = QgsOptionalExpression(QgsExpression('regexp_match(to_string("sample_id"),' + "'dbgi_[0-9]{6}') AND " + '"sample_name" IS NOT NULL AND (if("no_name_on_list" = 1, "name_proposition" IS NOT NULL, TRUE))'))
        pictures.setVisibilityExpression(pictures_expression)
        picture_panel = QgsAttributeEditorField("picture_panel", 5, sample_metadata)
        picture_general = QgsAttributeEditorField("picture_general", 6, sample_metadata)
        picture_detail = QgsAttributeEditorField("picture_detail", 7, sample_metadata)
        picture_cut = QgsAttributeEditorField("picture_cut", 8, sample_metadata)
        picture_panel_label = QgsAttributeEditorField("picture_panel_label", 9, sample_metadata)
        picture_free = QgsAttributeEditorField("picture_free", 5, sample_metadata)
        
        #Construct the sample metadata tab structure
        sample_metadata.addChildElement(sample_name)
        sample_metadata.addChildElement(no_name_on_list)
        if_no_name_list.addChildElement(name_proposition)
        sample_metadata.addChildElement(if_no_name_list)
        sample_metadata.addChildElement(sample_id)
        pictures.addChildElement(picture_panel)
        pictures.addChildElement(picture_general)
        pictures.addChildElement(picture_detail)
        pictures.addChildElement(picture_cut)
        pictures.addChildElement(picture_panel_label)
        pictures.addChildElement(picture_free)
        sample_metadata.addChildElement(pictures)
        root.addChildElement(sample_metadata)

        #Create individual metadata tab
        individual_metadata = QgsAttributeEditorContainer("individual_metadata", root)
        ipen = QgsAttributeEditorField("ipen", 1, individual_metadata)
        herbivory = QgsAttributeEditorField("herbivory_(percent)", 2, individual_metadata)
        comment_eco = QgsAttributeEditorField("comment_eco", 3, individual_metadata)
        individual_metadata.addChildElement(ipen)
        individual_metadata.addChildElement(herbivory)
        individual_metadata.addChildElement(comment_eco)
        root.addChildElement(individual_metadata)

        #Create environmental metadata tab
        environmental_metadata = QgsAttributeEditorContainer("environmental metadata", root)
        soil = QgsAttributeEditorField("soil_type", 1, environmental_metadata)
        weather = QgsAttributeEditorField("weather", 2, environmental_metadata)
        temperature = QgsAttributeEditorField("temperature_(°C)", 3, environmental_metadata)
        comment_env = QgsAttributeEditorField("comment_env", 4, environmental_metadata)
        environmental_metadata.addChildElement(soil)
        environmental_metadata.addChildElement(weather)
        environmental_metadata.addChildElement(temperature)
        environmental_metadata.addChildElement(comment_env)
        root.addChildElement(environmental_metadata)
        layer.setEditFormConfig(config)

        #Display label for the points
        label = QgsPalLayerSettings()
        label.fieldName = "sample_id"
        label.textcolor = QColor(0, 0, 0)
        label.placement = QgsPalLayerSettings.OverPoint
        layer.setLabelsEnabled(True)
        layer.setLabeling(QgsVectorLayerSimpleLabeling(label))

        #Show feature count
        root = QgsProject.instance().layerTreeRoot()
        layer_node = root.findLayer(imp_layer.id())
        layer_node.setCustomProperty("showFeatureCount", 1)

    def run_second(self):
        # Create the dialog to select a layer
        dialog = LayerSelectionDialog_second()
        if dialog.exec_() != QDialog.Accepted:
            return

        # Get the selected layer from the dialog
        selected_layer = dialog.selectedLayer()
        if not selected_layer:
            return
        
        layer = selected_layer
        layer_name = selected_layer.name()
        layer_id = selected_layer.id()

        field_def1 = QgsField("no_name_on_list", QVariant.Int)
        layer.dataProvider().addAttributes([field_def1])

        field_def2 = QgsField("name_proposition", QVariant.String)
        layer.dataProvider().addAttributes([field_def2])

        field_def3 = QgsField("picture_free", QVariant.String)
        layer.dataProvider().addAttributes([field_def3])

        #Creation of the individual metadata fields
        field_def4 = QgsField("ipen", QVariant.String)
        selected_layer.dataProvider().addAttributes([field_def4])

        field_def5 = QgsField("herbivory_(percent)", QVariant.Int)
        layer.dataProvider().addAttributes([field_def5])

        field_def6 = QgsField("comment_eco", QVariant.String)
        layer.dataProvider().addAttributes([field_def6])

        #Creation of the environmental metadata fields
        
        field_def7 = QgsField("soil_type", QVariant.String)
        selected_layer.dataProvider().addAttributes([field_def7])

        field_def8 = QgsField("weather", QVariant.String)
        layer.dataProvider().addAttributes([field_def8])

        field_def9 = QgsField("temperature_(°C)", QVariant.Double)
        layer.dataProvider().addAttributes([field_def9])

        field_def10 = QgsField("comment_env", QVariant.String)
        layer.dataProvider().addAttributes([field_def10])

        layer.updateFields()
    
        #layer = QgsProject.instance().mapLayer(layer_id)

        #Define different widget types
        attach = QgsEditorWidgetSetup('ExternalResource', {}) #Defines attachment widget type
        checkbox = QgsEditorWidgetSetup('CheckBox', {'CheckedState': 1, 'UncheckedState': 0})
        range = QgsEditorWidgetSetup('Range', {
            'AllowNull': True,
            'Max': 100,
            'Min': 0,
            'Step': 1,
            'Style': 'Slider'
        }
        )
        form_soil = QgsEditorWidgetSetup('ValueMap', 
                                         {'map': {
                                             "sandy soil": "sandy soil",
                                             "loamy soil": "loamy soil",
                                             "clay soil": "clay soil",
                                             "humus soil": "humus soil"
                                             }
                                             }
                                             )
        
        form_weather = QgsEditorWidgetSetup('ValueMap',
                                         {'map': {
                                             "sunny": "sunny",
                                             "cloudy": "cloudy",
                                             "rainy": "rainy",
                                             "snowy": "snowy",
                                             "foggy": "foggy"
                                             }
                                             }
                                             )

        #no_name_on_list field properties
        layer.setEditorWidgetSetup(10, checkbox)
        layer.setDefaultValueDefinition(10, QgsDefaultValue('0'))

        #name_proposition field properties
        expr_constr_name = 'CASE WHEN "no_name_on_list" = 0 THEN "name_proposition" IS NULL ELSE "name_proposition" IS NOT NULL END'
        layer.setConstraintExpression(11, expr_constr_name)

        #picture_free field properties
        layer.setEditorWidgetSetup(12, attach)
        
        #herbivory_(percent) field properties
        layer.setEditorWidgetSetup(14, range)

        #soil_type field properties
        layer.setEditorWidgetSetup(16, form_soil)

        #weather field properties
        layer.setEditorWidgetSetup(17, form_weather)

        #Change picture naming for the five concerned fields for QField
        custom_property_key = "QFieldSync/attachment_naming"
        rename_1 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "sample_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_01.jpg'"
        rename_2 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "sample_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_02.jpg'"
        rename_3 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "sample_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_03.jpg'"
        rename_4 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "sample_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_04.jpg'"
        rename_5 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "sample_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_05.jpg'"
        rename_6 = "'DCIM/" + layer_name + "/'" + ' || (CASE WHEN "no_name_on_list" != 1 THEN "sample_name" ELSE "name_proposition" END) ||' + "'_'" + '|| "sample_id" ||' + "'_06.jpg'"
        custom_property_values = {
            "picture_panel": rename_1,
            "picture_general": rename_2,
            "picture_detail": rename_3,
            "picture_cut": rename_4,
            "picture_panel_label": rename_5,
            "picture_free": rename_6
        }
        custom_property_json = json.dumps(custom_property_values)
        layer.setCustomProperty(custom_property_key, custom_property_json)

        #Clean the form layout tab
        config = layer.editFormConfig()
        config.setLayout(1)
        layer.setEditFormConfig(config)
        root = config.invisibleRootContainer()
        root.clear()

        #Create sample metadata tab
        sample_metadata = QgsAttributeEditorContainer("sample metadata", root)

        #Define the fields
        sample_name = QgsAttributeEditorField("sample_name", 1, sample_metadata)
        no_name_on_list = QgsAttributeEditorField("no_name_on_list", 2, sample_metadata)
        if_no_name_list = QgsAttributeEditorContainer("if_no_name_list", sample_metadata) #create the if_no_name_list tab
        if_no_expression = QgsOptionalExpression(QgsExpression("no_name_on_list = 1")) #add the visibility expression
        if_no_name_list.setVisibilityExpression(if_no_expression)
        name_proposition = QgsAttributeEditorField("name_proposition", 3, if_no_name_list)
        sample_id = QgsAttributeEditorField("sample_id", 4, sample_metadata)
        pictures = QgsAttributeEditorContainer("pictures", sample_metadata)
        pictures_expression = QgsOptionalExpression(QgsExpression('regexp_match(to_string("sample_id"),' + "'dbgi_[0-9]{6}') AND " + '"sample_name" IS NOT NULL AND (if("no_name_on_list" = 1, "name_proposition" IS NOT NULL, TRUE))'))
        pictures.setVisibilityExpression(pictures_expression)
        picture_panel = QgsAttributeEditorField("picture_panel", 5, sample_metadata)
        picture_general = QgsAttributeEditorField("picture_general", 6, sample_metadata)
        picture_detail = QgsAttributeEditorField("picture_detail", 7, sample_metadata)
        picture_cut = QgsAttributeEditorField("picture_cut", 8, sample_metadata)
        picture_panel_label = QgsAttributeEditorField("picture_panel_label", 9, sample_metadata)
        picture_free = QgsAttributeEditorField("picture_free", 5, sample_metadata)
        
        #Construct the sample metadata tab structure
        sample_metadata.addChildElement(sample_name)
        sample_metadata.addChildElement(no_name_on_list)
        if_no_name_list.addChildElement(name_proposition)
        sample_metadata.addChildElement(if_no_name_list)
        sample_metadata.addChildElement(sample_id)
        pictures.addChildElement(picture_panel)
        pictures.addChildElement(picture_general)
        pictures.addChildElement(picture_detail)
        pictures.addChildElement(picture_cut)
        pictures.addChildElement(picture_panel_label)
        pictures.addChildElement(picture_free)
        sample_metadata.addChildElement(pictures)
        root.addChildElement(sample_metadata)

        #Create individual metadata tab
        individual_metadata = QgsAttributeEditorContainer("individual_metadata", root)
        ipen = QgsAttributeEditorField("ipen", 1, individual_metadata)
        herbivory = QgsAttributeEditorField("herbivory_(percent)", 2, individual_metadata)
        comment_eco = QgsAttributeEditorField("comment_eco", 3, individual_metadata)
        individual_metadata.addChildElement(ipen)
        individual_metadata.addChildElement(herbivory)
        individual_metadata.addChildElement(comment_eco)
        root.addChildElement(individual_metadata)

        #Create environmental metadata tab
        environmental_metadata = QgsAttributeEditorContainer("environmental metadata", root)
        soil = QgsAttributeEditorField("soil_type", 1, environmental_metadata)
        weather = QgsAttributeEditorField("weather", 2, environmental_metadata)
        temperature = QgsAttributeEditorField("temperature_(°C)", 3, environmental_metadata)
        comment_env = QgsAttributeEditorField("comment_env", 4, environmental_metadata)
        environmental_metadata.addChildElement(soil)
        environmental_metadata.addChildElement(weather)
        environmental_metadata.addChildElement(temperature)
        environmental_metadata.addChildElement(comment_env)
        root.addChildElement(environmental_metadata)
        layer.setEditFormConfig(config)