# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GpkgCreator
                                 A QGIS plugin
 Creates geopackages that match the requirements for the DBGI project
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-08
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Edouard Brülhart
        email                : edouard.bruelhart@unifr.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import *
from qgis.core import QgsVectorLayer, QgsProject, QgsRelation, QgsEditorWidgetSetup, QgsFieldConstraints, QgsDefaultValue, QgsPalLayerSettings, QgsVectorLayerSimpleLabeling
from qgis.gui import QgsMapLayerComboBox
from osgeo import ogr
import os
import json

def classFactory(iface):
    return GpkgCreator(iface)

#Creates the selection dialog for binomial nomenclature item
class LayerSelectionDialog(QDialog):
    def __init__(self, gpkg_name, parent=None):
        super(LayerSelectionDialog, self).__init__(parent)
        self.setWindowTitle("Select identification's layer")
        self.layout = QVBoxLayout()

        # Create a label for GPKG name
        self.gpkg_label = QLabel(f"GPKG name: {gpkg_name}")
        self.layout.addWidget(self.gpkg_label)

        # Create a label for layer selection
        self.label = QLabel("Select identification's layer:")
        self.layout.addWidget(self.label)

        # Create a layer combobox
        self.layer_combobox = QgsMapLayerComboBox()
        self.layout.addWidget(self.layer_combobox)

        # Create a label for field selection
        self.field_label = QLabel("Select identification's name column in the identification's layer:")
        self.layout.addWidget(self.field_label)

        # Create a field combobox
        self.field_combobox = QComboBox()
        self.layout.addWidget(self.field_combobox)

        # Create a button to confirm the selection
        self.button_ok = QPushButton("OK")
        self.button_ok.clicked.connect(self.accept)
        self.layout.addWidget(self.button_ok)

        self.setLayout(self.layout)

        # Connect the signal to update field combobox when layer selection changes
        self.layer_combobox.currentIndexChanged.connect(self.updateFieldComboBox)

    #Gives the selected binomial nomenclature item
    def selectedLayer(self):
        return self.layer_combobox.currentLayer()
    
    #Gives the selected binomial nomenclature item's field
    def selectedField(self):
        return self.field_combobox.currentText()
    
    def updateFieldComboBox(self):
        # Clear the field combobox
        self.field_combobox.clear()

        # Get the selected layer
        selected_layer = self.selectedLayer()
        if not selected_layer:
            return
        
        # Get the field names from the selected layer
        field_names = [field.name() for field in selected_layer.fields()]
        self.field_combobox.addItems(field_names)

class GpkgCreator:
    def __init__(self, iface):
        self.iface = iface

    def initGui(self):
        # create action that will start plugin configuration
        self.action = QAction(
                          "Create a DBGI geopackage",
                          self.iface.mainWindow())
        
        self.action.triggered.connect(self.run)

        # add toolbar button
        self.iface.addPluginToVectorMenu("&DBGI", self.action)

    def unload(self):
        # remove the toolbar button
        self.iface.removePluginVectorMenu("&DBGI", self.action)

    def run(self):
        # Ask user to enter the name of the GPKG and name of the plant list
        gpkg_name, ok = QInputDialog.getText(self.iface.mainWindow(), "GPKG name", "Enter the name of the GPKG:")
        if not ok or gpkg_name == "":
            return

        # Create the dialog to select a layer
        dialog = LayerSelectionDialog(gpkg_name)
        if dialog.exec_() != QDialog.Accepted:
            return

        # Get the selected layer from the dialog
        selected_layer = dialog.selectedLayer()
        selected_field = dialog.selectedField()
        if not selected_layer or not selected_field:
            return

        # Retrieve layer information
        plant_layer_id = selected_layer.id()
        
        # Stores the project's folder
        project_folder = QgsProject.instance().readPath("./")
        # Creates the gpkg's path
        gpkg_file = os.path.join(project_folder, gpkg_name + '.gpkg')
        gpkg_file = gpkg_file.replace("\\", "/")
        # Define the type gpkg for the layer
        driver = ogr.GetDriverByName('GPKG')
        # Creates the gpkg
        ds = driver.CreateDataSource(gpkg_file)
        # Sets the layer name (same as gpkg's name)
        layer_name = gpkg_name
        #sets the layer's srs
        project_crs = QgsProject.instance().crs()
        crs_wkt = project_crs.toWkt()
        srs = ogr.osr.SpatialReference()
        srs.ImportFromWkt(crs_wkt)
        #Sets the layer geometry type (here point)
        geom_type = ogr.wkbPoint
        #Creates the layer
        layer = ds.CreateLayer(layer_name, srs, geom_type)

        #Creation of the layer's fields
        field_def1 = ogr.FieldDefn("sample_name", ogr.OFTString)
        field_def1.SetWidth(200)
        layer.CreateField(field_def1)

        field_def2 = ogr.FieldDefn("sample_id", ogr.OFTString)
        field_def2.SetWidth(15)
        layer.CreateField(field_def2)

        field_def3 = ogr.FieldDefn("picture_panel", ogr.OFTString)
        field_def3.SetWidth(200)
        layer.CreateField(field_def3)

        field_def4 = ogr.FieldDefn("picture_general", ogr.OFTString)
        field_def4.SetWidth(200)
        layer.CreateField(field_def4)

        field_def5 = ogr.FieldDefn("picture_detail", ogr.OFTString)
        field_def5.SetWidth(200)
        layer.CreateField(field_def5)

        field_def6 = ogr.FieldDefn("picture_cut", ogr.OFTString)
        field_def6.SetWidth(200)
        layer.CreateField(field_def6)

        field_def7 = ogr.FieldDefn("picture_panel_label", ogr.OFTString)
        field_def7.SetWidth(200)
        layer.CreateField(field_def7)

        field_def8 = ogr.FieldDefn("x_coord", ogr.OFTReal)
        field_def8.SetPrecision(0)
        layer.CreateField(field_def8)

        field_def9 = ogr.FieldDefn("y_coord", ogr.OFTReal)
        field_def9.SetPrecision(0)
        layer.CreateField(field_def9)

        #Close the GeoPackage file
        ds = None

        # Load the GeoPackage file as a vector layer in QGIS
        imp_layer = QgsVectorLayer(gpkg_file + "|layername=" + layer_name, layer_name, "ogr")
        QgsProject.instance().addMapLayer(imp_layer)
       
        #Create association relation between binomial nomenclature layer and sample_name field
        imp_layer_id = imp_layer.id()
        imp_layer_field = "sample_name"
        relation = QgsRelation()
        relation.setReferencingLayer(imp_layer_id)
        relation.setReferencedLayer(plant_layer_id)
        relation.addFieldPair(imp_layer_field, selected_field)
        relation.setId(layer_name)
        relation.setName(layer_name)
        QgsProject.instance().relationManager().addRelation(relation)

        ##Defines the layer to change field properties
        layer = QgsProject.instance().mapLayer(imp_layer_id)
 
        #sample_name field properties
        layer.setFieldConstraint(1, QgsFieldConstraints.ConstraintNotNull) #loads the layer
        attach = QgsEditorWidgetSetup('ExternalResource', {}) #Defines attachment widget type

        #sample_id field properties
        expr_constr = 'regexp_match(to_string("sample_id"), \'dbgi_[0-9]{6}\')'
        layer.setFieldConstraint(2, QgsFieldConstraints.ConstraintNotNull)
        layer.setFieldConstraint(2, QgsFieldConstraints.ConstraintUnique)
        layer.setConstraintExpression(2, expr_constr)

        #picture_panel field properties
        layer.setFieldConstraint(3, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(3, attach)

        #picture_general field properties
        layer.setFieldConstraint(4, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(4, attach)

        #picture_detail field properties
        layer.setFieldConstraint(5, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(5, attach)

        #picture_cut field properties
        layer.setFieldConstraint(6, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(6, attach)

        #picture_panel_label field properties
        layer.setFieldConstraint(7, QgsFieldConstraints.ConstraintNotNull)
        layer.setEditorWidgetSetup(7, attach)

        #x_coord field properties
        coord_x = QgsDefaultValue("$x")
        layer.setDefaultValueDefinition(8, coord_x)

        #y_coord field properties
        coord_y = QgsDefaultValue("$y")
        layer.setDefaultValueDefinition(9, coord_y)

        #Change picture naming for the five concerned fields for QField
        custom_property_key = "QFieldSync/attachment_naming"
        rename_1 = "'DCIM/" + layer_name + "/' || sample_name || '_' || sample_id || '_' || '01' || '.jpg'"
        rename_2 = "'DCIM/" + layer_name + "/' || sample_name || '_' || sample_id || '_' || '02' || '.jpg'"
        rename_3 = "'DCIM/" + layer_name + "/' || sample_name || '_' || sample_id || '_' || '03' || '.jpg'"
        rename_4 = "'DCIM/" + layer_name + "/' || sample_name || '_' || sample_id || '_' || '04' || '.jpg'"
        rename_5 = "'DCIM/" + layer_name + "/' || sample_name || '_' || sample_id || '_' || '05' || '.jpg'"
        custom_property_values = {
            "picture_panel": rename_1,
            "picture_general": rename_2,
            "picture_detail": rename_3,
            "picture_cut": rename_4,
            "picture_panel_label": rename_5
        }
        custom_property_json = json.dumps(custom_property_values)
        layer.setCustomProperty(custom_property_key, custom_property_json)

        #Display label for the points
        label = QgsPalLayerSettings()
        label.fieldName = "sample_id"
        label.textcolor = QColor(0, 0, 0)
        label.placement = QgsPalLayerSettings.OverPoint
        layer.setLabelsEnabled(True)
        layer.setLabeling(QgsVectorLayerSimpleLabeling(label))

        #Show feature count
        root = QgsProject.instance().layerTreeRoot()
        layer_node = root.findLayer(imp_layer.id())
        layer_node.setCustomProperty("showFeatureCount", 1)