# -*- coding: utf-8 -*-

"""
/***************************************************************************
 GoogleStreetViewLayer
                                 A QGIS plugin
 A QGIS plugin that uses your road layer, and creates a layer or table with the most recent Google Street View capture data. Google API Key required!
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-04-04
        copyright            : (C) 2022 by Nathan Saylor
        email                : gisn8@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Nathan Saylor'
__date__ = '2022-04-04'
__copyright__ = '(C) 2022 by Nathan Saylor'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon

from qgis.core import QgsProcessingAlgorithm, QgsApplication
import processing

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .google_street_view_layer_provider import GoogleStreetViewLayerProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class GoogleStreetViewLayerPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = GoogleStreetViewLayerProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

        icon = os.path.join(os.path.join(cmd_folder, 'icon.png'))
        self.action = QAction(
            QIcon(icon),
            u"Google Street View Layer", self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        # self.iface.addPluginToMenu(u"&Google API Tools", self.action)
        self.iface.addPluginToWebMenu(u"&Google API Tools", self.action)
        self.iface.addToolBarIcon(self.action)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        # self.iface.removePluginMenu(u"&Google API Tools", self.action)
        self.iface.removePluginWebMenu(u"&Google API Tools", self.action)
        self.iface.removeToolBarIcon(self.action)

    def run(self):
        processing.execAlgorithmDialog("Web Tools:Google Street View Layer")
