"""
/***************************************************************************
 go2streetview
                                 A QGIS plugin
 Click to open Google Street View
                              -------------------
        begin                : 2014-02-15
        copyright            : (C) 2014 enrico ferreguti
        email                : enricofer@me.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtWebKit import *
from qgis.core import *
from qgis.utils import *
from qgis.gui import *
from PyQt4.QtNetwork import *


import resources
import webbrowser
import urllib
import string 

class go2streetview:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # reference to the canvas
        self.canvas = self.iface.mapCanvas()

        # click tools
        self.clickStreetviewTool = QgsMapToolEmitPoint(self.canvas)
        self.clickBingTool = QgsMapToolEmitPoint(self.canvas)


    def initGui(self):
        # Create actions that will start plugin configuration
        self.StreetviewAction = QAction(QIcon(":/plugins/go2streetview/icoStreetview.png"), \
            "Click to open Google Street View", self.iface.mainWindow())
        self.BingAction = QAction(QIcon(":/plugins/go2streetview/icoBing.png"), \
            "Click to open Bing Bird's Eye", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.StreetviewAction, SIGNAL("triggered()"), self.StreetviewRun)
        QObject.connect(self.BingAction, SIGNAL("triggered()"), self.BingRun)
        # connect signal that the canvas was clicked
        result = QObject.connect(self.clickStreetviewTool, SIGNAL("canvasClicked(const QgsPoint &, Qt::MouseButton)"), self.StreetviewPlace)
        result = QObject.connect(self.clickBingTool, SIGNAL("canvasClicked(const QgsPoint &, Qt::MouseButton)"), self.BingPlace)
        #QMessageBox.information( self.iface.mainWindow(),"Info", "connect = %s"%str(result) )

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.StreetviewAction)
        self.iface.addPluginToMenu("&Click to open Google Street View...", self.StreetviewAction)
        self.iface.addToolBarIcon(self.BingAction)
        self.iface.addPluginToMenu("&Click to open Bing Bird's Eye...", self.BingAction)
        
    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("&Click to open Google Street View...",self.StreetviewAction)
        self.iface.removeToolBarIcon(self.StreetviewAction)
        self.iface.removePluginMenu("&Click to open Bing Bird's Eye...",self.BingAction)
        self.iface.removeToolBarIcon(self.BingAction)

    def StreetviewPlace(self, point, button):
        pointWgs84 = self.transformToWGS84(point)
        gswUrl = "qrc:///plugins/go2streetview/g2sv.html?lat="+str(pointWgs84.y())+"&long="+str(pointWgs84.x())+"&width=600&height=360" 
        gswTitle = "Google Street View"
        self.place(gswUrl, gswTitle )

    def StreetviewRun(self):
        gsvMessage="Pick a point to display Google Street View in browser window"
        iface.mainWindow().statusBar().showMessage(gsvMessage)
        self.canvas.setMapTool(self.clickStreetviewTool)
        
    def BingPlace(self, point, button):
        pointWgs84 = self.transformToWGS84(point)
        bbeUrl = "http://dev.virtualearth.net/embeddedMap/v1/ajax/Birdseye?zoomLevel=17&center="+str(pointWgs84.y())+"_"+str(pointWgs84.x())+"&heading=0" 
        print bbeUrl
        bbeTitle = "Bing Bird's Eye"
        self.place(bbeUrl, bbeTitle )

    def BingRun(self):
        bbeMessage="Pick a point to display Bing Bird's Eye in browser window"
        iface.mainWindow().statusBar().showMessage(bbeMessage)
        self.canvas.setMapTool(self.clickBingTool)

    def transformToWGS84(self, pPoint):
        crcMappaCorrente = iface.mapCanvas().mapRenderer().destinationCrs() # get current crs
        crsSrc = crcMappaCorrente
        crsDest = QgsCoordinateReferenceSystem(4326)  # WGS 84
        xform = QgsCoordinateTransform(crsSrc, crsDest)
        return xform.transform(pPoint) # forward transformation: src -> dest

    # get the x,y
    def place(self, wUrl, wTitle ):
        diz = urllib.getproxies()
        print diz
        if diz != {}: # test if there are proxy settings
           proxyServer = diz["http"][7:]
           proxyIpAddress = proxyServer[ : string.find(proxyServer,":")]
           proxyPort = int(proxyServer[string.find(proxyServer,":")+1 : ])
           proxy = QNetworkProxy()
           proxy.setType(QNetworkProxy.HttpProxy)
           proxy.setHostName(proxyIpAddress)
           proxy.setPort(proxyPort)
           QNetworkProxy.setApplicationProxy(proxy)

        self.view = QWebView()
        self.view.resize(600, 360)
        self.view.setWindowTitle(wTitle)
        self.view.load(QUrl(wUrl))
        self.view.setContextMenuPolicy( Qt.CustomContextMenu )
        QObject.connect(self.view, SIGNAL('customContextMenuRequested(const QPoint&)'), self.onContextMenu)
        self.popMenu = QMenu()
        toolbar = QToolBar()
        self.popMenu.addAction(toolbar.addAction("ZOOOO", self.ActionItem))
        self.popMenu.addSeparator()
        self.view.show()

    def run(self, wMessage):
        iface.mainWindow().statusBar().showMessage(wMessage)
        self.canvas.setMapTool(self.clickTool)

    def onContextMenu(self, point):
         print "RIGHTCLICK"
         self.popMenu.exec_( self.view.mapToGlobal(point) )

    def ActionItem():
         print "ACTION1"

