# -*- coding: utf-8 -*-
"""
/***************************************************************************
 FindLocationDockWidget
                                 A QGIS plugin
 Navigate to location
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-06-30
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Torsten Wiebke, Gerrit Balindt
        email                : support@gruenecho.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal

from qgis.PyQt.QtWidgets import QScroller

from .setup.setup import Setup
from .setup.settings import Settings
from ..utils.utils import Utils
from .recording.toggle_buttons import ToggleButtons
from qgis.core import  QgsMessageLog

FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), 'gnavs_dockwidget_base.ui'))

class GnavsDockWidget(QtWidgets.QDockWidget, FORM_CLASS):
    """
    DockWidget class. 
    Sets up the main views (Setup() + Settings()) and navigation (ToggleButtons()) between view.
    """

    closingPlugin = pyqtSignal()

    def __init__(self, interface, parent=None):
        """Constructor."""

        QtWidgets.QDockWidget.__init__(self, interface.mainWindow())
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        scroll = QScroller.scroller(self.lfbScrollArea.viewport())
        scroll.grabGesture(self.lfbScrollArea.viewport(), QScroller.LeftMouseButtonGesture) # Add tablet scrolling support

        self.setupDevice = Setup(interface)
        self.setupDevice.measurementCountChanged.connect(self.lfbMeasurementCountChanged)
        self.geMainLayout.addWidget(self.setupDevice)

        self.Settings = Settings(interface)
        self.geMainLayout.addWidget(self.Settings)

        toggleButtons = ToggleButtons(interface)
        toggleButtons.change.connect(self.toggleButtonsChanged)
        self.lfbMenuBarLayout.insertWidget(0, toggleButtons)

        self.lfbAddToMapBtn.clicked.connect(self.addToMap)

        self.toHome()
        self.toggleButtonsChanged('navigation')

    def addToMap(self):
        """Add the recorded points to the map"""

        self.setupDevice.addDataToMap()
        self.lfbAddToMapBtn.setEnabled(False)

    def lfbMeasurementCountChanged(self, count):
        """Enable the add to map button if there are points to add"""

        meassurementSetting = Utils.getSetting('meassurementSetting', 100)
        progress = round(count / int(meassurementSetting) * 100)

        if progress >= 100:
            self.lfbAddToMapBtn.setEnabled(True)
        else:
            self.lfbAddToMapBtn.setEnabled(False)

    def toggleButtonsChanged(self, state):
        """Toggle between the home and settings view"""

        if state == 'settings':
            self.toSettings()
        else:
            self.toHome()

            if state == 'point':
                self.lfbAddToMapWidget.show()
            else:
                self.lfbAddToMapWidget.hide()

        self.setupDevice.toggleButtonsChanged(state)

    def toHome(self):
        """Show the Navigation / Point Recording view"""

        self.setupDevice.show()
        self.Settings.hide()

    
    def toSettings(self):
        """Show the Settings view"""

        self.setupDevice.hide()
        self.Settings.show()

    def closeEvent(self, event):
        """Run on close of the plugin"""
        
        Utils.removeLayer(['lfb-tmp-position', 'lfb-tmp-distance']) # Remove the temporary layers
        self.setupDevice.stopTracking() # Stop the tracking if it is running
       
        self.closingPlugin.emit()
        event.accept()