# -*- coding: utf-8 -*-
"""
/***************************************************************************
 sphereOpendata
                                 A QGIS plugin
 A plugin for query and adding API data from GISTDA sphere platform (https://sphere.gistda.or.th/).
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-12
        git sha              : $Format:%H$
        copyright            : (C) 2023 by GISTDA sphere
        email                : sphere@gistda.or.th
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QLineEdit, QFileDialog
from qgis.PyQt import *
from qgis.core import *
from urllib.request import urlopen
import json
from osgeo import ogr
import requests
import shapely.wkb
import shapely.wkt as wkt
from shapely.geometry import shape
from qgis.PyQt.QtCore import *
import webbrowser

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .gistda_sphere_opendata_dialog import sphereOpendataDialog
from .gistda_sphere_crop_dialog import CropDialog
from .gistda_sphere_disaster_dialog import DisasterDialog
from .gistda_sphere_elevation_dialog import ElevationDialog
from .gistda_sphere_geocoding_dialog import GeocodingDialog
import os.path


class sphereOpendata:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'sphereOpendata_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&GISTDA sphere open data')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        # define parameter for each menu dialog
        self.dlg = sphereOpendataDialog()
        self.dlgCrop = CropDialog()
        self.dlgDisaster = DisasterDialog()
        self.dlgElevation = ElevationDialog()
        self.dlgGeocoding = GeocodingDialog()

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('sphereOpendata', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=False,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_key = f'{self.plugin_dir}/key.png'
        icon_layer = f'{self.plugin_dir}/icon.png'
        
        # Menu 1 Input API key
        self.add_action(
            icon_key,
            text=self.tr(u'Input API key'),
            callback=self.runKey,
            parent=self.iface.mainWindow())
        
        # Menu 2 Crop feature
        self.add_action(
            icon_layer,
            text=self.tr(u'Crop information and suitability'),
            callback=self.runCrop,
            parent=self.iface.mainWindow())
        # Menu 2: Import layer from file when click '...' button
        self.dlgCrop.search_file.clicked.connect(self.importFileCrop)
        # Menu 2: Get API layers when click 'OK' button
        self.dlgCrop.button_box.accepted.connect(self.getCropAPI)
        
        # Menu 3 Disaster
        self.add_action(
            icon_layer,
            text=self.tr(u'Disaster recurring'),
            callback=self.runDisaster,
            parent=self.iface.mainWindow())
        # Menu 3: Import layer from file when click '...' button
        self.dlgDisaster.search_file.clicked.connect(self.importFileDisaster)
        # Menu 3: Select API
        api_list_disaster = ['Flood', 'Drought', 'Hotspot']
        self.dlgDisaster.API_list.addItems(api_list_disaster)
        # Menu 3: Get API layers when click 'OK' button
        self.dlgDisaster.button_box.accepted.connect(self.getDisasterRecurring)
        
        # Menu 4 Elevation
        self.add_action(
            icon_layer,
            text=self.tr(u'Elevation'),
            callback=self.runElevation,
            parent=self.iface.mainWindow())
        # Menu 4: Import layer from file when click '...' button 
        self.dlgElevation.search_file.clicked.connect(self.importFileElevation)
        # Menu 4: Get API layers when click 'OK' button
        self.dlgElevation.button_box.accepted.connect(self.getElevation)
        
        # Menu 5 Reverse geocoding
        self.add_action(
            icon_layer,
            text=self.tr(u'Reverse geocoding'),
            callback=self.runGeocoding,
            parent=self.iface.mainWindow())
        # Menu 5: Import layer from file when click '...' button (This was putted here to solve the opening problem)
        self.dlgGeocoding.search_file.clicked.connect(self.importFileGeocoding)
        # Menu 5: Get API layers when click 'OK' button
        self.dlgGeocoding.button_box.accepted.connect(self.getGeocoding)

        # will be set False in run()
        self.first_start = True

    # Operating function for menu1: input key
    def inputAPIkey(self):
        valueKey = self.dlg.lineEdit.text()
        # messagePopup = "Your key '" + valueKey + "' were added"
        mss = "Success! Your API key were added."
        emptyKey = "API key value still empty."
        if valueKey == '':
            self.iface.messageBar().pushMessage(emptyKey, level=Qgis.Info)
        else:
            self.iface.messageBar().pushMessage(mss, level=Qgis.Success)
    
    # Sign-up for getting a key
    def signUpForKey(self):
        signUpURL = 'https://auth.sphere.gistda.or.th/auth/realms/sphere/protocol/openid-connect/registrations?client_id=frontend-iframe&redirect_uri=https%3A%2F%2Fsphere.gistda.or.th%2Fdashboard&state=2fdbcbfb-493f-4b8d-ab4b-f693002ab78a&response_mode=fragment&response_type=code&scope=openid&nonce=43abe85b-4651-4251-9f64-8b0876d30f02&ui_locales=th'
        webbrowser.open(signUpURL)

    #########################################################################################################################################################################################################
    # Operating function for menu 2: crop feature
    # Check what user select for input shapefile
    def checkSelectCrop(self):
        if self.dlgCrop.select_current.isChecked():
            self.dlgCrop.comboBox.setEnabled(True)
            self.dlgCrop.file_import.setEnabled(False)
            self.dlgCrop.search_file.setEnabled(False)
        else:
            self.dlgCrop.comboBox.setEnabled(False)
            self.dlgCrop.file_import.setEnabled(True)
            self.dlgCrop.search_file.setEnabled(True)

    # If user select for import shapefile
    def importFileCrop(self):
        filename, _filter = QFileDialog.getOpenFileName(
            self.dlgCrop, "Open file", '*.shp')
        self.dlgCrop.file_import.setText(filename)

    # Get select layer and notify the input layer which user selected
    def checkSelectLayerCrop(self):
        layerCurrent = self.dlgCrop.comboBox.currentText()
        file_import = self.dlgCrop.file_import.text()
        if file_import == '':
            self.iface.messageBar().pushMessage(layerCurrent, level=Qgis.Info)
        else:
            self.iface.messageBar().pushMessage(file_import, level=Qgis.Info)

    # Query and get crop data (crop information and crop suitability)
    def getCropAPI(self):
        valueKey = self.dlg.lineEdit.text()
        layer_name = self.dlgCrop.comboBox.currentText()
        file_path = self.dlgCrop.file_import.text()
        file_layer = QgsVectorLayer(file_path, "import_file", "ogr")
        current_layer = QgsProject.instance().mapLayersByName(layer_name)
        api_selected = self.dlgCrop.API_list_crop.currentText()
        #self.iface.messageBar().pushMessage(api_selected, level=Qgis.Info)

        # Crop suitability selected
        if api_selected == 'Crop suitability':
            # Crop suitability: Import layer from current project
            if self.dlgCrop.select_current.isChecked() == True and self.dlgCrop.select_file.isChecked() == False and self.dlgCrop.comboBox.currentText() != '':
                check_num_of_features = current_layer[0].featureCount() 
                
                # Show error message if point feature > 1000
                if check_num_of_features > 1000:
                    self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
                else:
                    # Prepare API layer for instance
                    API_layer = QgsVectorLayer(
                        "Point?csr=epsg:4326", "sphere crop suitability", 'memory')
                    QgsProject.instance().addMapLayer(API_layer)

                    # Access features of layer
                    feature = current_layer[0].getFeatures()
                    num_of_features = 0

                    for f in feature:
                        # Get coordinate of point
                        geom = f.geometry()
                        latitude = geom.asPoint().y()
                        longitude = geom.asPoint().x()
                        coor = latitude, longitude
                        num_of_features += 1
                        # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                        # Get API data from feature point
                        url = "https://api.sphere.gistda.or.th/services/info/land-suitability?lat=" + \
                            str(latitude) + "&lon=" + \
                            str(longitude) + "&key=" + valueKey
                        re = requests.get(url)
                        data = re.json()
                        # keys = [type, suitability, price, cost]

                        # Create vector layer
                        API_layer.startEditing()
                        location = QgsGeometry()
                        location = QgsGeometry.fromPointXY(
                            QgsPointXY(longitude, latitude))
                        feat = QgsFeature()
                        feat.setGeometry(location)
                        API_layer.dataProvider().addFeatures([feat])
                        API_layer.commitChanges()

                        # Create fields
                        layer = QgsProject.instance().mapLayersByName('sphere crop suitability')
                        pr = layer[0].dataProvider()
                        pr.addAttributes(
                            [QgsField("id", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("rice", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("maize", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("sugarcane", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("cassava", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("rubber", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("palm", QVariant.String, "text", 254)])

                        layer[0].updateFields()

                        # Add field value
                        id_idx = layer[0].fields().lookupField('id')
                        rice_idx = layer[0].fields().lookupField('rice')
                        maize_idx = layer[0].fields().lookupField('maize')
                        sugarcane_idx = layer[0].fields().lookupField('sugarcane')
                        cassava_idx = layer[0].fields().lookupField('cassava')
                        rubber_idx = layer[0].fields().lookupField('rubber')
                        palm_idx = layer[0].fields().lookupField('palm')

                        # self.iface.messageBar().pushMessage(str(len(data)), level=Qgis.Info)
                        result_list = []
                        for num in range(len(data)):
                            item = data[num]
                            result_list.append(item['suitability'])

                        atts = {id_idx: num_of_features, rice_idx: result_list[0], maize_idx: result_list[1], sugarcane_idx: result_list[
                            2], cassava_idx: result_list[3], rubber_idx: result_list[4], palm_idx: result_list[5]}
                        feats = layer[0].getFeature(num_of_features)
                        pr.changeAttributeValues({feats.id(): atts})
                        # self.iface.messageBar().pushMessage("finished run test!", level=Qgis.Info)
                        self.iface.messageBar().pushMessage(
                            "Success! Your 'Crop suitability' layer was created.", level=Qgis.Success)

                    message_instance = 'Creating layer from ' + layer_name
                    self.iface.messageBar().pushMessage(message_instance, level=Qgis.Info)

            # Crop suitability: Import layer from file
            elif self.dlgCrop.select_file.isChecked() == True and self.dlgCrop.select_current.isChecked() == False and self.dlgCrop.file_import.text() != '':
                check_num_of_features = file_layer.featureCount()  

                # Show error message if point feature > 1000
                if check_num_of_features > 1000:
                    self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
                else:
                    # Prepare API layer for instance
                    API_layer = QgsVectorLayer(
                        "Point?csr=epsg:4326", "sphere crop suitability", 'memory')
                    QgsProject.instance().addMapLayer(API_layer)

                    # Access features of layer
                    feature = file_layer.getFeatures()
                    num_of_features = 0

                    for f in feature:
                        # Get coordinate of point
                        geom = f.geometry()
                        latitude = geom.asPoint().y()
                        longitude = geom.asPoint().x()
                        coor = latitude, longitude
                        num_of_features += 1
                        # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                        # Get API data from feature point
                        url = "https://api.sphere.gistda.or.th/services/info/land-suitability?lat=" + \
                            str(latitude) + "&lon=" + \
                            str(longitude) + "&key=" + valueKey
                        re = requests.get(url)
                        data = re.json()
                        # keys = [type, suitability, price, cost]

                        # Create vector layer
                        API_layer.startEditing()
                        location = QgsGeometry()
                        location = QgsGeometry.fromPointXY(
                            QgsPointXY(longitude, latitude))
                        feat = QgsFeature()
                        feat.setGeometry(location)
                        API_layer.dataProvider().addFeatures([feat])
                        API_layer.commitChanges()

                        # Create fields
                        layer = QgsProject.instance().mapLayersByName('sphere crop suitability')
                        pr = layer[0].dataProvider()
                        pr.addAttributes(
                            [QgsField("id", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("rice", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("maize", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("sugarcane", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("cassava", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("rubber", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("palm", QVariant.String, "text", 254)])
                        layer[0].updateFields()

                        # Add field value
                        id_idx = layer[0].fields().lookupField('id')
                        rice_idx = layer[0].fields().lookupField('rice')
                        maize_idx = layer[0].fields().lookupField('maize')
                        sugarcane_idx = layer[0].fields().lookupField('sugarcane')
                        cassava_idx = layer[0].fields().lookupField('cassava')
                        rubber_idx = layer[0].fields().lookupField('rubber')
                        palm_idx = layer[0].fields().lookupField('palm')

                        # self.iface.messageBar().pushMessage(str(len(data)), level=Qgis.Info)
                        result_list = []
                        if len(data) > 0:
                            for num in range(len(data)):
                                item = data[num]
                                result_list.append(item['suitability'])
                        else:
                            result_list.append('ไม่พบข้อมูล')

                        atts = {id_idx: num_of_features, rice_idx: result_list[0], maize_idx: result_list[1], sugarcane_idx: result_list[
                            2], cassava_idx: result_list[3], rubber_idx: result_list[4], palm_idx: result_list[5]}
                        feats = layer[0].getFeature(num_of_features)
                        pr.changeAttributeValues({feats.id(): atts})
                        # self.iface.messageBar().pushMessage("finished run test!", level=Qgis.Info)
                        self.iface.messageBar().pushMessage(
                            "Success! Your 'Crop suitability' layer was created.", level=Qgis.Success)

                    message_path = 'Creating layer from ' + file_path
                    self.iface.messageBar().pushMessage(message_path, level=Qgis.Info)
            
            # Crop suitability: No layer was imported
            else:
                self.iface.messageBar().pushMessage(
                    "Please try again. No data of point or area layer.", level=Qgis.Warning)

        # Crop information selected
        else:
            # Crop information: Import layer from current project
            if self.dlgCrop.select_current.isChecked() == True and self.dlgCrop.select_file.isChecked() == False and self.dlgCrop.comboBox.currentText() != '':
                check_num_of_features = current_layer[0].featureCount()  

                # Show error message if point feature > 1000
                if check_num_of_features > 1000:
                    self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
                else:
                    # Prepare API layer for instance
                    API_layer = QgsVectorLayer(
                        "Point?csr=epsg:4326", "sphere crop information", 'memory')
                    QgsProject.instance().addMapLayer(API_layer)

                    # Access features of layer
                    feature = current_layer[0].getFeatures()
                    num_of_features = 0

                    for f in feature:
                        # Get coordinate of point
                        geom = f.geometry()
                        latitude = geom.asPoint().y()
                        longitude = geom.asPoint().x()
                        coor = latitude, longitude
                        num_of_features += 1
                        # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                        # Get API data from feature point
                        url = "https://api.sphere.gistda.or.th/services/info/crop?lat=" + \
                            str(latitude) + "&lon=" + \
                            str(longitude) + "&key=" + valueKey
                        re = requests.get(url)
                        data = re.json()
                        # keys = [type, suitability, price, cost]

                        # Create vector layer
                        API_layer.startEditing()
                        location = QgsGeometry()
                        location = QgsGeometry.fromPointXY(
                            QgsPointXY(longitude, latitude))
                        feat = QgsFeature()
                        feat.setGeometry(location)
                        API_layer.dataProvider().addFeatures([feat])
                        API_layer.commitChanges()

                        # Create fields
                        layer = QgsProject.instance().mapLayersByName('sphere crop information')
                        pr = layer[0].dataProvider()
                        pr.addAttributes(
                            [QgsField("id", QVariant.String, "text", 254)])
                        pr.addAttributes([QgsField("cost_rice", QVariant.Double)])
                        pr.addAttributes([QgsField("cost_maize", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("cost_sugarcane", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("cost_cassava", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("cost_rubber", QVariant.Double)])
                        pr.addAttributes([QgsField("cost_palm", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMin_rice", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMin_maize", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMin_sugarcane", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMin_cassava", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMin_rubber", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMin_palm", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMax_rice", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMax_maize", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMax_sugarcane", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMax_cassava", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMax_rubber", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMax_palm", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceDate_rice", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("priceDate_maize", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("priceDate_sugarcane", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("priceDate_cassava", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("priceDate_rubber", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("priceDate_palm", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("areaRai_rice", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("areaRai_maize", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("areaRai_sugarcane", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("areaRai_cassava", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("areaRai_rubber", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("areaRai_palm", QVariant.Double)])
                        layer[0].updateFields()

                        # Add field value
                        id_idx = layer[0].fields().lookupField('id')
                        costRice_idx = layer[0].fields().lookupField('cost_rice')
                        costMaize_idx = layer[0].fields().lookupField('cost_maize')
                        costSugarcane_idx = layer[0].fields(
                        ).lookupField('cost_sugarcane')
                        costCassava_idx = layer[0].fields(
                        ).lookupField('cost_cassava')
                        costRubber_idx = layer[0].fields(
                        ).lookupField('cost_rubber')
                        costPalm_idx = layer[0].fields().lookupField('cost_palm')
                        priceMinRice_idx = layer[0].fields(
                        ).lookupField('priceMin_rice')
                        priceMinMaize_idx = layer[0].fields(
                        ).lookupField('priceMin_maize')
                        priceMinSugarcane_idx = layer[0].fields(
                        ).lookupField('priceMin_sugarcane')
                        priceMinCassava_idx = layer[0].fields(
                        ).lookupField('priceMin_cassava')
                        priceMinRubber_idx = layer[0].fields(
                        ).lookupField('priceMin_rubber')
                        priceMinPalm_idx = layer[0].fields(
                        ).lookupField('priceMin_palm')
                        priceMaxRice_idx = layer[0].fields(
                        ).lookupField('priceMax_rice')
                        priceMaxMaize_idx = layer[0].fields(
                        ).lookupField('priceMax_maize')
                        priceMaxSugarcane_idx = layer[0].fields(
                        ).lookupField('priceMax_sugarcane')
                        priceMaxCassava_idx = layer[0].fields(
                        ).lookupField('priceMax_cassava')
                        priceMaxRubber_idx = layer[0].fields(
                        ).lookupField('priceMax_rubber')
                        priceMaxPalm_idx = layer[0].fields(
                        ).lookupField('priceMax_palm')
                        priceDateRice_idx = layer[0].fields(
                        ).lookupField('priceDate_rice')
                        priceDateMaize_idx = layer[0].fields(
                        ).lookupField('priceDate_maize')
                        priceDateSugarcane_idx = layer[0].fields(
                        ).lookupField('priceDate_sugarcane')
                        priceDateCassava_idx = layer[0].fields(
                        ).lookupField('priceDate_cassava')
                        priceDateRubber_idx = layer[0].fields(
                        ).lookupField('priceDate_rubber')
                        priceDatePalm_idx = layer[0].fields(
                        ).lookupField('priceDate_palm')
                        areaRaiRice_idx = layer[0].fields(
                        ).lookupField('areaRai_rice')
                        areaRaiMaize_idx = layer[0].fields(
                        ).lookupField('areaRai_maize')
                        areaRaiSugarcane_idx = layer[0].fields(
                        ).lookupField('areaRai_sugarcane')
                        areaRaiCassava_idx = layer[0].fields(
                        ).lookupField('areaRai_cassava')
                        areaRaiRubber_idx = layer[0].fields(
                        ).lookupField('areaRai_rubber')
                        areaRaiPalm_idx = layer[0].fields(
                        ).lookupField('areaRai_palm')

                        # Cost
                        cost_rice = data['majorrice']['cost']
                        cost_maize = data['maize']['cost']
                        cost_sugarcane = data['sugarcane']['cost']
                        cost_cassava = data['cassava']['cost']
                        cost_rubber = data['rubber']['cost']
                        cost_palm = data['palm']['cost']

                        # Date and year
                        if data['majorrice']['date'] != []:
                            date_rice = data['majorrice']['date'][len(
                                data['majorrice']['date']) - 1]
                        else:
                            date_rice = ''
                        if data['maize']['date'] != []:
                            date_maize = data['maize']['date'][len(
                                data['maize']['date']) - 1]
                        else:
                            date_maize = ''
                        if data['sugarcane']['date'] != []:
                            date_sugarcane = data['sugarcane']['date'][len(
                                data['sugarcane']['date']) - 1]
                        else:
                            date_sugarcane = ''
                        if data['cassava']['date']:
                            date_cassava = data['cassava']['date'][len(
                                data['cassava']['date']) - 1]
                        else:
                            date_cassava = ''
                        if data['rubber']['year']:
                            year_rubber = data['rubber']['year'][len(
                                data['rubber']['year']) - 1]
                        else:
                            year_rubber = ''
                        if data['palm']['year']:
                            year_palm = data['palm']['year'][len(
                                data['palm']['year']) - 1]
                        else:
                            year_palm = ''

                        # Area (rai)
                        rai_rice = data['majorrice']['rai']
                        rai_maize = data['maize']['rai']
                        rai_sugarcane = data['sugarcane']['rai']
                        rai_cassava = data['cassava']['rai']
                        rai_rubber = data['rubber']['rai']
                        rai_palm = data['palm']['rai']

                        # Prices
                        # if len(data['majorrice']['price']) > 0:
                        if str(data['majorrice']['price']) == '[]':
                            price_rice_date = 'ไม่พบข้อมูล'
                            price_rice_min = 0
                            price_rice_max = 0
                        else:
                            # txt1 = "rice = " + str(data['majorrice']['price'])
                            # self.iface.messageBar().pushMessage(txt1, level=Qgis.Info)
                            price_rice_date = data['majorrice']['price'][0]['date'].replace(
                                "T00:00:00", "")
                            price_rice_min = data['majorrice']['price'][0]['price_max']
                            price_rice_max = data['majorrice']['price'][0]['price_max']

                        # if len(data['maize']['price']) > 0:
                        if str(data['maize']['price']) == '[]':
                            price_maize_date = 'ไม่พบข้อมูล'
                            price_maize_min = 0
                            price_maize_max = 0
                        else:
                            # txt2 = "maize = " + str(data['maize']['price'])
                            # self.iface.messageBar().pushMessage(txt2, level=Qgis.Info)
                            price_maize_date = data['maize']['price'][0]['date'].replace(
                                "T00:00:00", "")
                            price_maize_min = data['maize']['price'][0]['price_min']
                            price_maize_max = data['maize']['price'][0]['price_max']

                        # if len(data['sugarcane']['price']) > 0:
                        if str(data['sugarcane']['price']) == '[]':
                            price_sugarcane_date = 'ไม่พบข้อมูล'
                            price_sugarcane_min = 0
                            price_sugarcane_max = 0
                        else:
                            # txt3 = "sugarcane = " + str(data['sugarcane']['price'])
                            # self.iface.messageBar().pushMessage(txt3, level=Qgis.Info)
                            price_sugarcane_date = data['sugarcane']['price'][0]['date'].replace(
                                "T00:00:00", "")
                            price_sugarcane_min = data['sugarcane']['price'][0]['price_min']
                            price_sugarcane_max = data['sugarcane']['price'][0]['price_max']

                        # if len(data['cassava']['price']) > 0:
                        if str(data['cassava']['price']) == '[]':
                            price_cassava_date = 'ไม่พบข้อมูล'
                            price_cassava_min = 0
                            price_cassava_max = 0
                        else:
                            # txt4 = "cassava = " + str(data['cassava']['price'])
                            # self.iface.messageBar().pushMessage(txt4, level=Qgis.Info)
                            price_cassava_date = data['cassava']['price'][0]['date'].replace(
                                "T00:00:00", "")
                            price_cassava_min = data['cassava']['price'][0]['price_min']
                            price_cassava_max = data['cassava']['price'][0]['price_max']

                        # if len(data['rubber']['price']) > 0:
                        if str(data['rubber']['price']) == '[]':
                            price_rubber_date = 'ไม่พบข้อมูล'
                            price_rubber_min = 0
                            price_rubber_max = 0
                        else:
                            # txt5 = "rubber = " + str(data['rubber']['price'])
                            # self.iface.messageBar().pushMessage(txt5, level=Qgis.Info)
                            price_rubber_date = data['rubber']['price'][0]['date'].replace(
                                "T00:00:00", "")
                            price_rubber_min = data['rubber']['price'][0]['price_min']
                            price_rubber_max = data['rubber']['price'][0]['price_max']

                        # if len(data['palm']['price']) > 0:
                        if str(data['palm']['price']) == '[]':
                            price_palm_date = 'ไม่พบข้อมูล'
                            price_palm_min = 0
                            price_palm_max = 0
                        else:
                            # txt6 = "palm = " + str(data['palm']['price'])
                            # self.iface.messageBar().pushMessage(txt6, level=Qgis.Info)
                            price_palm_date = data['palm']['price'][0]['date'].replace(
                                "T00:00:00", "")
                            price_palm_min = data['palm']['price'][0]['price_min']
                            price_palm_max = data['palm']['price'][0]['price_max']

                        # self.iface.messageBar().pushMessage(str(data['majorrice']['price']), level=Qgis.Info)

                        atts = {id_idx: num_of_features,
                                costRice_idx: cost_rice,
                                costMaize_idx: cost_maize,
                                costSugarcane_idx: cost_sugarcane,
                                costCassava_idx: cost_cassava,
                                costRubber_idx: cost_rubber,
                                costPalm_idx: cost_palm,
                                priceMinRice_idx: price_rice_min,
                                priceMinMaize_idx: price_maize_min,
                                priceMinSugarcane_idx: price_sugarcane_min,
                                priceMinCassava_idx: price_cassava_min,
                                priceMinRubber_idx: price_rubber_min,
                                priceMinPalm_idx: price_palm_min,
                                priceMaxRice_idx: price_rice_max,
                                priceMaxMaize_idx: price_maize_max,
                                priceMaxSugarcane_idx: price_sugarcane_max,
                                priceMaxCassava_idx: price_cassava_max,
                                priceMaxRubber_idx: price_rubber_max,
                                priceMaxPalm_idx: price_palm_max,
                                priceDateRice_idx: price_rice_date,
                                priceDateMaize_idx: price_maize_date,
                                priceDateSugarcane_idx: price_sugarcane_date,
                                priceDateCassava_idx: price_cassava_date,
                                priceDateRubber_idx: price_rubber_date,
                                priceDatePalm_idx: price_palm_date,
                                areaRaiRice_idx: rai_rice,
                                areaRaiMaize_idx: rai_maize,
                                areaRaiSugarcane_idx: rai_sugarcane,
                                areaRaiCassava_idx: rai_cassava,
                                areaRaiRubber_idx: rai_rubber,
                                areaRaiPalm_idx: rai_palm,
                                }
                        feats = layer[0].getFeature(num_of_features)
                        pr.changeAttributeValues({feats.id(): atts})
                        # self.iface.messageBar().pushMessage("finished run test!", level=Qgis.Info)
                        self.iface.messageBar().pushMessage(
                            "Success! Your 'Crop information' layer was created.", level=Qgis.Success)
                    
                    message_instance = 'Creating layer from ' + layer_name
                    self.iface.messageBar().pushMessage(message_instance, level=Qgis.Info)

            # Crop information: Import layer from file
            elif self.dlgCrop.select_file.isChecked() == True and self.dlgCrop.select_current.isChecked() == False and self.dlgCrop.file_import.text() != '':
                check_num_of_features = file_layer.featureCount()  

                # Show error message if point feature > 1000
                if check_num_of_features > 1000:
                    self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
                else:
                    # Prepare API layer for instance
                    API_layer = QgsVectorLayer(
                        "Point?csr=epsg:4326", "sphere crop information", 'memory')
                    QgsProject.instance().addMapLayer(API_layer)

                    # Access features of layer
                    feature = file_layer.getFeatures()
                    num_of_features = 0

                    for f in feature:
                        # Get coordinate of point
                        geom = f.geometry()
                        latitude = geom.asPoint().y()
                        longitude = geom.asPoint().x()
                        coor = latitude, longitude
                        num_of_features += 1
                        # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                        # Get API data from feature point
                        url = "https://api.sphere.gistda.or.th/services/info/crop?lat=" + \
                            str(latitude) + "&lon=" + \
                            str(longitude) + "&key=" + valueKey
                        re = requests.get(url)
                        data = re.json()
                        # keys = [type, suitability, price, cost]

                        # Create vector layer
                        API_layer.startEditing()
                        location = QgsGeometry()
                        location = QgsGeometry.fromPointXY(
                            QgsPointXY(longitude, latitude))
                        feat = QgsFeature()
                        feat.setGeometry(location)
                        API_layer.dataProvider().addFeatures([feat])
                        API_layer.commitChanges()

                        # Create fields
                        layer = QgsProject.instance().mapLayersByName('sphere crop information')
                        pr = layer[0].dataProvider()
                        pr.addAttributes(
                            [QgsField("id", QVariant.String, "text", 254)])
                        pr.addAttributes([QgsField("cost_rice", QVariant.Double)])
                        pr.addAttributes([QgsField("cost_maize", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("cost_sugarcane", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("cost_cassava", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("cost_rubber", QVariant.Double)])
                        pr.addAttributes([QgsField("cost_palm", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMin_rice", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMin_maize", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMin_sugarcane", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMin_cassava", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMin_rubber", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMin_palm", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMax_rice", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMax_maize", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMax_sugarcane", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMax_cassava", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMax_rubber", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceMax_palm", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("priceDate_rice", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("priceDate_maize", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("priceDate_sugarcane", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("priceDate_cassava", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("priceDate_rubber", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("priceDate_palm", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("areaRai_rice", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("areaRai_maize", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("areaRai_sugarcane", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("areaRai_cassava", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("areaRai_rubber", QVariant.Double)])
                        pr.addAttributes(
                            [QgsField("areaRai_palm", QVariant.Double)])
                        layer[0].updateFields()

                        # Add field value
                        id_idx = layer[0].fields().lookupField('id')
                        costRice_idx = layer[0].fields().lookupField('cost_rice')
                        costMaize_idx = layer[0].fields().lookupField('cost_maize')
                        costSugarcane_idx = layer[0].fields(
                        ).lookupField('cost_sugarcane')
                        costCassava_idx = layer[0].fields(
                        ).lookupField('cost_cassava')
                        costRubber_idx = layer[0].fields(
                        ).lookupField('cost_rubber')
                        costPalm_idx = layer[0].fields().lookupField('cost_palm')
                        priceMinRice_idx = layer[0].fields(
                        ).lookupField('priceMin_rice')
                        priceMinMaize_idx = layer[0].fields(
                        ).lookupField('priceMin_maize')
                        priceMinSugarcane_idx = layer[0].fields(
                        ).lookupField('priceMin_sugarcane')
                        priceMinCassava_idx = layer[0].fields(
                        ).lookupField('priceMin_cassava')
                        priceMinRubber_idx = layer[0].fields(
                        ).lookupField('priceMin_rubber')
                        priceMinPalm_idx = layer[0].fields(
                        ).lookupField('priceMin_palm')
                        priceMaxRice_idx = layer[0].fields(
                        ).lookupField('priceMax_rice')
                        priceMaxMaize_idx = layer[0].fields(
                        ).lookupField('priceMax_maize')
                        priceMaxSugarcane_idx = layer[0].fields(
                        ).lookupField('priceMax_sugarcane')
                        priceMaxCassava_idx = layer[0].fields(
                        ).lookupField('priceMax_cassava')
                        priceMaxRubber_idx = layer[0].fields(
                        ).lookupField('priceMax_rubber')
                        priceMaxPalm_idx = layer[0].fields(
                        ).lookupField('priceMax_palm')
                        priceDateRice_idx = layer[0].fields(
                        ).lookupField('priceDate_rice')
                        priceDateMaize_idx = layer[0].fields(
                        ).lookupField('priceDate_maize')
                        priceDateSugarcane_idx = layer[0].fields(
                        ).lookupField('priceDate_sugarcane')
                        priceDateCassava_idx = layer[0].fields(
                        ).lookupField('priceDate_cassava')
                        priceDateRubber_idx = layer[0].fields(
                        ).lookupField('priceDate_rubber')
                        priceDatePalm_idx = layer[0].fields(
                        ).lookupField('priceDate_palm')
                        areaRaiRice_idx = layer[0].fields(
                        ).lookupField('areaRai_rice')
                        areaRaiMaize_idx = layer[0].fields(
                        ).lookupField('areaRai_maize')
                        areaRaiSugarcane_idx = layer[0].fields(
                        ).lookupField('areaRai_sugarcane')
                        areaRaiCassava_idx = layer[0].fields(
                        ).lookupField('areaRai_cassava')
                        areaRaiRubber_idx = layer[0].fields(
                        ).lookupField('areaRai_rubber')
                        areaRaiPalm_idx = layer[0].fields(
                        ).lookupField('areaRai_palm')

                        # Cost
                        cost_rice = data['majorrice']['cost']
                        cost_maize = data['maize']['cost']
                        cost_sugarcane = data['sugarcane']['cost']
                        cost_cassava = data['cassava']['cost']
                        cost_rubber = data['rubber']['cost']
                        cost_palm = data['palm']['cost']

                        # Date and year
                        if data['majorrice']['date'] != []:
                            date_rice = data['majorrice']['date'][len(
                                data['majorrice']['date']) - 1]
                        else:
                            date_rice = ''
                        if data['maize']['date'] != []:
                            date_maize = data['maize']['date'][len(
                                data['maize']['date']) - 1]
                        else:
                            date_maize = ''
                        if data['sugarcane']['date'] != []:
                            date_sugarcane = data['sugarcane']['date'][len(
                                data['sugarcane']['date']) - 1]
                        else:
                            date_sugarcane = ''
                        if data['cassava']['date']:
                            date_cassava = data['cassava']['date'][len(
                                data['cassava']['date']) - 1]
                        else:
                            date_cassava = ''
                        if data['rubber']['year']:
                            year_rubber = data['rubber']['year'][len(
                                data['rubber']['year']) - 1]
                        else:
                            year_rubber = ''
                        if data['palm']['year']:
                            year_palm = data['palm']['year'][len(
                                data['palm']['year']) - 1]
                        else:
                            year_palm = ''

                        # Area (rai)
                        rai_rice = data['majorrice']['rai']
                        rai_maize = data['maize']['rai']
                        rai_sugarcane = data['sugarcane']['rai']
                        rai_cassava = data['cassava']['rai']
                        rai_rubber = data['rubber']['rai']
                        rai_palm = data['palm']['rai']

                        # Prices
                        # if len(data['majorrice']['price']) > 0:
                        if str(data['majorrice']['price']) == '[]':
                            price_rice_date = 'ไม่พบข้อมูล'
                            price_rice_min = 0
                            price_rice_max = 0
                        else:
                            # txt1 = "rice = " + str(data['majorrice']['price'])
                            # self.iface.messageBar().pushMessage(txt1, level=Qgis.Info)
                            price_rice_date = data['majorrice']['price'][0]['date'].replace(
                                "T00:00:00", "")
                            price_rice_min = data['majorrice']['price'][0]['price_max']
                            price_rice_max = data['majorrice']['price'][0]['price_max']

                        # if len(data['maize']['price']) > 0:
                        if str(data['maize']['price']) == '[]':
                            price_maize_date = 'ไม่พบข้อมูล'
                            price_maize_min = 0
                            price_maize_max = 0
                        else:
                            # txt2 = "maize = " + str(data['maize']['price'])
                            # self.iface.messageBar().pushMessage(txt2, level=Qgis.Info)
                            price_maize_date = data['maize']['price'][0]['date'].replace(
                                "T00:00:00", "")
                            price_maize_min = data['maize']['price'][0]['price_min']
                            price_maize_max = data['maize']['price'][0]['price_max']

                        # if len(data['sugarcane']['price']) > 0:
                        if str(data['sugarcane']['price']) == '[]':
                            price_sugarcane_date = 'ไม่พบข้อมูล'
                            price_sugarcane_min = 0
                            price_sugarcane_max = 0
                        else:
                            # txt3 = "sugarcane = " + str(data['sugarcane']['price'])
                            # self.iface.messageBar().pushMessage(txt3, level=Qgis.Info)
                            price_sugarcane_date = data['sugarcane']['price'][0]['date'].replace(
                                "T00:00:00", "")
                            price_sugarcane_min = data['sugarcane']['price'][0]['price_min']
                            price_sugarcane_max = data['sugarcane']['price'][0]['price_max']

                        # if len(data['cassava']['price']) > 0:
                        if str(data['cassava']['price']) == '[]':
                            price_cassava_date = 'ไม่พบข้อมูล'
                            price_cassava_min = 0
                            price_cassava_max = 0
                        else:
                            # txt4 = "cassava = " + str(data['cassava']['price'])
                            # self.iface.messageBar().pushMessage(txt4, level=Qgis.Info)
                            price_cassava_date = data['cassava']['price'][0]['date'].replace(
                                "T00:00:00", "")
                            price_cassava_min = data['cassava']['price'][0]['price_min']
                            price_cassava_max = data['cassava']['price'][0]['price_max']

                        # if len(data['rubber']['price']) > 0:
                        if str(data['rubber']['price']) == '[]':
                            price_rubber_date = 'ไม่พบข้อมูล'
                            price_rubber_min = 0
                            price_rubber_max = 0
                        else:
                            # txt5 = "rubber = " + str(data['rubber']['price'])
                            # self.iface.messageBar().pushMessage(txt5, level=Qgis.Info)
                            price_rubber_date = data['rubber']['price'][0]['date'].replace(
                                "T00:00:00", "")
                            price_rubber_min = data['rubber']['price'][0]['price_min']
                            price_rubber_max = data['rubber']['price'][0]['price_max']

                        # if len(data['palm']['price']) > 0:
                        if str(data['palm']['price']) == '[]':
                            price_palm_date = 'ไม่พบข้อมูล'
                            price_palm_min = 0
                            price_palm_max = 0
                        else:
                            # txt6 = "palm = " + str(data['palm']['price'])
                            # self.iface.messageBar().pushMessage(txt6, level=Qgis.Info)
                            price_palm_date = data['palm']['price'][0]['date'].replace(
                                "T00:00:00", "")
                            price_palm_min = data['palm']['price'][0]['price_min']
                            price_palm_max = data['palm']['price'][0]['price_max']

                        # self.iface.messageBar().pushMessage(str(data['majorrice']['price']), level=Qgis.Info)

                        atts = {id_idx: num_of_features,
                                costRice_idx: cost_rice,
                                costMaize_idx: cost_maize,
                                costSugarcane_idx: cost_sugarcane,
                                costCassava_idx: cost_cassava,
                                costRubber_idx: cost_rubber,
                                costPalm_idx: cost_palm,
                                priceMinRice_idx: price_rice_min,
                                priceMinMaize_idx: price_maize_min,
                                priceMinSugarcane_idx: price_sugarcane_min,
                                priceMinCassava_idx: price_cassava_min,
                                priceMinRubber_idx: price_rubber_min,
                                priceMinPalm_idx: price_palm_min,
                                priceMaxRice_idx: price_rice_max,
                                priceMaxMaize_idx: price_maize_max,
                                priceMaxSugarcane_idx: price_sugarcane_max,
                                priceMaxCassava_idx: price_cassava_max,
                                priceMaxRubber_idx: price_rubber_max,
                                priceMaxPalm_idx: price_palm_max,
                                priceDateRice_idx: price_rice_date,
                                priceDateMaize_idx: price_maize_date,
                                priceDateSugarcane_idx: price_sugarcane_date,
                                priceDateCassava_idx: price_cassava_date,
                                priceDateRubber_idx: price_rubber_date,
                                priceDatePalm_idx: price_palm_date,
                                areaRaiRice_idx: rai_rice,
                                areaRaiMaize_idx: rai_maize,
                                areaRaiSugarcane_idx: rai_sugarcane,
                                areaRaiCassava_idx: rai_cassava,
                                areaRaiRubber_idx: rai_rubber,
                                areaRaiPalm_idx: rai_palm,
                                }
                        feats = layer[0].getFeature(num_of_features)
                        pr.changeAttributeValues({feats.id(): atts})
                        # self.iface.messageBar().pushMessage("finished run test!", level=Qgis.Info)
                        self.iface.messageBar().pushMessage(
                            "Success! Your 'Crop information' layer was created.", level=Qgis.Success)

                    message_path = 'Creating layer from ' + file_path
                    self.iface.messageBar().pushMessage(message_path, level=Qgis.Info)
            
            # Crop information: No layer was imported
            else:
                self.iface.messageBar().pushMessage(
                    "Please try again. No data of point or area layer.", level=Qgis.Warning)

    #########################################################################################################################################################################################################
    # Operating function for menu 3: disaster recurring
    # Check what user select for input shapefile
    def checkSelectDisaster(self):
        if self.dlgDisaster.select_current.isChecked():
            self.dlgDisaster.comboBox.setEnabled(True)
            self.dlgDisaster.file_import.setEnabled(False)
            self.dlgDisaster.search_file.setEnabled(False)
        else:
            self.dlgDisaster.comboBox.setEnabled(False)
            self.dlgDisaster.file_import.setEnabled(True)
            self.dlgDisaster.search_file.setEnabled(True)
    
    # If user select for import shapefile
    def importFileDisaster(self):
        filename, _filter = QFileDialog.getOpenFileName(
            self.dlgDisaster, "Open file", '*.shp')
        self.dlgDisaster.file_import.setText(filename)
    
    # Get select layer and notify the input layer which user selected
    def checkSelectLayerDisaster(self):
        layerCurrent = self.dlgDisaster.comboBox.currentText()
        file_import = self.dlgDisaster.file_import.text()
        if file_import == '':
            self.iface.messageBar().pushMessage(layerCurrent, level=Qgis.Info)
        else:
            self.iface.messageBar().pushMessage(file_import, level=Qgis.Info)
    
    # Query and get disaster recurring data
    def getDisasterRecurring(self):
        valueKey = self.dlg.lineEdit.text()
        layer_name = self.dlgDisaster.comboBox.currentText()
        file_path = self.dlgDisaster.file_import.text()
        file_layer = QgsVectorLayer(file_path, "import_file", "ogr")
        current_layer = QgsProject.instance().mapLayersByName(layer_name)
        api_selected = self.dlgDisaster.API_list.currentText()

        # Flood selected
        if api_selected == 'Flood':
            # Flood: Import layer from current project
            if self.dlgDisaster.select_current.isChecked() == True and self.dlgDisaster.select_file.isChecked() == False and self.dlgDisaster.comboBox.currentText() != '':
                    check_num_of_features = current_layer[0].featureCount()  

                    # Show error message if point feature > 1000
                    if check_num_of_features > 1000:
                        self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
                    else:
                        # Prepare API layer for instance
                        API_layer = QgsVectorLayer(
                            "Point?csr=epsg:4326", "sphere flood recurring", 'memory')
                        QgsProject.instance().addMapLayer(API_layer)

                        # Access features of layer
                        feature = current_layer[0].getFeatures()
                        num_of_features = 0

                        for f in feature:
                            # Get coordinate of point
                            geom = f.geometry()
                            latitude = geom.asPoint().y()
                            longitude = geom.asPoint().x()
                            coor = latitude, longitude
                            num_of_features += 1
                            # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                            # Get API data from feature point
                            url = "https://api.sphere.gistda.or.th/services/info/disaster-recurring?lat=" + \
                                str(latitude) + "&lon=" + \
                                str(longitude) + "&key=" + \
                                valueKey + "&disaster_type=flood"
                            re = requests.get(url)
                            data = re.json()

                            # Create vector layer
                            API_layer.startEditing()
                            location = QgsGeometry()
                            location = QgsGeometry.fromPointXY(
                                QgsPointXY(longitude, latitude))
                            feat = QgsFeature()
                            feat.setGeometry(location)
                            API_layer.dataProvider().addFeatures([feat])
                            API_layer.commitChanges()

                            # Create fields
                            layer = QgsProject.instance().mapLayersByName('sphere flood recurring')
                            pr = layer[0].dataProvider()
                            pr.addAttributes(
                                [QgsField("id", QVariant.String, "text", 254)])
                            pr.addAttributes(
                                [QgsField("summary_frequency", QVariant.Int)])
                            pr.addAttributes([QgsField("year_2011", QVariant.Int)])
                            pr.addAttributes([QgsField("year_2012", QVariant.Int)])
                            pr.addAttributes([QgsField("year_2013", QVariant.Int)])
                            pr.addAttributes([QgsField("year_2014", QVariant.Int)])
                            pr.addAttributes([QgsField("year_2015", QVariant.Int)])
                            pr.addAttributes([QgsField("year_2016", QVariant.Int)])
                            pr.addAttributes([QgsField("year_2017", QVariant.Int)])
                            pr.addAttributes([QgsField("year_2018", QVariant.Int)])
                            pr.addAttributes([QgsField("year_2019", QVariant.Int)])
                            pr.addAttributes([QgsField("year_2020", QVariant.Int)])
                            pr.addAttributes([QgsField("year_2021", QVariant.Int)])
                            pr.addAttributes(
                                [QgsField("subdistrict", QVariant.String, "text", 254)])
                            pr.addAttributes(
                                [QgsField("district", QVariant.String, "text", 254)])
                            pr.addAttributes(
                                [QgsField("province", QVariant.String, "text", 254)])

                            layer[0].updateFields()

                            # Add field value
                            id_idx = layer[0].fields().lookupField('id')
                            sum_idx = layer[0].fields().lookupField(
                                'summary_frequency')
                            year2011_idx = layer[0].fields(
                            ).lookupField('year_2011')
                            year2012_idx = layer[0].fields(
                            ).lookupField('year_2012')
                            year2013_idx = layer[0].fields(
                            ).lookupField('year_2013')
                            year2014_idx = layer[0].fields(
                            ).lookupField('year_2014')
                            year2015_idx = layer[0].fields(
                            ).lookupField('year_2015')
                            year2016_idx = layer[0].fields(
                            ).lookupField('year_2016')
                            year2017_idx = layer[0].fields(
                            ).lookupField('year_2017')
                            year2018_idx = layer[0].fields(
                            ).lookupField('year_2018')
                            year2019_idx = layer[0].fields(
                            ).lookupField('year_2019')
                            year2020_idx = layer[0].fields(
                            ).lookupField('year_2020')
                            year2021_idx = layer[0].fields(
                            ).lookupField('year_2021')
                            subdistrict_idx = layer[0].fields(
                            ).lookupField('subdistrict')
                            district_idx = layer[0].fields(
                            ).lookupField('district')
                            province_idx = layer[0].fields(
                            ).lookupField('province')

                            # Define variable from result
                            sum_f = data['flood']['summary_frequency']
                            if len(data['flood']['data']) == 0:
                                y2011 = 0
                                y2012 = 0
                                y2013 = 0
                                y2014 = 0
                                y2015 = 0
                                y2016 = 0
                                y2017 = 0
                                y2018 = 0
                                y2019 = 0
                                y2020 = 0
                                y2021 = 0
                            else:
                                y2011 = data['flood']['data'][0]['frequency']
                                y2012 = data['flood']['data'][1]['frequency']
                                y2013 = data['flood']['data'][2]['frequency']
                                y2014 = data['flood']['data'][3]['frequency']
                                y2015 = data['flood']['data'][4]['frequency']
                                y2016 = data['flood']['data'][5]['frequency']
                                y2017 = data['flood']['data'][6]['frequency']
                                y2018 = data['flood']['data'][7]['frequency']
                                y2019 = data['flood']['data'][8]['frequency']
                                y2020 = data['flood']['data'][9]['frequency']
                                y2021 = data['flood']['data'][10]['frequency']

                            subdistrict_value = data['location'][0]['tb_tn']
                            district_value = data['location'][0]['ap_tn']
                            prov = data['location'][0]['pv_tn']

                            atts = {
                                id_idx: num_of_features,
                                sum_idx: sum_f,
                                year2011_idx: y2011,
                                year2012_idx: y2012,
                                year2013_idx: y2013,
                                year2014_idx: y2014,
                                year2015_idx: y2015,
                                year2016_idx: y2016,
                                year2017_idx: y2017,
                                year2018_idx: y2018,
                                year2019_idx: y2019,
                                year2020_idx: y2020,
                                year2021_idx: y2021,
                                subdistrict_idx: subdistrict_value,
                                district_idx: district_value,
                                province_idx: prov
                            }

                            feats = layer[0].getFeature(num_of_features)
                            pr.changeAttributeValues({feats.id(): atts})
                            self.iface.messageBar().pushMessage(
                                "Success! Your 'Flood information' layer was created.", level=Qgis.Success)
                        
                        message_instance = 'Creating layer from ' + layer_name
                        self.iface.messageBar().pushMessage(message_instance, level=Qgis.Info)

            # Flood: Import layer from file
            elif self.dlgDisaster.select_file.isChecked() == True and self.dlgDisaster.select_current.isChecked() == False and self.dlgDisaster.file_import.text() != '':
                check_num_of_features = file_layer.featureCount()  

                # Show error message if point feature > 1000
                if check_num_of_features > 1000:
                    self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
                else:
                    # Prepare API layer for instance
                    API_layer = QgsVectorLayer(
                        "Point?csr=epsg:4326", "sphere flood recurring", 'memory')
                    QgsProject.instance().addMapLayer(API_layer)

                    # Access features of layer
                    feature = file_layer.getFeatures()
                    num_of_features = 0

                    for f in feature:
                        # Get coordinate of point
                        geom = f.geometry()
                        latitude = geom.asPoint().y()
                        longitude = geom.asPoint().x()
                        coor = latitude, longitude
                        num_of_features += 1
                        # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                        # Get API data from feature point
                        url = "https://api.sphere.gistda.or.th/services/info/disaster-recurring?lat=" + \
                            str(latitude) + "&lon=" + \
                            str(longitude) + "&key=" + \
                            valueKey + "&disaster_type=flood"
                        re = requests.get(url)
                        data = re.json()

                        # Create vector layer
                        API_layer.startEditing()
                        location = QgsGeometry()
                        location = QgsGeometry.fromPointXY(
                            QgsPointXY(longitude, latitude))
                        feat = QgsFeature()
                        feat.setGeometry(location)
                        API_layer.dataProvider().addFeatures([feat])
                        API_layer.commitChanges()

                        # Create fields
                        layer = QgsProject.instance().mapLayersByName('sphere flood recurring')
                        pr = layer[0].dataProvider()
                        pr.addAttributes(
                            [QgsField("id", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("summary_frequency", QVariant.Int)])
                        pr.addAttributes([QgsField("year_2011", QVariant.Int)])
                        pr.addAttributes([QgsField("year_2012", QVariant.Int)])
                        pr.addAttributes([QgsField("year_2013", QVariant.Int)])
                        pr.addAttributes([QgsField("year_2014", QVariant.Int)])
                        pr.addAttributes([QgsField("year_2015", QVariant.Int)])
                        pr.addAttributes([QgsField("year_2016", QVariant.Int)])
                        pr.addAttributes([QgsField("year_2017", QVariant.Int)])
                        pr.addAttributes([QgsField("year_2018", QVariant.Int)])
                        pr.addAttributes([QgsField("year_2019", QVariant.Int)])
                        pr.addAttributes([QgsField("year_2020", QVariant.Int)])
                        pr.addAttributes([QgsField("year_2021", QVariant.Int)])
                        pr.addAttributes(
                            [QgsField("subdistrict", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("district", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("province", QVariant.String, "text", 254)])

                        layer[0].updateFields()

                        # Add field value
                        id_idx = layer[0].fields().lookupField('id')
                        sum_idx = layer[0].fields().lookupField(
                            'summary_frequency')
                        year2011_idx = layer[0].fields(
                        ).lookupField('year_2011')
                        year2012_idx = layer[0].fields(
                        ).lookupField('year_2012')
                        year2013_idx = layer[0].fields(
                        ).lookupField('year_2013')
                        year2014_idx = layer[0].fields(
                        ).lookupField('year_2014')
                        year2015_idx = layer[0].fields(
                        ).lookupField('year_2015')
                        year2016_idx = layer[0].fields(
                        ).lookupField('year_2016')
                        year2017_idx = layer[0].fields(
                        ).lookupField('year_2017')
                        year2018_idx = layer[0].fields(
                        ).lookupField('year_2018')
                        year2019_idx = layer[0].fields(
                        ).lookupField('year_2019')
                        year2020_idx = layer[0].fields(
                        ).lookupField('year_2020')
                        year2021_idx = layer[0].fields(
                        ).lookupField('year_2021')
                        subdistrict_idx = layer[0].fields(
                        ).lookupField('subdistrict')
                        district_idx = layer[0].fields(
                        ).lookupField('district')
                        province_idx = layer[0].fields(
                        ).lookupField('province')

                        # Define variable from result
                        sum_f = data['flood']['summary_frequency']
                        if len(data['flood']['data']) == 0:
                            y2011 = 0
                            y2012 = 0
                            y2013 = 0
                            y2014 = 0
                            y2015 = 0
                            y2016 = 0
                            y2017 = 0
                            y2018 = 0
                            y2019 = 0
                            y2020 = 0
                            y2021 = 0
                        else:
                            y2011 = data['flood']['data'][0]['frequency']
                            y2012 = data['flood']['data'][1]['frequency']
                            y2013 = data['flood']['data'][2]['frequency']
                            y2014 = data['flood']['data'][3]['frequency']
                            y2015 = data['flood']['data'][4]['frequency']
                            y2016 = data['flood']['data'][5]['frequency']
                            y2017 = data['flood']['data'][6]['frequency']
                            y2018 = data['flood']['data'][7]['frequency']
                            y2019 = data['flood']['data'][8]['frequency']
                            y2020 = data['flood']['data'][9]['frequency']
                            y2021 = data['flood']['data'][10]['frequency']

                        subdistrict_value = data['location'][0]['tb_tn']
                        district_value = data['location'][0]['ap_tn']
                        prov = data['location'][0]['pv_tn']

                        atts = {
                            id_idx: num_of_features,
                            sum_idx: sum_f,
                            year2011_idx: y2011,
                            year2012_idx: y2012,
                            year2013_idx: y2013,
                            year2014_idx: y2014,
                            year2015_idx: y2015,
                            year2016_idx: y2016,
                            year2017_idx: y2017,
                            year2018_idx: y2018,
                            year2019_idx: y2019,
                            year2020_idx: y2020,
                            year2021_idx: y2021,
                            subdistrict_idx: subdistrict_value,
                            district_idx: district_value,
                            province_idx: prov
                        }

                        feats = layer[0].getFeature(num_of_features)
                        pr.changeAttributeValues({feats.id(): atts})
                        self.iface.messageBar().pushMessage(
                            "Success! Your 'Flood information' layer was created.", level=Qgis.Success)
                    
                    message_instance = 'Creating layer from ' + file_path
                    self.iface.messageBar().pushMessage(message_instance, level=Qgis.Info)

            # Flood: No layer was imported
            else:
                self.iface.messageBar().pushMessage(
                    "Please try again. No data of point or area layer.", level=Qgis.Warning)

        # Drought selected
        elif api_selected == 'Drought':
            # Drought: Import layer from current project
            if self.dlgDisaster.select_current.isChecked() == True and self.dlgDisaster.select_file.isChecked() == False and self.dlgDisaster.comboBox.currentText() != '':
                check_num_of_features = current_layer[0].featureCount()  

                # Show error message if point feature > 1000
                if check_num_of_features > 1000:
                    self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
                else:
                    # Prepare API layer for instance
                    API_layer = QgsVectorLayer(
                        "Point?csr=epsg:4326", "sphere drought recurring", 'memory')
                    QgsProject.instance().addMapLayer(API_layer)

                    # Access features of layer
                    feature = current_layer[0].getFeatures()
                    num_of_features = 0

                    for f in feature:
                        # Get coordinate of point
                        geom = f.geometry()
                        latitude = geom.asPoint().y()
                        longitude = geom.asPoint().x()
                        coor = latitude, longitude
                        num_of_features += 1
                        # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                        # Get API data from feature point
                        url = "https://api.sphere.gistda.or.th/services/info/disaster-recurring?lat=" + \
                            str(latitude) + "&lon=" + \
                            str(longitude) + "&key=" + \
                            valueKey + "&disaster_type=drought"
                        re = requests.get(url)
                        data = re.json()

                        # Create vector layer
                        API_layer.startEditing()
                        location = QgsGeometry()
                        location = QgsGeometry.fromPointXY(
                            QgsPointXY(longitude, latitude))
                        feat = QgsFeature()
                        feat.setGeometry(location)
                        API_layer.dataProvider().addFeatures([feat])
                        API_layer.commitChanges()

                        # Create fields
                        layer = QgsProject.instance().mapLayersByName('sphere drought recurring')
                        pr = layer[0].dataProvider()
                        pr.addAttributes(
                            [QgsField("id", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("low", QVariant.Int)])
                        pr.addAttributes(
                            [QgsField("medium", QVariant.Int)])
                        pr.addAttributes(
                            [QgsField("high", QVariant.Int)])
                        pr.addAttributes(
                            [QgsField("subdistrict", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("district", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("province", QVariant.String, "text", 254)])

                        layer[0].updateFields()

                        # Add field value
                        id_idx = layer[0].fields().lookupField('id')
                        low_idx = layer[0].fields(
                        ).lookupField('low')
                        medium_idx = layer[0].fields(
                        ).lookupField('medium')
                        high_idx = layer[0].fields(
                        ).lookupField('high')
                        subdistrict_idx = layer[0].fields(
                        ).lookupField('subdistrict')
                        district_idx = layer[0].fields(
                        ).lookupField('district')
                        province_idx = layer[0].fields(
                        ).lookupField('province')

                        # Define variable from result
                        lv_low = data['drought']['summary_frequency']['low']
                        lv_medium = data['drought']['summary_frequency']['medium']
                        lv_high = data['drought']['summary_frequency']['high']
                        subdistrict_value = data['location'][0]['tb_tn']
                        district_value = data['location'][0]['ap_tn']
                        prov = data['location'][0]['pv_tn']

                        atts = {
                            id_idx: num_of_features,
                            low_idx: lv_low,
                            medium_idx: lv_medium,
                            high_idx: lv_high,
                            subdistrict_idx: subdistrict_value,
                            district_idx: district_value,
                            province_idx: prov
                        }

                        feats = layer[0].getFeature(num_of_features)
                        pr.changeAttributeValues({feats.id(): atts})
                        # self.iface.messageBar().pushMessage(str(num_of_features), level=Qgis.Info)
                        self.iface.messageBar().pushMessage(
                            "Success! Your 'Drought information' layer was created.", level=Qgis.Success)
                    
                    message_instance = 'Creating layer from ' + layer_name
                    self.iface.messageBar().pushMessage(message_instance, level=Qgis.Info)

            # Drought: Import layer from file
            elif self.dlgDisaster.select_file.isChecked() == True and self.dlgDisaster.select_current.isChecked() == False and self.dlgDisaster.file_import.text() != '':
                check_num_of_features = file_layer.featureCount()  

                # Show error message if point feature > 1000
                if check_num_of_features > 1000:
                    self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
                else:
                    # Prepare API layer for instance
                    API_layer = QgsVectorLayer(
                        "Point?csr=epsg:4326", "sphere drought recurring", 'memory')
                    QgsProject.instance().addMapLayer(API_layer)

                    # Access features of layer
                    feature = file_layer.getFeatures()
                    num_of_features = 0

                    for f in feature:
                        # Get coordinate of point
                        geom = f.geometry()
                        latitude = geom.asPoint().y()
                        longitude = geom.asPoint().x()
                        coor = latitude, longitude
                        num_of_features += 1
                        # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                        # Get API data from feature point
                        url = "https://api.sphere.gistda.or.th/services/info/disaster-recurring?lat=" + \
                            str(latitude) + "&lon=" + \
                            str(longitude) + "&key=" + \
                            valueKey + "&disaster_type=drought"
                        re = requests.get(url)
                        data = re.json()

                        # Create vector layer
                        API_layer.startEditing()
                        location = QgsGeometry()
                        location = QgsGeometry.fromPointXY(
                            QgsPointXY(longitude, latitude))
                        feat = QgsFeature()
                        feat.setGeometry(location)
                        API_layer.dataProvider().addFeatures([feat])
                        API_layer.commitChanges()

                        # Create fields
                        layer = QgsProject.instance().mapLayersByName('sphere drought recurring')
                        pr = layer[0].dataProvider()
                        pr.addAttributes(
                            [QgsField("id", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("low", QVariant.Int)])
                        pr.addAttributes(
                            [QgsField("medium", QVariant.Int)])
                        pr.addAttributes(
                            [QgsField("high", QVariant.Int)])
                        pr.addAttributes(
                            [QgsField("subdistrict", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("district", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("province", QVariant.String, "text", 254)])

                        layer[0].updateFields()

                        # Add field value
                        id_idx = layer[0].fields().lookupField('id')
                        low_idx = layer[0].fields(
                        ).lookupField('low')
                        medium_idx = layer[0].fields(
                        ).lookupField('medium')
                        high_idx = layer[0].fields(
                        ).lookupField('high')
                        subdistrict_idx = layer[0].fields(
                        ).lookupField('subdistrict')
                        district_idx = layer[0].fields(
                        ).lookupField('district')
                        province_idx = layer[0].fields(
                        ).lookupField('province')

                        # Define variable from result
                        lv_low = data['drought']['summary_frequency']['low']
                        lv_medium = data['drought']['summary_frequency']['medium']
                        lv_high = data['drought']['summary_frequency']['high']
                        subdistrict_value = data['location'][0]['tb_tn']
                        district_value = data['location'][0]['ap_tn']
                        prov = data['location'][0]['pv_tn']

                        atts = {
                            id_idx: num_of_features,
                            low_idx: lv_low,
                            medium_idx: lv_medium,
                            high_idx: lv_high,
                            subdistrict_idx: subdistrict_value,
                            district_idx: district_value,
                            province_idx: prov
                        }

                        feats = layer[0].getFeature(num_of_features)
                        pr.changeAttributeValues({feats.id(): atts})
                        # self.iface.messageBar().pushMessage(str(num_of_features), level=Qgis.Info)
                        self.iface.messageBar().pushMessage(
                            "Success! Your 'Drought information' layer was created.", level=Qgis.Success)
                    
                    message_instance = 'Creating layer from ' + file_path
                    self.iface.messageBar().pushMessage(message_instance, level=Qgis.Info)

            # Drought: No layer was imported
            else:
                self.iface.messageBar().pushMessage(
                    "Please try again. No data of point or area layer.", level=Qgis.Warning)

        # Hotspot selected
        else:
            # Hotspot: Import layer from current project
            if self.dlgDisaster.select_current.isChecked() == True and self.dlgDisaster.select_file.isChecked() == False and self.dlgDisaster.comboBox.currentText() != '':
                check_num_of_features = current_layer[0].featureCount()  

                # Show error message if point feature > 1000
                if check_num_of_features > 1000:
                    self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
                else:
                    # Prepare API layer for instance
                    API_layer = QgsVectorLayer(
                        "Point?csr=epsg:4326", "sphere hotspot recurring", 'memory')
                    QgsProject.instance().addMapLayer(API_layer)

                    # Access features of layer
                    feature = current_layer[0].getFeatures()
                    num_of_features = 0

                    for f in feature:
                        # Get coordinate of point
                        geom = f.geometry()
                        latitude = geom.asPoint().y()
                        longitude = geom.asPoint().x()
                        coor = latitude, longitude
                        num_of_features += 1
                        # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                        # Get API data from feature point
                        url = "https://api.sphere.gistda.or.th/services/info/disaster-recurring?lat=" + \
                            str(latitude) + "&lon=" + \
                            str(longitude) + "&key=" + \
                            valueKey + "&disaster_type=hotspot"
                        re = requests.get(url)
                        data = re.json()
                        # self.iface.messageBar().pushMessage(
                        #     "This " + str(num_of_features) + " = " + str(data['hotspot']['data']), level=Qgis.Info)

                        # Create vector layer
                        API_layer.startEditing()
                        location = QgsGeometry()
                        location = QgsGeometry.fromPointXY(
                            QgsPointXY(longitude, latitude))
                        feat = QgsFeature()
                        feat.setGeometry(location)
                        API_layer.dataProvider().addFeatures([feat])
                        API_layer.commitChanges()

                        # Create fields
                        layer = QgsProject.instance().mapLayersByName('sphere hotspot recurring')
                        pr = layer[0].dataProvider()
                        pr.addAttributes(
                            [QgsField("id", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("subdistrict", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("district", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("province", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("summary_frequency", QVariant.Int)])

                        for i in range(len(data['hotspot']['data'])):
                            record = data['hotspot']['data'][i]
                            lu = record['landuse']
                            f = record['frequency']

                            pr.addAttributes([QgsField(lu, QVariant.Int)])
                            layer[0].updateFields()
                            lu_idx = layer[0].fields().lookupField(lu)
                            feats = layer[0].getFeature(num_of_features)
                            pr.changeAttributeValues({feats.id(): {lu_idx: f}})

                            # self.iface.messageBar().pushMessage(str(record), level=Qgis.Info)

                        layer[0].updateFields()

                        # Add field value
                        id_idx = layer[0].fields().lookupField('id')
                        subdistrict_idx = layer[0].fields(
                        ).lookupField('subdistrict')
                        district_idx = layer[0].fields(
                        ).lookupField('district')
                        province_idx = layer[0].fields(
                        ).lookupField('province')
                        sum_idx = layer[0].fields().lookupField(
                            'summary_frequency')

                        # Define variable from result
                        sum_f = data['hotspot']['summary_frequency']
                        subdistrict_value = data['location'][0]['tb_tn']
                        district_value = data['location'][0]['ap_tn']
                        prov = data['location'][0]['pv_tn']

                        atts = {
                            id_idx: num_of_features,
                            subdistrict_idx: subdistrict_value,
                            district_idx: district_value,
                            province_idx: prov,
                            sum_idx: sum_f,
                        }

                        feats = layer[0].getFeature(num_of_features)
                        pr.changeAttributeValues({feats.id(): atts})
                        # self.iface.messageBar().pushMessage(str(num_of_features), level=Qgis.Info)
                        self.iface.messageBar().pushMessage(
                            "Success! Your 'Hotspot' layer was created.", level=Qgis.Success)
                    
                    message_instance = 'Creating layer from ' + layer_name
                    self.iface.messageBar().pushMessage(message_instance, level=Qgis.Info)

            # Hotspot: Import layer from file
            elif self.dlgDisaster.select_file.isChecked() == True and self.dlgDisaster.select_current.isChecked() == False and self.dlgDisaster.file_import.text() != '':
                check_num_of_features = file_layer.featureCount()  

                # Show error message if point feature > 1000
                if check_num_of_features > 1000:
                    self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
                else:
                    # Prepare API layer for instance
                    API_layer = QgsVectorLayer(
                        "Point?csr=epsg:4326", "sphere hotspot recurring", 'memory')
                    QgsProject.instance().addMapLayer(API_layer)

                    # Access features of layer
                    feature = file_layer.getFeatures()
                    num_of_features = 0

                    for f in feature:
                        # Get coordinate of point
                        geom = f.geometry()
                        latitude = geom.asPoint().y()
                        longitude = geom.asPoint().x()
                        coor = latitude, longitude
                        num_of_features += 1
                        # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                        # Get API data from feature point
                        url = "https://api.sphere.gistda.or.th/services/info/disaster-recurring?lat=" + \
                            str(latitude) + "&lon=" + \
                            str(longitude) + "&key=" + \
                            valueKey + "&disaster_type=hotspot"
                        re = requests.get(url)
                        data = re.json()
                        # self.iface.messageBar().pushMessage(
                        #     "This " + str(num_of_features) + " = " + str(data['hotspot']['data']), level=Qgis.Info)

                        # Create vector layer
                        API_layer.startEditing()
                        location = QgsGeometry()
                        location = QgsGeometry.fromPointXY(
                            QgsPointXY(longitude, latitude))
                        feat = QgsFeature()
                        feat.setGeometry(location)
                        API_layer.dataProvider().addFeatures([feat])
                        API_layer.commitChanges()

                        # Create fields
                        layer = QgsProject.instance().mapLayersByName('sphere hotspot recurring')
                        pr = layer[0].dataProvider()
                        pr.addAttributes(
                            [QgsField("id", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("subdistrict", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("district", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("province", QVariant.String, "text", 254)])
                        pr.addAttributes(
                            [QgsField("summary_frequency", QVariant.Int)])

                        for i in range(len(data['hotspot']['data'])):
                            record = data['hotspot']['data'][i]
                            lu = record['landuse']
                            f = record['frequency']

                            pr.addAttributes([QgsField(lu, QVariant.Int)])
                            layer[0].updateFields()
                            lu_idx = layer[0].fields().lookupField(lu)
                            feats = layer[0].getFeature(num_of_features)
                            pr.changeAttributeValues({feats.id(): {lu_idx: f}})

                            # self.iface.messageBar().pushMessage(str(record), level=Qgis.Info)

                        layer[0].updateFields()

                        # Add field value
                        id_idx = layer[0].fields().lookupField('id')
                        subdistrict_idx = layer[0].fields(
                        ).lookupField('subdistrict')
                        district_idx = layer[0].fields(
                        ).lookupField('district')
                        province_idx = layer[0].fields(
                        ).lookupField('province')
                        sum_idx = layer[0].fields().lookupField(
                            'summary_frequency')

                        # Define variable from result
                        sum_f = data['hotspot']['summary_frequency']
                        subdistrict_value = data['location'][0]['tb_tn']
                        district_value = data['location'][0]['ap_tn']
                        prov = data['location'][0]['pv_tn']

                        atts = {
                            id_idx: num_of_features,
                            subdistrict_idx: subdistrict_value,
                            district_idx: district_value,
                            province_idx: prov,
                            sum_idx: sum_f,
                        }

                        feats = layer[0].getFeature(num_of_features)
                        pr.changeAttributeValues({feats.id(): atts})
                        # self.iface.messageBar().pushMessage(str(num_of_features), level=Qgis.Info)
                        self.iface.messageBar().pushMessage(
                            "Success! Your 'Hotspot' layer was created.", level=Qgis.Success)
                    
                    message_instance = 'Creating layer from ' + file_path
                    self.iface.messageBar().pushMessage(message_instance, level=Qgis.Info)

            # Hotspot: No layer was imported
            else:
                self.iface.messageBar().pushMessage(
                    "Please try again. No data of point or area layer.", level=Qgis.Warning)


    #########################################################################################################################################################################################################
    # Operating function for menu 4: elevation
    # Check what user select for input shapefile
    def checkSelectElevation(self):
        if self.dlgElevation.select_current.isChecked():
            self.dlgElevation.comboBox.setEnabled(True)
            self.dlgElevation.file_import.setEnabled(False)
            self.dlgElevation.search_file.setEnabled(False)
        else:
            self.dlgElevation.comboBox.setEnabled(False)
            self.dlgElevation.file_import.setEnabled(True)
            self.dlgElevation.search_file.setEnabled(True)
    
    # If user select for import shapefile
    def importFileElevation(self):
        filename, _filter = QFileDialog.getOpenFileName(
            self.dlgElevation, "Open file", '*.shp')
        self.dlgElevation.file_import.setText(filename)
    
    # Get select layer and notify the input layer which user selected
    def checkSelectLayerElevation(self):
        layerCurrent = self.dlgElevation.comboBox.currentText()
        file_import = self.dlgElevation.file_import.text()
        if file_import == '':
            self.iface.messageBar().pushMessage(layerCurrent, level=Qgis.Info)
        else:
            self.iface.messageBar().pushMessage(file_import, level=Qgis.Info)
    
    # Query and get elevation data
    def getElevation(self):
        valueKey = self.dlg.lineEdit.text()
        layer_name = self.dlgElevation.comboBox.currentText()
        file_path = self.dlgElevation.file_import.text()
        file_layer = QgsVectorLayer(file_path, "import_file", "ogr")
        current_layer = QgsProject.instance().mapLayersByName(layer_name)

        if self.dlgElevation.select_current.isChecked() == True and self.dlgElevation.select_file.isChecked() == False and self.dlgElevation.comboBox.currentText() != '':
            check_num_of_features = current_layer[0].featureCount()  

            # Show error message if point feature > 1000
            if check_num_of_features > 1000:
                self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
            else:
                # Prepare API layer for instance
                API_layer = QgsVectorLayer(
                    "Point?csr=epsg:4326", "sphere elevation", 'memory')
                QgsProject.instance().addMapLayer(API_layer)

                # Access features of layer
                feature = current_layer[0].getFeatures()
                num_of_features = 0

                for f in feature:
                    # Get coordinate of point
                    geom = f.geometry()
                    latitude = geom.asPoint().y()
                    longitude = geom.asPoint().x()
                    coor = latitude, longitude
                    num_of_features += 1
                    # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                    # Get API data from feature point
                    url = "https://api.sphere.gistda.or.th/services/geo/elevation?lat=" + \
                        str(latitude) + "&lon=" + \
                        str(longitude) + "&key=" + valueKey
                    re = requests.get(url)
                    data = re.json()
                    # keys = [type, suitability, price, cost]
                    # self.iface.messageBar().pushMessage(str(data), level=Qgis.Info)

                    # Create vector layer
                    API_layer.startEditing()
                    location = QgsGeometry()
                    location = QgsGeometry.fromPointXY(
                        QgsPointXY(longitude, latitude))
                    feat = QgsFeature()
                    feat.setGeometry(location)
                    API_layer.dataProvider().addFeatures([feat])
                    API_layer.commitChanges()

                    # Create fields
                    layer = QgsProject.instance().mapLayersByName('sphere elevation')
                    pr = layer[0].dataProvider()
                    pr.addAttributes(
                        [QgsField("id", QVariant.String, "text", 254)])
                    pr.addAttributes(
                        [QgsField("elevation_meter", QVariant.Double)])

                    layer[0].updateFields()

                    # Add field value
                    id_idx = layer[0].fields().lookupField('id')
                    elevation_idx = layer[0].fields(
                    ).lookupField('elevation_meter')

                    elevation_value = data[0]['elevation']

                    atts = {id_idx: num_of_features,
                            elevation_idx: elevation_value}
                    feats = layer[0].getFeature(num_of_features)
                    pr.changeAttributeValues({feats.id(): atts})
                    # self.iface.messageBar().pushMessage("finished run test!", level=Qgis.Info)
                    self.iface.messageBar().pushMessage(
                        "Success! Your 'Elevation' layer was created.", level=Qgis.Success)

                message_instance = 'Creating layer from ' + layer_name
                self.iface.messageBar().pushMessage(message_instance, level=Qgis.Info)

        elif self.dlgElevation.select_file.isChecked() == True and self.dlgElevation.select_current.isChecked() == False and self.dlgElevation.file_import.text() != '':
            check_num_of_features = file_layer.featureCount()  

            # Show error message if point feature > 1000
            if check_num_of_features > 1000:
                self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
            else:
                # Prepare API layer for instance
                API_layer = QgsVectorLayer(
                    "Point?csr=epsg:4326", "sphere elevation", 'memory')
                QgsProject.instance().addMapLayer(API_layer)

                # Access features of layer
                feature = file_layer.getFeatures()
                num_of_features = 0

                for f in feature:
                    # Get coordinate of point
                    geom = f.geometry()
                    latitude = geom.asPoint().y()
                    longitude = geom.asPoint().x()
                    coor = latitude, longitude
                    num_of_features += 1
                    # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                    # Get API data from feature point
                    url = "https://api.sphere.gistda.or.th/services/geo/elevation?lat=" + \
                        str(latitude) + "&lon=" + \
                        str(longitude) + "&key=" + valueKey
                    re = requests.get(url)
                    data = re.json()
                    # keys = [type, suitability, price, cost]
                    # self.iface.messageBar().pushMessage(str(data), level=Qgis.Info)

                    # Create vector layer
                    API_layer.startEditing()
                    location = QgsGeometry()
                    location = QgsGeometry.fromPointXY(
                        QgsPointXY(longitude, latitude))
                    feat = QgsFeature()
                    feat.setGeometry(location)
                    API_layer.dataProvider().addFeatures([feat])
                    API_layer.commitChanges()

                    # Create fields
                    layer = QgsProject.instance().mapLayersByName('sphere elevation')
                    pr = layer[0].dataProvider()
                    pr.addAttributes(
                        [QgsField("id", QVariant.String, "text", 254)])
                    pr.addAttributes(
                        [QgsField("elevation_meter", QVariant.Double)])

                    layer[0].updateFields()

                    # Add field value
                    id_idx = layer[0].fields().lookupField('id')
                    elevation_idx = layer[0].fields(
                    ).lookupField('elevation_meter')

                    elevation_value = data[0]['elevation']

                    atts = {id_idx: num_of_features,
                            elevation_idx: elevation_value}
                    feats = layer[0].getFeature(num_of_features)
                    pr.changeAttributeValues({feats.id(): atts})
                    # self.iface.messageBar().pushMessage("finished run test!", level=Qgis.Info)
                    self.iface.messageBar().pushMessage(
                        "Success! Your 'Elevation' layer was created.", level=Qgis.Success)

                message_instance = 'Creating layer from ' + file_path
                self.iface.messageBar().pushMessage(message_instance, level=Qgis.Info)

        else:
            self.iface.messageBar().pushMessage(
                "No data of point feature. Please try again.", level=Qgis.Warning)
    
    #########################################################################################################################################################################################################
    # Operating function for menu 5: reverse geocoding
    # Check what user select for input shapefile
    def checkSelectGeocoding(self):
        if self.dlgGeocoding.select_current.isChecked():
            self.dlgGeocoding.comboBox.setEnabled(True)
            self.dlgGeocoding.file_import.setEnabled(False)
            self.dlgGeocoding.search_file.setEnabled(False)
        else:
            self.dlgGeocoding.comboBox.setEnabled(False)
            self.dlgGeocoding.file_import.setEnabled(True)
            self.dlgGeocoding.search_file.setEnabled(True)
    
    # If user select for import shapefile
    def importFileGeocoding(self):
        filename, _filter = QFileDialog.getOpenFileName(
            self.dlgGeocoding, "Select file to import", '*.shp')
        self.dlgGeocoding.file_import.setText(filename)
    
    # Get select layer and notify the input layer which user selected
    def checkSelectLayerGeocoding(self):
        layerCurrent = self.dlgGeocoding.comboBox.currentText()
        file_import = self.dlgGeocoding.file_import.text()
        if file_import == '':
            self.iface.messageBar().pushMessage(layerCurrent, level=Qgis.Info)
        else:
            self.iface.messageBar().pushMessage(file_import, level=Qgis.Info)
    
    # Query and get reverse geocoding data
    def getGeocoding(self):
        valueKey = self.dlg.lineEdit.text()
        layer_name = self.dlgGeocoding.comboBox.currentText()
        file_path = self.dlgGeocoding.file_import.text()
        file_layer = QgsVectorLayer(file_path, "import_file", "ogr")
        current_layer = QgsProject.instance().mapLayersByName(layer_name)

        if self.dlgGeocoding.select_current.isChecked() == True and self.dlgGeocoding.select_file.isChecked() == False and self.dlgGeocoding.comboBox.currentText() != '':
            check_num_of_features = current_layer[0].featureCount()  

            # Show error message if point feature > 1000
            if check_num_of_features > 1000:
                self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
            else:
                # Prepare API layer for instance
                API_layer = QgsVectorLayer(
                    "Point?csr=epsg:4326", "sphere reverse geocoding", 'memory')
                QgsProject.instance().addMapLayer(API_layer)

                # Access features of layer
                feature = current_layer[0].getFeatures()
                num_of_features = 0

                for f in feature:
                    # Get coordinate of point
                    geom = f.geometry()
                    latitude = geom.asPoint().y()
                    longitude = geom.asPoint().x()
                    coor = latitude, longitude
                    num_of_features += 1
                    # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                    # Get API data from feature point
                    url = "https://api.sphere.gistda.or.th/services/geo/address?lat=" + \
                        str(latitude) + "&lon=" + \
                        str(longitude) + "&key=" + valueKey
                    re = requests.get(url)
                    data = re.json()

                    # Create vector layer
                    API_layer.startEditing()
                    location = QgsGeometry()
                    location = QgsGeometry.fromPointXY(
                        QgsPointXY(longitude, latitude))
                    feat = QgsFeature()
                    feat.setGeometry(location)
                    API_layer.dataProvider().addFeatures([feat])
                    API_layer.commitChanges()

                    # Create fields
                    layer = QgsProject.instance().mapLayersByName('sphere reverse geocoding')
                    pr = layer[0].dataProvider()
                    pr.addAttributes(
                        [QgsField("id", QVariant.String, "text", 254)])
                    pr.addAttributes(
                        [QgsField("geocode", QVariant.String, "text", 254)])
                    pr.addAttributes(
                        [QgsField("province", QVariant.String, "text", 254)])
                    pr.addAttributes(
                        [QgsField("district", QVariant.String, "text", 254)])
                    pr.addAttributes(
                        [QgsField("subdistrict", QVariant.String, "text", 254)])

                    layer[0].updateFields()

                    # Add field value
                    id_idx = layer[0].fields().lookupField('id')
                    code_idx = layer[0].fields(
                    ).lookupField('geocode')
                    province_idx = layer[0].fields().lookupField('province')
                    district_idx = layer[0].fields().lookupField('district')
                    subdistrict_idx = layer[0].fields().lookupField('subdistrict')

                    code_value = data['geocode']
                    prov_value = data['province']
                    district_value = data['district']
                    subdis_value = data['subdistrict']

                    
                    atts = {id_idx: num_of_features,
                            code_idx: code_value,
                            province_idx: prov_value,
                            district_idx: district_value,
                            subdistrict_idx: subdis_value}
                    feats = layer[0].getFeature(num_of_features)
                    pr.changeAttributeValues({feats.id(): atts})
                    # self.iface.messageBar().pushMessage("finished run test!", level=Qgis.Info)
                    self.iface.messageBar().pushMessage(
                        "Success! Your 'Geocoding' layer was created.", level=Qgis.Success)

                message_instance = 'Creating layer from ' + layer_name
                self.iface.messageBar().pushMessage(message_instance, level=Qgis.Info)

        elif self.dlgGeocoding.select_file.isChecked() == True and self.dlgGeocoding.select_current.isChecked() == False and self.dlgGeocoding.file_import.text() != '':
            check_num_of_features = file_layer.featureCount()  

            # Show error message if point feature > 1000
            if check_num_of_features > 1000:
                self.iface.messageBar().pushMessage("Error: Your point features are greather than 1000.", level=Qgis.Critical)
            else:
                # Prepare API layer for instance
                API_layer = QgsVectorLayer(
                    "Point?csr=epsg:4326", "sphere reverse geocoding", 'memory')
                QgsProject.instance().addMapLayer(API_layer)

                # Access features of layer
                feature = file_layer.getFeatures()
                num_of_features = 0

                for f in feature:
                    # Get coordinate of point
                    geom = f.geometry()
                    latitude = geom.asPoint().y()
                    longitude = geom.asPoint().x()
                    coor = latitude, longitude
                    num_of_features += 1
                    # self.iface.messageBar().pushMessage(str(coor), level=Qgis.Info)

                    # Get API data from feature point
                    url = "https://api.sphere.gistda.or.th/services/geo/address?lat=" + \
                        str(latitude) + "&lon=" + \
                        str(longitude) + "&key=" + valueKey
                    re = requests.get(url)
                    data = re.json()

                    # Create vector layer
                    API_layer.startEditing()
                    location = QgsGeometry()
                    location = QgsGeometry.fromPointXY(
                        QgsPointXY(longitude, latitude))
                    feat = QgsFeature()
                    feat.setGeometry(location)
                    API_layer.dataProvider().addFeatures([feat])
                    API_layer.commitChanges()

                    # Create fields
                    layer = QgsProject.instance().mapLayersByName('sphere reverse geocoding')
                    pr = layer[0].dataProvider()
                    pr.addAttributes(
                        [QgsField("id", QVariant.String, "text", 254)])
                    pr.addAttributes(
                        [QgsField("geocode", QVariant.String, "text", 254)])
                    pr.addAttributes(
                        [QgsField("province", QVariant.String, "text", 254)])
                    pr.addAttributes(
                        [QgsField("district", QVariant.String, "text", 254)])
                    pr.addAttributes(
                        [QgsField("subdistrict", QVariant.String, "text", 254)])

                    layer[0].updateFields()

                    # Add field value
                    id_idx = layer[0].fields().lookupField('id')
                    code_idx = layer[0].fields(
                    ).lookupField('geocode')
                    province_idx = layer[0].fields().lookupField('province')
                    district_idx = layer[0].fields().lookupField('district')
                    subdistrict_idx = layer[0].fields().lookupField('subdistrict')

                    code_value = data['geocode']
                    prov_value = data['province']
                    district_value = data['district']
                    subdis_value = data['subdistrict']

                    
                    atts = {id_idx: num_of_features,
                            code_idx: code_value,
                            province_idx: prov_value,
                            district_idx: district_value,
                            subdistrict_idx: subdis_value}
                    feats = layer[0].getFeature(num_of_features)
                    pr.changeAttributeValues({feats.id(): atts})
                    # self.iface.messageBar().pushMessage("finished run test!", level=Qgis.Info)
                    self.iface.messageBar().pushMessage(
                        "Success! Your 'Geocoding' layer was created.", level=Qgis.Success)

                message_instance = 'Creating layer from ' + file_path
                self.iface.messageBar().pushMessage(message_instance, level=Qgis.Info)
                
        else:
            self.iface.messageBar().pushMessage(
                "No data of point feature. Please try again.", level=Qgis.Warning)

    #########################################################################################################################################################################################################
    
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&GISTDA sphere open data'),
                action)
            self.iface.removeToolBarIcon(action)

    # run dialog for menu 1: input key
    def runKey(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = sphereOpendataDialog()

            # hide key when input
            self.dlg.lineEdit.setEchoMode(QLineEdit.Password)

            # Get result message when click OK
            self.dlg.button_box.accepted.connect(self.inputAPIkey)

            # Sign-up for creating a key
            self.dlg.signUpBtn.clicked.connect(self.signUpForKey)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
    
    # run dialog for menu 2: crop feature
    def runCrop(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlgCrop = CropDialog()
        
        # Detect API key value
        valueKey = self.dlg.lineEdit.text()
        if valueKey == '':
            self.iface.messageBar().pushMessage(
                "Please input your API key.", level=Qgis.Warning)
        else:
            # Clear the contents of the comboBox from previous runs
            self.dlgCrop.comboBox.clear()
            self.dlgCrop.file_import.clear()
            self.dlgCrop.API_list_crop.clear()

            # Get only point vector layer to display in comboBox
            vector_names = [l.name() for l in QgsProject().instance(
            ).mapLayers().values() if isinstance(l, QgsVectorLayer)]
            for c in QgsProject().instance().mapLayers().values():
                if isinstance(c, QgsVectorLayer):
                    if c.wkbType() == 1:
                        #self.iface.messageBar().pushMessage(str(c.name()), level=Qgis.Info)
                        self.dlgCrop.comboBox.addItems([c.name()])

            # Set default, select layer from project is already checked when open window
            self.dlgCrop.select_current.setChecked(True)
            self.dlgCrop.comboBox.setEnabled(True)
            self.dlgCrop.file_import.setEnabled(False)
            self.dlgCrop.search_file.setEnabled(False)

            # Display check condition when select option
            self.dlgCrop.select_current.clicked.connect(self.checkSelectCrop)
            self.dlgCrop.select_file.clicked.connect(self.checkSelectCrop)

            # Menu 2: Select API
            api_list_crop = ['Crop suitability', 'Crop information']
            self.dlgCrop.API_list_crop.addItems(api_list_crop)

            # show the dialog
            self.dlgCrop.show()
            # Run the dialog event loop
            result = self.dlgCrop.exec_()
            # See if OK was pressed
            if result:
                # Do something useful here - delete the line containing pass and
                # substitute with your code.
                pass
    
    # run dialog for menu 3: disaster recurring
    def runDisaster(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlgDisaster = DisasterDialog()
        
        # Detect API key value
        valueKey = self.dlg.lineEdit.text()
        if valueKey == '':
            self.iface.messageBar().pushMessage(
                "Please input your API key.", level=Qgis.Warning)
        else:
            # Clear the contents of the comboBox from previous runs
            self.dlgDisaster.comboBox.clear()
            self.dlgDisaster.file_import.clear()

            # Get only point vector layer to display in comboBox
            vector_names = [l.name() for l in QgsProject().instance(
            ).mapLayers().values() if isinstance(l, QgsVectorLayer)]
            for c in QgsProject().instance().mapLayers().values():
                if isinstance(c, QgsVectorLayer):
                    if c.wkbType() == 1:
                        #self.iface.messageBar().pushMessage(str(c.name()), level=Qgis.Info)
                        self.dlgDisaster.comboBox.addItems([c.name()])

            # Set default, select layer from project is already checked when open window
            self.dlgDisaster.select_current.setChecked(True)
            self.dlgDisaster.comboBox.setEnabled(True)
            self.dlgDisaster.file_import.setEnabled(False)
            self.dlgDisaster.search_file.setEnabled(False)

            # Display check condition when select option
            self.dlgDisaster.select_current.clicked.connect(self.checkSelectDisaster)
            self.dlgDisaster.select_file.clicked.connect(self.checkSelectDisaster)

            # show the dialog
            self.dlgDisaster.show()
            # Run the dialog event loop
            result = self.dlgDisaster.exec_()
            # See if OK was pressed
            if result:
                # Do something useful here - delete the line containing pass and
                # substitute with your code.
                pass
    
    # run dialog for menu 4: elevation
    def runElevation(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlgElevation = ElevationDialog()
        
        # Detect API key value
        valueKey = self.dlg.lineEdit.text()
        if valueKey == '':
            self.iface.messageBar().pushMessage(
                "Please input your API key.", level=Qgis.Warning)
        else:
            # Clear the contents of the comboBox from previous runs
            self.dlgElevation.comboBox.clear()
            self.dlgElevation.file_import.clear()

            # Get only point vector layer to display in comboBox
            vector_names = [l.name() for l in QgsProject().instance(
            ).mapLayers().values() if isinstance(l, QgsVectorLayer)]
            for c in QgsProject().instance().mapLayers().values():
                if isinstance(c, QgsVectorLayer):
                    if c.wkbType() == 1:
                        #self.iface.messageBar().pushMessage(str(c.name()), level=Qgis.Info)
                        self.dlgElevation.comboBox.addItems([c.name()])

            # Set default, select layer from project is already checked when open window
            self.dlgElevation.select_current.setChecked(True)
            self.dlgElevation.comboBox.setEnabled(True)
            self.dlgElevation.file_import.setEnabled(False)
            self.dlgElevation.search_file.setEnabled(False)

            # Display check condition when select option
            self.dlgElevation.select_current.clicked.connect(self.checkSelectElevation)
            self.dlgElevation.select_file.clicked.connect(self.checkSelectElevation)

            # Import layer from file when click '...' button (Move to initGui() > add_action())
            # self.dlgElevation.search_file.clicked.connect(self.importFileElevation)

            # Get API layers when click 'OK' button
            # self.dlgElevation.button_box.accepted.connect(self.getElevation)

            # show the dialog
            self.dlgElevation.show()
            # Run the dialog event loop
            result = self.dlgElevation.exec_()
            # See if OK was pressed
            if result:
                # Do something useful here - delete the line containing pass and
                # substitute with your code.
                pass
    
    # run dialog for menu 5: reverse geocoding
    def runGeocoding(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlgGeocoding = GeocodingDialog()
        
        # Detect API key value
        valueKey = self.dlg.lineEdit.text()
        if valueKey == '':
            self.iface.messageBar().pushMessage(
                "Please input your API key.", level=Qgis.Warning)
        else:
            # Clear the contents of the comboBox from previous runs
            self.dlgGeocoding.comboBox.clear()
            self.dlgGeocoding.file_import.clear()

            # Get only point vector layer to display in comboBox
            vector_names = [l.name() for l in QgsProject().instance().mapLayers().values() if isinstance(l, QgsVectorLayer)]
            for c in QgsProject().instance().mapLayers().values():
                if isinstance(c, QgsVectorLayer):
                    if c.wkbType() == 1:
                        #self.iface.messageBar().pushMessage(str(c.name()), level=Qgis.Info)
                        self.dlgGeocoding.comboBox.addItems([c.name()])

            # Set default, select layer from project is already checked when open window
            self.dlgGeocoding.select_current.setChecked(True)
            self.dlgGeocoding.comboBox.setEnabled(True)
            self.dlgGeocoding.file_import.setEnabled(False)
            self.dlgGeocoding.search_file.setEnabled(False)

            # Display check condition when select option
            self.dlgGeocoding.select_current.clicked.connect(self.checkSelectGeocoding)
            self.dlgGeocoding.select_file.clicked.connect(self.checkSelectGeocoding)

            # Import layer from file when click '...' button (Move to initGui() > add_action() for menu 5 to solve bug in open window)
            # self.dlgGeocoding.search_file.clicked.connect(self.importFileGeocoding)

            # Get API layers when click 'OK' button
            # self.dlgGeocoding.button_box.accepted.connect(self.getGeocoding)

            # show the dialog
            self.dlgGeocoding.show()
            # Run the dialog event loop
            result = self.dlgGeocoding.exec_()
            # See if OK was pressed
            if result:
                # Do something useful here - delete the line containing pass and
                # substitute with your code.
                pass