# -*- coding: utf-8 -*-
"""
/***************************************************************************
 sphereBasemap
                                 A QGIS plugin
 A plugin for adding base map layers from GISTDA sphere platform (https://sphere.gistda.or.th/).
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-11
        git sha              : $Format:%H$
        copyright            : (C) 2023 by GISTDA sphere
        email                : sphere@gistda.or.th
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QLineEdit
from qgis.core import *
from qgis.PyQt.QtCore import *
import webbrowser

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .gistda_sphere_basemap_dialog import sphereBasemapDialog
import os.path


class sphereBasemap:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'sphereBasemap_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&GISTDA sphere basemap')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        self.dlg = sphereBasemapDialog()

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('sphereBasemap', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=False,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToRasterMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        # icon for layer menu
        icon_path = f'{self.plugin_dir}/icon.png'
        icon_key = f'{self.plugin_dir}/key.png'
        
        # Input API key
        self.add_action(
            icon_key,
            text=self.tr(u'Input API key'),
            callback=self.run,
            parent=self.iface.mainWindow())
        
        # list of layers
        self.add_action(
            icon_path,
            text=self.tr(u'sphere streets'),
            callback=self.sphereStreets,
            parent=self.iface.mainWindow())
    
        self.add_action(
            icon_path,
            text=self.tr(u'sphere hybrid'),
            callback=self.sphereHybrid,
            parent=self.iface.mainWindow())
    
        self.add_action(
            icon_path,
            text=self.tr(u'sphere transparent'),
            callback=self.sphereTransparent,
            parent=self.iface.mainWindow())
        
        self.add_action(
            icon_path,
            text=self.tr(u'sphere Thailand images'),
            callback=self.ThailandImages,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True
    
    # Operating function for input key
    def inputAPIkey(self):
        valueKey = self.dlg.lineEdit.text()
        # messagePopup = "Your key '" + valueKey + "' were added"
        mss = "Success! Your API key were added."
        emptyKey = "API key value still empty."
        if valueKey == '':
            self.iface.messageBar().pushMessage(emptyKey, level=Qgis.Info)
        else:
            self.iface.messageBar().pushMessage(mss, level=Qgis.Success)
    
    # Sign-up for getting a key
    def signUpForKey(self):
        signUpURL = 'https://auth.sphere.gistda.or.th/auth/realms/sphere/protocol/openid-connect/registrations?client_id=frontend-iframe&redirect_uri=https%3A%2F%2Fsphere.gistda.or.th%2Fdashboard&state=2fdbcbfb-493f-4b8d-ab4b-f693002ab78a&response_mode=fragment&response_type=code&scope=openid&nonce=43abe85b-4651-4251-9f64-8b0876d30f02&ui_locales=th'
        webbrowser.open(signUpURL)

    # add basemap by url : sphere_streets
    def sphereStreets(self):
        valueKey = self.dlg.lineEdit.text()
        if valueKey == '':
            self.iface.messageBar().pushMessage(
                "Please input your API key.", level=Qgis.Warning)
        else:
            url_streets = 'type=xyz&url=https://basemap.sphere.gistda.or.th/tiles/sphere_streets/EPSG3857/{z}/{x}/{y}.png?key=' + valueKey
            rlayer_streets = QgsRasterLayer(url_streets, 'GISTDA sphere streets', 'wms')
            QgsProject.instance().addMapLayer(rlayer_streets)
            self.iface.messageBar().pushMessage('Success to add sphere streets layer', level=Qgis.Success)

    # add basemap by url : sphere_hybrid
    def sphereHybrid(self):
        valueKey = self.dlg.lineEdit.text()
        if valueKey == '':
            self.iface.messageBar().pushMessage(
                "Please input your API key.", level=Qgis.Warning)
        else:
            url_streets = 'type=xyz&url=https://basemap.sphere.gistda.or.th/tiles/sphere_hybrid/EPSG3857/{z}/{x}/{y}.jpeg?key=' + valueKey
            rlayer_streets = QgsRasterLayer(url_streets, 'GISTDA sphere hybrid', 'wms')
            QgsProject.instance().addMapLayer(rlayer_streets)
            self.iface.messageBar().pushMessage('Success to add sphere hybrid layer', level=Qgis.Success)
    
    # add basemap by url : sphere_transparent
    def sphereTransparent(self):
        valueKey = self.dlg.lineEdit.text()
        if valueKey == '':
            self.iface.messageBar().pushMessage(
                "Please input your API key.", level=Qgis.Warning)
        else:
            url_streets = 'type=xyz&url=https://basemap.sphere.gistda.or.th/tiles/sphere_transparent/EPSG3857/{z}/{x}/{y}.png?key=' + valueKey
            rlayer_streets = QgsRasterLayer(url_streets, 'GISTDA sphere transparent', 'wms')
            QgsProject.instance().addMapLayer(rlayer_streets)
            self.iface.messageBar().pushMessage('Success to add sphere transparent layer', level=Qgis.Success)
    
    # add basemap by url : sphere_thailand_images
    def ThailandImages(self):
        valueKey = self.dlg.lineEdit.text()
        if valueKey == '':
            self.iface.messageBar().pushMessage(
                "Please input your API key.", level=Qgis.Warning)
        else:
            url_streets = 'type=xyz&url=https://basemap.sphere.gistda.or.th/tiles/thailand_images/EPSG3857/{z}/{x}/{y}.jpeg?key=' + valueKey
            rlayer_streets = QgsRasterLayer(url_streets, 'GISTDA sphere Thailand images', 'wms')
            QgsProject.instance().addMapLayer(rlayer_streets)
            self.iface.messageBar().pushMessage('Success to add Thailand images layer', level=Qgis.Success)

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginRasterMenu(
                self.tr(u'&GISTDA sphere basemap'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = sphereBasemapDialog()
        
        # hide key when input
        self.dlg.lineEdit.setEchoMode(QLineEdit.Password)

        # Get result message when click OK
        self.dlg.button_box.accepted.connect(self.inputAPIkey)

        # Sign-up for creating a key
        self.dlg.signUp.clicked.connect(self.signUpForKey)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
