# -*- coding: utf-8 -*-
"""
/***************************************************************************
 wyszukiwarkaDzialekDockWidget
                                 A QGIS plugin
 desc
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-07-05
        git sha              : $Format:%H$
        copyright            : (C) 2018 by umcs
        email                : mail@mail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import QtGui, QtWidgets, uic
from PyQt5.QtCore import pyqtSignal
from qgis.core import QgsMapLayerProxyModel

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'plugin_dockwidget_base.ui'))

class wyszukiwarkaDzialekDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        super(wyszukiwarkaDzialekDockWidget, self).__init__(parent)
        self.setupUi(self)

        self.comboLayers.setFilters(QgsMapLayerProxyModel.PolygonLayer)
        self.radioExistingLayer.toggled.connect(self.comboLayers.setEnabled)

        self.radioTempLayer.setChecked(True)
        self.comboLayers.setEnabled(False)

        self.tabs.currentChanged.connect(self._update_layer_selection_ui)
        self._update_layer_selection_ui(self.tabs.currentIndex())

    def _update_layer_selection_ui(self, index: int) -> None:
        tab_text = self.tabs.tabText(index)
        restricted_tabs = ["Sprawdź"]
        if tab_text in restricted_tabs:
            self.radioTempLayer.setChecked(True)
            self.radioExistingLayer.setEnabled(False)
            self.comboLayers.setEnabled(False)
        else:
            self.radioExistingLayer.setEnabled(True)
            self.comboLayers.setEnabled(self.radioExistingLayer.isChecked())

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()
