# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GisCartaQGISDialog
                                 A QGIS plugin
 Manage your GISCARTA data
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-09-07
        git sha              : $Format:%H$
        copyright            : (C) 2023 by GISCARTA
        email                : support@giscarta.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from pathlib import Path

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt import QtCore
from PyQt5.QtGui import QPixmap, QIcon
from PyQt5.QtWidgets import QLineEdit
from qgis.PyQt.QtWidgets import QLabel

from PyQt5.QtSvg import QSvgRenderer
from PyQt5.QtGui import QPainter

from PyQt5.QtCore import QRectF

from ..constants import (
    AUTH_STYLE_MAC, AUTH_STYLE_WIN
)

from sys import platform 

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
root_path = Path(__file__).parents[1]
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    root_path, 'ui', 'giscarta_dialog_base.ui'))


class GisCartaQGISDialog(QtWidgets.QDialog, FORM_CLASS):
    
    BANNER_WIDTH_PIXELS = 541 # 3246
    BANNER_HEIGHT_PIXELS = 282 # 1692
    
    def __init__(self, parent=None):
        """Constructor."""
        super(GisCartaQGISDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        #self.setStyleSheet('background-color: #ececec;')
        #print(__file__)
        # self.setWindowFlags(Qt.CustomizeWindowHint | Qt.WindowTitleHint)
        root_path = Path(__file__).parents[1]
        
        self.setupUi(self)
        
        self.svg_path = os.path.join(root_path, 'icons', 'background_new.svg')
        self.svg_renderer = QSvgRenderer(self.svg_path)
        
        self.png_path = os.path.join(root_path, 'icons', 'background_el.png')
        
        self.svg_path2 = os.path.join(root_path, 'icons', 'Elements.svg')
        self.svg_renderer2 = QSvgRenderer(self.svg_path2)

        imgPath_logo_mini = os.path.join(root_path, 'icons', 'icon.png')
        self.setWindowIcon(QIcon(imgPath_logo_mini))
                
        if platform == "win32":
            self.setStyleSheet(AUTH_STYLE_WIN)
        else:
            self.setStyleSheet(AUTH_STYLE_MAC)
       
        self.setup_dynamic_borders()
        
    def paintEvent(self, event):
        super().paintEvent(event)
        try:
            painter = QPainter(self)
            painter.setRenderHint(QPainter.Antialiasing, True)
            if self.svg_renderer.isValid():
                rect_f = QRectF(self.rect())
                self.svg_renderer.render(painter, rect_f)
                
            if os.path.exists(self.png_path):
                png_pixmap = QPixmap(self.png_path)
                if not png_pixmap.isNull():
                    scaled_pixmap = png_pixmap.scaled(
                        541,
                        282,
                        QtCore.Qt.KeepAspectRatioByExpanding,
                        QtCore.Qt.SmoothTransformation
                    )
                    painter.drawPixmap(0, 0, scaled_pixmap)                 
            if self.svg_renderer.isValid():
                rect_f2 = QRectF(self.rect())
                self.svg_renderer2.render(painter, rect_f2)
        except Exception as e:
            print(f"Ошибка при отрисовке SVG: {e}")
        finally:
            painter.end()
    
    def setup_dynamic_borders(self):
        fields = [self.domain, self.username, self.password]
        
        for field in fields:
            field.setProperty("hasContent", False)
            self.update_field_style(field)
            
            field.textChanged.connect(lambda text, f=field: self.on_field_text_changed(f))
            field.installEventFilter(self)
    
    def on_field_text_changed(self, field):
        has_content = bool(field.text() and field.text().strip())
        field.setProperty("hasContent", has_content)
        self.update_field_style(field)
    
    def eventFilter(self, obj, event):
        if isinstance(obj, QLineEdit):
            if event.type() == event.FocusIn:
                obj.setProperty("hasFocus", True)
                self.update_field_style(obj)
            elif event.type() == event.FocusOut:
                obj.setProperty("hasFocus", False)
                self.update_field_style(obj)
        return super().eventFilter(obj, event)
    
    def update_field_style(self, field):
        has_content = field.property("hasContent")
        has_focus = field.property("hasFocus")
        
        if has_focus or has_content:
            border_style = "1px solid #44D9BC"
        else:
            border_style = "1px solid transparent"
        
        style = f"""
        background-color: #294869;
        border: {border_style};
        border-radius: 8px;
        color: white;
        padding: 0px 8px;
        """
        
        field.setStyleSheet(style)