# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GisCartaQGISDialog
                                 A QGIS plugin
 Manage your GisCarta data
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-09-07
        git sha              : $Format:%H$
        copyright            : (C) 2023 by GisCarta
        email                : info@giscarta.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from pathlib import Path

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from PyQt5.QtGui import QPixmap, QIcon
from qgis.PyQt.QtWidgets import (
    QLabel
)

from ..constants import (
    AUTH_STYLE_MAC, AUTH_STYLE_WIN
)

from sys import platform


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
root_path = Path(__file__).parents[1]
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    root_path, 'ui', 'giscarta_dialog_base.ui'))


class GisCartaQGISDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(GisCartaQGISDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        #self.setStyleSheet('background-color: #ececec;')
        #print(__file__)
        # self.setWindowFlags(Qt.CustomizeWindowHint | Qt.WindowTitleHint)
        root_path = Path(__file__).parents[1]
        imgPath_logo_mini = os.path.join(
            root_path,
            'icons',
            'icon.png',
            )
        icon = QIcon()
        wtPixmap = QPixmap(imgPath_logo_mini)
        icon.addPixmap(wtPixmap)
        self.setWindowIcon(icon)

        imgPath_banner = os.path.join(
            root_path,
            'icons',
            'giscarta-banner.svg',
            )
        self.pixmap_banner = QPixmap(imgPath_banner)
        
        self.label_banner = QLabel(self)
        self.label_banner.setPixmap(self.pixmap_banner)
        self.label_banner.resize(self.pixmap_banner.width(),
                          self.pixmap_banner.height())
        self.label_banner.move(210, 26)
        self.label_banner.setStyleSheet("background-color:rgba(31,46,65,1.0)")

        imgPath_logo = os.path.join(
            root_path,
            'icons',
            'giscarta-logo.svg',
            )
        self.pixmap_logo = QPixmap(imgPath_logo)
        
        self.label_logo = QLabel(self)
        self.label_logo.setPixmap(self.pixmap_logo)
        self.label_logo.resize(self.pixmap_logo.width(),
                          self.pixmap_logo.height())
        self.label_logo.move(297, 32)
        # self.label.setStyleSheet("font-size: 72px;font-weight:bold; color:black; background-color:rgba(0,0,0,.0)")
        self.label_logo.setStyleSheet("background-color:rgba(31,46,65,1.0)")
        # print(AUTH_STYLE)
        
        
        if platform == "win32":
            self.setStyleSheet(AUTH_STYLE_WIN)
        else:
            self.setStyleSheet(AUTH_STYLE_MAC)

        self.setupUi(self)
