# -*- coding: utf-8 -*-

"""
/***************************************************************************
 gis3d
                                 A QGIS plugin
 This plugins generates a 3D model based on the inputs
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-11-30
        copyright            : (C) 2023 by chenkianwee
        email                : chenkianwee@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'chenkianwee'
__date__ = '2023-11-30'
__copyright__ = '(C) 2023 by chenkianwee'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import subprocess
import pathlib
import inspect

from importlib import util
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsProcessingProvider


# check if all the required libraries are installed
plugin_dir = pathlib.Path(__file__).parent.resolve()

try:
    import pip

except (ModuleNotFoundError, ImportError) as e:
    python_interp = sys.executable
    get_pip_path = str(pathlib.Path(plugin_dir, 'scripts', 'get-pip.py'))
    subprocess.run([python_interp, get_pip_path])
    import pip
    # just in case the included version is old
    pip.main(['install', '--upgrade', 'pip'])

with open(str(pathlib.Path(plugin_dir,'requirements.txt')), "r") as requirements:
    for dep in requirements.readlines():
        dep = dep.replace('\n', '')
        dep_version = dep.strip().split("==")[0]
        dep_specs = util.find_spec(dep_version)
        if dep_specs == None:
            # pip install the dependencies 
            # print("{} not available, installing".format(dep_version))
            # subprocess.check_call([sys.executable, "-m", "pip", "install", dep, "-y"])
            pip.main(['install', dep])

from .algs import (
    estimate_tree_height_grids,
    extrude3d
    )

class gis3dProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        # add additional algorithms here
        self.addAlgorithm(extrude3d.extrude3D())
        self.addAlgorithm(estimate_tree_height_grids.treeHeightGrids())
        
    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'gis3d'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('gis3d')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
