# -*- coding: utf-8 -*-

"""
/***************************************************************************
 gis3d
                                 A QGIS plugin
 This plugins generates a 3D model based on the inputs
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-11-30
        copyright            : (C) 2023 by chenkianwee
        email                : chenkianwee@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'chenkianwee'
__date__ = '2023-11-30'
__copyright__ = '(C) 2023 by chenkianwee'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon

from qgis.core import QgsProcessingAlgorithm, QgsApplication
import processing
from .gis3d_provider import gis3dProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class gis3dPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = gis3dProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

        icon_tree = os.path.join(os.path.join(cmd_folder, 'tree_logo.png'))
        self.action_tree = QAction( QIcon(icon_tree), u"tree_height_grids", self.iface.mainWindow())
        self.action_tree.triggered.connect(self.run_estimate_tree_heights)

        icon_ext = os.path.join(os.path.join(cmd_folder, 'ext_logo.png'))
        self.action_ext = QAction( QIcon(icon_ext), u"extrude3d", self.iface.mainWindow())
        self.action_ext.triggered.connect(self.run_extrude3d)

        self.iface.addPluginToMenu(u"&gis3d", self.action_tree)
        # self.iface.addPluginToVectorMenu(u"&gis3d", self.action_tree)
        self.iface.addToolBarIcon(self.action_tree)
        self.iface.addPluginToMenu(u"&gis3d", self.action_ext)
        # self.iface.addPluginToVectorMenu(u"&gis3d", self.action_ext)
        self.iface.addToolBarIcon(self.action_ext)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)

        for action in [self.action_tree,self.action_ext]:
            self.iface.removePluginMenu(u"&gis3d", action)
            # self.iface.removePluginVectorMenu(u"&gis3d", action)
            self.iface.removeToolBarIcon(action)
    
    def run_estimate_tree_heights(self):
        processing.execAlgorithmDialog("gis3d:tree_height_grids")
    
    def run_extrude3d(self):
        processing.execAlgorithmDialog("gis3d:extrude3d")
