#
# This file is part of GHydraulics
#
# GHydraulicsCommon.py - Base class 
#
# Copyright 2007 - 2013 Steffen Macke <sdteffen@sdteffen.de>
#
# GHydraulics is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GHydraulics is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#

from pickle import *
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
from qgis import *
from EpanetModel import *

# Base class with common functionality
class GHydraulicsCommon:
    NAME = 'GHydraulics'

    # message logging
    def log(self, message):
        QgsMessageLog.instance().logMessage(message, self.NAME)
    
    # Read the layers from the project
    def getLayers(self):
        self.layers = {}
        project = QgsProject.instance()
        for section in EpanetModel.GIS_SECTIONS:
            pickle_list = str(project.readEntry("ghydraulics", section, "")[0])
            if '' != pickle_list:
                # Windows QGIS injects some carriage returns here
                pickle_list = pickle_list.replace('\r','')
                try:
                    l = loads(pickle_list)
                    if 0 < len(l):
                        self.layers[section] = l
                    else:
                        self.layers[section] = []
                except(KeyError):
                    self.layers[section] = []

    # Ensure that we work with a point geometry
    def getFirstMultiPoint(self, geometry):
        collection = geometry.asGeometryCollection()
        if 0 < len(collection):
            return collection[0].asPoint()
        return geometry.asPoint()

    # Run the given callback function on each layer
    def eachLayer(self, callback):
        # loop over all sections
        for section in EpanetModel.GIS_SECTIONS:
            #loop over all layers
            if not self.layers.has_key(section):
                continue
            for name in self.layers[section]:
                maplayers = QgsMapLayerRegistry.instance().mapLayers()
                for l,layer in maplayers.iteritems():
                    if layer.type() == QgsMapLayer.VectorLayer and layer.name() == name:
                        callback(layer)

    # Return the field name index or raise an exception
    def fieldNameIndex(self, layer, fieldname):
        idx = layer.dataProvider().fieldNameIndex(fieldname)
        if -1 == idx:
            raise GHydraulicsException('ERROR: Failed to locate '+fieldname+' field in layer '+layer.name())
        return idx
