#
# This file is part of GHydraulics
#
# GHydraulicsSettingsDialog.py - Manage settings for projects
#
# Copyright 2007 - 2013 Steffen Macke <sdteffen@sdteffen.de>
#
# GHydraulics is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GHydraulics is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# QGIS 1.0.0 or better required to run this file
#
from pickle import *
import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
from EpanetModel import *
from Ui_GHydraulicsSettingsDialog import *

class GHydraulicsSettingsDialog(QDialog):
    # Store all configuration data under this key
    SETTINGS = 'ghydraulics'
    # Store auto length configuration under this key
    AUTO_LENGTH = 'autolength'
    STRING_TRUE = '1'
    
    def accepted(self):
        # Store layers
        proj = QgsProject.instance()
        for i in range(0,6):
            treewidget = self.ui.treeWidget.topLevelItem(i)
            layers = []
            for j in range(0,treewidget.childCount()):
                layers.append(str(treewidget.child(j).text(0)))
            proj.writeEntry("ghydraulics",EpanetModel.GIS_SECTIONS[i], dumps(layers))
        # Store Inp file
        templatedir = os.path.join(os.path.dirname(__file__), 'etc')
        template = str(self.ui.inpFileLineEdit.text()).replace(templatedir+os.path.sep, '')
        proj.writeEntry("ghydraulics","templateinpfile", template)
        # Store auto length configuration
        autoLength = '0'
        if self.ui.autoLengthCB.isChecked():
            autoLength = self.STRING_TRUE
        proj.writeEntry(self.SETTINGS, self.AUTO_LENGTH, autoLength)

    def selectInpFile(self):
        f = QFileDialog.getOpenFileName()
        if 0 < len(f):
            self.ui.inpFileLineEdit.setText(f)

    def getTemplate(self):
        project = QgsProject.instance()
        template = str(project.readEntry("ghydraulics", "templateinpfile")[0])
        if os.path.isfile(template):
            return template
        templatedir = os.path.join(os.path.dirname(__file__), 'etc')
        templatepath = os.path.join(templatedir, template)
        if os.path.isfile(templatepath):
                return templatepath
        return os.path.join(templatedir, 'template_d-w_cmd.inp')

    # True if length should be calculated automatically, otherwise false
    def getAutoLength(self):
        project = QgsProject.instance()
        return  self.STRING_TRUE == str(project.readEntry(self.SETTINGS, self.AUTO_LENGTH)[0])

    def __init__(self):
        QDialog.__init__(self)
        self.ui = Ui_GHydraulicsSettingsDialog()
        self.ui.setupUi(self)
        QObject.connect(self.ui.buttonBox, SIGNAL("accepted()"), self.accepted)
        QObject.connect(self.ui.inpFilePushButton, SIGNAL("clicked()"), self.selectInpFile)
