#
# This file is part of GHydraulics
#
# GHydraulicsInpWriter.py - Write INP files
#
# Copyright 2007 - 2012 Steffen Macke <sdteffen@sdteffen.de>
#
# GHydraulics is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GHydraulics is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# QGIS 1.8.0 or better required to run this file
#
from pickle import *
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
from qgis import *
from EpanetModel import *

# Base class with common functionality
class GHydraulicsCommon:

    # Read the layers from the project
    def getLayers(self):
        self.layers = {}
        project = QgsProject.instance()
        for section in EpanetModel.GIS_SECTIONS:
            pickle_list = str(project.readEntry("ghydraulics", section, "")[0])
            if '' != pickle_list:
                # Windows QGIS injects some carriage returns here
                pickle_list = pickle_list.replace('\r','')
                try:
                    l = loads(pickle_list)
                    if 0 < len(l):
                        self.layers[section] = l
                    else:
                        self.layers[section] = []
                except(KeyError):
                    self.layers[section] = []
