#
# This file is part of GHydraulics
#
# GHydraulicsModel.py - Encapsulates GHydraulics model stucture and logic
#
# Copyright 2012, 2013 Steffen Macke <sdteffen@sdteffen.de>
#
# GHydraulics is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GHydraulics is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#

from PyQt4.QtCore import *

# Describe the model structure
class GHydraulicsModel:
    NODE_SECTIONS = ['JUNCTIONS', 'RESERVOIRS', 'PUMPS', 'VALVES', 'TANKS']
    ID_FIELD = 'DC_ID'

    # maximum distance between nodes and line end vertices
    SNAP_RADIUS = 0.1

    # Intended length of virtual lines. Actual virtual lines might be shorter,
    # depending on the length of the first segment
    VIRTUAL_LINE_LENGTH = 1.0
    VIRTUAL_POSTFIX = 'dn'

    # Preferred column types
    COLUMN_TYPES = {
        'DC_ID': QVariant.String,
        'DIAMETER': QVariant.Double,
        'DEMAND': QVariant.Double,
        'ELEVATION': QVariant.Double,
        'HEAD': QVariant.Double,
        'LENGTH': QVariant.Double,
        'INITIALLEV': QVariant.Double,
        'MAXIMUMLEV': QVariant.Double,
        'MINIMUMLEV': QVariant.Double,
        'MINIMUMVOL': QVariant.Double,
        'MINORLOSS': QVariant.Double,
        'NODE1': QVariant.String,
        'NODE2': QVariant.String,
        'PATTERN': QVariant.String,
        'PROPERTIES':QVariant.String,
        'ROUGHNESS': QVariant.String,
        'SETTTING': QVariant.String,
        'STATUS': QVariant.String,
        'TYPE': QVariant.String,
        'VOLUMECURV': QVariant.String
        }
