# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GetBaseLine
                                 A QGIS plugin
 GetBaseLine
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-07-24
        git sha              : $Format:%H$
        copyright            : (C) 2023 by LX
        email                : celesti@lx.or.kr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

"""

import os
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.core import QgsProject, QgsVectorLayer, Qgis, QgsVectorFileWriter, QgsField, QgsExpression, QgsExpressionContextUtils, QgsExpressionContext, QgsFillSymbol
from qgis.PyQt.QtCore import QVariant
import processing

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .GetBaseLine_dialog import GetBaseLineDialog
import os.path


class GetBaseLine:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'GetBaseLine_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&GetBaseLine')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('GetBaseLine', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/GetBaseLine/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'GetBaseLine'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&GetBaseLine'),
                action)
            self.iface.removeToolBarIcon(action)

    def select_output_file(self):
        output_filename, _filter = QFileDialog.getSaveFileName(
            self.dlg, "Select   output file ", "", '*.shp')
        self.dlg.lineEdit.setText(output_filename)

    def select_input_file(self):
        input_filename, _filter = QFileDialog.getOpenFileName(
            self.dlg, "Select input file ", "", '*.shp')

        for i in range(0, self.dlg.comboBox.count()) :
            if input_filename == self.dlg.comboBox.itemText(i):
                self.dlg.comboBox.removeItem(i)
            else:
                pass

        self.dlg.comboBox.addItems([input_filename])

        self.dlg.comboBox.setCurrentIndex(self.dlg.comboBox.count() - 1)

    def run(self):
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = GetBaseLineDialog()
            self.dlg.pushButton.clicked.connect(self.select_output_file)
            self.dlg.inputButton.clicked.connect(self.select_input_file)

        self.dlg.comboBox.clear()
        layers = QgsProject.instance().layerTreeRoot().children()
        self.dlg.comboBox.addItems([layer.name() for layer in layers])

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            output_fieldnames = self.dlg.lineEdit.text()

            input_filename = self.dlg.comboBox.currentText()
            print(input_filename)

            flayer = QgsVectorLayer(input_filename, "poly", "ogr")
            if not flayer.isValid():
                print("Layer failed to load!: ", input_filename)
            else:
                print("Layer loaded!")

            f_name = os.path.splitext(os.path.basename(input_filename))[0] + "_temp"
            file_num = 0
            dup_chk_fin = False
            dup_chk_num = 0
            new_name = f_name

            self.iface.messageBar().pushMessage("name", "# of layer:" + str(len(layers)), level=Qgis.Info, duration=3)

            while dup_chk_fin == False:
                file_num += 1
                dup_chk_num = 0

                for layer in layers:
                    if new_name == layer.name():
                        self.iface.messageBar().pushMessage("name", "The same layer exists. Renaming " +new_name, level=Qgis.Info,
                                                            duration=3)
                        new_name = f_name + "(" + str(file_num) + ")"
                        break
                    else:
                        dup_chk_num += 1
                if len(layers) == dup_chk_num:
                    dup_chk_fin = True
                    f_name = new_name
            self.iface.messageBar().pushMessage("name", "# of check: " + str(dup_chk_num), level=Qgis.Info, duration=3)


            temp_filename = ''.join(os.path.dirname(input_filename)) +"/"+ f_name + ".shp"
            self.iface.messageBar().pushMessage("name", temp_filename, level=Qgis.Info, duration=3)
            save_options = QgsVectorFileWriter.SaveVectorOptions()
            save_options.driverName = "ESRI Shapefile"
            save_options.fileEncoding = "UTF-8"
            transform_context = QgsProject.instance().transformContext()

            error = QgsVectorFileWriter.writeAsVectorFormatV3(flayer, temp_filename, transform_context, save_options)

            if error[0] == QgsVectorFileWriter.NoError:
                print("temp layer created.")
            else:
                print(error)


            path_to_poly_layer = temp_filename
            vlayer = QgsVectorLayer(path_to_poly_layer, f_name, "ogr")
            if not vlayer.isValid():
                print("Duplicated Layer failed to load!")
            else:
                QgsProject.instance().addMapLayer(vlayer)
                print("Duplicated Layer loaded!")

            symbol = QgsFillSymbol.createSimple(
                {"outline_style": "solid", "outline_color": "black", "color": "#00ff0000", "outline_width": "0.5"})

            vlayer.renderer().setSymbol(symbol)
            vlayer.triggerRepaint()
            self.iface.layerTreeView().refreshLayerSymbology(vlayer.id())

            bfield_cnt = 0
            pnufield_cnt = 0
            for f in vlayer.fields():
                if f.name() == "BUNGI" or f.name() == "bungi":
                    bfield_cnt += 1
                elif f.name() == "PNU" or f.name() == "pnu":
                    pnufield_cnt += 1

            if pnufield_cnt < 1:
                print("PNU field is not existed")
                self.iface.messageBar().pushMessage("No PNU", "This file(" + input_filename + ") doesn't have PNU.", level=Qgis.Info, duration=3)
            else:
                print("PNU validation checked OK")

                if bfield_cnt > 0:
                    print("bungi validation checked OK")
                else:
                    pr = vlayer.dataProvider()
                    pr.addAttributes([QgsField("bungi", QVariant.String)])
                    vlayer.updateFields()
                    print("bungi field is created")

                expression1 = QgsExpression('left("PNU", 15)')
                expression2 = QgsExpression('length("PNU" )')
                context = QgsExpressionContext()
                context.appendScopes(QgsExpressionContextUtils.globalProjectLayerScopes(vlayer))

                pnu_count = 0
                pnu_valid = 0
                pnu_len = 0

                vlayer.beginEditCommand("Feature triangulation")
                vlayer.startEditing()

                for field in vlayer.getFeatures():
                    pnu_count += 1

                    context.setFeature(field)
                    field["bungi"] = expression1.evaluate(context)
                    pnu_len = expression2.evaluate(context)
                    if pnu_len == 19:
                        pnu_valid += 1
                        vlayer.updateFeature(field)

                        print(field["bungi"], pnu_count)
                    #vlayer.changeAttributeValue(field)

                vlayer.commitChanges()
                vlayer.endEditCommand()

                vlayer.updateFields()
                print(pnu_valid, "of", pnu_count, "PNU are valid and processed ")
                output_filename = self.dlg.lineEdit.text()
                dissolve_result = processing.runAndLoadResults("native:dissolve", {'INPUT': vlayer,
                                                                      'FIELD': "bungi",
                                                                      'OUTPUT': 'TEMPORARY_OUTPUT'})
                olayer = self.iface.activeLayer()
                symbol = QgsFillSymbol.createSimple(
                        {"outline_style": "solid", "outline_color": "Red", "color": "#00ff0000", "outline_width": "1"})
                olayer.renderer().setSymbol(symbol)
                olayer.triggerRepaint()
                self.iface.layerTreeView().refreshLayerSymbology(olayer.id())

                error = QgsVectorFileWriter.writeAsVectorFormatV3(olayer,
                                                                output_filename,
                                                                transform_context,
                                                                save_options)

                if error[0] == QgsVectorFileWriter.NoError:
                    print("saved", output_filename)
                    self.iface.messageBar().pushMessage("Success", "Output file written at " + output_filename,
                                                        level=Qgis.Success, duration=3)
                else:
                    print(error)










