# NIB-ortofoto-prosjekt <img src=./icon.png alt="NIB-ortofoto-prosjekt"/>

Henter alle ortofoto- (inkl. midlertidige), Satellitt- og Infrarødt-prosjekt fra Norge i bilder (WMS) som ligger innafor et utsnitt.
Utsnittet kan være bounding boksen til
- aktuelt map canvas (default)
- et utsnitt man angir selv i hele km (1-500) i lengde og høyde (km x km)
- et kartlag i Layers panel (table of contents (TOC))
- en vektor- eller rasterfil man laster opp

Man kan hente inn tilgjengelige prosjekt fra alle år eller bare fra bestemte år.<br>
I tillegg kan man velge å skrive prosjektnavna usortert/sotert til tekstfil(er) som lagres under C:\Users\<user>\Documents på Windows-maskiner.<br>

<br>
Utsnittet kan ikke overskride **500 km x 500 km**.<br>
Alle WMS-layere (Ortofoto, Satellitt, Infrarødt) havner i en egen gruppe "Nib-prosjekt".<br>
Tidligere innhenta prosjekt kan slettes før nye hentes inn (husker siste valg).<br>

Har inkludert alle koder i kodelista oppgitt i Produktspesifikasjon for ortofoto, versjon 5.0 (ss. 19-20):<br>
https://register.geonorge.no/register/versjoner/produktspesifikasjoner/geovekst/digitale-ortofoto/8/no<br>


**{-NB!-}** Pluginen fungerer _kun_ for brukere som har tilgang til Norge i bilder ortofoto-prosjekt ([Norge digitalt-part](https://www.geonorge.no/Geodataarbeid/Norge-digitalt/parter-i-norge-digitalt/))<br>
**{-NB!-}** Prosjektet må være i UTM 32, 33 eller 35

For installasjon og bruk, se [Wiki](./../../wikis/home).

Gjelder for QGIS 3.x (opprinnelig utviklet i QGIS 3.22 med pyQt5).


# NIB orthophoto project <img src=./icon.png alt="NIB orthophoto project"/>

Retrieves all orthophoto- (incl. temporary), Satellite- and Infrared-projects from Norway in images (WMS) that are located within a bounding box.
The bounding box can be
- current map canvas (standard)
- a box you enter yourself in whole km (1-500) in length and height (km x km)
- a map layer in the Layers panel (table of contents (TOC))
- a vector or raster file that you upload

You can retrieve available projects from all years or only from certain years.<br>
In addition, you can choose to write the project names unsorted/sorted to text file(s) saved in C:\Users\<user>\Documents on Windows-computers.<br>
<br>
The bounding box cannot exceed **500 km x 500 km**.<br>
All WMS layers (Orthophoto, Satellite, Infrared) end up in a separate group "Nib project".<br>
Previously obtained projects can be deleted before new ones are obtained (remembers the last selection).<br>

All codes in the table in Produktspesifikasjon for ortofoto, version 5.0 (pp. 19-20) are included:<br>
https://register.geonorge.no/register/versjoner/produktspesifikasjoner/geovekst/digitale-ortofoto/8/no<br>


**{-NB!-}** The plugin works _only_ for users who have access to Norway in images orthophoto project ([Norge digitalt-part](https://www.geonorge.no/Geodataarbeid/Norge-digitalt/parter-in-norway-digital/))<br>
**{-NB!-}** The project must be in UTM 32, 33 or 35

For installation and usage see [Wiki](./../../wikis/home).

Applies to QGIS 3.x (originally developed in QGIS 3.22 with pyQt5).
